<?php
/**
 * @package SJ Contact Ajax
 * @version 1.3.2
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @copyright (c) 2013 YouTech Company. All Rights Reserved.
 * @author YouTech Company http://www.smartaddons.com
 *
 */
use Joomla\CMS\Factory; 
 
defined('_JEXEC') or die;
if (!defined('DS')) {
	define('DS', DIRECTORY_SEPARATOR);
}

require_once dirname(__FILE__) . '/core/helper.php';
$file = 'https://www.google.com/recaptcha/api.js?onload=JoomlaInitReCaptcha2&render=explicit&hl=' . JFactory::getLanguage()->getTag();
JHtml::_('script', $file);
JHtml::_('script', 'plg_captcha_recaptcha/recaptcha.min.js', false, true);
			
if (!class_exists('plgSystemX_Sj_Contact_Ajax')) {
	echo JText::_('WARNING_NOT_INSTALL_PLUGIN');
	return;
}

$layout = $params->get('layout', 'default');
$list = ContactAjaxHelper::getList($params);

$captcha_type = $params->get('captcha_type');
$captcha_dis = $params->get('captcha_dis');
$captcha_disable = $params->get('captcha_disable');

if ($captcha_dis == 1) {
	if ($captcha_type == 0) {
		$captcha_plg = JPluginHelper::importPlugin('captcha');
		if ($captcha_plg == null) {
			echo JText::_('WARNING_NOT_INSTALL_PLUGIN_RECAPTCHA');
			return;
		}
	}
}

$user = JFactory::getUser();
$currentSession = JFactory::getSession();
if ($list != false) {
	$is_ajax = !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';
	if ($is_ajax) {
		$jinput = JFactory::getApplication()->input;
		$ctajax_modid = $jinput->get('ctajax_modid', null);
		if ($ctajax_modid == $module->id) {
			if (isset($_POST['task'])) {
				if ($_POST['task'] == 'checkcaptcha') {
					$ss_c = $currentSession->get('codeCaptcha' . $module->id);
					$result = new stdClass();
					if ($_POST['captcha'] != $ss_c) {
						$result->valid = false;
					} else {
						$result->valid = true;
					}
					echo json_encode($result);
					die();
				}
				if ($_POST['task'] == 'sendmail') {
					$mail_to = $list->email_to;
					if ($captcha_dis == 1) {
						if ($captcha_disable == 1 && $user->id != 0) {
						} else {
							if ($captcha_type == 0) {
								JPluginHelper::importPlugin('captcha');
								$dispatcher = \Joomla\CMS\Factory::getApplication();								
								if(isset($_POST['recaptcha_challenge'])){
									$jinput->set('recaptcha_challenge_field', $_POST['recaptcha_challenge']);
								}
								if(isset($_POST['recaptcha_response'])){
									$jinput->set('recaptcha_response_field', $_POST['recaptcha_response']);
									$res = $dispatcher->trigger('onCheckAnswer', $_POST['recaptcha_response']);
								}
								if(isset($_POST['captchaResponse'])){
									$jinput->set('g-recaptcha-response', $_POST['captchaResponse']);
									$res = $dispatcher->trigger('onCheckAnswer', $_POST['captchaResponse']);
								}
								
								$result = new stdClass();
								if (!$res[0]) {
									$result->error_captcha = 0;
									echo json_encode($result);
								}
							}
							ContactAjaxHelper::_processSendMail($mail_to);
						}
					}else{
						ContactAjaxHelper::_processSendMail($mail_to);
					}
				}
			}
		}
	} else {
		require JModuleHelper::getLayoutPath($module->module, $layout);
		require JModuleHelper::getLayoutPath($module->module, $layout . '_js');
	}
} else {
	echo JText::_('WARNING_MASSAGE');
}

