<?php
/**
 * @package SJ Twitter Slider
 * @version 1.0.1
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @copyright (c) 2016 YouTech Company. All Rights Reserved.
 * @author YouTech Company http://www.smartaddons.com
 */

defined('_JEXEC') or die ();

JHtml::stylesheet('modules/' . $module->module . '/assets/css/styles.css');
JHtml::script('modules/' . $module->module . '/assets/js/jcarousel.js');
JHtml::script('modules/' . $module->module . '/assets/js/jquery.cj-swipe.js');
JHtml::script('modules/' . $module->module . '/assets/js/twitterFetcher.js');
$tag_id = 'sj_twitter_slider_' . rand() . time();
$cls_id = rand() . time();
$id_user = $params->get('id_user');
$count_item = (int)$params->get('count', 6);
$display_avatars = $params->get('display_avatars',1) ? 'true' : 'false';
$screen_label = $params->get('screenname');

$play = (int)$params->get('play', 1);
$interval = (int)$params->get('interval', 4000);
$interval = ($play) ? $interval : 0;

$start = (int)$params->get('start', 1);
$start =  $start - 1;

$pause_hover = $params->get('pause_hover', 'hover');
$pause_hover = ($pause_hover == 'hover') ? 'hover' : '';

$effect = $params->get('effect', 'slide');
$effect = ($effect == 'slide') ? 'slide' : '';

$slider_id = 'ts_slider_wap_' . rand() . time() . $module->id;
if ($params->get('pretext') != '') {
	?>
	<div class="sc-pretext">
		<?php echo $params->get('pretext'); ?>
	</div>
	<?php
}?>

<!--Begin sj-twitter-slider-->
<div id="<?php echo $tag_id; ?>" class="sj-twitter-slider">
	<script src="//platform.twitter.com/widgets.js" type="text/javascript"></script>
	<!--Begin ts-wrap-->
	<div class="ts-wrap ts-slider-wrap <?php echo $effect; ?>" id="<?php echo $slider_id; ?>"
		 data-interval="<?php echo $interval; ?>" data-pause="<?php echo $pause_hover; ?>">
		<?php if ((int)$params->get('display_direction_button', 1)) { ?>
			<a class="ts-ctr-prev ts-ctr" href="#<?php echo $slider_id; ?>" data-jslide="prev">&lsaquo;</a>
		<?php } ?>
		<div id="content-twiter-<?php echo $cls_id;?>" class="ts-items"></div>
		<?php if ((int)$params->get('display_direction_button', 1)) { ?>
			<a class="ts-ctr-next ts-ctr" href="#<?php echo $slider_id; ?>" data-jslide="next">&rsaquo;</a>
		<?php } ?>
		<?php
		if ((int)$params->get('display_follow_button', 1)) {
			?>
			<!--Begin ts-btn-follow-->
			<div class="ts-btn-follow">
				<a href="https://twitter.com/<?php echo $screen_label; ?>" class="twitter-follow-button"
				   data-show-count="false">Follow @<?php echo $screen_label; ?></a>
				<script>!function (d, s, id) {
						var js, fjs = d.getElementsByTagName(s)[0];
						if (!d.getElementById(id)) {
							js = d.createElement(s);
							js.id = id;
							js.src = "https://platform.twitter.com/widgets.js";
							fjs.parentNode.insertBefore(js, fjs);
						}
					}(document, "script", "twitter-wjs");</script>
			</div>
			<!--End ts-btn-follow-->
		<?php } ?>
	</div>
	<!--End ts-wrap-->
</div>
<?php
if ($params->get('posttext') != '') {
	?>
	<div class="sc-posttext">
		<?php echo $params->get('posttext'); ?>
	</div>
<?php } ?>
<script type="text/javascript">
	jQuery(document).ready(function($){
		var config = {
			"profile": {"screenName": "<?php echo $screen_label; ?>"},
            "id": '<?php echo $id_user; ?>',
			"domId": '',
			"maxTweets": <?php echo $count_item; ?>,
			"enableLinks": true,
			"showUser": <?php echo $display_avatars; ?>,
			"customCallback": handleTweets
		};

		function handleTweets(tweets){
			
			var x = tweets.length;
			var n = 0;
			var j = 0;
			var element = document.getElementById('content-twiter-<?php echo $cls_id;?>');
			var start = <?php echo $start; ?>;
			var html = '<ul class="list-item">';
			while(n < x) {
				var active_cls = (n == start) ? 'active' : '';
				html += '<li class="ts-item item '+active_cls+'">' + tweets[n] + '</li>';
				n++;
			}
			html += '</ul>';
			html += '<ul class="ts-ctr-pages">';
			for(var k = 0; k < x; k++ ){
				var sel_class = k == start ? " sel" : "";
				html += '<li class="ts-ctr-page '+sel_class+'" href="#<?php echo $slider_id; ?>" data-jslide="'+k+'"></li>';
			}
			html += '</ul>';
			element.innerHTML = html;
			var this_li = $('li.ts-item','#<?php echo $tag_id;?>').find('.user');
			var this_span = this_li.find('span:eq(1)');
			this_span.css('margin', '6px');
			this_span.css('font-size', '20px');
			this_span.css('color', '#000');
			this_span.css('width', '100%');
			$('</br>').insertAfter(this_span);
			var this_a = $('.user','#<?php echo $tag_id;?>').find('a');
			var this_img = this_a.find('img');
			//this_a.find('img').remove();
			//this_a.prepend('<span class="ts-avatar"><span class="ts-mask"><span class="ts-mask-logo">Open in Twitter</span></span><img src="'+this_img.attr('src')+'" /></span>');
			
			this_a.find('img').css('display','none');
			this_a.find('img').before('<span class="ts-avatar"><span class="ts-mask"><span class="ts-mask-logo">Open in Twitter</span></span><img src="'+this_img.attr('src')+'" /></span>');		
			
		}
		twitterFetcher.fetch(config);


		(function (element) {
			var $element = $(element);
			var $_slider = $('#<?php echo $slider_id; ?>', $element);
			$_slider.each(function () {
				var $this = $(this), options = options = !$this.data('modal') && $.extend({}, $this.data());
				$this.jcarousel(options);
				$this.bind('jslide', function (e) {
					var index = $(this).find(e.relatedTarget).index();
					$('[data-jslide]').each(function () {
						var $nav = $(this), $navData = $nav.data(), href, $target = $($nav.attr('data-target') || (href = $nav.attr('href')) && href.replace(/.*(?=#[^\s]+$)/, ''));
						if (!$target.is($this)) return;
						if (typeof $navData.jslide == 'number' && $navData.jslide == index) {
							$nav.addClass('sel');
						} else {
							$nav.removeClass('sel');
						}
					});
				});
				<?php
                if($params->get('swipe_enable') == 1) {	?>
				$this.touchSwipeLeft(function () {
						$this.jcarousel('next');
					}
				);
				$this.touchSwipeRight(function () {
						$this.jcarousel('prev');
					}
				);
				<?php } ?>
				return;
			});

		})('#<?php echo $tag_id; ?>');

	});
</script>