<?php
/**
 * @package Sj News Ajax Tabs
 * @version 3.1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @copyright (c) 2012 YouTech Company. All Rights Reserved.
 * @author YouTech Company http://www.smartaddons.com
 *
 */
use Joomla\CMS\Factory;

defined('_JEXEC') or die;
if(!isset($params) || !(count($params) > 0)) return;
if (!defined('DS')) {
	define('DS', DIRECTORY_SEPARATOR);
}
	
require_once dirname( __FILE__ ).'/core/helper.php';

$layout = $params->get('layout', 'default');
$cacheid = md5(serialize(array ($layout, $module->id)));
$cacheparams = new stdClass;
$cacheparams->cachemode = 'id';
$cacheparams->class = 'NewsAjaxtabsHelper';
$cacheparams->method = 'getList';
$cacheparams->methodparams =array($params,$module);
$cacheparams->modeparams = $cacheid;
$list = JModuleHelper::moduleCache($module, $params, $cacheparams);

if(!empty($list)) {
	$is_ajax_request = !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';
	$input = JFactory::getApplication()->input;
	$is_ajax_request = $is_ajax_request || (int)$input->getInt('sj_module_ajax_request', 0);
	if($is_ajax_request) {
		$category_id	= $input->getVar('sj_category_id', null);
		$sj_module_id	= $input->getVar('sj_module_id', null);
		$sj_module		= $input->getVar('sj_module', null);
		$cls_module		= $input->getVar('sj_class_module', null);

		if ($sj_module == $module->module && $sj_module_id==$module->id){
			$category_items = NewsAjaxtabsHelper::getArticles($category_id, $params);
	
			ob_start();
			include JModuleHelper::getLayoutPath($module->module, $layout.'_items');
			$ajax_respond = ob_get_contents();					
			ob_end_clean();
			die ($ajax_respond);
		}

	}else{
		require JModuleHelper::getLayoutPath($module->module, $params->get('position', $layout));
	}
} else {
	echo JText::_('Has no content to show!');
}


