;
(function($) {	
	$.fn.megaii = function(options){
		return this.each(function(){
			this.options = $.extend({}, {
				sectionExpr: '.yt_section_wrap',
				tabsExpr: 'ul.yt_categories_nav li',
				categoryExpr: '.yt_categories_wrap .yt_category_wrap',
				activeClass: 'selected',				
				
				sectionControl: '.yt_section_state',
				animateElement: '.yt_categories_wrap',
				collapeSpeed: 'normal',
				expandSpeed: 'fast',
				expandedClass: 'expanded',
				
				tooltip: true
			}, options || {});
			if ($.browser.msie && $.browser.version<=7){
				this.options.collapeSpeed = 100;
				this.options.expandSpeed = 50;
			}
			var opts = this.options;
			var sections = $(opts.sectionExpr, this);
			
			sections.each(function(){
				
				var tabs = $(opts.tabsExpr, this);
				var tabContents = $(opts.categoryExpr, this);
				
				var sectionControl = $(opts.sectionControl, this);
				var animateElement = $(opts.animateElement, this); 
				
				sectionControl.each(function(i, control){
					$(control).click(function(e){
						if ( $(this).hasClass(opts.expandedClass) ){	
							if ( animateElement.hasClass('__busy') ) return;
							
							$.data(animateElement, '__orHeight', animateElement.height() );
							animateElement.stop().addClass('__busy').animate(
								{
									height: 0
								},
								{
									duration: opts.collapeSpeed,
									complete: function(){
										$(control).removeClass(opts.expandedClass);
										animateElement.removeClass('__busy').addClass('__hideall');
									}
								}
							);
						} else {						
							var toValue = $.data(animateElement, '__orHeight') || 0;
							$.removeData(animateElement, '__orHeight');							
							try{															
								var tabContentSelected = tabContents.filter('.'+opts.activeClass);
								var toValue2 = $(tabContentSelected[0]).height();
								if (toValue2 && toValue2!=toValue){
									toValue = toValue2;
								}
							} catch(e){
								console.log(e.message);
							}
							animateElement.stop().removeClass('__hideall').addClass('__busy').animate(
								{
									height: toValue
								},
								{
									duration: opts.expandSpeed,
									complete: function(){
										$(control).addClass(opts.expandedClass);
										animateElement.removeClass('__busy');
										animateElement.css({height: ''});
									}
								}
							);
						}	
					});					
				}.bind(this));
				
				// tabs process				
				if (tabs.size()==tabContents.size()){
					tabs.each(function(i, tab){						
						$(tab).click(function(e){
							if ($(this).hasClass(opts.activeClass)){
								return;
							} else {
								var tab_id = $(this).attr('id');
								var category_class = '.category_' + parseInt(tab_id.replace('megaii_tab_',''));
								var tabContent = tabContents.filter(category_class) || tabContents[i];
								tabs.removeClass(opts.activeClass).filter(this).addClass(opts.activeClass);
								tabContents.removeClass(opts.activeClass).filter(tabContent).addClass(opts.activeClass);
								if (sectionControl.size()>0){
									var _sectionControl = sectionControl[0];
									if (!$(_sectionControl).hasClass(opts.expandedClass)){
										$(_sectionControl).click();
									}
								}
							}							
						});
					}.bind(this));
				}

				if ($('.yt_section_title ul.yt_categories_nav', this).size()>0){
					var navbar = $('.yt_section_title ul.yt_categories_nav', this)[0];
					var navwrap = $(navbar).parent().parent();
					var prevs = $(navbar).parent().prevAll();
					var nexts = $(navbar).parent().nextAll();
					var new_w = navwrap.width() - prevs.width() - nexts.width() - 1;
					var new_h = navwrap.height() - 1;
					var nav_pad = parseInt($(navbar).css('padding-left')) + parseInt($(navbar).css('padding-right'));
					$(navbar).css({
						width: new_w - nav_pad,
						height: new_h,
						overflow: 'hidden'
					});
				}
				
			});
			if (opts.tooltip){
				$.fn.yttooltip.apply(this, [{}]);
			}
			
		});
	}
	
	$.fn.yttooltip = function(){
		var options = $.extend({}, {
			element: '.has_tooltip',
			tooltip_instance: 'default',
			tooltip_showclass: 'using',
			timer: null
		}, options || {});
		
		$(options.element, this).each(function(){
			$(this).hover(function(e){
				var tooltipWrap = getTooltipInstance('#yt_tooltip_'+options.tooltip_instance);
				var tooltipStored = $('.' + $(this).attr('id'));
				$('.yt_tooltip_content', $(tooltipWrap)).html(tooltipStored.html());
				$(tooltipWrap).css({
					top: e.pageY - $(tooltipWrap).height() - 1,
					left: e.pageX - 25,
					width: tooltipStored.width()
				});
				var to_top = e.pageY - $(tooltipWrap).height() - 1;
				var to_left = e.pageX - 25;
				$(tooltipWrap).css({
					top: to_top,
					left: to_left,
					width: tooltipStored.width(),
					opacity: 0.2
				}).stop().animate({
					opacity: 0.9999
				}, {
					duration: 500
				});
				$(tooltipWrap).addClass(options.tooltip_showclass);
			},function(e){
				var tooltipWrap = getTooltipInstance('#yt_tooltip_'+options.tooltip_instance);
				$(tooltipWrap).removeClass(options.tooltip_showclass);
				$(tooltipWrap).stop().css({top: '-999em'});
			});
		});
		$(document).mousemove(function(e){
			var tooltipWrap = getTooltipInstance('#yt_tooltip_'+options.tooltip_instance);
			if ($(tooltipWrap).hasClass('using')){
				var to_top = e.pageY - $(tooltipWrap).height() - 1;
				var to_left = e.pageX - 25;
				$(tooltipWrap).css({
					top: e.pageY - $(tooltipWrap).height() - 1,
					left: e.pageX - 25
				});
			}
		});
	}
	
	function getTooltipInstance(selector){
		var instance = $(selector);
		if (instance.get().length>0){
			return instance[0];
		} else {
			var tiphtml = '%3Cdiv%20class%3D%22yt_tooltip_top_left%22%3E%3Cdiv%20class%3D%22yt_tooltip_top_right%22%3E%3Cdiv%20class%3D%22yt_tooltip_top_center%22%3E%3C/div%3E%3C/div%3E%3C/div%3E%3Cdiv%20class%3D%22yt_tooltip_content_left%22%3E%3Cdiv%20class%3D%22yt_tooltip_content_right%22%3E%3Cdiv%20class%3D%22yt_tooltip_content%22%3E%3C/div%3E%3C/div%3E%3C/div%3E%3Cdiv%20class%3D%22yt_tooltip_foot_left%22%3E%3Cdiv%20class%3D%22yt_tooltip_foot_right%22%3E%3Cdiv%20class%3D%22yt_tooltip_foot_center%22%3E%3C/div%3E%3C/div%3E%3C/div%3E%3C/div%3E';
			return $('<div></div>', {
				id: selector.replace('#',''),
				'class': 'yt_tooltip_wrap',
				'html': unescape(tiphtml)
			}).appendTo('body');
		}
	}
	
})(jQuery);
