<?php

/**
 * @version    1.0.0
 * @package    Com_Sj_newsletter
 * @author     YouTech Company <contact@ytcvn.com>
 * @copyright  Copyright (c) 2016 YouTech Company
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

/**
 * Class Sj_newsletterFrontendHelper
 *
 * @since  1.6
 */
class Sj_newsletterFrontendHelper
{
	/**
	 * Get an instance of the named model
	 *
	 * @param   string  $name  Model name
	 *
	 * @return null|object
	 */
	public static function getModel($name)
	{
		$model = null;

		// If the file exists, let's
		if (file_exists(JPATH_SITE . '/components/com_sj_newsletter/models/' . strtolower($name) . '.php'))
		{
			require_once JPATH_SITE . '/components/com_sj_newsletter/models/' . strtolower($name) . '.php';
			$model = JModelLegacy::getInstance($name, 'Sj_newsletterModel');
		}

		return $model;
	}
}
