<?php
/**
 * @package Sj Mega News II
 * @version 3.0.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @copyright (c) 2013 YouTech Company. All Rights Reserved.
 * @author YouTech Company http://www.smartaddons.com
 *
 */
defined('_JEXEC') or die;

use Joomla\CMS\Access\Access;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Content\Site\Helper\RouteHelper;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;

include_once dirname(__FILE__) . '/helper_base.php';

class SjMegaNewsIIHelper extends SjMegaNewsIIBaseHelper
{
	public static function getList(&$params)
	{
		$categories = JCategories::getInstance('Content');
		$catids = $params->get('catid');
		$_categories = array();
		settype($catids, 'array');
		settype($catid, 'array');
		$list = array();
		
		foreach ($catids as $i => $cid){
			$category = $categories->get($cid);
			$_categories[$i] = $category;
			if(empty($category)) {
				unset($_categories[$i]);
			}
		}
	
		
		foreach	($_categories as $_cat){
			$_cat->url = JRoute::_( ContentHelperRoute::getCategoryRoute($_cat->id));			
			if ($_cat != null){
				$child_category = $_cat->getChildren();
				$subcat_items = array();
				foreach($child_category as $k => $subcat){
					$sub_childs = self::getArticles($subcat->id, $params);
					if ( count($sub_childs) ){
						$subcat->url = JRoute::_( ContentHelperRoute::getCategoryRoute($subcat->id));
						$subcat->child = $sub_childs;
						$subcat_items[] = $subcat;
					}
				}
			
				if ( count($subcat_items) ){
					$_cat->child_category = $subcat_items;
					$list[] = $_cat;
				}
			}
		}			
		return $list;
	}

	public static function getArticles ($catids, $params){
		
			

		$app = Factory::getApplication();

		/** @var \Joomla\Component\Content\Site\Model\ArticlesModel $model */
		$model = $app->bootComponent('com_content')
			->getMVCFactory()->createModel('Articles', 'Site', ['ignore_request' => true]);

		// Set application parameters in model
		$appParams = $app->getParams();
		$model->setState('params', $appParams);

		$model->setState('list.start', 0);
		$model->setState('filter.published', 1);

		// Set the filters based on the module params
		$model->setState('list.limit', (int) $params->get('count', 0));

		// This module does not use tags data
		$model->setState('load_tags', false);

		// Access filter
		$access     = !ComponentHelper::getParams('com_content')->get('show_noauth');
		$authorised = Access::getAuthorisedViewLevels(Factory::getUser()->get('id'));
		$model->setState('filter.access', $access);

		// Category filter
			settype($catids,'array');
			if ($catids != null) {
				if ($params->get('show_child_category_articles', 0) && (int) $params->get('levels', 0) > 0) {
					// Get an instance of the generic categories model
					$categories = JModelLegacy::getInstance('Categories', 'ContentModel', array('ignore_request' => true));
					$categories->setState('params', $appParams);
					$levels = $params->get('levels', 1) ? $params->get('levels', 1) : 9999;
					$categories->setState('filter.get_children', $levels);
					$categories->setState('filter.published', 1);
					$categories->setState('filter.access', $access);
					$additional_catids = array();
				
					foreach($catids as $catid)
					{
						$categories->setState('filter.parentId', $catid);
						$recursive = true;
						$items = $categories->getItems($recursive);
				
						if ($items)
						{
							foreach($items as $category)
							{
								$condition = (($category->level - $categories->getParent()->level) <= $levels);
								if ($condition) {
									$additional_catids[] = $category->id;
								}
				
							}
						}
					}
				
					$catids = array_unique(array_merge($catids, $additional_catids));
		}
		

		
		$model->setState('filter.category_id', $catids);

		// Filter by language
		$model->setState('filter.language', $app->getLanguageFilter());
		
		$model->setState('filter.featured', $params->get('show_front', 'show'));

        // Find current Article ID if on an article page
        $option = $app->input->get('option');
        $view = $app->input->get('view');

		// Filter by id in case it should be excluded
		if ($app->input->get('option') === 'com_content'
			&& $app->input->get('view') === 'article')
		{
			// Exclude the current article from displaying in this module
			$model->setState('filter.article_id', $app->input->get('id', 0, 'UINT'));
			$model->setState('filter.article_id.include', false);
		}

        // Ordering
        $model->setState('list.ordering', $params->get('article_ordering', 'a.ordering'));
        $model->setState('list.direction', $params->get('article_ordering_direction', 'ASC'));

		// Retrieve Content
		$items = $model->getItems();
		
		foreach ($items as &$item)
		{
			$item->readmore = \strlen(trim($item->fulltext));
			$item->slug     = $item->id . ':' . $item->alias;

			if ($access || \in_array($item->access, $authorised))
			{
				// We know that user has the privilege to view the article
				$item->link     = Route::_(RouteHelper::getArticleRoute($item->slug, $item->catid, $item->language));
				$item->linkText = Text::_('MOD_ARTICLES_NEWS_READMORE');
			}
			else
			{
				$item->link = new Uri(Route::_('index.php?option=com_users&view=login', false));
				$item->link->setVar('return', base64_encode(RouteHelper::getArticleRoute($item->slug, $item->catid, $item->language)));
				$item->linkText = Text::_('MOD_ARTICLES_NEWS_READMORE_REGISTER');
			}

			$item->introtext = HTMLHelper::_('content.prepare', $item->introtext, '', 'mod_articles_news.content');

			// Remove any images belongs to the text
			if (!$params->get('image'))
			{
				$item->introtext = preg_replace('/<img[^>]*>/', '', $item->introtext);
			}
			
			$fields = FieldsHelper::getFields('com_content.article', $item, true);
			
			$item->jcfields = array();

			foreach ($fields as $key => $field)
			{
				$item->jcfields[$field->id] = $field;
			}			

			// Show the Intro/Full image field of the article
			if ($params->get('img_intro_full') !== 'none')
			{
				$images = json_decode($item->images);
				$item->imageSrc = '';
				$item->imageAlt = '';
				$item->imageCaption = '';

				if ($params->get('img_intro_full') === 'intro' && !empty($images->image_intro))
				{
					$item->imageSrc = htmlspecialchars($images->image_intro, ENT_COMPAT, 'UTF-8');
					$item->imageAlt = htmlspecialchars($images->image_intro_alt, ENT_COMPAT, 'UTF-8');

					if ($images->image_intro_caption)
					{
						$item->imageCaption = htmlspecialchars($images->image_intro_caption, ENT_COMPAT, 'UTF-8');
					}
				}
				elseif ($params->get('img_intro_full') === 'full' && !empty($images->image_fulltext))
				{
					$item->imageSrc = htmlspecialchars($images->image_fulltext, ENT_COMPAT, 'UTF-8');
					$item->imageAlt = htmlspecialchars($images->image_fulltext_alt, ENT_COMPAT, 'UTF-8');

					if ($images->image_intro_caption)
					{
						$item->imageCaption = htmlspecialchars($images->image_fulltext_caption, ENT_COMPAT, 'UTF-8');
					}
				}
			}

		}

		return $items;
    	}
	}

}
