<?php
/**
 * @version    1.0.0
 * @package    Com_Sj_newsletter
 * @author     YouTech Company <contact@ytcvn.com>
 * @copyright  Copyright (c) 2016 YouTech Company
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet(JUri::root() . 'media/com_sj_newsletter/css/list.css');

$user = JFactory::getUser();
$userId = $user->get('id');
$listOrder = $this->state->get('list.ordering');
$listDirn = $this->state->get('list.direction');
$canOrder = $user->authorise('core.edit.state', 'com_sj_newsletter');
$saveOrder = $listOrder == 'a.`ordering`';
$check = $this->escape($this->state->get('filter.confirm_mail'));

if ($saveOrder) {
    $saveOrderingUrl = 'index.php?option=com_sj_newsletter&task=emails.saveOrderAjax&tmpl=component';
    JHtml::_('sortablelist.sortable', 'emailList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
}

$sortFields = $this->getSortFields();
// get content mail
$db = JFactory::getDBO();
$query = $db->getQuery(true);
$query->select("c.*");
$query->from("#__sj_newsletter_email_content as c");
$query->where("c.state = 1");
$db->setQuery($query);
$data =  $db->loadObjectList();
// get id content mail
$query1 = $db->getQuery(true);
$query1->select("cid.*");
$query1->from("#__sj_newsletter_email_content_id as cid");
$db->setQuery($query1);
$data_cid =  $db->loadObjectList();
?>
<script type="text/javascript">
    Joomla.orderTable = function () {
        table = document.getElementById("sortTable");
        direction = document.getElementById("directionTable");
        order = table.options[table.selectedIndex].value;
        if (order != '<?php echo $listOrder; ?>') {
            dirn = 'asc';
        } else {
            dirn = direction.options[direction.selectedIndex].value;
        }
        Joomla.tableOrdering(order, dirn, '');
    };

    jQuery(document).ready(function ($) {
        $('#clear-search-button').on('click', function () {
            $('#filter_search').val('');
            $('#adminForm').submit();
        });
        // select content mail
        var select_mail = $('.select-content-mail');
        $('select',select_mail).on('change', function(){
            var id    = $(this).val();
            var dataString = 'id='+id;
            $.ajax({
                type: "POST",
                url: "index.php?option=com_sj_newsletter&task=emails.saveId&id="+id,
                data: dataString,
                success: function (data) {
                },
                complete: function(){
                    document.location.reload();
                }
            });
            return false;
        });
        // Send mail to all
        $('.send-mail-all').click(function(e){
            e.preventDefault();
            var select_mail = $('.select-content-mail');
            var val_mail = select_mail.find('select').val();
            if(val_mail ==''){
                $('.chzn-container',select_mail).css('border','1px solid red');
                $('.chzn-container',select_mail).css('border-radius','5px');
                alert('Please select email content');
            }else{
                $.ajax({
                    type: "POST",
                    url: "index.php?option=com_sj_newsletter&task=emails.sendall",
                    //data: $("form").serialize(),
                    dataType: 'json',
                    success: function (data) {
                        if(data == 1){
                            alert('Successfully Sent');
                        }else if(data == 2){
                            alert('If you want to resend confirm mail, please list it as Pending')
                        }else if(data == 0){
                            alert('Error sending email');
                        }
                    },
                    complete: function(){
                        //do smth if you need
                        document.location.reload();
                    }
                });
            }
        });
        // Send mail to select
        $('.send-mail-select').click(function(e){
            e.preventDefault();
            var select_mail = $('.select-content-mail');
            var val_mail = select_mail.find('select').val();
            var val_check  = $('#emailList input[type=\'checkbox\']:checked');
            if(val_mail ==''){
                $('.chzn-container',select_mail).css('border','1px solid red');
                $('.chzn-container',select_mail).css('border-radius','5px');
                alert('Please select email content');
            }else if (val_check.length > 0) {
                $.ajax({
                    type: 'POST',
                    url: "index.php?option=com_sj_newsletter&task=emails.sendselect",
                    data: val_check,
                    dataType: 'json',
                    success: function (data) {
                        if(data == 1){
                            alert('Successfully Sent');
                        }else if(data == 2){
                            alert('If you want to resend confirm mail, please list it as Pending')
                        }else if(data == 0){
                            alert('Error sending email');
                        }
                    },
                    complete: function(){
                        //do smth if you need
                        document.location.reload();
                    }
                });
            }else{
                alert('Please select item');

            }
        });
    });
</script>

<?php

// Joomla Component Creator code to allow adding non select list filters
if (!empty($this->extra_sidebar)) {
    $this->sidebar .= $this->extra_sidebar;
}

?>

<form action="<?php echo JRoute::_('index.php?option=com_sj_newsletter&view=emails'); ?>" method="post"
      name="adminForm" id="adminForm">
    <?php if (!empty($this->sidebar)): ?>
    <div id="j-sidebar-container" class="span2">
        <?php echo $this->sidebar; ?>
        <div class="filter-select hidden-phone">
            <h4 class="page-header"><?php echo JText::_('COM_SJ_NEWSLETTER_EMAILS_SELECT_CONFIRM_MAIL'); ?>:</h4>
            <select name="filter_confirm_mail" id="filter_confirm_mail" class="input-small" onchange="this.form.submit()">
                <option value="all" <?php if ($check == 'all') echo 'selected="selected"'; ?>>
                    <?php echo JText::_('COM_SJ_NEWSLETTER_EMAILS_SELECT_CONFIRM_MAIL_ALL'); ?>
                </option>
                <option value="1" <?php if ($check == 1) echo 'selected="selected"'; ?>>
                    <?php echo JText::_('COM_SJ_NEWSLETTER_EMAILS_SELECT_CONFIRM_MAIL_SENT'); ?>
                </option>
                <option value="0" <?php if (!$check) echo 'selected="selected"'; ?>>
                    <?php echo JText::_('COM_SJ_NEWSLETTER_EMAILS_SELECT_CONFIRM_MAIL_PENDING'); ?>
                </option>
            </select>
        </div>

    </div>
    <div id="j-main-container" class="span10">
        <?php else : ?>
        <div id="j-main-container">
            <?php endif; ?>

            <div id="filter-bar" class="btn-toolbar">
                <div class="filter-search btn-group pull-left">
                    <label for="filter_search"
                           class="element-invisible">
                        <?php echo JText::_('JSEARCH_FILTER'); ?>
                    </label>
                    <input type="text" name="filter_search" id="filter_search"
                           placeholder="<?php echo JText::_('JSEARCH_FILTER'); ?>"
                           value="<?php echo $this->escape($this->state->get('filter.search')); ?>"
                           title="<?php echo JText::_('JSEARCH_FILTER'); ?>"/>
                </div>
                <div class="btn-group pull-left">
                    <button class="btn hasTooltip" type="submit"
                            title="<?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?>">
                        <i class="icon-search"></i></button>
                    <button class="btn hasTooltip" id="clear-search-button" type="button"
                            title="<?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?>">
                        <i class="icon-remove"></i></button>
                </div>
                <div class="btn-group pull-left select-content-mail">
                    <select name="" id="" class="email-content">
                        <option
                            value=""><?php echo JText::_('COM_SJ_NEWSLETTER_EMAILS_SELECT_EMAIL_CONTENT'); ?></option>
                        <?php foreach ($data as $d) : ?>
                            <option <?php if ($data_cid[0]->id_content_mail == $d->id) {
                                echo "selected='selected'";
                            } ?> value="<?php echo $d->id; ?>"><?php echo $d->title; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="btn-group pull-left">
                    <button class="btn btn-primary send-mail-select" type="submit"
                            title="<?php echo JText::_('COM_SJ_NEWSLETTER_EMAILS_SEND_MAIL_SELECT'); ?>">
                        <?php echo JText::_('COM_SJ_NEWSLETTER_EMAILS_SEND_MAIL_SELECT'); ?>
                    </button>
                </div>
                <div class="btn-group pull-left">
                    <button class="btn btn-primary send-mail-all" type="submit"
                            title="<?php echo JText::_('COM_SJ_NEWSLETTER_EMAILS_SEND_MAIL_ALL'); ?>">
                        <?php echo JText::_('COM_SJ_NEWSLETTER_EMAILS_SEND_MAIL_ALL'); ?>
                    </button>
                </div>
                <div class="btn-group pull-left">
                    <a href="index.php?option=com_sj_newsletter&task=emails.revert"
                       title="<?php echo JText::_('COM_SJ_NEWSLETTER_EMAILS_REVERT_MAIL'); ?>"
                       class="btn btn-primary" OnClick="return confirm('Are you sure you want to revert mail?');">
                        <?php echo JText::_('COM_SJ_NEWSLETTER_EMAILS_REVERT'); ?>
                    </a>
                </div>
                <div class="btn-group pull-right hidden-phone">
                    <label for="limit"
                           class="element-invisible">
                        <?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?>
                    </label>
                    <?php echo $this->pagination->getLimitBox(); ?>
                </div>
                <div class="btn-group pull-right">
                    <label for="sortTable" class="element-invisible"><?php echo JText::_('JGLOBAL_SORT_BY'); ?></label>
                    <select name="sortTable" id="sortTable" class="input-medium" onchange="Joomla.orderTable()">
                        <option value=""><?php echo JText::_('JGLOBAL_SORT_BY'); ?></option>
                        <?php echo JHtml::_('select.options', $sortFields, 'value', 'text', $listOrder); ?>
                    </select>
                </div>
            </div>
            <div class="clearfix"></div>
            <table class="table table-striped" id="emailList">
                <thead>
                <tr>
                    <?php if (isset($this->items[0]->ordering)): ?>
                        <th width="1%" class="nowrap center hidden-phone">
                            <?php echo JHtml::_('grid.sort', '<i class="icon-menu-2"></i>', 'a.`ordering`', $listDirn, $listOrder, null, 'asc', 'JGRID_HEADING_ORDERING'); ?>
                        </th>
                    <?php endif; ?>
                    <th width="1%" class="hidden-phone">
                        <input type="checkbox" name="checkall-toggle" value=""
                               title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)"/>
                    </th>
                    <?php if (isset($this->items[0]->state)): ?>
                        <th width="1%" class="nowrap center">
                            <?php echo JHtml::_('grid.sort', 'JSTATUS', 'a.`state`', $listDirn, $listOrder); ?>
                        </th>
                    <?php endif; ?>

                    <th class='left'>
                        <?php echo JHtml::_('grid.sort', 'COM_SJ_NEWSLETTER_EMAILS_ID', 'a.`id`', $listDirn, $listOrder); ?>
                    </th>
                    <th class='left'>
                        <?php echo JHtml::_('grid.sort', 'COM_SJ_NEWSLETTER_EMAILS_EMAIL', 'a.`email`', $listDirn, $listOrder); ?>
                    </th>
                    <th class='left'>
                        <?php echo JHtml::_('grid.sort', 'COM_SJ_NEWSLETTER_EMAILS_CREATED_DATE', 'a.`created_date`', $listDirn, $listOrder); ?>
                    </th>
                    <th class='left'>
                        <?php echo JHtml::_('grid.sort', 'COM_SJ_NEWSLETTER_EMAILS_CONFIRM_MAIL', 'a.`confirm_mail`', $listDirn, $listOrder); ?>
                    </th>
                    <th class='center'>
                        <?php echo JHtml::_('grid.sort', 'COM_SJ_NEWSLETTER_EMAILS_ACTION', '', $listDirn, $listOrder); ?>
                    </th>
                </tr>
                </thead>
                <tfoot>
                <tr>
                    <td colspan="<?php echo isset($this->items[0]) ? count(get_object_vars($this->items[0])) : 10; ?>">
                        <?php echo $this->pagination->getListFooter(); ?>
                    </td>
                </tr>
                </tfoot>
                <tbody>
                <?php foreach ($this->items as $i => $item) :
                    $ordering = ($listOrder == 'a.ordering');
                    $canCreate = $user->authorise('core.create', 'com_sj_newsletter');
                    $canEdit = $user->authorise('core.edit', 'com_sj_newsletter');
                    $canCheckin = $user->authorise('core.manage', 'com_sj_newsletter');
                    $canChange = $user->authorise('core.edit.state', 'com_sj_newsletter');
                    ?>
                    <tr class="row<?php echo $i % 2; ?>">
                        <?php if (isset($this->items[0]->ordering)) : ?>
                            <td class="order nowrap center hidden-phone">
                                <?php if ($canChange) :
                                    $disableClassName = '';
                                    $disabledLabel = '';
                                    if (!$saveOrder) :
                                        $disabledLabel = JText::_('JORDERINGDISABLED');
                                        $disableClassName = 'inactive tip-top';
                                    endif; ?>
                                    <span class="sortable-handler hasTooltip <?php echo $disableClassName ?>"
                                          title="<?php echo $disabledLabel ?>">
										<i class="icon-menu"></i>
									</span>
                                    <input type="text" style="display:none" name="order[]" size="5"
                                           value="<?php echo $item->ordering; ?>" class="width-20 text-area-order "/>
                                <?php else : ?>
                                    <span class="sortable-handler inactive">
										<i class="icon-menu"></i>
									</span>
                                <?php endif; ?>
                            </td>
                        <?php endif; ?>
                        <td class="hidden-phone">
                            <?php echo JHtml::_('grid.id', $i, $item->id); ?>
                        </td>
                        <?php if (isset($this->items[0]->state)): ?>
                            <td class="center">
                                <?php echo JHtml::_('jgrid.published', $item->state, $i, 'emails.', $canChange, 'cb'); ?>
                            </td>
                        <?php endif; ?>
                        <td>
                            <?php echo $item->id; ?>
                        </td>
                        <td>
                            <?php if (isset($item->checked_out) && $item->checked_out && ($canEdit || $canChange)) : ?>
                                <?php echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'emails.', $canCheckin); ?>
                            <?php endif; ?>
                            <?php if ($canEdit) : ?>
                                <span style="color: #003bb3"> <?php echo $this->escape($item->email); ?></span>
                            <?php else : ?>
                                <?php echo $this->escape($item->email); ?>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php echo $item->created_date; ?>
                        </td>
                        <td>
                            <?php if($item->confirm_mail == 1) { ?>
                                <span class="label label-success">Sent</span>
                            <?php }else{ ?>
                                <span class="label label-warning">pending</span>
                            <?php } ?>
                        </td>
                        <td class="center">
                            <a href="index.php?option=com_sj_newsletter&task=emails.deleteitem&id=<?php echo $item->id ;?>" title="<?php echo JText::_('COM_SJ_NEWSLETTER_EMAILS_DELETE'); ?>" class="btn" OnClick="return confirm('Are you sure you want to delete?');">
                                <i class="icon-trash" style="margin-right: 0"></i>
                            </a>
                            <button class="btn send-mail-<?php echo $item->id ;?>" type="submit"
                                    title="<?php echo JText::_('COM_SJ_NEWSLETTER_EMAILS_SEND_MAIL'); ?>">
                                <i class="icon-envelope" style="margin-right: 0"></i>
                            </button>
                            <script type="text/javascript">
                                jQuery(document).ready(function($){
                                    $('.send-mail-<?php echo $item->id ;?>').click(function(e){
                                        e.preventDefault();
                                        var select_mail = $('.select-content-mail');
                                        var val_mail = select_mail.find('select').val();
                                        if(val_mail ==''){
                                            $('.chzn-container',select_mail).css('border','1px solid red');
                                            $('.chzn-container',select_mail).css('border-radius','5px');
                                            alert('Please select email content');
                                        }else{
                                            var id    = <?php echo $item->id ;?>;
                                            var dataString = 'id='+id;
                                            $.ajax({
                                                type: "POST",
                                                url: "index.php?option=com_sj_newsletter&task=emails.sendone&id=<?php echo $item->id;?>",
                                                //data: $("form").serialize(),
                                                data: dataString,
                                                dataType: 'json',
                                                success: function (data) {
                                                    if(data == 1){
                                                        alert('Successfully Sent');
                                                    }else if(data == 2){
                                                        alert('If you want to resend confirm mail, please list it as Pending');
                                                    }else if(data == 0){
                                                        alert('Error sending email');
                                                    }
                                                },
                                                complete: function(){ //A function to be called when the request finishes (after success and error callbacks are executed) - from jquery docs
                                                    //do smth if you need
                                                    document.location.reload();
                                                }
                                            });
                                        }
                                    });
                                });
                            </script>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>

            <input type="hidden" name="task" value=""/>
            <input type="hidden" name="boxchecked" value="0"/>
            <input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>"/>
            <input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>"/>
            <?php echo JHtml::_('form.token'); ?>
        </div>
</form>        
