DROP TABLE IF EXISTS #__action_log_config;
CREATE TABLE `#__action_log_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `id_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text_prefix` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__action_log_config VALUES
("1","article","com_content.article","id","title","#__content","PLG_ACTIONLOG_JOOMLA"),
("2","article","com_content.form","id","title","#__content","PLG_ACTIONLOG_JOOMLA"),
("3","banner","com_banners.banner","id","name","#__banners","PLG_ACTIONLOG_JOOMLA"),
("4","user_note","com_users.note","id","subject","#__user_notes","PLG_ACTIONLOG_JOOMLA"),
("5","media","com_media.file","","name","","PLG_ACTIONLOG_JOOMLA"),
("6","category","com_categories.category","id","title","#__categories","PLG_ACTIONLOG_JOOMLA"),
("7","menu","com_menus.menu","id","title","#__menu_types","PLG_ACTIONLOG_JOOMLA"),
("8","menu_item","com_menus.item","id","title","#__menu","PLG_ACTIONLOG_JOOMLA"),
("9","newsfeed","com_newsfeeds.newsfeed","id","name","#__newsfeeds","PLG_ACTIONLOG_JOOMLA"),
("10","link","com_redirect.link","id","old_url","#__redirect_links","PLG_ACTIONLOG_JOOMLA"),
("11","tag","com_tags.tag","id","title","#__tags","PLG_ACTIONLOG_JOOMLA"),
("12","style","com_templates.style","id","title","#__template_styles","PLG_ACTIONLOG_JOOMLA"),
("13","plugin","com_plugins.plugin","extension_id","name","#__extensions","PLG_ACTIONLOG_JOOMLA"),
("14","component_config","com_config.component","extension_id","name","","PLG_ACTIONLOG_JOOMLA"),
("15","contact","com_contact.contact","id","name","#__contact_details","PLG_ACTIONLOG_JOOMLA"),
("16","module","com_modules.module","id","title","#__modules","PLG_ACTIONLOG_JOOMLA"),
("17","access_level","com_users.level","id","title","#__viewlevels","PLG_ACTIONLOG_JOOMLA"),
("18","banner_client","com_banners.client","id","name","#__banner_clients","PLG_ACTIONLOG_JOOMLA"),
("19","application_config","com_config.application","","name","","PLG_ACTIONLOG_JOOMLA");


DROP TABLE IF EXISTS #__action_logs;
CREATE TABLE `#__action_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message_language_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date` datetime NOT NULL,
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `item_id` int(11) NOT NULL DEFAULT '0',
  `ip_address` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_user_id_logdate` (`user_id`,`log_date`),
  KEY `idx_user_id_extension` (`user_id`,`extension`),
  KEY `idx_extension_item_id` (`extension`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS #__action_logs_extensions;
CREATE TABLE `#__action_logs_extensions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__action_logs_extensions VALUES
("1","com_banners"),
("2","com_cache"),
("3","com_categories"),
("4","com_config"),
("5","com_contact"),
("6","com_content"),
("7","com_installer"),
("8","com_media"),
("9","com_menus"),
("10","com_messages"),
("11","com_modules"),
("12","com_newsfeeds"),
("13","com_plugins"),
("14","com_redirect"),
("15","com_tags"),
("16","com_templates"),
("17","com_users"),
("18","com_checkin");


DROP TABLE IF EXISTS #__action_logs_users;
CREATE TABLE `#__action_logs_users` (
  `user_id` int(11) unsigned NOT NULL,
  `notify` tinyint(1) unsigned NOT NULL,
  `extensions` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`),
  KEY `idx_notify` (`notify`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS #__assets;
CREATE TABLE `#__assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=314 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__assets VALUES
("1","0","1","470","0","root.1","Root Asset","{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}"),
("2","1","2","3","1","com_admin","com_admin","{}"),
("3","1","4","15","1","com_banners","com_banners","{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("4","1","16","17","1","com_cache","com_cache","{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}"),
("5","1","18","19","1","com_checkin","com_checkin","{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}"),
("6","1","20","21","1","com_config","com_config","{}"),
("7","1","22","93","1","com_contact","com_contact","{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("8","1","94","197","1","com_content","com_content","{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}"),
("9","1","198","199","1","com_cpanel","com_cpanel","{}"),
("10","1","200","201","1","com_installer","com_installer","{\"core.admin\":[],\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}"),
("11","1","202","205","1","com_languages","com_languages","{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("12","1","206","207","1","com_login","com_login","{}"),
("13","1","208","209","1","com_mailto","com_mailto","{}"),
("14","1","210","211","1","com_massmail","com_massmail","{}"),
("15","1","212","213","1","com_media","com_media","{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1},\"core.edit\":[],\"core.edit.state\":[]}"),
("16","1","214","229","1","com_menus","com_menus","{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("17","1","41","42","1","com_messages","com_messages","{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}"),
("18","1","232","359","1","com_modules","com_modules","{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("19","1","360","367","1","com_newsfeeds","com_newsfeeds","{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("20","1","368","369","1","com_plugins","com_plugins","{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("21","1","370","371","1","com_redirect","com_redirect","{\"core.admin\":{\"7\":1},\"core.manage\":[]}"),
("22","1","372","373","1","com_search","com_search","{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}"),
("23","1","374","375","1","com_templates","com_templates","{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("24","1","376","379","1","com_users","com_users","{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("26","1","380","381","1","com_wrapper","com_wrapper","{}"),
("33","1","442","443","1","com_finder","com_finder","{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}"),
("34","8","111","114","2","com_content.category.9","Uncategorised","{\"core.create\":{\"10\":0,\"12\":0},\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("35","3","7","8","2","com_banners.category.10","Uncategorised","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("36","7","27","28","2","com_contact.category.11","Uncategorised","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("37","19","363","364","2","com_newsfeeds.category.12","Uncategorised","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("40","3","9","10","2","com_banners.category.15","Sample Data-Banners","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("41","7","29","90","2","com_contact.category.16","Sample Data-Contact","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("42","19","365","366","2","com_newsfeeds.category.17","Sample Data-Newsfeeds","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("44","8","117","158","2","com_content.category.19","Joomla!","{\"core.create\":{\"10\":0,\"12\":0},\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}"),
("46","44","144","157","3","com_content.category.21","Components","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}"),
("59","41","30","31","3","com_contact.category.34","Park Site","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("60","41","32","89","3","com_contact.category.35","Shop Site","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("61","60","33","34","4","com_contact.category.36","Staff","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("62","60","35","88","4","com_contact.category.37","Fruit Encyclopedia","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("63","62","36","37","5","com_contact.category.38","A","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("64","62","38","39","5","com_contact.category.39","B","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("65","62","40","41","5","com_contact.category.40","C","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("66","62","42","43","5","com_contact.category.41","D","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("67","62","44","45","5","com_contact.category.42","E","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("68","62","46","47","5","com_contact.category.43","F","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("69","62","48","49","5","com_contact.category.44","G","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("70","62","50","51","5","com_contact.category.45","H","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("71","62","52","53","5","com_contact.category.46","I","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("72","62","54","55","5","com_contact.category.47","J","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("73","62","56","57","5","com_contact.category.48","K","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("74","62","58","59","5","com_contact.category.49","L","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("75","62","60","61","5","com_contact.category.50","M","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("76","62","62","63","5","com_contact.category.51","N","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("77","62","64","65","5","com_contact.category.52","O","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("78","62","66","67","5","com_contact.category.53","P","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("79","62","68","69","5","com_contact.category.54","Q","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("80","62","70","71","5","com_contact.category.55","R","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("81","62","72","73","5","com_contact.category.56","S","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("82","62","74","75","5","com_contact.category.57","T","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("83","62","76","77","5","com_contact.category.58","U","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("84","62","78","79","5","com_contact.category.59","V","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("85","62","80","81","5","com_contact.category.60","W","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("86","62","82","83","5","com_contact.category.61","X","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("87","62","84","85","5","com_contact.category.62","Y","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("88","62","86","87","5","com_contact.category.63","Z","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("89","46","145","146","4","com_content.article.1","Administrator Components","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("100","44","120","121","3","com_content.category.71","Milky Way","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("104","44","122","123","3","com_content.article.8","Beginners","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("105","46","147","148","4","com_content.article.9","Contact","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("106","46","149","150","4","com_content.article.10","Content","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("119","44","124","125","3","com_content.article.21","Getting Help","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("120","44","126","127","3","com_content.article.22","Getting Started","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("122","44","128","129","3","com_content.article.24","Joomla!","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("130","44","130","131","3","com_content.article.32","Options","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("133","44","132","133","3","com_content.article.35","Professionals","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("136","44","134","135","3","com_content.article.38","Sample Sites","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("137","46","151","152","4","com_content.article.39","Search","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("145","44","136","137","3","com_content.article.47","The Joomla! Community","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("146","44","138","139","3","com_content.article.48","The Joomla! Project","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("148","44","140","141","3","com_content.article.50","Upgraders","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("150","46","153","154","4","com_content.article.52","Users","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("151","44","142","143","3","com_content.article.53","Using Joomla!","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("158","46","155","156","4","com_content.article.60","News Feeds","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("168","34","112","113","3","com_content.article.67","What\'s New in 1.5?","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("169","24","377","378","2","com_users.category.77","Uncategorised",""),
("173","1","444","445","1","com_joomlaupdate","com_joomlaupdate","{\"core.admin\":[],\"core.manage\":[],\"core.delete\":[],\"core.edit.state\":[]}"),
("175","1","446","447","1","com_tags","com_tags","{\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}"),
("176","1","448","449","1","com_contenthistory","com_contenthistory","{}"),
("177","1","450","451","1","com_ajax","com_ajax","{}"),
("178","1","452","453","1","com_postinstall","com_postinstall","{}"),
("179","8","159","182","2","com_content.category.79","Blog","{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}"),
("180","1","454","457","1","com_sppagebuilder","sppagebuilder","{}"),
("181","18","233","234","2","com_modules.module.91","SP Page Builder","{}"),
("183","1","458","459","1","com_spsimpleportfolio","spsimpleportfolio","{}"),
("185","18","235","236","2","com_modules.module.17","Breadcrumbs","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}"),
("186","18","237","238","2","com_modules.module.35","Search","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}"),
("187","18","239","240","2","com_modules.module.94","About Helix","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}"),
("188","18","241","242","2","com_modules.module.95","Latest News","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}"),
("189","18","243","244","2","com_modules.module.96","Our Partners","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}"),
("190","18","245","246","2","com_modules.module.97","Quick Link","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}");
INSERT INTO #__assets VALUES
("191","179","160","161","3","com_content.category.80","News","{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}"),
("192","179","162","163","3","com_content.category.81","Tutorial","{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}"),
("193","179","164","165","3","com_content.category.82","Review","{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}"),
("194","179","166","167","3","com_content.category.83","Updates","{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}"),
("195","179","168","169","3","com_content.article.71","Doner spare ribs pastrami shank","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}"),
("196","179","170","171","3","com_content.article.72","Jerky shank chicken boudin","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}"),
("197","179","172","173","3","com_content.article.73","Pellentesque Habitant Morbi Tristique","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}"),
("198","179","174","175","3","com_content.article.74","Meatball kevin beef ribs shoulder","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}"),
("199","179","176","177","3","com_content.article.75","5 Effective Email Unsubscribe Pages","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}"),
("200","179","178","179","3","com_content.article.76","Who Actually Clicks on Banner Ads?","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}"),
("201","179","180","181","3","com_content.article.77","See the new Miss Universe get her crown","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}"),
("202","18","247","248","2","com_modules.module.98","Portfolio Module","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}"),
("203","18","249","250","2","com_modules.module.99","Latest News","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}"),
("204","18","251","252","2","com_modules.module.100","Search sidebar right","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}"),
("205","18","253","254","2","com_modules.module.101","Information","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}"),
("206","18","255","256","2","com_modules.module.102","Search","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("207","18","257","258","2","com_modules.module.103","Latest News","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("208","18","259","260","2","com_modules.module.104","Information","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}"),
("209","18","261","262","2","com_modules.module.105","Off Canvas Menu","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}"),
("211","18","263","264","2","com_modules.module.107","Portfolio Module -  Portfolio Home","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}"),
("212","18","265","266","2","com_modules.module.108","test","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}"),
("213","18","267","268","2","com_modules.module.109","Login","{}"),
("214","18","269","270","2","com_modules.module.110","Language","{}"),
("215","16","215","216","2","com_menus.menu.10","Menu Horizontal ","{}"),
("224","1","460","461","1","#__languages.2","#__languages.2","{}"),
("225","16","217","218","2","com_menus.menu.11","Menu English","{}"),
("226","16","219","220","2","com_menus.menu.12","Menu Arabic","{}"),
("228","8","183","186","2","com_content.category.84","Trending Post","{}"),
("229","8","187","188","2","com_content.category.85","Life Styles","{}"),
("230","8","189","190","2","com_content.category.86","World News","{}"),
("231","8","191","192","2","com_content.category.87","Watch Now","{}"),
("232","8","193","194","2","com_content.category.88","Food & Recipes","{}"),
("233","8","195","196","2","com_content.category.89","Entertainment","{}"),
("234","228","184","185","3","com_content.article.78","Spectacular New Bridges That Break The Mold","{\"core.admin\":{\"7\":1},\"core.options\":[],\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}"),
("245","16","221","222","2","com_menus.menu.13","Menu Footer","{}"),
("246","18","271","272","2","com_modules.module.128","Our Services","{}"),
("247","16","223","224","2","com_menus.menu.14","Menu Categories","{}"),
("248","18","273","274","2","com_modules.module.129","Categories","{}"),
("249","16","225","226","2","com_menus.menu.15","Menu Copyright","{}"),
("250","18","275","276","2","com_modules.module.130","Menu Copyright","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}"),
("256","18","277","278","2","com_modules.module.136","HTML Top Categories","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}"),
("258","18","279","280","2","com_modules.module.138","SJ Twitter Slider","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}"),
("260","18","281","282","2","com_modules.module.140","SJ Instagram","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}"),
("261","1","462","463","1","com_fields","com_fields","{}"),
("262","1","464","465","1","com_associations","com_associations","{}"),
("263","18","283","284","2","com_modules.module.141","Home - Why choose us","{}"),
("265","18","285","286","2","com_modules.module.143","Home - Project Counter","{}"),
("266","7","91","92","2","com_contact.category.90","Contact Form","{}"),
("267","18","287","288","2","com_modules.module.144","Sj Ajax contact","{}"),
("268","18","289","290","2","com_modules.module.145","Custom HTML Sidebar","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}"),
("269","3","11","12","2","com_banners.category.91","Banner Sidebar","{}"),
("270","18","291","292","2","com_modules.module.146","iConstruct About","{}"),
("271","18","293","294","2","com_modules.module.147","SJ Mega Menu Horizontal","{}"),
("272","18","295","296","2","com_modules.module.148","SJ Mega Menu Vertical","{}"),
("273","16","227","228","2","com_menus.menu.16","Menu Social Header","{}"),
("274","18","297","298","2","com_modules.module.149","Menu Social Header","{}"),
("275","18","299","300","2","com_modules.module.150","Portfolio","{}"),
("276","18","301","302","2","com_modules.module.151","Menu","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}"),
("277","3","13","14","2","com_banners.category.92","Banner Mainboard","{}"),
("278","18","303","304","2","com_modules.module.152","Home - Our Team","{}"),
("279","18","305","306","2","com_modules.module.153","SJ Mega Menu Vertical - Arabic","{}"),
("281","18","307","308","2","com_modules.module.155","Twitter Feeds","{}"),
("283","18","309","310","2","com_modules.module.157","Instagram","{}"),
("284","18","311","312","2","com_modules.module.158","Home - Slideshow","{}"),
("285","18","313","314","2","com_modules.module.159","Home - Our services","{}"),
("286","18","315","316","2","com_modules.module.160","Home - Our Product","{}"),
("287","18","317","318","2","com_modules.module.161","Home - Faq","{}"),
("288","18","319","320","2","com_modules.module.162","Our information","{}"),
("289","18","321","322","2","com_modules.module.163","Html Latest Blog","{}"),
("290","18","323","324","2","com_modules.module.164","Latest news","{}"),
("291","18","325","326","2","com_modules.module.165","Contact Me","{}"),
("292","18","327","328","2","com_modules.module.166","Search sidebar left","{}"),
("293","18","329","330","2","com_modules.module.167","Recent Posts","{}"),
("294","18","331","332","2","com_modules.module.168","Recent Posts","{}"),
("295","18","333","334","2","com_modules.module.169","Instagram ","{}"),
("296","18","335","336","2","com_modules.module.170","Archives","{}"),
("297","18","337","338","2","com_modules.module.171","Archives","{}"),
("298","18","339","340","2","com_modules.module.172","Working Time","{}"),
("299","18","341","342","2","com_modules.module.173","Home - Our Awards","{}"),
("301","18","343","344","2","com_modules.module.175","We and our features ","{}"),
("302","18","345","346","2","com_modules.module.176","Home - Our Project","{}"),
("303","18","347","348","2","com_modules.module.177","Home - Testimonials","{}"),
("304","18","349","350","2","com_modules.module.178","Html - Contact Us","{}"),
("305","18","351","352","2","com_modules.module.179","Smart Search","{}"),
("306","18","353","354","2","com_modules.module.180","Search Menu","{}"),
("307","11","203","204","2","com_languages.language.1","English ","{}"),
("308","1","466","467","1","com_privacy","com_privacy","{}"),
("309","1","468","469","1","com_actionlogs","com_actionlogs","{}"),
("311","18","355","356","2","com_modules.module.201","SP Page Builder","{}"),
("312","180","455","456","2","com_sppagebuilder.page.1","Home","{}"),
("313","18","357","358","2","com_modules.module.202","Newsletter","{}");


DROP TABLE IF EXISTS #__associations;
CREATE TABLE `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS #__categories;
CREATE TABLE `#__categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_alias` (`alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=93 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__categories VALUES
("1","0","0","0","109","0","","system","ROOT","root","","","1",NULL,NULL,"1","{}","","","","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("9","34","1","5","6","1","uncategorised","com_content","Uncategorised","uncategorised","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("10","35","1","77","78","1","uncategorised","com_banners","Uncategorised","uncategorised","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\",\"foobar\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("11","36","1","73","74","1","uncategorised","com_contact","Uncategorised","uncategorised","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("12","37","1","9","10","1","uncategorised","com_newsfeeds","Uncategorised","uncategorised","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("15","40","1","75","76","1","sample-data-banners","com_banners","Sample Data-Banners","sample-data-banners","","","-2",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\",\"foobar\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("16","41","1","11","72","1","sample-data-contact","com_contact","Sample Data-Contact","sample-data-contact","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("17","42","1","7","8","1","sample-data-newsfeeds","com_newsfeeds","Sample Data-Newsfeeds","sample-data-newsfeeds","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("19","44","1","1","4","1","joomla","com_content","Joomla!","joomla","","","1",NULL,NULL,"1","{\"category_layout\":\"\",\"image\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","864","2015-02-02 06:05:15","0","*","1"),
("21","46","19","2","3","2","joomla/components","com_content","Components","components","","<p>Components are larger extensions that produce the major content for your site. Each component has one or more \"views\" that control how content is displayed. In the Joomla administrator there are additional extensions such as Menus, Redirection, and the extension managers.</p>","1",NULL,NULL,"1","{\"category_layout\":\"\",\"image\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","864","2015-02-02 06:05:23","0","*","1"),
("34","59","16","12","13","2","sample-data-contact/park-site","com_contact","Park Site","park-site","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","en-GB","1"),
("35","60","16","14","71","2","sample-data-contact/shop-site","com_contact","Shop Site","shop-site","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("36","61","35","15","16","3","sample-data-contact/shop-site/staff","com_contact","Staff","staff","","<p>Please feel free to contact our staff at any time should you need assistance.</p>","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("37","62","35","17","70","3","sample-data-contact/shop-site/fruit-encyclopedia","com_contact","Fruit Encyclopedia","fruit-encyclopedia","","<p> </p><p>Our directory of information about different kinds of fruit.</p><p>We love fruit and want the world to know more about all of its many varieties.</p><p>Although it is small now, we work on it whenever we have a chance.</p><p>All of the images can be found in <a href=\"http://commons.wikimedia.org/wiki/Main_Page\">Wikimedia Commons</a>.</p><p><img src=\"images/sampledata/fruitshop/apple.jpg\" border=\"0\" alt=\"Apples\" title=\"Apples\" /></p><p><em>This encyclopedia is implemented using the contact component, each fruit a separate contact and a category for each letter. A CSS style is used to create the horizontal layout of the alphabet headings. </em></p><p><em>If you wanted to, you could allow some users (such as your growers) to have access to just this category in the contact component and let them help you to create new content for the encyclopedia.</em></p><p> </p>","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("38","63","37","18","19","4","sample-data-contact/shop-site/fruit-encyclopedia/a","com_contact","A","a","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("39","64","37","20","21","4","sample-data-contact/shop-site/fruit-encyclopedia/b","com_contact","B","b","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("40","65","37","22","23","4","sample-data-contact/shop-site/fruit-encyclopedia/c","com_contact","C","c","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("41","66","37","24","25","4","sample-data-contact/shop-site/fruit-encyclopedia/d","com_contact","D","d","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("42","67","37","26","27","4","sample-data-contact/shop-site/fruit-encyclopedia/e","com_contact","E","e","","","0",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("43","68","37","28","29","4","sample-data-contact/shop-site/fruit-encyclopedia/f","com_contact","F","f","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("44","69","37","30","31","4","sample-data-contact/shop-site/fruit-encyclopedia/g","com_contact","G","g","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("45","70","37","32","33","4","sample-data-contact/shop-site/fruit-encyclopedia/h","com_contact","H","h","","","0",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("46","71","37","34","35","4","sample-data-contact/shop-site/fruit-encyclopedia/i","com_contact","I","i","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("47","72","37","36","37","4","sample-data-contact/shop-site/fruit-encyclopedia/j","com_contact","J","j","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("48","73","37","38","39","4","sample-data-contact/shop-site/fruit-encyclopedia/k","com_contact","K","k","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("49","74","37","40","41","4","sample-data-contact/shop-site/fruit-encyclopedia/l","com_contact","L","l","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("50","75","37","42","43","4","sample-data-contact/shop-site/fruit-encyclopedia/m","com_contact","M","m","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("51","76","37","44","45","4","sample-data-contact/shop-site/fruit-encyclopedia/n","com_contact","N","n","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("52","77","37","46","47","4","sample-data-contact/shop-site/fruit-encyclopedia/o","com_contact","O","o","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("53","78","37","48","49","4","sample-data-contact/shop-site/fruit-encyclopedia/p","com_contact","P","p","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("54","79","37","50","51","4","sample-data-contact/shop-site/fruit-encyclopedia/q","com_contact","Q","q","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("55","80","37","52","53","4","sample-data-contact/shop-site/fruit-encyclopedia/r","com_contact","R","r","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("56","81","37","54","55","4","sample-data-contact/shop-site/fruit-encyclopedia/s","com_contact","S","s","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("57","82","37","56","57","4","sample-data-contact/shop-site/fruit-encyclopedia/t","com_contact","T","t","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("58","83","37","58","59","4","sample-data-contact/shop-site/fruit-encyclopedia/u","com_contact","U","u","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("59","84","37","60","61","4","sample-data-contact/shop-site/fruit-encyclopedia/v","com_contact","V","v","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("60","85","37","62","63","4","sample-data-contact/shop-site/fruit-encyclopedia/w","com_contact","W","w","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("61","86","37","64","65","4","sample-data-contact/shop-site/fruit-encyclopedia/x","com_contact","X","x","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("62","87","37","66","67","4","sample-data-contact/shop-site/fruit-encyclopedia/y","com_contact","Y","y","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("63","88","37","68","69","4","sample-data-contact/shop-site/fruit-encyclopedia/z","com_contact","Z","z","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("77","169","1","79","80","1","uncategorised","com_users","Uncategorised","uncategorised","","","1",NULL,NULL,"1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","739","2011-01-01 00:00:01","739","2011-01-01 00:00:01","0","*","1"),
("79","179","1","81","90","1","blog","com_content","Blog","blog","","","1",NULL,NULL,"1","{\"category_layout\":\"\",\"image\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","739","2015-02-02 06:12:46","739","2015-02-02 06:12:46","0","*","1"),
("80","191","79","82","83","2","blog/news","com_content","News","news","","","1",NULL,NULL,"1","{\"category_layout\":\"\",\"image\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","739","2015-02-02 18:42:14","864","2015-02-02 18:42:30","0","*","1"),
("81","192","79","84","85","2","blog/tutorial","com_content","Tutorial","tutorial","","","1",NULL,NULL,"1","{\"category_layout\":\"\",\"image\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","739","2015-02-02 18:42:46","739","2015-02-02 18:42:46","0","*","1"),
("82","193","79","86","87","2","blog/review","com_content","Review","review","","","1",NULL,NULL,"1","{\"category_layout\":\"\",\"image\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","739","2015-02-02 18:42:56","739","2015-02-02 18:42:56","0","*","1"),
("83","194","79","88","89","2","blog/updates","com_content","Updates","updates","","","1",NULL,NULL,"1","{\"category_layout\":\"\",\"image\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","739","2015-02-02 18:43:15","739","2015-02-02 18:43:15","0","*","1"),
("84","228","1","91","92","1","trending-post","com_content","Trending Post","trending-post","","","1",NULL,NULL,"1","{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","739","2017-04-20 02:47:43","0","2017-04-20 02:47:43","0","*","1"),
("85","229","1","93","94","1","life-styles","com_content","Life Styles","life-styles","","","1",NULL,NULL,"1","{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","739","2017-04-20 02:48:05","0","2017-04-20 02:48:05","0","*","1"),
("86","230","1","95","96","1","world-news","com_content","World News","world-news","","","1",NULL,NULL,"1","{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","739","2017-04-20 02:48:28","0","2017-04-20 02:48:28","0","*","1"),
("87","231","1","97","98","1","watch-now","com_content","Watch Now","watch-now","","","1",NULL,NULL,"1","{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","739","2017-04-20 02:48:45","0","2017-04-20 02:48:45","0","*","1"),
("88","232","1","99","100","1","food-recipes","com_content","Food & Recipes","food-recipes","","","1",NULL,NULL,"1","{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","739","2017-04-20 02:49:20","0","2017-04-20 02:49:20","0","*","1"),
("89","233","1","101","102","1","entertainment","com_content","Entertainment","entertainment","","","1",NULL,NULL,"1","{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","739","2017-04-20 02:50:37","0","2017-04-20 02:50:37","0","*","1"),
("90","266","1","103","104","1","contact-form","com_contact","Contact Form","contact-form","","","1",NULL,NULL,"1","{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","739","2017-05-15 17:12:29","0","2017-05-15 17:12:29","0","*","1"),
("91","269","1","105","106","1","banner-sidebar","com_banners","Banner Sidebar","banner-sidebar","","","1",NULL,NULL,"1","{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","739","2017-05-25 17:06:58","0","2017-05-25 17:06:58","0","*","1"),
("92","277","1","107","108","1","banner-mainboard","com_banners","Banner Mainboard","banner-mainboard","","","1",NULL,NULL,"1","{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","739","2017-05-28 15:46:29","0","2017-05-28 15:46:29","0","*","1");


DROP TABLE IF EXISTS #__contact_details;
CREATE TABLE `#__contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `con_position` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` longtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname3` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__contact_details VALUES
("1","Contact Name Here","name","Position","Street Address","Suburb","State","Country","Zip Code","Telephone","Fax","<p>Information about or by the contact.</p>","images/powered_by.png","email@example.com","1","1",NULL,NULL,"1","{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"1\",\"linka_name\":\"Twitter\",\"linka\":\"http:\\/\\/twitter.com\\/joomla\",\"linkb_name\":\"YouTube\",\"linkb\":\"http:\\/\\/www.youtube.com\\/user\\/joomla\",\"linkc_name\":\"Facebook\",\"linkc\":\"http:\\/\\/www.facebook.com\\/joomla\",\"linkd_name\":\"FriendFeed\",\"linkd\":\"http:\\/\\/friendfeed.com\\/joomla\",\"linke_name\":\"Scribed\",\"linke\":\"http:\\/\\/www.scribd.com\\/people\\/view\\/504592-joomla\",\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}","0","16","1","","","last","first","middle","en-GB","2011-01-01 00:00:01","739","Joomla","2011-01-01 00:00:01","739","","","{\"robots\":\"\",\"rights\":\"\"}","1",NULL,NULL,"1","15"),
("2","Webmaster","webmaster","","","","",NULL,"","","","","","webmaster@example.com","0","1",NULL,NULL,"1","{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":\"\",\"linkb_name\":\"\",\"linkb\":\"\",\"linkc_name\":\"\",\"linkc\":\"\",\"linkd_name\":\"\",\"linkd\":\"\",\"linke_name\":\"\",\"linke\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"1\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"\",\"redirect\":\"\"}","0","34","1","","","","","","en-GB","2011-01-01 00:00:01","739","Joomla","2011-01-01 00:00:01","739","","","{\"robots\":\"\",\"rights\":\"\"}","1",NULL,NULL,"1","1"),
("3","Owner","owner","","","","",NULL,"","","","<p>I\'m the owner of this store.</p>","","","0","1",NULL,NULL,"2","{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":\"\",\"linkb_name\":\"\",\"linkb\":\"\",\"linkc_name\":\"\",\"linkc\":\"\",\"linkd_name\":\"\",\"linkd\":\"\",\"linke_name\":\"\",\"linke\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}","0","36","1","","","","","","*","2011-01-01 00:00:01","739","Joomla","2011-01-01 00:00:01","739","","","{\"robots\":\"\",\"rights\":\"\"}","1",NULL,NULL,"1","0"),
("4","Buyer","buyer","","","","",NULL,"","","","<p>I am in charge of buying fruit. If you sell good fruit, contact me.</p>","","","0","1",NULL,NULL,"1","{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"0\",\"linka_name\":\"\",\"linka\":\"\",\"linkb_name\":\"\",\"linkb\":\"\",\"linkc_name\":\"\",\"linkc\":\"\",\"linkd_name\":\"\",\"linkd\":\"\",\"linke_name\":\"\",\"linke\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}","0","36","1","","","","","","*","2011-01-01 00:00:01","739","Joomla","2011-01-01 00:00:01","739","","","{\"robots\":\"\",\"rights\":\"\"}","1",NULL,NULL,"1","2"),
("5","Bananas","bananas","Scientific Name: Musa","Image Credit: Enzik
\nRights: Creative Commons Share Alike Unported 3.0
\nSource: http://commons.wikimedia.org/wiki/File:Bananas_-_Morocco.jpg","","Type: Herbaceous","Large Producers: India, China, Brasil","","","","<p>Bananas are a great source of potassium.</p>
\n<p> </p>","images/sampledata/fruitshop/bananas_2.jpg","","0","1",NULL,NULL,"1","{\"show_contact_category\":\"show_with_link\",\"show_contact_list\":\"\",\"presentation_style\":\"plain\",\"show_name\":\"\",\"show_position\":\"1\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"1\",\"show_postcode\":\"\",\"show_country\":\"1\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"1\",\"linka_name\":\"Wikipedia: Banana English\",\"linka\":\"http:\\/\\/en.wikipedia.org\\/wiki\\/Banana\",\"linkb_name\":\"Wikipedia:  \\u0939\\u093f\\u0928\\u094d\\u0926\\u0940 \\u0915\\u0947\\u0932\\u093e\",\"linkb\":\"http:\\/\\/hi.wikipedia.org\\/wiki\\/%E0%A4%95%E0%A5%87%E0%A4%B2%E0%A4%BE\",\"linkc_name\":\"Wikipedia:Banana Portugu\\u00eas\",\"linkc\":\"http:\\/\\/pt.wikipedia.org\\/wiki\\/Banana\",\"linkd_name\":\"Wikipedia: \\u0411\\u0430\\u043d\\u0430\\u043d  \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439\",\"linkd\":\"http:\\/\\/ru.wikipedia.org\\/\\u0411\\u0430\\u043d\\u0430\\u043d\",\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"beez5:encyclopedia\"}","0","39","1","","","","","","*","2011-01-01 00:00:01","739","Joomla","2011-01-01 00:00:01","739","","","{\"robots\":\"\",\"rights\":\"\"}","0",NULL,NULL,"1","0"),
("6","Apples","apples","Scientific Name: Malus domestica","Image Credit: Fievet
\nRights: Public Domain
\nSource: http://commons.wikimedia.org/wiki/File:Pommes_vertes.JPG","","Family: Rosaceae","Large: Producers: China, United States","","","","<p>Apples are a versatile fruit, used for eating, cooking, and preserving.</p>
\n<p>There are more that 7500 different kinds of apples grown around the world.</p>","images/sampledata/fruitshop/apple.jpg","","0","1",NULL,NULL,"1","{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"plain\",\"show_tags\":\"\",\"show_info\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_image\":\"\",\"show_misc\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"articles_display_num\":\"\",\"show_profile\":\"\",\"show_links\":\"1\",\"linka_name\":\"Wikipedia: Apples English\",\"linka\":\"http:\\/\\/en.wikipedia.org\\/wiki\\/Apple\",\"linkb_name\":\"Wikipedia: Manzana Espa\\u00f1ol \",\"linkb\":\"http:\\/\\/es.wikipedia.org\\/wiki\\/Manzana\",\"linkc_name\":\"Wikipedia: \\u82f9\\u679c \\u4e2d\\u6587\",\"linkc\":\"http:\\/\\/zh.wikipedia.org\\/zh\\/\\u82f9\\u679c\",\"linkd_name\":\"Wikipedia: Tofaa Kiswahili\",\"linkd\":\"http:\\/\\/sw.wikipedia.org\\/wiki\\/Tofaa\",\"linke_name\":\"\",\"linke\":false,\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}","0","38","1","","","","","","*","2011-01-01 00:00:01","739","Joomla","2017-05-15 17:13:33","507","","","{\"robots\":\"\",\"rights\":\"\"}","0",NULL,NULL,"2","1"),
("7","Tamarind","tamarind","Scientific Name: Tamarindus indica","Image Credit: Franz Eugen Köhler, Köhler\'s Medizinal-Pflanzen 
\nRights: Public Domain
\nSource:http://commons.wikimedia.org/wiki/File:Koeh-134.jpg","","Family: Fabaceae","Large Producers: India, United States","","","","<p>Tamarinds are a versatile fruit used around the world. In its young form it is used in hot sauces; ripened it is the basis for many refreshing drinks.</p>
\n<p> </p>","images/sampledata/fruitshop/tamarind.jpg","","0","1",NULL,NULL,"1","{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"plain\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"1\",\"linka_name\":\"Wikipedia: Tamarind English\",\"linka\":\"http:\\/\\/en.wikipedia.org\\/wiki\\/Tamarind\",\"linkb_name\":\"Wikipedia: \\u09a4\\u09c7\\u0981\\u09a4\\u09c1\\u09b2  \\u09ac\\u09be\\u0982\\u09b2\\u09be  \",\"linkb\":\"http:\\/\\/bn.wikipedia.org\\/wiki\\/\\u09a4\\u09c7\\u0981\\u09a4\\u09c1\\u09b2 \",\"linkc_name\":\"Wikipedia: Tamarinier Fran\\u00e7ais\",\"linkc\":\"http:\\/\\/fr.wikipedia.org\\/wiki\\/Tamarinier\",\"linkd_name\":\"Wikipedia:Tamaline lea faka-Tonga\",\"linkd\":\"http:\\/\\/to.wikipedia.org\\/wiki\\/Tamaline\",\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"beez5:encyclopedia\"}","0","57","1","","","","","","*","2011-01-01 00:00:01","739","Joomla","2011-01-01 00:00:01","739","","","{\"robots\":\"\",\"rights\":\"\"}","0",NULL,NULL,"1","0"),
("8","Shop Address","shop-address","","","Our City","Our Province","Our Country","","555-555-5555","","<p>Here are directions for how to get to our shop.</p>","","","0","1",NULL,NULL,"1","{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":\"\",\"linkb_name\":\"\",\"linkb\":\"\",\"linkc_name\":\"\",\"linkc\":\"\",\"linkd_name\":\"\",\"linkd\":\"\",\"linke_name\":\"\",\"linke\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}","0","35","1","","","","","","*","2011-01-01 00:00:01","739","Joomla","2011-01-01 00:00:01","739","","","{\"robots\":\"\",\"rights\":\"\"}","1",NULL,NULL,"1","1"),
("9","Contact Form","contact-form","","Room 302, No 18 Lane 11, Thai Ha Street, Trung Liet, Dong Da, Hanoi, Vietnam ","","",NULL,"","+84 (04) 3514 9260","","","images/corporate1.jpg","contact@ytcvn.com","0","-2",NULL,NULL,"3","{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_tags\":\"\",\"show_info\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_image\":\"\",\"show_misc\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"articles_display_num\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":false,\"linkb_name\":\"\",\"linkb\":false,\"linkc_name\":\"\",\"linkc\":false,\"linkd_name\":\"\",\"linkd\":false,\"linke_name\":\"\",\"linke\":false,\"contact_layout\":\"_:default\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}","507","90","1","+84 (04) 3514 9260","https://www.smartaddons.com/","","","","*","2017-05-15 17:16:36","739","","2017-05-24 15:50:02","507","","","{\"robots\":\"\",\"rights\":\"\"}","0","2017-05-24 15:55:48",NULL,"3","0"),
("10","Contact Us","contact-us","CEO","1233, 20th Street,
\nN.W. Suite 400
\nWashington DC, 20036","Washington DC","","England","","+84 (0123) 456 7899","+84 (0123) 456 7899","","images/testimonial.png","contact@ytcvn.com","0","1",NULL,NULL,"4","{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_tags\":\"\",\"show_info\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"add_mailto_link\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_image\":\"\",\"show_misc\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"articles_display_num\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":false,\"linkb_name\":\"\",\"linkb\":false,\"linkc_name\":\"\",\"linkc\":false,\"linkd_name\":\"\",\"linkd\":false,\"linke_name\":\"\",\"linke\":false,\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}","507","16","1","+84 (0123) 456 7890","https://www.smartaddons.com/","","","","*","2017-05-24 16:01:32","739","","2017-09-11 09:38:14","266","","","{\"robots\":\"\",\"rights\":\"\"}","0",NULL,NULL,"4","0"),
("11","Hằng","h-ng","","","","",NULL,"","","","","","hangltt@ytcvn.com","0","0",NULL,NULL,"0","","508","34","1","","","","","","*","2017-09-27 09:04:56","739","","2017-09-27 09:04:56","0","","","","0",NULL,NULL,"1","0");


DROP TABLE IF EXISTS #__content;
CREATE TABLE `#__content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(191))
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__content VALUES
("1","89","Administrator Components","administrator-components","<p>All components are also used in the administrator area of your website. In addition to the ones listed here, there are components in the administrator that do not have direct front end displays, but do help shape your site. The most important ones for most users are</p>
\n<ul>
\n<li>Media Manager</li>
\n<li>Extensions Manager</li>
\n<li>Menu Manager</li>
\n<li>Global Configuration</li>
\n<li>Banners</li>
\n<li>Redirect</li>
\n</ul>
\n<hr title=\"Media Manager\" alt=\"Media Manager\" class=\"system-pagebreak\" style=\"color: gray; border: 1px dashed gray;\" />
\n<p> </p>
\n<h3>Media Manager</h3>
\n<p>The media manager component lets you upload and insert images into content throughout your site. Optionally, you can enable the flash uploader which will allow you to to upload multiple images. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Content_Media_Manager\">Help</a></p>
\n<hr title=\"Extensions Manager\" alt=\"Extensions Manager\" class=\"system-pagebreak\" style=\"color: gray; border: 1px dashed gray;\" />
\n<h3>Extensions Manager</h3>
\n<p>The extensions manager lets you install, update, uninstall and manage all of your extensions. The extensions manager has been extensively redesigned, although the core install and uninstall functionality remains the same as in Joomla! 1.5. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Extensions_Extension_Manager_Install\">Help</a></p>
\n<hr title=\"Menu Manager\" alt=\"Menu Manager\" class=\"system-pagebreak\" style=\"color: gray; border: 1px dashed gray;\" />
\n<h3>Menu Manager</h3>
\n<p>The menu manager lets you create the menus you see displayed on your site. It also allows you to assign modules and template styles to specific menu links. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Menus_Menu_Manager\">Help</a></p>
\n<hr title=\"Global Configuration\" alt=\"Global Configuration\" class=\"system-pagebreak\" style=\"color: gray; border: 1px dashed gray;\" />
\n<h3>Global Configuration</h3>
\n<p>The global configuration is where the site administrator configures things such as whether search engine friendly urls are enabled, the site meta data (descriptive text used by search engines and indexers) and other functions. For many beginning users simply leaving the settings on default is a good way to begin, although when your site is ready for the public you will want to change the meta data to match its content. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Site_Global_Configuration\">Help</a></p>
\n<hr title=\"Banners\" alt=\"Banners\" class=\"system-pagebreak\" style=\"color: gray; border: 1px dashed gray;\" />
\n<h3>Banners</h3>
\n<p>The banners component provides a simple way to display a rotating image in a module and, if you wish to have advertising, a way to track the number of times an image is viewed and clicked. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Banners_Banners_Edit\">Help</a></p>
\n<hr title=\"Redirect\" class=\"system-pagebreak\" />
\n<h3><br />Redirect</h3>
\n<p>The redirect component is used to manage broken links that produce Page Not Found (404) errors. If enabled it will allow you to redirect broken links to specific pages. It can also be used to manage migration related URL changes. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Redirect_Manager\">Help</a></p>","","1","21","2011-01-01 00:00:01","739","Joomla","2011-01-01 00:00:01","739",NULL,NULL,"2011-01-01 00:00:01",NULL,"{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}","1","7","","","1","7","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("8","104","Beginners","beginners","<p>If this is your first Joomla! site or your first web site, you have come to the right place. Joomla will help you get your website up and running quickly and easily.</p>
\n<p>Start off using your site by logging in using the administrator account you created when you installed Joomla.</p>
\n","
\n<p>Explore the articles and other resources right here on your site data to learn more about how Joomla works. (When you\'re done reading, you can delete or archive all of this.) You will also probably want to visit the Beginners\' Areas of the <a href=\"http://docs.joomla.org/Beginners\">Joomla documentation</a> and <a href=\"http://forum.joomla.org\">support forums</a>.</p>
\n<p>You\'ll also want to sign up for the Joomla Security Mailing list and the Announcements mailing list. For inspiration visit the <a href=\"http://community.joomla.org/showcase/\">Joomla! Site Showcase</a> to see an amazing array of ways people use Joomla to tell their stories on the web.</p>
\n<p>The basic Joomla installation will let you get a great site up and running, but when you are ready for more features the power of Joomla is in the creative ways that developers have extended it to do all kinds of things. Visit the <a href=\"http://extensions.joomla.org/\">Joomla! Extensions Directory</a> to see thousands of extensions that can do almost anything you could want on a website. Can\'t find what you need? You may want to find a Joomla professional in the <a href=\"http://resources.joomla.org/\">Joomla! Resource Directory</a>.</p>
\n<p>Want to learn more? Consider attending a <a href=\"http://community.joomla.org/events.html\">Joomla! Day</a> or other event or joining a local <a href=\"http://community.joomla.org/user-groups.html\">Joomla! Users Group</a>. Can\'t find one near you? Start one yourself.</p>","1","19","2011-01-01 00:00:01","739","Joomla","2017-09-07 07:42:58","266",NULL,NULL,"2011-01-01 00:00:01",NULL,"{\"image_intro\":\"images\\/articles\\/a1.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}","{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}","3","4","","","1","12","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","1","*",""),
("9","105","Contacts","contact","<p>The contact component provides a way to provide contact forms and information for your site or to create a complex directory that can be used for many different purposes. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Contacts_Contacts\">Help</a></p>","","1","21","2011-01-01 00:00:01","739","Joomla","2011-01-01 00:00:01","739",NULL,NULL,"2011-01-01 00:00:01",NULL,"","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","1","2","","","1","1","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("10","106","Content","content","<p>The content component (com_content) is what you use to write articles. It is extremely flexible and has the largest number of built in views. Articles can be created and edited from the front end, making content the easiest component to use to create your site content. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Content_Article_Manager\">Help</a></p>","","1","21","2011-01-01 00:00:01","739","Joomla","2011-01-01 00:00:01","739",NULL,NULL,"2011-01-01 00:00:01",NULL,"","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","1","1","","","1","3","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("21","119","Getting Help","getting-help","<p> There are lots of places you can get help with Joomla!. In many places in your site administrator you will see the help icon. Click on this for more information about the options and functions of items on your screen. Other places to get help are:</p>
\n<ul>
\n<li><a href=\"http://forum.joomla.org\">Support Forums</a></li>
\n<li><a href=\"http://docs.joomla.org\">Documentation</a></li>
\n<li><a href=\"http://resources.joomla.org\">Professionals</a></li>
\n<li><a href=\"http://shop.joomla.org/amazoncom-bookstores.html\">Books</a></li>
\n</ul>","","1","19","2011-01-01 00:00:01","739","Joomla","2017-09-07 07:43:47","266",NULL,NULL,"2011-01-01 00:00:01",NULL,"{\"image_intro\":\"images\\/articles\\/a2.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}","{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}","3","8","","","1","5","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("22","120","Getting Started","getting-started","<p>It\'s easy to get started creating your website. Knowing some of the basics will help.</p>
\n<h3>What is a Content Management System?</h3>
\n<p>A content management system is software that allows you to create and manage webpages easily by separating the creation of your content from the mechanics required to present it on the web.</p>
\n<p>In this site, the content is stored in a <em>database</em>. The look and feel are created by a <em>template</em>. The Joomla! software brings together the template and the content to create web pages.</p>
\n<h3>Site and Administrator</h3>
\n<p>Your site actually has two separate sites. The site (also called the front end) is what visitors to your site will see. The administrator (also called the back end) is only used by people managing your site. You can access the administrator by clicking the \"Site Administrator\" link on the \"This Site\" menu or by adding /administrator to the end of you domain name.</p>
\n<p>Log in to the administrator using the username and password created during the installation of Joomla.</p>
\n<h3>Logging in</h3>
\n<p>To login to the front end of your site use the login form or the login menu link on the \"This Site\" menu. Use the user name and password that were created as part of the installation process. Once logged-in you will be able to create and edit articles.</p>
\n<p>In managing your site, you will be able to create content that only logged-in users are able to see.</p>
\n<h3>Creating an article</h3>
\n<p>Once you are logged-in, a new menu will be visible. To create a new article, click on the \"submit article\" link on that menu.</p>
\n<p>The new article interface gives you a lot of options, but all you need to do is add a title and put something in the content area. To make it easy to find, set the state to published and put it in the Joomla category.</p>
\n<div>You can edit an existing article by clicking on the edit icon (this only displays to users who have the right to edit).</div>
\n<h3>Learn more</h3>
\n<p>There is much more to learn about how to use Joomla! to create the web site you envision. You can learn much more at the <a href=\"http://docs.joomla.org\">Joomla! documentation site</a> and on the<a href=\"http://forum.joomla.org\"> Joomla! forums</a>.</p>","","1","19","2011-01-01 00:00:01","739","Joomla","2017-09-07 07:49:33","266",NULL,NULL,"2011-01-01 00:00:01",NULL,"{\"image_intro\":\"images\\/articles\\/a3.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}","{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}","3","9","","","1","69","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("24","122","Joomla!","joomla","<p>Congratulations! You have a Joomla site! Joomla makes it easy to build a website just the way you want it and keep it simple to update and maintain.</p>
\n<p>Joomla is a flexible and powerful platform, whether you are building a small site for yourself or a huge site with hundreds of thousands of visitors. Joomla is open source, which means you can make it work just the way you want it to.</p>
\n<p>The content in this installation of Joomla has been designed to give you an in depth tour of Joomla\'s features.</p>","","1","19","2011-01-01 00:00:01","739","Joomla","2017-09-07 07:50:01","266",NULL,NULL,"2011-01-01 00:00:01",NULL,"{\"image_intro\":\"images\\/articles\\/a4.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}","{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}","5","2","","","1","11","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("32","130","Options","options","<p>As you make your Joomla! site you will control the details of the display using <em>options</em> also referred to as <em>parameter</em><strong>s</strong>. Options control everything from whether the author\'s name is displayed to who can view what to the number of items shown on a list.</p>
\n<p>Default options for each component are changed using the Options button on the component toolbar.</p>
\n<p>Options can also be set on an individual item, such as an article or contact and in menu links.</p>
\n<p>If you are happy with how your site looks, it is fine to leave all of the options set to the defaults that were created when your site was installed. As you become more experienced with Joomla you will use options more.</p>
\n<p> </p>","","1","19","2011-01-01 00:00:01","739","Joomla","2017-09-07 07:45:48","266",NULL,NULL,"2011-01-01 00:00:01",NULL,"{\"image_intro\":\"images\\/articles\\/a5.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}","{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}","2","10","","","1","9","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("35","133","Professionals","professionals","<p>Joomla! 3 continues development of the Joomla Platform and CMS as a powerful and flexible way to bring your vision of the web to reality. With the new administrator interface and adoption of Twitter Bootstrap, the ability to control its look and the management of extensions is now complete.</p>
\n","
\n<p>Working with multiple template styles and overrides for the same views, creating the design you want is easier than it has ever been. Limiting support to PHP 5.3.10 and above makes Joomla lighter and faster than ever. </p>
\n<p>The separation of the Joomla! Platform project from the Joomla! CMS project makes continuous development of new, powerful APIs and continuous improvement of existing APIs possible while maintaining the stability of the CMS that millions of webmasters and professionals rely upon.</p>","1","19","2011-01-01 00:00:01","739","Joomla","2017-09-07 07:46:23","266",NULL,NULL,"2011-01-09 16:41:13",NULL,"{\"image_intro\":\"images\\/articles\\/a6.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}","{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}","3","5","","","1","44","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("38","136","Sample Sites","sample-sites","<p>Your installation includes sample data, designed to show you some of the options you have for building your website. In addition to information about Joomla! there are two sample \"sites within a site\" designed to help you get started with building your own site.</p>
\n<p>The first site is a simple site about <a href=\"index.php?Itemid=243\">Australian Parks</a>. It shows how you can quickly and easily build a personal site with just the building blocks that are part of Joomla. It includes a personal blog, weblinks, and a very simple image gallery.</p>
\n<p>The second site is slightly more complex and represents what you might do if you are building a site for a small business, in this case a <a href=\"index.php?Itemid=429\">Fruit Shop</a>.</p>
\n<p>In building either style site, or something completely different, you will probably want to add <a href=\"http://extensions.joomla.org\">extensions</a> and either create or purchase your own template. Many Joomla users start by modifying the <a href=\"http://docs.joomla.org/How_do_you_modify_a_template%3F\">templates</a> that come with the core distribution so that they include special images and other design elements that relate to their site\'s focus.</p>","","1","19","2011-01-01 00:00:01","739","Joomla","2017-09-07 07:47:01","266",NULL,NULL,"2011-01-01 00:00:01",NULL,"{\"image_intro\":\"images\\/articles\\/a7.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}","{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}","2","11","","","1","15","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("39","137","Search","search-component","<p>Joomla! 2.5 offers two search options.</p>
\n<p>The Basic Search component provides basic search functionality for the information contained in your core components. Many extensions can also be searched by the search component. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Search\">Help</a></p>
\n<p>The Smart Search component offers searching similar to that found in major search engines. Smart Search is disabled by default. If you choose to enable it you will need to take several steps. First, enable the Smart Search Plugin in the plugin manager. Then, if you are using the Basic Search Module replace it with the Smart Search Module. Finally, if you have already created content, go to the Smart Search component in your site administrator and click the Index icon. Once indexing of your content is complete, Smart Search will be ready to use. Help.</p>","","1","21","2011-01-01 00:00:01","739","Joomla","2011-01-01 00:00:01","739",NULL,NULL,"2011-01-01 00:00:01",NULL,"{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}","1","3","","","1","43","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("47","145","The Joomla! Community","the-joomla-community","<p>Joomla means All Together, and it is a community of people all working and having fun together that makes Joomla possible. Thousands of people each year participate in the Joomla community, and we hope you will be one of them.</p>
\n<p>People with all kinds of skills, of all skill levels and from around the world are welcome to join in. Participate in the <a href=\"http://joomla.org\">Joomla.org</a> family of websites (the<a href=\"http://forum.joomla.org\"> forum </a>is a great place to start). Come to a <a href=\"http://community.joomla.org/events.html\">Joomla! event</a>. Join or start a <a href=\"http://community.joomla.org/user-groups.html\">Joomla! Users Group</a>. Whether you are a developer, site administrator, designer, end user or fan, there are ways for you to participate and contribute.</p>","","1","19","2011-01-01 00:00:01","739","Joomla","2017-09-07 07:47:27","266",NULL,NULL,"2011-01-01 00:00:01",NULL,"{\"image_intro\":\"images\\/articles\\/a8.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}","{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}","2","3","","","1","2","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("48","146","The Joomla! Project","the-joomla-project","<p>The Joomla Project consists of all of the people who make and support the Joomla Web Platform and Content Management System.</p>
\n<p>Our mission is to provide a flexible platform for digital publishing and collaboration.</p>
\n<p>The core values are:</p>
\n<ul>
\n<li>Freedom</li>
\n<li>Equality</li>
\n<li>Trust</li>
\n<li>Community</li>
\n<li>Collaboration</li>
\n<li>Usability</li>
\n</ul>
\n<p>In our vision, we see:</p>
\n<ul>
\n<li>People publishing and collaborating in their communities and around the world</li>
\n<li>Software that is free, secure, and high-quality</li>
\n<li>A community that is enjoyable and rewarding to participate in</li>
\n<li>People around the world using their preferred languages</li>
\n<li>A project that acts autonomously</li>
\n<li>A project that is socially responsible</li>
\n<li>A project dedicated to maintaining the trust of its users</li>
\n</ul>
\n<p>There are millions of users around the world and thousands of people who contribute to the Joomla Project. They work in three main groups: the Production Working Group, responsible for everything that goes into software and documentation; the Community Working Group, responsible for creating a nurturing the community; and Open Source Matters, the non profit organization responsible for managing legal, financial and organizational issues.</p>
\n<p>Joomla is a free and open source project, which uses the GNU General Public License version 2 or later.</p>","","1","19","2011-01-01 00:00:01","739","Joomla","2011-01-01 00:00:01","739",NULL,NULL,"2011-01-01 00:00:01",NULL,"{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}","1","1","","","1","4","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("50","148","Upgraders","upgraders","<p>If you are an experienced Joomla! user, this Joomla site will seem very familiar but also very different. The biggest change is the new administrator interface and the adoption of responsive design. Hundreds of other improvements have been made.</p>
\n<p> </p>
\n<p> </p>","","1","19","2011-01-01 00:00:01","739","Joomla","2012-09-25 07:12:10","123",NULL,NULL,"2011-01-01 00:00:01",NULL,"{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}","3","6","","","1","3","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("52","150","Users","users-component","<p>The users extension lets your site visitors register, login and logout, change their passwords and other information, and recover lost passwords. In the administrator it allows you to create, block and manage users and create user groups and access levels. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Users_User_Manager\">Help</a></p>
\n<p>Please note that some of the user views will not display if you are not logged-in to the site.</p>","","1","21","2011-01-01 00:00:01","739","Joomla","2011-01-01 00:00:01","739",NULL,NULL,"2011-01-01 00:00:01",NULL,"","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","1","5","","","1","0","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("53","151","Using Joomla!","using-joomla","<p>With Joomla you can create anything from a simple personal website to a complex ecommerce or social site with millions of visitors.</p>
\n<p>This section of the sample data provides you with a brief introduction to Joomla concepts and reference material to help you understand how Joomla works.</p>
\n<p><em>When you no longer need the sample data, you can can simply unpublish the sample data category found within each extension in the site administrator or you may completely delete each item and all of the categories. </em></p>","","1","19","2011-01-01 00:00:01","739","Joomla","2011-01-01 00:00:01","739",NULL,NULL,"2011-01-01 00:00:01",NULL,"{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}","1","7","","","1","9","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("60","158","News Feeds","news-feeds","<p>News Feeds (com_newsfeeds) provides a way to organize and present news feeds. News feeds are a way that you present information from another site on your site. For example, the joomla.org website has numerous feeds that you can incorporate on your site. You an use menus to present a single feed, a list of feeds in a category, or a list of all feed categories. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Newsfeeds_Feeds\">Help</a></p>","","1","21","2011-01-01 00:00:01","739","Joomla","2011-01-01 00:00:01","739",NULL,NULL,"2011-01-01 00:00:01",NULL,"{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}","1","4","","","1","37","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("67","168","What\'s New in 1.5?","whats-new-in-15","<p>This article deliberately archived as an example.</p><p>As with previous releases, Joomla! provides a unified and easy-to-use framework for delivering content for Web sites of all kinds. To support the changing nature of the Internet and emerging Web technologies, Joomla! required substantial restructuring of its core functionality and we also used this effort to simplify many challenges within the current user interface. Joomla! 1.5 has many new features.</p>
\n<p style=\"margin-bottom: 0in;\">In Joomla! 1.5, you\'\'ll notice:</p>
\n<ul>
\n<li>Substantially improved usability, manageability, and scalability far beyond the original Mambo foundations</li>
\n<li>Expanded accessibility to support internationalisation, double-byte characters and right-to-left support for Arabic, Farsi, and Hebrew languages among others</li>
\n<li>Extended integration of external applications through Web services</li>
\n<li>Enhanced content delivery, template and presentation capabilities to support accessibility standards and content delivery to any destination</li>
\n<li>A more sustainable and flexible framework for Component and Extension developers</li>
\n<li>Backward compatibility with previous releases of Components, Templates, Modules, and other Extensions</li>
\n</ul>","","2","9","2011-01-01 00:00:01","739","Joomla","2011-01-01 00:00:01","739",NULL,NULL,"2011-01-01 00:00:01",NULL,"","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_readmore\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"page_title\":\"\",\"alternative_readmore\":\"\",\"layout\":\"\"}","1","0","","","1","0","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("71","195","Doner spare ribs pastrami shank","doner-spare-ribs-pastrami-shank","<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>
\n","
\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>","1","79","2015-02-02 18:56:08","739","","2017-12-06 14:32:46","621",NULL,NULL,"2015-02-02 18:56:08",NULL,"{\"image_intro\":\"images\\/blog\\/6.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}","{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"status\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"<blockquote class=\\\"twitter-tweet\\\" lang=\\\"en\\\"><p>Published a new blog entry One Month Extra for all JoomShaper Members in News. <a href=\\\"http:\\/\\/t.co\\/2pQYdykKy8\\\">http:\\/\\/t.co\\/2pQYdykKy8<\\/a><\\/p>&mdash; JoomShaper (@joomshaper) <a href=\\\"https:\\/\\/twitter.com\\/joomshaper\\/status\\/562210375480139777\\\">February 2, 2015<\\/a><\\/blockquote>\\r\\n<script async src=\\\"\\/\\/platform.twitter.com\\/widgets.js\\\" charset=\\\"utf-8\\\"><\\/script>\"}","7","6","","","1","43","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("72","196","Jerky shank chicken boudin","jerky-shank-chicken-boudin","<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>
\n","
\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>","1","79","2015-02-02 20:29:50","739","","2017-09-07 09:33:06","266",NULL,NULL,"2015-02-02 20:29:50",NULL,"{\"image_intro\":\"images\\/blog\\/blog3.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}","{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"video\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"http:\\/\\/vimeo.com\\/43426940\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}","6","5","","","1","79","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","1","*",""),
("73","197","Pellentesque Habitant Morbi Tristique","leberkas-tail-swine-pork","<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>
\n","
\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>","1","79","2015-02-02 20:29:50","739","","2017-12-06 14:35:52","621",NULL,NULL,"2015-02-02 20:29:50",NULL,"{\"image_intro\":\"images\\/blog\\/blog06.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/blog06.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}","{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}","8","4","","","1","242","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*",""),
("74","198","Meatball kevin beef ribs shoulder","meatball-kevin-beef-ribs-shoulder","<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>
\n","
\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>","1","79","2015-02-02 20:29:50","739","","2017-09-14 09:00:26","266",NULL,NULL,"2015-02-02 20:29:50",NULL,"{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/blog07.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}","{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"gallery\",\"gallery\":\"{\\\"gallery_images\\\":[\\\"images\\/blog\\/blog06.jpg\\\",\\\"images\\/blog\\/blog04.jpg\\\",\\\"images\\/2017\\/09\\/14\\/blog01.jpg\\\"]}\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}","6","3","","","1","130","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","1","*",""),
("75","199","5 Effective Email Unsubscribe Pages","5-effective-email-unsubscribe-pages","<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>
\n","
\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>","1","79","2015-02-02 20:29:50","739","","2017-12-06 14:26:34","621",NULL,NULL,"2015-02-02 20:29:50",NULL,"{\"image_intro\":\"images\\/blog\\/blog1.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}","{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"audio\",\"gallery\":\"\",\"audio\":\"<iframe width=\\\"100%\\\" height=\\\"450\\\" scrolling=\\\"no\\\" frameborder=\\\"no\\\" src=\\\"https:\\/\\/w.soundcloud.com\\/player\\/?url=https%3A\\/\\/api.soundcloud.com\\/tracks\\/28830162&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true\\\"><\\/iframe>\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}","7","2","","","1","53","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","1","*",""),
("76","200","Who Actually Clicks on Banner Ads?","who-actually-clicks-on-banner-ads","<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>
\n","
\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>","1","79","2015-02-02 20:29:50","739","","2017-05-28 14:57:57","507",NULL,NULL,"2015-02-02 20:29:50",NULL,"{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}","{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"link\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"Responive Joomla Templates\",\"link_url\":\"http:\\/\\/www.joomshaper.com\\/joomla-templates\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}","4","1","","","1","58","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","1","*",""),
("77","201","See the new Miss Universe get her crown","see-the-new-miss-universe-get-her-crown","<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>
\n","
\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>","1","79","2015-02-02 20:29:50","739","","2017-05-28 14:57:36","507",NULL,NULL,"2015-02-02 20:29:50",NULL,"{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}","{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"quote\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"Pork meatball ground round prosciutto. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Filet mignon bresaola pork boudin capicola prosciutto. Frankfurter chicken leberkas drumstick ball tip turducken rump spare ribs meatball. Tail salami pork loin ham. Drumstick flank porchetta, hamburger ham swine biltong chicken pancetta. Spare ribs prosciutto t-bone.\",\"quote_author\":\"- John Doe\",\"post_status\":\"\"}","3","0","","","1","64","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","1","*",""),
("78","234","Spectacular New Bridges That Break The Mold","spectacular-new-bridges-that-break-the-mold","<p>In a world of bamboo skyscrapers and transforming apartments, it\'s easy to forget about the bridge, the humble structure that makes getting from point A to B all the more simple.</p>","","1","84","2017-04-20 03:03:58","739","","2017-04-20 03:03:58","0",NULL,NULL,"2017-04-20 03:03:58",NULL,"{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}","{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}","{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}","1","0","","","1","1","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","1","*","");


DROP TABLE IF EXISTS #__content_frontpage;
CREATE TABLE `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `featured_up` datetime DEFAULT NULL,
  `featured_down` datetime DEFAULT NULL,
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__content_frontpage VALUES
("8","7",NULL,NULL),
("72","1",NULL,NULL),
("74","2",NULL,NULL),
("75","3",NULL,NULL),
("76","4",NULL,NULL),
("77","6",NULL,NULL),
("78","5",NULL,NULL);


DROP TABLE IF EXISTS #__content_rating;
CREATE TABLE `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',
  `rating_count` int(10) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__content_rating VALUES
("72","5","1","::1"),
("73","5","1","::1"),
("74","9","2","14.1.100.85"),
("75","4","1","::1"),
("77","5","1","::1");


DROP TABLE IF EXISTS #__content_types;
CREATE TABLE `#__content_types` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__content_types VALUES
("1","Article","com_content.article","{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"ArticleTable\",\"prefix\":\"Joomla\\\\Component\\\\Content\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"introtext\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"attribs\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"asset_id\", \"note\":\"note\"}, \"special\":{\"fulltext\":\"fulltext\"}}","ContentHelperRoute::getArticleRoute","{\"formFile\":\"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}"),
("2","Weblink","com_weblinks.weblink","{\"special\":{\"dbtable\":\"#__weblinks\",\"key\":\"id\",\"type\":\"Weblink\",\"prefix\":\"WeblinksTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{}}","WeblinksHelperRoute::getWeblinkRoute","{\"formFile\":\"administrator\\/components\\/com_weblinks\\/models\\/forms\\/weblink.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"featured\",\"images\"], \"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}"),
("3","Contact","com_contact.contact","{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"ContactTable\",\"prefix\":\"Joomla\\\\Component\\\\Contact\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}","ContactHelperRoute::getContactRoute","{\"formFile\":\"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml\",\"hideFields\":[\"default_con\",\"checked_out\",\"checked_out_time\",\"version\",\"xreference\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[ {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ] }"),
("4","Newsfeed","com_newsfeeds.newsfeed","{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"NewsfeedTable\",\"prefix\":\"Joomla\\\\Component\\\\Newsfeeds\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}","NewsfeedsHelperRoute::getNewsfeedRoute","{\"formFile\":\"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml\",\"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}"),
("5","User","com_users.user","{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"UserTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerDate\",\"core_modified_time\":\"null\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{}}","",""),
("6","Article Category","com_content.category","{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}","ContentHelperRoute::getCategoryRoute","{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}"),
("7","Contact Category","com_contact.category","{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}","ContactHelperRoute::getCategoryRoute","{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}"),
("8","Newsfeeds Category","com_newsfeeds.category","{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}","NewsfeedsHelperRoute::getCategoryRoute","{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}"),
("9","Weblinks Category","com_weblinks.category","{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}","WeblinksHelperRoute::getCategoryRoute","{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}"),
("10","Tag","com_tags.tag","{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"TagTable\",\"prefix\":\"Joomla\\\\Component\\\\Tags\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}","TagsHelperRoute::getTagRoute","{\"formFile\":\"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}"),
("11","Banner","com_banners.banner","{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"BannerTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}","","{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}"),
("12","Banners Category","com_banners.category","{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}","","{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}"),
("13","Banner Client","com_banners.client","{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"ClientTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\"}}","","","","{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}"),
("14","User Notes","com_users.note","{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"NoteTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\"}}","","","","{\"formFile\":\"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}"),
("15","User Notes Category","com_users.category","{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}","","{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}");


DROP TABLE IF EXISTS #__contentitem_tag_map;
CREATE TABLE `#__contentitem_tag_map` (
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int(10) unsigned NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) unsigned NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';



DROP TABLE IF EXISTS #__core_log_searches;
CREATE TABLE `#__core_log_searches` (
  `search_term` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS #__extensions;
CREATE TABLE `#__extensions` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `package_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `changelogurl` text COLLATE utf8mb4_unicode_ci,
  `folder` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '1',
  `protected` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate if the extension is protected. Protected extensions cannot be disabled.',
  `manifest_cache` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate if the extension is locked. Locked extensions cannot be uninstalled.',
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10158 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__extensions VALUES
("2","0","com_wrapper","component","com_wrapper","","","1","1","1","0","{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"wrapper\"}","","",NULL,NULL,"0","0","","1"),
("3","0","com_admin","component","com_admin","","","1","1","1","1","{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\"}","","",NULL,NULL,"0","0","","1"),
("4","0","com_banners","component","com_banners","","","1","1","1","0","{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"banners\"}","{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\",\"save_history\":\"1\",\"history_limit\":10}","",NULL,NULL,"0","0","","1"),
("5","0","com_cache","component","com_cache","","","1","1","1","1","{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\"}","","",NULL,NULL,"0","0","","1"),
("6","0","com_categories","component","com_categories","","","1","1","1","1","{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}","","",NULL,NULL,"0","0","","1"),
("7","0","com_checkin","component","com_checkin","","","1","1","1","1","{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\"}","","",NULL,NULL,"0","0","","1"),
("8","0","com_contact","component","com_contact","","","1","1","1","0","{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}","{\"show_contact_category\":\"hide\",\"save_history\":\"1\",\"history_limit\":10,\"show_contact_list\":\"0\",\"presentation_style\":\"sliders\",\"show_name\":\"1\",\"show_position\":\"1\",\"show_email\":\"0\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_misc\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"show_profile\":\"0\",\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"show_headings\":\"1\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"allow_vcard_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_email_form\":\"1\",\"show_email_copy\":\"1\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_category_crumb\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","",NULL,NULL,"0","0","","1"),
("9","0","com_cpanel","component","com_cpanel","","","1","1","1","1","{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"Jun 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\"}","","",NULL,NULL,"0","0","","1"),
("10","0","com_installer","component","com_installer","","","1","1","1","1","{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\"}","{\"show_jed_info\":\"1\",\"cachetimeout\":\"6\",\"minimum_stability\":\"4\"}","",NULL,NULL,"0","0","","1"),
("11","0","com_languages","component","com_languages","","","1","1","1","1","{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}","{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}","",NULL,NULL,"0","0","","1"),
("12","0","com_login","component","com_login","","","1","1","1","1","{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}","","",NULL,NULL,"0","0","","1"),
("13","0","com_media","component","com_media","","","1","1","0","1","{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}","{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\"}","",NULL,NULL,"0","0","","1"),
("14","0","com_menus","component","com_menus","","","1","1","1","1","{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menus\"}","","",NULL,NULL,"0","0","","1"),
("15","0","com_messages","component","com_messages","","","1","1","1","1","{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\"}","","",NULL,NULL,"0","0","","1"),
("16","0","com_modules","component","com_modules","","","1","1","1","1","{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"modules\"}","","",NULL,NULL,"0","0","","1"),
("17","0","com_newsfeeds","component","com_newsfeeds","","","1","1","1","0","{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}","{\"newsfeed_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_character_count\":\"0\",\"feed_display_order\":\"des\",\"float_first\":\"right\",\"float_second\":\"right\",\"show_tags\":\"1\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\"}","",NULL,NULL,"0","0","","1"),
("18","0","com_plugins","component","com_plugins","","","1","1","1","1","{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\"}","","",NULL,NULL,"0","0","","1"),
("19","10153","com_search","component","com_search","","","1","1","1","0","{\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"17.06.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"filename\":\"search\"}","{\"enabled\":\"0\",\"show_date\":\"1\"}","",NULL,NULL,"0","0","","0"),
("20","0","com_templates","component","com_templates","","","1","1","1","1","{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}","{\"template_positions_display\":\"0\",\"upload_limit\":\"2\",\"image_formats\":\"gif,bmp,jpg,jpeg,png\",\"source_formats\":\"txt,less,ini,xml,js,php,css\",\"font_formats\":\"woff,ttf,otf\",\"compressed_formats\":\"zip\"}","",NULL,NULL,"0","0","","1"),
("22","0","com_content","component","com_content","","","1","1","0","1","{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}","{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"info_block_position\":\"0\",\"info_block_show_title\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_associations\":\"0\",\"flags\":\"1\",\"show_author\":\"0\",\"link_author\":\"1\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"1\",\"show_readmore_title\":\"0\",\"readmore_limit\":100,\"show_tags\":\"1\",\"record_hits\":\"1\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"urls_position\":0,\"captcha\":\"\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"show_configure_edit_options\":\"1\",\"show_permissions\":\"1\",\"show_associations_edit\":\"1\",\"save_history\":\"1\",\"history_limit\":10,\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"0\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_category_heading_title_text\":\"1\",\"show_subcat_desc\":\"0\",\"show_cat_num_articles\":\"0\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"0\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":0,\"blog_class_leading\":\"\",\"num_intro_articles\":4,\"blog_class\":\"\",\"num_columns\":1,\"multi_column_order\":\"0\",\"num_links\":0,\"show_subcategory_content\":\"0\",\"link_intro_image\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"list_show_votes\":\"0\",\"list_show_ratings\":\"0\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"0\",\"show_featured\":\"show\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\",\"sef_ids\":0,\"custom_fields_enable\":\"1\",\"workflow_enabled\":\"0\"}","",NULL,NULL,"0","0","","1"),
("23","0","com_config","component","com_config","","","1","1","0","1","{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"config\"}","{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}","",NULL,NULL,"0","0","","1"),
("24","0","com_redirect","component","com_redirect","","","1","1","0","0","{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}","","",NULL,NULL,"0","0","","1"),
("25","0","com_users","component","com_users","","","1","1","0","1","{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"users\"}","{\"allowUserRegistration\":\"1\",\"new_usertype\":\"2\",\"guest_usergroup\":\"13\",\"sendpassword\":\"1\",\"useractivation\":\"1\",\"mail_to_admin\":\"0\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"reset_count\":\"10\",\"reset_time\":\"1\",\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\",\"save_history\":\"1\",\"history_limit\":5}","",NULL,NULL,"0","0","","1"),
("27","0","com_finder","component","com_finder","","","1","1","0","0","{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}","{\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_advanced\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stemmer\":\"snowball\"}","",NULL,NULL,"0","0","","1"),
("28","0","com_joomlaupdate","component","com_joomlaupdate","","","1","1","0","1","{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"August 2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.3\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}","{\"updatesource\":\"default\",\"minimum_stability\":\"4\",\"customurl\":\"\"}","",NULL,NULL,"0","0","","1"),
("29","0","com_tags","component","com_tags","","","1","1","1","0","{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"December 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}","{\"tag_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_tag_title\":\"0\",\"tag_list_show_tag_image\":\"0\",\"tag_list_show_tag_description\":\"0\",\"tag_list_image\":\"\",\"show_tag_num_items\":\"0\",\"tag_list_orderby\":\"title\",\"tag_list_orderby_direction\":\"ASC\",\"show_headings\":\"0\",\"tag_list_show_date\":\"0\",\"tag_list_show_item_image\":\"0\",\"tag_list_show_item_description\":\"0\",\"tag_list_item_maximum_characters\":0,\"return_any_or_all\":\"1\",\"include_children\":\"0\",\"maximum\":200,\"tag_list_language_filter\":\"all\",\"tags_layout\":\"_:default\",\"all_tags_orderby\":\"title\",\"all_tags_orderby_direction\":\"ASC\",\"all_tags_show_tag_image\":\"0\",\"all_tags_show_tag_descripion\":\"0\",\"all_tags_tag_maximum_characters\":20,\"all_tags_show_tag_hits\":\"0\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"tag_field_ajax_mode\":\"1\",\"show_feed_link\":\"1\"}","",NULL,NULL,"0","0","","1"),
("30","0","com_contenthistory","component","com_contenthistory","","","1","1","1","0","{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"May 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contenthistory\"}","","",NULL,NULL,"0","0","","1"),
("31","0","com_ajax","component","com_ajax","","","1","1","1","1","{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ajax\"}","","",NULL,NULL,"0","0","","1"),
("32","0","com_postinstall","component","com_postinstall","","","1","1","1","1","{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\"}","","",NULL,NULL,"0","0","","1"),
("33","0","com_fields","component","com_fields","","","1","1","1","0","{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}","","",NULL,NULL,"0","0","","1"),
("34","0","com_associations","component","com_associations","","","1","1","1","0","{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"January 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\"}","","",NULL,NULL,"0","0","","1"),
("35","0","com_privacy","component","com_privacy","","","1","1","1","0","{\"name\":\"com_privacy\",\"type\":\"component\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacy\"}","","",NULL,NULL,"0","0","","1"),
("36","0","com_actionlogs","component","com_actionlogs","","","1","1","1","0","{\"name\":\"com_actionlogs\",\"type\":\"component\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\"}","{\"ip_logging\":0,\"csv_delimiter\":\",\",\"loggable_extensions\":[\"com_banners\",\"com_cache\",\"com_categories\",\"com_checkin\",\"com_config\",\"com_contact\",\"com_content\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_tags\",\"com_templates\",\"com_users\"]}","",NULL,NULL,"0","0","","1"),
("103","0","lib_joomla","library","joomla","","","0","1","1","1","{\"name\":\"lib_joomla\",\"type\":\"library\",\"creationDate\":\"2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}","{\"mediaversion\":\"fccb7c28b8c67fab0da7b2e2e777f1e7\"}","",NULL,NULL,"0","0","","1"),
("106","0","lib_phpass","library","phpass","","","0","1","1","1","{\"name\":\"lib_phpass\",\"type\":\"library\",\"creationDate\":\"2004-2006\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"https:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.3\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpass\"}","","",NULL,NULL,"0","0","","1"),
("200","0","mod_articles_archive","module","mod_articles_archive","","","0","1","1","0","{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_archive\"}","","",NULL,NULL,"0","0","","1"),
("201","0","mod_articles_latest","module","mod_articles_latest","","","0","1","1","0","{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_latest\"}","","",NULL,NULL,"0","0","","1"),
("202","0","mod_articles_popular","module","mod_articles_popular","","","0","1","1","0","{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_popular\"}","","",NULL,NULL,"0","0","","1"),
("203","0","mod_banners","module","mod_banners","","","0","1","1","0","{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_banners\"}","","",NULL,NULL,"0","0","","1"),
("204","0","mod_breadcrumbs","module","mod_breadcrumbs","","","0","1","1","0","{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_breadcrumbs\"}","","",NULL,NULL,"0","0","","1"),
("205","0","mod_custom","module","mod_custom","","","0","1","1","0","{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}","","",NULL,NULL,"0","0","","1"),
("206","0","mod_feed","module","mod_feed","","","0","1","1","0","{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}","","",NULL,NULL,"0","0","","1"),
("207","0","mod_footer","module","mod_footer","","","0","1","1","0","{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_footer\"}","","",NULL,NULL,"0","0","","1"),
("208","0","mod_login","module","mod_login","","","0","1","1","0","{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}","","",NULL,NULL,"0","0","","1"),
("209","0","mod_menu","module","mod_menu","","","0","1","1","0","{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}","","",NULL,NULL,"0","0","","1"),
("210","0","mod_articles_news","module","mod_articles_news","","","0","1","1","0","{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_news\"}","","",NULL,NULL,"0","0","","1"),
("211","0","mod_random_image","module","mod_random_image","","","0","1","1","0","{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_random_image\"}","","",NULL,NULL,"0","0","","1"),
("212","0","mod_related_items","module","mod_related_items","","","0","1","1","0","{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_related_items\"}","","",NULL,NULL,"0","0","","1"),
("213","10153","mod_search","module","mod_search","","","0","1","1","0","{\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"filename\":\"mod_search\"}","","",NULL,NULL,"0","0","","0"),
("214","0","mod_stats","module","mod_stats","","","0","1","1","0","{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats\"}","","",NULL,NULL,"0","0","","1"),
("215","0","mod_syndicate","module","mod_syndicate","","","0","1","1","0","{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"May 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_syndicate\"}","","",NULL,NULL,"0","0","","1"),
("216","0","mod_users_latest","module","mod_users_latest","","","0","1","1","0","{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"December 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_users_latest\"}","","",NULL,NULL,"0","0","","1"),
("218","0","mod_whosonline","module","mod_whosonline","","","0","1","1","0","{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_whosonline\"}","","",NULL,NULL,"0","0","","1"),
("219","0","mod_wrapper","module","mod_wrapper","","","0","1","1","0","{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"October 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_wrapper\"}","","",NULL,NULL,"0","0","","1"),
("220","0","mod_articles_category","module","mod_articles_category","","","0","1","1","0","{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_category\"}","","",NULL,NULL,"0","0","","1"),
("221","0","mod_articles_categories","module","mod_articles_categories","","","0","1","1","0","{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_categories\"}","","",NULL,NULL,"0","0","","1"),
("222","0","mod_languages","module","mod_languages","","","0","1","1","0","{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_languages\"}","","",NULL,NULL,"0","0","","1"),
("223","0","mod_finder","module","mod_finder","","","0","1","0","0","{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_finder\"}","","",NULL,NULL,"0","0","","1"),
("300","0","mod_custom","module","mod_custom","","","1","1","1","0","{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}","","",NULL,NULL,"0","0","","1"),
("301","0","mod_feed","module","mod_feed","","","1","1","1","0","{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}","","",NULL,NULL,"0","0","","1"),
("302","0","mod_latest","module","mod_latest","","","1","1","1","0","{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latest\"}","","",NULL,NULL,"0","0","","1"),
("303","0","mod_logged","module","mod_logged","","","1","1","1","0","{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"January 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_logged\"}","","",NULL,NULL,"0","0","","1"),
("304","0","mod_login","module","mod_login","","","1","1","1","0","{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"March 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}","","",NULL,NULL,"0","0","","1"),
("305","0","mod_menu","module","mod_menu","","","1","1","1","0","{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}","","",NULL,NULL,"0","0","","1"),
("307","0","mod_popular","module","mod_popular","","","1","1","1","0","{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_popular\"}","","",NULL,NULL,"0","0","","1"),
("308","0","mod_quickicon","module","mod_quickicon","","","1","1","1","0","{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_quickicon\"}","","",NULL,NULL,"0","0","","1"),
("311","0","mod_title","module","mod_title","","","1","1","1","0","{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_title\"}","","",NULL,NULL,"0","0","","1"),
("312","0","mod_toolbar","module","mod_toolbar","","","1","1","1","0","{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_toolbar\"}","","",NULL,NULL,"0","0","","1"),
("313","0","mod_multilangstatus","module","mod_multilangstatus","","","1","1","1","0","{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"September 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_multilangstatus\"}","{\"cache\":\"0\"}","",NULL,NULL,"0","0","","1"),
("314","0","mod_version","module","mod_version","","","1","1","1","0","{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"January 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_version\"}","{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}","",NULL,NULL,"0","0","","1"),
("315","0","mod_stats_admin","module","mod_stats_admin","","","1","1","1","0","{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats_admin\"}","{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}","",NULL,NULL,"0","0","","1"),
("316","0","mod_tags_popular","module","mod_tags_popular","","","0","1","1","0","{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_popular\"}","{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}","",NULL,NULL,"0","0","","1"),
("317","0","mod_tags_similar","module","mod_tags_similar","","","0","1","1","0","{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_similar\"}","{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}","",NULL,NULL,"0","0","","1"),
("318","0","mod_sampledata","module","mod_sampledata","","","1","1","1","0","{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sampledata\"}","{}","",NULL,NULL,"0","0","","1"),
("319","0","mod_latestactions","module","mod_latestactions","","","1","1","1","0","{\"name\":\"mod_latestactions\",\"type\":\"module\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_LATESTACTIONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latestactions\"}","{}","",NULL,"1970-01-01 00:00:00","0","0","","1"),
("320","0","mod_privacy_dashboard","module","mod_privacy_dashboard","","","1","1","1","0","{\"name\":\"mod_privacy_dashboard\",\"type\":\"module\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_PRIVACY_DASHBOARD_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_privacy_dashboard\"}","{}","",NULL,"1970-01-01 00:00:00","0","0","","1"),
("401","0","plg_authentication_joomla","plugin","joomla","","authentication","0","1","1","1","{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}","","",NULL,NULL,"0","0","","1"),
("402","0","plg_authentication_ldap","plugin","ldap","","authentication","0","0","1","0","{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ldap\"}","{\"host\":\"http:\\/\\/dev.ytcvn.com\",\"port\":389,\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"template\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}","",NULL,NULL,"3","0","","1"),
("403","0","plg_content_contact","plugin","contact","","content","0","1","1","0","{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"January 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2014 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}","","",NULL,NULL,"1","0","","1"),
("404","0","plg_content_emailcloak","plugin","emailcloak","","content","0","1","1","0","{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"emailcloak\"}","{\"mode\":\"1\"}","",NULL,NULL,"1","0","","1"),
("406","0","plg_content_loadmodule","plugin","loadmodule","","content","0","1","1","0","{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"loadmodule\"}","{\"style\":\"xhtml\"}","",NULL,"2011-09-18 15:22:50","0","0","","1"),
("407","0","plg_content_pagebreak","plugin","pagebreak","","content","0","1","1","0","{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}","{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}","",NULL,NULL,"4","0","","1"),
("408","0","plg_content_pagenavigation","plugin","pagenavigation","","content","0","1","1","0","{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"January 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagenavigation\"}","{\"position\":\"1\"}","",NULL,NULL,"5","0","","1"),
("409","0","plg_content_vote","plugin","vote","","content","0","1","1","0","{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"vote\"}","","",NULL,NULL,"6","0","","1"),
("410","0","plg_editors_codemirror","plugin","codemirror","","editors","0","1","1","0","{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2021 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"https:\\/\\/codemirror.net\\/\",\"version\":\"5.65.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"codemirror\"}","{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}","",NULL,NULL,"1","0","","1"),
("411","0","plg_editors_none","plugin","none","","editors","0","1","1","1","{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"September 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"none\"}","","",NULL,NULL,"2","0","","1"),
("412","0","plg_editors_tinymce","plugin","tinymce","","editors","0","1","1","0","{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-2021\",\"author\":\"Tiny Technologies, Inc\",\"copyright\":\"Tiny Technologies, Inc\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"https:\\/\\/www.tiny.cloud\",\"version\":\"5.10.2\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tinymce\"}","{\"mode\":\"1\",\"skin\":\"0\",\"mobile\":\"0\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"extended_elements\":\"\",\"html_height\":\"550\",\"html_width\":\"750\",\"resizing\":\"1\",\"element_path\":\"1\",\"fonts\":\"1\",\"paste\":\"1\",\"searchreplace\":\"1\",\"insertdate\":\"1\",\"colors\":\"1\",\"table\":\"1\",\"smilies\":\"1\",\"hr\":\"1\",\"link\":\"1\",\"media\":\"1\",\"print\":\"1\",\"directionality\":\"1\",\"fullscreen\":\"1\",\"alignment\":\"1\",\"visualchars\":\"1\",\"visualblocks\":\"1\",\"nonbreaking\":\"1\",\"template\":\"1\",\"blockquote\":\"1\",\"wordcount\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"inlinepopups\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}","",NULL,NULL,"3","0","","1"),
("413","0","plg_editors-xtd_article","plugin","article","","editors-xtd","0","1","1","0","{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"October 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"article\"}","","",NULL,NULL,"1","0","","1"),
("414","0","plg_editors-xtd_image","plugin","image","","editors-xtd","0","1","1","0","{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"image\"}","","",NULL,NULL,"2","0","","1"),
("415","0","plg_editors-xtd_pagebreak","plugin","pagebreak","","editors-xtd","0","1","1","0","{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}","","",NULL,NULL,"3","0","","1"),
("416","0","plg_editors-xtd_readmore","plugin","readmore","","editors-xtd","0","1","1","0","{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"readmore\"}","","",NULL,NULL,"4","0","","1"),
("417","10153","plg_search_categories","plugin","categories","","search","0","1","1","0","{\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}","{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}","",NULL,NULL,"0","0","","0"),
("418","10153","plg_search_contacts","plugin","contacts","","search","0","1","1","0","{\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"filename\":\"contacts\"}","{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}","",NULL,NULL,"0","0","","0"),
("419","10153","plg_search_content","plugin","content","","search","0","1","1","0","{\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}","{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}","",NULL,NULL,"0","0","","0"),
("420","10153","plg_search_newsfeeds","plugin","newsfeeds","","search","0","1","1","0","{\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"filename\":\"newsfeeds\"}","{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}","",NULL,NULL,"0","0","","0"),
("422","0","plg_system_languagefilter","plugin","languagefilter","","system","0","1","1","0","{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"July 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagefilter\"}","{\"detect_browser\":\"0\",\"automatic_change\":\"1\",\"item_associations\":\"1\",\"alternate_meta\":\"1\",\"xdefault\":\"1\",\"xdefault_language\":\"default\",\"remove_default_prefix\":\"1\",\"lang_cookie\":\"0\"}","",NULL,NULL,"1","0","","1"),
("424","0","plg_system_cache","plugin","cache","","system","0","0","1","0","{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"February 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cache\"}","{\"browsercache\":\"0\",\"cachetime\":\"15\"}","",NULL,NULL,"9","0","","1"),
("425","0","plg_system_debug","plugin","debug","","system","0","1","1","0","{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"debug\"}","{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}","",NULL,NULL,"4","0","","1"),
("426","0","plg_system_log","plugin","log","","system","0","1","1","0","{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"log\"}","","",NULL,NULL,"5","0","","1"),
("427","0","plg_system_redirect","plugin","redirect","","system","0","0","1","0","{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"redirect\"}","","",NULL,NULL,"6","0","","1");
INSERT INTO #__extensions VALUES
("428","0","plg_system_remember","plugin","remember","","system","0","1","1","0","{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"remember\"}","","",NULL,NULL,"7","0","","1"),
("429","0","plg_system_sef","plugin","sef","","system","0","1","1","0","{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sef\"}","","",NULL,NULL,"8","0","","1"),
("430","0","plg_system_logout","plugin","logout","","system","0","1","1","0","{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logout\"}","","",NULL,NULL,"3","0","","1"),
("431","0","plg_user_contactcreator","plugin","contactcreator","","user","0","1","1","0","{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"August 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contactcreator\"}","{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}","",NULL,NULL,"1","0","","1"),
("432","0","plg_user_joomla","plugin","joomla","","user","0","1","1","0","{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}","{\"strong_passwords\":\"1\",\"autoregister\":\"1\"}","",NULL,NULL,"2","0","","1"),
("433","0","plg_user_profile","plugin","profile","","user","0","1","1","0","{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"January 2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"profile\"}","{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"2\",\"register_tos_article\":\"\",\"register-require_dob\":\"0\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_dob\":\"0\"}","",NULL,NULL,"0","0","","1"),
("434","0","plg_extension_joomla","plugin","joomla","","extension","0","1","1","0","{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}","","",NULL,NULL,"1","0","","1"),
("435","0","plg_content_joomla","plugin","joomla","","content","0","1","1","0","{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}","","",NULL,NULL,"0","0","","1"),
("436","0","plg_system_languagecode","plugin","languagecode","","system","0","1","1","0","{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"November 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagecode\"}","{\"ar-aa\":\"\",\"en-gb\":\"\"}","",NULL,NULL,"10","0","","1"),
("437","0","plg_quickicon_joomlaupdate","plugin","joomlaupdate","","quickicon","0","1","1","0","{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomlaupdate\"}","","",NULL,NULL,"0","0","","1"),
("438","0","plg_quickicon_extensionupdate","plugin","extensionupdate","","quickicon","0","1","1","0","{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"extensionupdate\"}","","",NULL,NULL,"0","0","","1"),
("439","0","plg_captcha_recaptcha","plugin","recaptcha","","captcha","0","0","1","0","{\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.4.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha\"}","{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}","",NULL,NULL,"0","0","","1"),
("440","0","plg_system_highlight","plugin","highlight","","system","0","1","1","0","{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"highlight\"}","","",NULL,NULL,"7","0","","1"),
("441","0","plg_content_finder","plugin","finder","","content","0","1","1","0","{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}","","",NULL,NULL,"0","0","","1"),
("442","0","plg_finder_categories","plugin","categories","","finder","0","1","1","0","{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}","","",NULL,NULL,"1","0","","1"),
("443","0","plg_finder_contacts","plugin","contacts","","finder","0","1","1","0","{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}","","",NULL,NULL,"2","0","","1"),
("444","0","plg_finder_content","plugin","content","","finder","0","1","1","0","{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}","","",NULL,NULL,"3","0","","1"),
("445","0","plg_finder_newsfeeds","plugin","newsfeeds","","finder","0","1","1","0","{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}","","",NULL,NULL,"4","0","","1"),
("447","0","plg_finder_tags","plugin","tags","","finder","0","1","1","0","{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"February 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}","","",NULL,NULL,"0","0","","1"),
("448","0","plg_twofactorauth_totp","plugin","totp","","twofactorauth","0","0","1","0","{\"name\":\"plg_twofactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"totp\"}","","",NULL,NULL,"0","0","","1"),
("449","0","plg_authentication_cookie","plugin","cookie","","authentication","0","1","1","0","{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"July 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cookie\"}","","",NULL,NULL,"0","0","","1"),
("450","0","plg_twofactorauth_yubikey","plugin","yubikey","","twofactorauth","0","0","1","0","{\"name\":\"plg_twofactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"yubikey\"}","","",NULL,NULL,"0","0","","1"),
("451","10153","plg_search_tags","plugin","tags","","search","0","1","1","0","{\"name\":\"plg_search_tags\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2014 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"filename\":\"tags\"}","{\"search_limit\":\"50\",\"show_tagged_items\":\"1\"}","",NULL,NULL,"0","0","","0"),
("452","0","plg_system_updatenotification","plugin","updatenotification","","system","0","1","1","0","{\"name\":\"plg_system_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"May 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2015 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"updatenotification\"}","{\"lastrun\":1644460027}","",NULL,NULL,"0","0","","1"),
("453","0","plg_editors-xtd_module","plugin","module","","editors-xtd","0","1","1","0","{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"October 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2015 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"module\"}","","",NULL,NULL,"0","0","","1"),
("454","0","plg_system_stats","plugin","stats","","system","0","1","1","0","{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"stats\"}","{\"mode\":1,\"lastrun\":1644460122,\"unique_id\":\"67e29b79898ccbf829924b216a424e0d993c5547\",\"interval\":12}","",NULL,NULL,"0","0","","1"),
("455","0","plg_installer_packageinstaller","plugin","packageinstaller","","installer","0","1","1","0","{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"packageinstaller\"}","","",NULL,NULL,"1","0","","1"),
("456","0","plg_installer_folderinstaller","plugin","folderinstaller","","installer","0","1","1","0","{\"name\":\"plg_installer_folderinstaller\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"folderinstaller\"}","","",NULL,NULL,"2","0","","1"),
("457","0","plg_installer_urlinstaller","plugin","urlinstaller","","installer","0","1","1","0","{\"name\":\"plg_installer_urlinstaller\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"urlinstaller\"}","","",NULL,NULL,"3","0","","1"),
("458","0","plg_quickicon_phpversioncheck","plugin","phpversioncheck","","quickicon","0","1","1","0","{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpversioncheck\"}","","",NULL,NULL,"0","0","","1"),
("459","0","plg_editors-xtd_menu","plugin","menu","","editors-xtd","0","1","1","0","{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menu\"}","","",NULL,NULL,"0","0","","1"),
("460","0","plg_editors-xtd_contact","plugin","contact","","editors-xtd","0","1","1","0","{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"October 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}","","",NULL,NULL,"0","0","","1"),
("461","0","plg_system_fields","plugin","fields","","system","0","1","1","0","{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}","","",NULL,NULL,"0","0","","1"),
("462","0","plg_fields_calendar","plugin","calendar","","fields","0","1","1","0","{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"calendar\"}","","",NULL,NULL,"0","0","","1"),
("463","0","plg_fields_checkboxes","plugin","checkboxes","","fields","0","1","1","0","{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"checkboxes\"}","","",NULL,NULL,"0","0","","1"),
("464","0","plg_fields_color","plugin","color","","fields","0","1","1","0","{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"color\"}","","",NULL,NULL,"0","0","","1"),
("465","0","plg_fields_editor","plugin","editor","","fields","0","1","1","0","{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"editor\"}","","",NULL,NULL,"0","0","","1"),
("466","0","plg_fields_imagelist","plugin","imagelist","","fields","0","1","1","0","{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"imagelist\"}","","",NULL,NULL,"0","0","","1"),
("467","0","plg_fields_integer","plugin","integer","","fields","0","1","1","0","{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"integer\"}","{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}","",NULL,NULL,"0","0","","1"),
("468","0","plg_fields_list","plugin","list","","fields","0","1","1","0","{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"list\"}","","",NULL,NULL,"0","0","","1"),
("469","0","plg_fields_media","plugin","media","","fields","0","1","1","0","{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}","","",NULL,NULL,"0","0","","1"),
("470","0","plg_fields_radio","plugin","radio","","fields","0","1","1","0","{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"radio\"}","","",NULL,NULL,"0","0","","1"),
("471","0","plg_fields_sql","plugin","sql","","fields","0","1","1","0","{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sql\"}","","",NULL,NULL,"0","0","","1"),
("472","0","plg_fields_text","plugin","text","","fields","0","1","1","0","{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"text\"}","","",NULL,NULL,"0","0","","1"),
("473","0","plg_fields_textarea","plugin","textarea","","fields","0","1","1","0","{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"textarea\"}","","",NULL,NULL,"0","0","","1"),
("474","0","plg_fields_url","plugin","url","","fields","0","1","1","0","{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"url\"}","","",NULL,NULL,"0","0","","1"),
("475","0","plg_fields_user","plugin","user","","fields","0","1","1","0","{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}","","",NULL,NULL,"0","0","","1"),
("476","0","plg_fields_usergrouplist","plugin","usergrouplist","","fields","0","1","1","0","{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"usergrouplist\"}","","",NULL,NULL,"0","0","","1"),
("477","0","plg_content_fields","plugin","fields","","content","0","1","1","0","{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}","","",NULL,NULL,"0","0","","1"),
("478","0","plg_editors-xtd_fields","plugin","fields","","editors-xtd","0","1","1","0","{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}","","",NULL,NULL,"0","0","","1"),
("479","0","plg_sampledata_blog","plugin","blog","","sampledata","0","0","1","0","{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"blog\"}","","",NULL,NULL,"0","0","","1"),
("480","0","plg_system_sessiongc","plugin","sessiongc","","system","0","1","1","0","{\"name\":\"plg_system_sessiongc\",\"type\":\"plugin\",\"creationDate\":\"February 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.6\",\"description\":\"PLG_SYSTEM_SESSIONGC_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sessiongc\"}","","",NULL,NULL,"0","0","","1"),
("482","0","plg_content_confirmconsent","plugin","confirmconsent","","content","0","0","1","0","{\"name\":\"plg_content_confirmconsent\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_CONTENT_CONFIRMCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"confirmconsent\"}","{}","",NULL,NULL,"0","0","","1"),
("483","0","plg_system_actionlogs","plugin","actionlogs","","system","0","0","1","0","{\"name\":\"plg_system_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}","{}","",NULL,NULL,"0","0","","1"),
("484","0","plg_actionlog_joomla","plugin","joomla","","actionlog","0","1","1","0","{\"name\":\"plg_actionlog_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_ACTIONLOG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}","{}","",NULL,NULL,"0","0","","1"),
("485","0","plg_system_privacyconsent","plugin","privacyconsent","","system","0","0","1","0","{\"name\":\"plg_system_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"April 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacyconsent\"}","{}","",NULL,NULL,"0","0","","1"),
("486","0","plg_system_logrotation","plugin","logrotation","","system","0","1","1","0","{\"name\":\"plg_system_logrotation\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_LOGROTATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logrotation\"}","{\"lastrun\":1643352137}","",NULL,NULL,"0","0","","1"),
("487","0","plg_privacy_user","plugin","user","","privacy","0","1","1","0","{\"name\":\"plg_privacy_user\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}","{}","",NULL,NULL,"0","0","","1"),
("488","0","plg_quickicon_privacycheck","plugin","privacycheck","","quickicon","0","1","1","0","{\"name\":\"plg_quickicon_privacycheck\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_QUICKICON_PRIVACYCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacycheck\"}","{}","",NULL,NULL,"0","0","","1"),
("489","0","plg_user_terms","plugin","terms","","user","0","0","1","0","{\"name\":\"plg_user_terms\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TERMS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"terms\"}","{}","",NULL,NULL,"0","0","","1"),
("490","0","plg_privacy_contact","plugin","contact","","privacy","0","1","1","0","{\"name\":\"plg_privacy_contact\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}","{}","",NULL,NULL,"0","0","","1"),
("491","0","plg_privacy_content","plugin","content","","privacy","0","1","1","0","{\"name\":\"plg_privacy_content\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}","{}","",NULL,NULL,"0","0","","1"),
("492","0","plg_privacy_message","plugin","message","","privacy","0","1","1","0","{\"name\":\"plg_privacy_message\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_MESSAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"message\"}","{}","",NULL,NULL,"0","0","","1"),
("493","0","plg_privacy_actionlogs","plugin","actionlogs","","privacy","0","1","1","0","{\"name\":\"plg_privacy_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}","{}","",NULL,NULL,"0","0","","1"),
("494","0","plg_captcha_recaptcha_invisible","plugin","recaptcha_invisible","","captcha","0","0","1","0","{\"name\":\"plg_captcha_recaptcha_invisible\",\"type\":\"plugin\",\"creationDate\":\"November 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_INVISIBLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha_invisible\"}","{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}","",NULL,NULL,"0","0","","1"),
("495","0","plg_privacy_consents","plugin","consents","","privacy","0","1","1","0","{\"name\":\"plg_privacy_consents\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONSENTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"consents\"}","{}","",NULL,NULL,"0","0","","1"),
("600","802","English (en-GB)","language","en-GB","","","0","1","1","1","{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"January 2022\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.6\",\"description\":\"en-GB site language\",\"group\":\"\"}","","",NULL,NULL,"0","0","","1"),
("601","802","English (en-GB)","language","en-GB","","","1","1","1","1","{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"January 2022\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.6\",\"description\":\"en-GB administrator language\",\"group\":\"\"}","","",NULL,NULL,"0","0","","1"),
("700","0","files_joomla","file","joomla","","","0","1","1","1","{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"January 2022\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.6\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}","","",NULL,NULL,"0","0","","1"),
("802","0","English (en-GB) Language Pack","package","pkg_en-GB","","","0","1","1","1","{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"January 2022\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.6.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"filename\":\"pkg_en-GB\"}","","",NULL,NULL,"0","0","","1"),
("10001","0","Helix3 - Ajax","plugin","helix3","","ajax","0","1","1","0","{\"name\":\"Helix3 - Ajax\",\"type\":\"plugin\",\"creationDate\":\"Jan 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (c) 2010 - 2021 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"3.0.2\",\"description\":\"Helix3 Framework - Joomla Template Framework by JoomShaper\",\"group\":\"\",\"filename\":\"helix3\"}","{}","",NULL,NULL,"0","0","","0"),
("10002","0","System - Helix3 Framework","plugin","helix3","","system","0","1","1","0","{\"name\":\"System - Helix3 Framework\",\"type\":\"plugin\",\"creationDate\":\"Jan 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (c) 2010 - 2021 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"3.0.2\",\"description\":\"Helix3 Framework - Joomla Template Framework by JoomShaper\",\"group\":\"\",\"filename\":\"helix3\"}","{}","",NULL,NULL,"0","0","","0"),
("10004","0","SP Page Builder","component","com_sppagebuilder","","","1","1","0","0","{\"name\":\"SP Page Builder\",\"type\":\"component\",\"creationDate\":\"Sep 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (c) 2010 - 2021 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"3.8.3\",\"description\":\"\",\"group\":\"\",\"filename\":\"sppagebuilder\"}","{}","",NULL,NULL,"0","0","","0"),
("10005","0","mod_sppagebuilder_icons","module","mod_sppagebuilder_icons","","","1","1","2","0","{\"name\":\"mod_sppagebuilder_icons\",\"type\":\"module\",\"creationDate\":\"August 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.2\",\"description\":\"MOD_SPPAGEBUILDER_ICONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sppagebuilder_icons\"}","[]","",NULL,NULL,"0","0","","0"),
("10007","0","SP Simple Portfolio","component","com_spsimpleportfolio","","","1","1","0","0","{\"name\":\"SP Simple Portfolio\",\"type\":\"component\",\"creationDate\":\"December 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (c) 2010- 2021 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"2.0.5\",\"description\":\"Simple Portfolio Component for Joomla\",\"group\":\"\",\"filename\":\"spsimpleportfolio\"}","{\"quare\":\"480x400\",\"rectangle\":\"480x400\",\"tall\":\"600X800\",\"cropratio\":\"4\"}","",NULL,NULL,"0","0","","0"),
("10008","0","SP Simple Portfolio Module","module","mod_spsimpleportfolio","","","0","1","0","0","{\"name\":\"SP Simple Portfolio Module\",\"type\":\"module\",\"creationDate\":\"December 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2021 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"2.0\",\"description\":\"Module to display latest item from SP Simple Portfolio\",\"group\":\"\",\"filename\":\"mod_spsimpleportfolio\"}","{\"show_filter\":\"1\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"masonry\",\"limit\":\"12\",\"cache\":\"1\",\"cache_time\":\"900\"}","",NULL,NULL,"0","0","","0"),
("10027","10029","Arabic Unitag (العربية الموحدة)","language","ar-AA","","","0","1","0","0","{\"name\":\"Arabic Unitag (\\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629)\",\"type\":\"language\",\"creationDate\":\"August 2021\",\"author\":\"Dr. Ashraf Damra\",\"copyright\":\"Copyright (C) 2005 - 2021 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"dr.d.ashraf@gmail.com\",\"authorUrl\":\"www.dr-ashraf.com\",\"version\":\"\",\"description\":\"Arabic Unitag language files\\/Site \\u0645\\u0644\\u0641\\u0627\\u062a \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629\\/\\u0627\\u0644\\u0645\\u0648\\u0642\\u0639\",\"group\":\"\",\"filename\":\"install\"}","{}","",NULL,NULL,"0","0","","0"),
("10028","10029","اللغة العربية بالكود الموحد (ar-AA)","language","ar-AA","","","1","1","0","0","{\"name\":\"\\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0628\\u0627\\u0644\\u0643\\u0648\\u062f \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f (ar-AA)\",\"type\":\"language\",\"creationDate\":\"August 2021\",\"author\":\"Dr. Ashraf Damra\",\"copyright\":\"Copyright (C) 2005 - 2021 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"dr.d.ashraf@gmail.com\",\"authorUrl\":\"www.dr-ashraf.com\",\"version\":\"\",\"description\":\"Arabic Unitag language files\\/Administrator \\u0645\\u0644\\u0641\\u0627\\u062a \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629\\/\\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u0629\",\"group\":\"\",\"filename\":\"install\"}","{}","",NULL,NULL,"0","0","","0"),
("10029","0","Arabic ar-AA(العربية الموحدة)","package","pkg_ar-AA","","","0","1","1","0","{\"name\":\"Arabic ar-AA(\\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629)\",\"type\":\"package\",\"creationDate\":\"August 2021\",\"author\":\"Dr. Ashraf Damra\",\"copyright\":\"Copyright (C) 2019 - 2021 Open Source Matters.\",\"authorEmail\":\"dr.d.ashraf@gmail.com\",\"authorUrl\":\"www.dr-ashraf.com\",\"version\":\"\",\"description\":\"\\n        <div class=\\\"alert alert-info\\\">\\n<h4 class=\\\"alert-heading\\\" style=\\\"direction: rtl;\\\">\\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629<\\/h4>\\n<div class=\\\"alert-message\\\" style=\\\"direction: rtl;\\\">\\u062a\\u0645 \\u062a\\u0646\\u0635\\u064a\\u0628 \\u062d\\u0632\\u0645\\u0629 \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0644\\u0646\\u0638\\u0627\\u0645 \\u0627\\u062f\\u0627\\u0631\\u0629 \\u0645\\u062d\\u062a\\u0648\\u0649 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0642\\u0639 \\u062c\\u0648\\u0645\\u0644\\u0627\\u060c \\u0628\\u0627\\u0644\\u0643\\u0648\\u062f \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f.<\\/div>\\n<\\/div>\\n        \",\"group\":\"\",\"filename\":\"pkg_ar-AA\"}","{}","",NULL,NULL,"0","0","","0"),
("10055","0","SJ Twitter Slider","module","mod_sj_twitter_slider","","","0","1","0","0","{\"name\":\"SJ Twitter Slider\",\"type\":\"module\",\"creationDate\":\"Deccember 2021\",\"author\":\"YouTech Company\",\"copyright\":\"Copyright (c) 2016 YouTech Company\",\"authorEmail\":\"contact@ytcvn.com\",\"authorUrl\":\"http:\\/\\/www.smartaddons.com\",\"version\":\"2.0.0\",\"description\":\"TPL_YTFRAMEWORK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sj_twitter_slider\"}","{\"screenname\":\"smartaddons\",\"id_user\":\"321482620284321792\",\"count\":\"6\",\"display_avatars\":\"1\",\"display_follow_button\":\"1\",\"display_direction_button\":\"0\",\"start\":\"1\",\"play\":\"0\",\"interval\":\"5000\",\"pause_hover\":\"hover\",\"effect\":\"slide\",\"swipe_enable\":\"1\",\"pretext\":\"\",\"posttext\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\"}","",NULL,NULL,"0","0","","0"),
("10057","0","SJ Instagram Gallery","module","mod_sj_instagram_gallery","","","0","1","0","0","{\"name\":\"SJ Instagram Gallery\",\"type\":\"module\",\"creationDate\":\"September 2021\",\"author\":\"YouTech Company\",\"copyright\":\"Copyright (c) 2016 YouTech Company\",\"authorEmail\":\"contact@ytcvn.com\",\"authorUrl\":\"http:\\/\\/www.smartaddons.com\",\"version\":\"2.0\",\"description\":\"TPL_YTFRAMEWORK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sj_instagram_gallery\"}","{\"type_show\":\"simple\",\"nb_rows\":\"1\",\"nb-column1\":\"4\",\"nb-column2\":\"4\",\"nb-column3\":\"2\",\"nb-column4\":\"1\",\"title\":\"\",\"show_title\":\"1\",\"full_name\":\"1\",\"target\":\"_blank\",\"users_id\":\"2104313612\",\"access_token\":\"2104313612.1677ed0.2a631e32ce344b4580477470faa0517c\",\"limit_image\":\"8\",\"autoplay\":\"1\",\"display_nav\":\"1\",\"display_loop\":\"1\",\"touchdrag\":\"1\",\"mousedrag\":\"1\",\"pausehover\":\"1\",\"autoplay_timeout\":\"5000\",\"autoplay_speed\":\"2000\",\"pretext\":\"\",\"posttext\":\"\"}","",NULL,NULL,"0","0","","0"),
("10058","0","YT Shortcodes","plugin","ytshortcodes","","system","0","1","1","0","{\"name\":\"YT Shortcodes\",\"type\":\"plugin\",\"creationDate\":\"September 2021\",\"author\":\"YouTech Company\",\"copyright\":\"Copyright (C) 2015 YouTech Company\",\"authorEmail\":\"contact@ytcvn.com\",\"authorUrl\":\"http:\\/\\/www.smartaddons.com\",\"version\":\"4.0\",\"description\":\"YT_DESC\",\"group\":\"\",\"filename\":\"ytshortcodes\"}","{\"show_sjbootstrap\":0,\"show_sjfont-awesome\":0,\"show_sjjquery\":0,\"show_sjprettify\":0}","",NULL,NULL,"0","0","","0"),
("10062","0","SJ Contact Ajax","module","mod_sj_contact_ajax","","","0","1","0","0","{\"name\":\"SJ Contact Ajax\",\"type\":\"module\",\"creationDate\":\"March 2021\",\"author\":\"YouTech Company\",\"copyright\":\"Copyright (c) 2016 YouTech Company\",\"authorEmail\":\"contact@ytcvn.com\",\"authorUrl\":\"http:\\/\\/www.smartaddons.com\",\"version\":\"2\",\"description\":\"TPL_YTFRAMEWORK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sj_contact_ajax\"}","{\"email_copy_dis\":\"0\",\"facebook_dis\":\"0\",\"facebook_text\":\"\",\"twitter_dis\":\"0\",\"twitter_text\":\"\",\"rss_dis\":\"0\",\"rss_text\":\"\",\"linkedin_dis\":\"0\",\"linkedin_text\":\"\",\"google_plus_dis\":\"0\",\"google_plus_text\":\"\",\"captcha_dis\":\"1\",\"captcha_type\":\"1\",\"captcha_disable\":\"1\",\"maps_display\":\"1\",\"map_width\":\"500\",\"map_height\":\"300\",\"select_type\":\"0\",\"key_text\":\"AIzaSyAYvfhU3lQ4Z52FXziEBemhbiXzFycLj7U\",\"address_text\":\"Hanoi, Viet nam\",\"sLat\":\"21.0333333\",\"sLong\":\"105.85000000000002\",\"map_zoom\":\"3\",\"moduleclass_sfx\":\"\",\"layout\":\"basic\",\"pretext\":\"\",\"posttext\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\"}","",NULL,NULL,"0","0","","0"),
("10063","10066","SJ Mega Menu","module","mod_sj_megamenu_res","","","0","1","0","0","{\"name\":\"SJ Mega Menu\",\"type\":\"module\",\"creationDate\":\"November 2012\",\"author\":\"YouTech Company\",\"copyright\":\"Copyright (c) 2009-2012 YouTech Company\",\"authorEmail\":\"contact@ytcvn.com\",\"authorUrl\":\"http:\\/\\/www.smartaddons.com\",\"version\":\"4.0.1\",\"description\":\"TPL_YTFRAMEWORK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sj_megamenu_res\"}","{\"style_layout\":\"layout1\",\"show_heading_title\":\"0\",\"bg_menu\":\"#444444\",\"menu_event\":\"click\",\"moofx\":\"easeInOutCirc\",\"moofxtimeout\":\"150\",\"css_style\":\"0\",\"sub_animation\":\"\",\"megamenutype\":\"horizontal\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"mobilemenutype\":\"sidebar\",\"tag_id\":\"container_menu\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}","",NULL,NULL,"0","0","","0"),
("10064","10066","System - Extra Menu Params","plugin","x_menu_params","","system","0","1","1","0","{\"name\":\"System - Extra Menu Params\",\"type\":\"plugin\",\"creationDate\":\"November 2012\",\"author\":\"YouTech Company\",\"copyright\":\"Copyright (c) 2012 YouTech Company\",\"authorEmail\":\"contact@ytcvn.com\",\"authorUrl\":\"http:\\/\\/www.ytcvn.com\",\"version\":\"4.0.1\",\"description\":\"YouTech Extra Params plugin for Joomla 4.0.x\",\"group\":\"\",\"filename\":\"x_menu_params\"}","{}","",NULL,NULL,"0","0","","0"),
("10065","10066","Extra Mega Menu - Ajax","plugin","xmenu","","ajax","0","0","1","0","{\"name\":\"Extra Mega Menu - Ajax\",\"type\":\"plugin\",\"creationDate\":\"March 2017\",\"author\":\"smartaddons.com\",\"copyright\":\"Copyright (C) 2010 - 2015 SmartAddons. All rights reserved.\",\"authorEmail\":\"contact@smartaddons.com\",\"authorUrl\":\"www.smartaddons.com\",\"version\":\"1.0\",\"description\":\"\",\"group\":\"\",\"filename\":\"xmenu\"}","{}","",NULL,NULL,"0","0","","0"),
("10070","0","Sj Basic News","module","mod_sj_basic_news","","","0","1","0","0","{\"name\":\"Sj Basic News\",\"type\":\"module\",\"creationDate\":\"Oct 2021\",\"author\":\"YouTech Company\",\"copyright\":\"Copyright (c) 2016 YouTech Company\",\"authorEmail\":\"contact@ytcvn.com\",\"authorUrl\":\"http:\\/\\/www.smartaddons.com\",\"version\":\"4.0.0\",\"description\":\"SJ_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sj_basic_news\"}","{\"link_target\":\"_self\",\"catid\":\"\",\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"show_front\":\"show\",\"article_ordering\":\"a.title\",\"article_ordering_direction\":\"ASC\",\"count\":\"10\",\"cat_title_display\":\"1\",\"title_display\":\"1\",\"item_title_max_characs\":\"25\",\"item_desc_display\":\"1\",\"item_desc_max_characs\":\"200\",\"item_date_display\":\"1\",\"item_readmore_display\":\"1\",\"item_readmore_text\":\"Read more\",\"showline\":\"0\",\"imgcfg_from_image_intro\":\"1\",\"imgcfg_from_image_fulltext\":\"1\",\"imgcfg_from_inline_introtext\":\"1\",\"imgcfg_from_inline_fulltext\":\"1\",\"imgcfg_from_external\":\"1\",\"imgcfg_external_url\":\"images\\/{id}.jpg\",\"imgcfg_order\":\"image_intro, image_fulltext, inline_introtext, inline_fulltext, external\",\"imgcfg_function\":\"resize_stretch\",\"imgcfg_type\":\"\",\"imgcfg_transparency\":\"1\",\"imgcfg_width\":\"500\",\"imgcfg_height\":\"400\",\"imgcfg_background\":\"\",\"imgcfg_placeholder\":\"1\",\"imgcfg_placeholder_path\":\"modules\\/mod_sj_basic_news\\/assets\\/images\\/nophoto.png\",\"pretext\":\"\",\"posttext\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\"}","",NULL,NULL,"0","0","","0"),
("10071","0","sj_iconstruct","template","sj_iconstruct","","","0","1","1","0","{\"name\":\"sj_iconstruct\",\"type\":\"template\",\"creationDate\":\"20\\/10\\/2017\",\"author\":\"smartaddons.com\",\"copyright\":\"Copyright (C) 2017 SmartAddons.com. All rights reserved.\",\"authorEmail\":\"contact@ytcvn.com\",\"authorUrl\":\"http:\\/\\/smartaddons.com\\/\",\"version\":\"1.0\",\"description\":\"SJ Personal - Starter Template of Helix3 framework\",\"group\":\"\",\"filename\":\"templateDetails\"}","{\"preloader\":\"0\",\"preloader_animation\":\"circle\",\"preloader_bg\":\"#f5f5f5\",\"preloader_tx\":\"#333333\",\"goto_top\":\"0\",\"sticky_header\":\"1\",\"boxed_layout\":\"0\",\"logo_type\":\"image\",\"logo_position\":\"logo\",\"logo_load_pos\":\"default\",\"body_bg_repeat\":\"inherit\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"body_bg_position\":\"0 0\",\"enabled_copyright\":\"1\",\"copyright_position\":\"footer1\",\"copyright_load_pos\":\"default\",\"copyright\":\"\\u00a92017 Sj Expnews - Joomla Templates.  All Rights Reserved. Designed by SmartAddons.Com\",\"show_social_icons\":\"1\",\"social_position\":\"top1\",\"social_load_pos\":\"default\",\"enable_contactinfo\":\"1\",\"contact_position\":\"top2\",\"comingsoon_mode\":\"0\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_date\":\"5-10-2018\",\"comingsoon_content\":\"Coming soon content\",\"preset\":\"preset1\",\"preset1_bg\":\"#ffffff\",\"preset1_text\":\"#000000\",\"preset1_major\":\"#26aae1\",\"preset1_megabg\":\"#ffffff\",\"preset1_megatx\":\"#333333\",\"preset2_bg\":\"#ffffff\",\"preset2_text\":\"#000000\",\"preset2_major\":\"#3d449a\",\"preset2_megabg\":\"#ffffff\",\"preset2_megatx\":\"#333333\",\"preset3_bg\":\"#ffffff\",\"preset3_text\":\"#000000\",\"preset3_major\":\"#2bb673\",\"preset3_megabg\":\"#ffffff\",\"preset3_megatx\":\"#333333\",\"preset4_bg\":\"#ffffff\",\"preset4_text\":\"#000000\",\"preset4_major\":\"#eb4947\",\"preset4_megabg\":\"#ffffff\",\"preset4_megatx\":\"#333333\",\"menu\":\"mainmenu\",\"menu_type\":\"mega_offcanvas\",\"menu_animation\":\"menu-fade\",\"offcanvas_animation\":\"default\",\"enable_body_font\":\"1\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"300\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h1_font\":\"1\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"800\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h2_font\":\"1\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h3_font\":\"1\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h4_font\":\"1\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h5_font\":\"1\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h6_font\":\"1\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_navigation_font\":\"0\",\"enable_custom_font\":\"0\",\"compress_css\":\"0\",\"compress_js\":\"0\",\"lessoption\":\"0\",\"show_post_format\":\"1\",\"commenting_engine\":\"disabled\",\"disqus_devmode\":\"0\",\"intensedebate_acc\":\"\",\"fb_width\":\"500\",\"fb_cpp\":\"10\",\"comments_count\":\"0\",\"social_share\":\"1\",\"image_small\":\"0\",\"image_small_size\":\"100X100\",\"image_thumbnail\":\"1\",\"image_thumbnail_size\":\"200X200\",\"image_medium\":\"0\",\"image_medium_size\":\"300X300\",\"image_large\":\"0\",\"image_large_size\":\"600X600\",\"blog_list_image\":\"default\"}","",NULL,NULL,"0","0","","0"),
("10073","0","SJ Extra Slider for Content","module","mod_sj_news_extra_slider","","","0","1","0","0","{\"name\":\"SJ Extra Slider for Content\",\"type\":\"module\",\"creationDate\":\"November 2021\",\"author\":\"YouTech Company\",\"copyright\":\"Copyright (c) 2015 YouTech Company\",\"authorEmail\":\"contact@ytcvn.com\",\"authorUrl\":\"http:\\/\\/www.smartaddons.com\",\"version\":\"4.0.0\",\"description\":\"TPL_YTFRAMEWORK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sj_news_extra_slider\"}","{\"item_link_target\":\"_self\",\"button_page\":\"\",\"theme\":\"style1\",\"nb-column0\":\"4\",\"nb-column1\":\"3\",\"nb-column2\":\"3\",\"nb-column3\":\"2\",\"nb-column4\":\"1\",\"nb_rows\":\"1\",\"catid\":\"\",\"show_child_category_articles\":\"1\",\"levels\":\"1\",\"show_front\":\"show\",\"article_ordering\":\"a.title\",\"article_ordering_direction\":\"ASC\",\"count\":\"8\",\"title_slider_display\":\"1\",\"title_slider\":\"Latest News\",\"item_title_display\":\"1\",\"item_title_max_characs\":\"20\",\"item_desc_display\":\"1\",\"item_desc_max_characs\":\"50\",\"item_tags_display\":\"0\",\"item_readmore_display\":\"1\",\"item_readmore_text\":\"Read more\",\"imgcfg_from_image_intro\":\"1\",\"imgcfg_from_image_fulltext\":\"1\",\"imgcfg_from_inline_introtext\":\"1\",\"imgcfg_from_inline_fulltext\":\"1\",\"imgcfg_from_external\":\"1\",\"imgcfg_order\":\"image_intro, image_fulltext, inline_introtext, inline_fulltext, external\",\"imgcfg_external_url\":\"images\\/{id}.jpg\",\"imgcfg_function\":\"resize_stretch\",\"imgcfg_type\":\"\",\"imgcfg_transparency\":\"1\",\"imgcfg_width\":\"210\",\"imgcfg_height\":\"150\",\"imgcfg_background\":\"#FFFFFF\",\"imgcfg_placeholder_path\":\"modules\\/mod_sj_news_extra_slider\\/assets\\/images\\/nophoto.jpg\",\"margin\":\"5\",\"slideBy\":\"1\",\"autoplay\":\"1\",\"autoplay_timeout\":\"5000\",\"pausehover\":\"1\",\"autoplay_speed\":\"2000\",\"startPosition\":\"0\",\"mousedrag\":\"1\",\"touchdrag\":\"1\",\"effect\":\"starwars\",\"dots\":\"1\",\"dotsSpeed\":\"500\",\"navs\":\"1\",\"navSpeed\":\"500\",\"duration\":\"600\",\"delay\":\"300\",\"pretext\":\"\",\"posttext\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\"}","",NULL,NULL,"0","0","","0"),
("10101","0","plg_behaviour_taggable","plugin","taggable","","behaviour","0","1","1","0","{\"name\":\"plg_behaviour_taggable\",\"type\":\"plugin\",\"creationDate\":\"August 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_TAGGABLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"taggable\"}","{}","",NULL,NULL,"0","0","","1"),
("10102","0","plg_behaviour_versionable","plugin","versionable","","behaviour","0","1","1","0","{\"name\":\"plg_behaviour_versionable\",\"type\":\"plugin\",\"creationDate\":\"August 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_VERSIONABLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"versionable\"}","{}","",NULL,NULL,"0","0","","1"),
("10103","0","atum","template","atum","","","1","1","1","0","{\"name\":\"atum\",\"type\":\"template\",\"creationDate\":\"September 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ATUM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}","{}","",NULL,NULL,"0","0","","1"),
("10104","0","cassiopeia","template","cassiopeia","","","0","1","1","0","{\"name\":\"cassiopeia\",\"type\":\"template\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_CASSIOPEIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}","{}","",NULL,NULL,"0","0","","1"),
("10105","0","plg_filesystem_local","plugin","local","","filesystem","0","1","1","0","{\"name\":\"plg_filesystem_local\",\"type\":\"plugin\",\"creationDate\":\"April 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FILESYSTEM_LOCAL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"local\"}","{}","",NULL,NULL,"0","0","","1"),
("10106","0","plg_media-action_crop","plugin","crop","","media-action","0","1","1","0","{\"name\":\"plg_media-action_crop\",\"type\":\"plugin\",\"creationDate\":\"January 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_CROP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"crop\"}","{}","",NULL,NULL,"0","0","","1"),
("10107","0","plg_media-action_resize","plugin","resize","","media-action","0","1","1","0","{\"name\":\"plg_media-action_resize\",\"type\":\"plugin\",\"creationDate\":\"January 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_RESIZE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"resize\"}","{}","",NULL,NULL,"0","0","","1"),
("10108","0","plg_media-action_rotate","plugin","rotate","","media-action","0","1","1","0","{\"name\":\"plg_media-action_rotate\",\"type\":\"plugin\",\"creationDate\":\"January 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_ROTATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"rotate\"}","{}","",NULL,NULL,"0","0","","1"),
("10109","0","plg_system_httpheaders","plugin","httpheaders","","system","0","0","1","0","{\"name\":\"plg_system_httpheaders\",\"type\":\"plugin\",\"creationDate\":\"October 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_HTTPHEADERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"httpheaders\"}","{}","",NULL,NULL,"0","0","","1"),
("10110","0","com_workflow","component","com_workflow","","","1","1","0","1","{\"name\":\"com_workflow\",\"type\":\"component\",\"creationDate\":\"June 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WORKFLOW_XML_DESCRIPTION\",\"group\":\"\"}","{}","",NULL,NULL,"0","0","","1"),
("10111","0","plg_workflow_publishing","plugin","publishing","","workflow","0","1","1","0","{\"name\":\"plg_workflow_publishing\",\"type\":\"plugin\",\"creationDate\":\"March 2020\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_PUBLISHING_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"publishing\"}","{}","",NULL,NULL,"0","0","","0");
INSERT INTO #__extensions VALUES
("10112","0","plg_workflow_featuring","plugin","featuring","","workflow","0","1","1","0","{\"name\":\"plg_workflow_featuring\",\"type\":\"plugin\",\"creationDate\":\"March 2020\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_FEATURING_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"featuring\"}","{}","",NULL,NULL,"0","0","","0"),
("10113","0","plg_workflow_notification","plugin","notification","","workflow","0","1","1","0","{\"name\":\"plg_workflow_notification\",\"type\":\"plugin\",\"creationDate\":\"May 2020\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"notification\"}","{}","",NULL,NULL,"0","0","","0"),
("10114","0","plg_extension_namespacemap","plugin","namespacemap","","extension","0","1","1","1","{\"name\":\"plg_extension_namespacemap\",\"type\":\"plugin\",\"creationDate\":\"May 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_NAMESPACEMAP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"namespacemap\"}","","",NULL,NULL,"0","0","","1"),
("10115","0","plg_installer_override","plugin","override","","installer","0","1","1","0","{\"name\":\"plg_installer_override\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_OVERRIDE_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"override\"}","","",NULL,NULL,"4","0","","1"),
("10116","0","plg_quickicon_overridecheck","plugin","overridecheck","","quickicon","0","1","1","0","{\"name\":\"plg_quickicon_overridecheck\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_OVERRIDECHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"overridecheck\"}","","",NULL,NULL,"0","0","","1"),
("10117","0","plg_extension_finder","plugin","finder","","extension","0","1","1","0","{\"name\":\"plg_extension_finder\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}","","",NULL,NULL,"0","0","","1"),
("10118","0","plg_api-authentication_basic","plugin","basic","","api-authentication","0","0","1","0","{\"name\":\"plg_api-authentication_basic\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_BASIC_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"basic\"}","{}","",NULL,NULL,"0","0","","1"),
("10119","0","plg_webservices_content","plugin","content","","webservices","0","1","1","0","{\"name\":\"plg_webservices_content\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}","{}","",NULL,NULL,"0","0","","1"),
("10120","0","com_mails","component","com_mails","","","1","1","1","1","{\"name\":\"com_mails\",\"type\":\"component\",\"creationDate\":\"January 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MAILS_XML_DESCRIPTION\",\"group\":\"\"}","{}","",NULL,NULL,"0","0","","1"),
("10121","0","plg_system_skipto","plugin","skipto","","system","0","1","1","0","{\"name\":\"plg_system_skipto\",\"type\":\"plugin\",\"creationDate\":\"February 2020\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_SKIPTO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"skipto\"}","{}","",NULL,NULL,"0","0","","1"),
("10122","0","plg_sampledata_multilang","plugin","multilang","","sampledata","0","1","1","0","{\"name\":\"plg_sampledata_multilang\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SAMPLEDATA_MULTILANG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"multilang\"}","{}","",NULL,NULL,"0","0","","1"),
("10123","0","plg_installer_webinstaller","plugin","webinstaller","","installer","0","1","1","0","{\"name\":\"plg_installer_webinstaller\",\"type\":\"plugin\",\"creationDate\":\"April 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_WEBINSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"webinstaller\"}","{}","",NULL,NULL,"0","0","","1"),
("10124","0","plg_fields_subform","plugin","subform","","fields","0","1","1","0","{\"name\":\"plg_fields_subform\",\"type\":\"plugin\",\"creationDate\":\"June 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FIELDS_SUBFORM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"subform\"}","","",NULL,NULL,"0","0","","1"),
("10125","0","plg_system_webauthn","plugin","webauthn","","system","0","1","1","0","{\"name\":\"plg_system_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2019-07-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_WEBAUTHN_DESCRIPTION\",\"group\":\"\",\"filename\":\"webauthn\"}","{}","",NULL,NULL,"0","0","","1"),
("10126","0","mod_loginsupport","module","mod_loginsupport","","","1","1","1","0","{\"name\":\"mod_loginsupport\",\"type\":\"module\",\"creationDate\":\"June 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_LOGINSUPPORT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_loginsupport\"}","","",NULL,NULL,"0","0","","1"),
("10127","0","mod_frontend","module","mod_frontend","","","1","1","1","0","{\"name\":\"mod_frontend\",\"type\":\"module\",\"creationDate\":\"July 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_FRONTEND_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_frontend\"}","","",NULL,NULL,"0","0","","1"),
("10128","0","mod_messages","module","mod_messages","","","1","1","1","0","{\"name\":\"mod_messages\",\"type\":\"module\",\"creationDate\":\"July 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_messages\"}","","",NULL,NULL,"0","0","","1"),
("10129","0","mod_post_installation_messages","module","mod_post_installation_messages","","","1","1","1","0","{\"name\":\"mod_post_installation_messages\",\"type\":\"module\",\"creationDate\":\"July2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_POST_INSTALLATION_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_post_installation_messages\"}","","",NULL,NULL,"0","0","","1"),
("10130","0","mod_user","module","mod_user","","","1","1","1","0","{\"name\":\"mod_user\",\"type\":\"module\",\"creationDate\":\"July 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_user\"}","","",NULL,NULL,"0","0","","1"),
("10131","0","mod_submenu","module","mod_submenu","","","1","1","1","0","{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_submenu\"}","{}","",NULL,NULL,"0","0","","1"),
("10132","0","mod_privacy_status","module","mod_privacy_status","","","1","1","1","0","{\"name\":\"mod_privacy_status\",\"type\":\"module\",\"creationDate\":\"July 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_PRIVACY_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_privacy_status\"}","{}","",NULL,NULL,"0","0","","1"),
("10133","0","plg_webservices_banners","plugin","banners","","webservices","0","1","1","0","{\"name\":\"plg_webservices_banners\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"banners\"}","{}","",NULL,NULL,"0","0","","1"),
("10134","0","plg_webservices_config","plugin","config","","webservices","0","1","1","0","{\"name\":\"plg_webservices_config\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"config\"}","{}","",NULL,NULL,"0","0","","1"),
("10135","0","plg_webservices_contact","plugin","contact","","webservices","0","1","1","0","{\"name\":\"plg_webservices_contact\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}","{}","",NULL,NULL,"0","0","","1"),
("10136","0","plg_webservices_languages","plugin","languages","","webservices","0","1","1","0","{\"name\":\"plg_webservices_languages\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languages\"}","{}","",NULL,NULL,"0","0","","1"),
("10137","0","plg_webservices_menus","plugin","menus","","webservices","0","1","1","0","{\"name\":\"plg_webservices_menus\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menus\"}","{}","",NULL,NULL,"0","0","","1"),
("10138","0","plg_webservices_messages","plugin","messages","","webservices","0","1","1","0","{\"name\":\"plg_webservices_messages\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"messages\"}","{}","",NULL,NULL,"0","0","","1"),
("10139","0","plg_webservices_modules","plugin","modules","","webservices","0","1","1","0","{\"name\":\"plg_webservices_modules\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"modules\"}","{}","",NULL,NULL,"0","0","","1"),
("10140","0","plg_webservices_newsfeeds","plugin","newsfeeds","","webservices","0","1","1","0","{\"name\":\"plg_webservices_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}","{}","",NULL,NULL,"0","0","","1"),
("10141","0","plg_webservices_plugins","plugin","plugins","","webservices","0","1","1","0","{\"name\":\"plg_webservices_plugins\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"plugins\"}","{}","",NULL,NULL,"0","0","","1"),
("10142","0","plg_webservices_privacy","plugin","privacy","","webservices","0","1","1","0","{\"name\":\"plg_webservices_privacy\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacy\"}","{}","",NULL,NULL,"0","0","","1"),
("10143","0","plg_webservices_redirect","plugin","redirect","","webservices","0","1","1","0","{\"name\":\"plg_webservices_redirect\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"redirect\"}","{}","",NULL,NULL,"0","0","","1"),
("10144","0","plg_webservices_tags","plugin","tags","","webservices","0","1","1","0","{\"name\":\"plg_webservices_tags\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}","{}","",NULL,NULL,"0","0","","1"),
("10145","0","plg_webservices_templates","plugin","templates","","webservices","0","1","1","0","{\"name\":\"plg_webservices_templates\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templates\"}","{}","",NULL,NULL,"0","0","","1"),
("10146","0","plg_webservices_users","plugin","users","","webservices","0","1","1","0","{\"name\":\"plg_webservices_users\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_USERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"users\"}","{}","",NULL,NULL,"0","0","","1"),
("10147","0","plg_webservices_installer","plugin","installer","","webservices","0","1","1","0","{\"name\":\"plg_webservices_installer\",\"type\":\"plugin\",\"creationDate\":\"June 2020\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"installer\"}","{}","",NULL,NULL,"0","0","","0"),
("10148","0","plg_user_token","plugin","token","","user","0","1","1","0","{\"name\":\"plg_user_token\",\"type\":\"plugin\",\"creationDate\":\"November 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"token\"}","{}","",NULL,NULL,"0","0","","1"),
("10149","0","plg_api-authentication_token","plugin","token","","api-authentication","0","1","1","0","{\"name\":\"plg_api-authentication_token\",\"type\":\"plugin\",\"creationDate\":\"November 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"token\"}","{}","",NULL,NULL,"0","0","","1"),
("10150","0","plg_system_accessibility","plugin","accessibility","","system","0","0","1","0","{\"name\":\"plg_system_accessibility\",\"type\":\"plugin\",\"creationDate\":\"2020-02-15\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_ACCESSIBILITY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"accessibility\"}","{}","",NULL,NULL,"0","0","","1"),
("10151","802","English (en-GB)","language","en-GB","","","3","1","1","1","{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"January 2022\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.6\",\"description\":\"en-GB api language\",\"group\":\"\"}","","",NULL,NULL,"0","0","","1"),
("10152","0","plg_quickicon_downloadkey","plugin","downloadkey","","quickicon","0","1","1","0","{\"name\":\"plg_quickicon_downloadkey\",\"type\":\"plugin\",\"creationDate\":\"October 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_DOWNLOADKEY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"downloadkey\"}","","",NULL,NULL,"0","0","","1"),
("10153","0","pkg_search","package","pkg_search","","","0","1","1","0","{\"name\":\"pkg_search\",\"type\":\"package\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.1-dev\",\"description\":\"\",\"group\":\"\",\"filename\":\"pkg_search\"}","","",NULL,NULL,"0","0","","0"),
("10155","0","plg_system_sj_contact_ajax","plugin","x_sj_contact_ajax","","system","0","1","1","0","{\"name\":\"plg_system_sj_contact_ajax\",\"type\":\"plugin\",\"creationDate\":\"March 2021\",\"author\":\"YouTech Company\",\"copyright\":\"Copyright (c) 2009-2013 YouTech Company. All rights reserved.\",\"authorEmail\":\"contact@ytcvn.com\",\"authorUrl\":\"http:\\/\\/www.smartaddons.com\",\"version\":\"2.0\",\"description\":\"TPL_YTFRAMEWORK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"x_sj_contact_ajax\"}","{}","",NULL,NULL,"0","0","","0"),
("10156","10029","Arabic Unitag (العربية الموحدة)","language","ar-AA","","","3","1","0","0","{\"name\":\"Arabic Unitag (\\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629)\",\"type\":\"language\",\"creationDate\":\"June 2021\",\"author\":\"Dr. Ashraf Damra\",\"copyright\":\"Copyright (C) 2005 - 2021 Open Source Matters.\",\"authorEmail\":\"dr.d.ashraf@gmail.com\",\"authorUrl\":\"www.dr-ashraf.com\",\"version\":\"4.0.0\",\"description\":\"\\u0648\\u0627\\u062c\\u0647\\u0629 \\u0628\\u0631\\u0645\\u062c\\u0629 \\u062a\\u0637\\u0628\\u064a\\u0642 \\u0627\\u0644\\u0644\\u063a\\u0629 ar-AA\",\"group\":\"\",\"filename\":\"install\"}","{}","",NULL,NULL,"0","0","","0"),
("10157","0","SP Page Builder","module","mod_sppagebuilder","","","0","1","0","0","{\"name\":\"SP Page Builder\",\"type\":\"module\",\"creationDate\":\"Oct 2016\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (c) 2010 - 2021 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.5\",\"description\":\"Module to display content from SP Page Builder\",\"group\":\"\",\"filename\":\"mod_sppagebuilder\"}","{\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}","",NULL,NULL,"0","0","","0");


DROP TABLE IF EXISTS #__fields;
CREATE TABLE `#__fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_value` text COLLATE utf8mb4_unicode_ci,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldparams` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL,
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  `only_use_in_subform` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_user_id` (`created_user_id`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS #__fields_categories;
CREATE TABLE `#__fields_categories` (
  `field_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`field_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS #__fields_groups;
CREATE TABLE `#__fields_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS #__fields_values;
CREATE TABLE `#__fields_values` (
  `field_id` int(10) unsigned NOT NULL,
  `item_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` text COLLATE utf8mb4_unicode_ci,
  KEY `idx_field_id` (`field_id`),
  KEY `idx_item_id` (`item_id`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS #__finder_links_terms;
CREATE TABLE `#__finder_links_terms` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS #__finder_logging;
CREATE TABLE `#__finder_logging` (
  `searchterm` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `md5sum` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `query` blob NOT NULL,
  `hits` int(11) NOT NULL DEFAULT '1',
  `results` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`md5sum`),
  KEY `searchterm` (`searchterm`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS #__history;
CREATE TABLE `#__history` (
  `version_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version_note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Optional version name',
  `save_date` datetime NOT NULL,
  `editor_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `character_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Number of characters in this version.',
  `sha1_hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'SHA1 hash of the version_data column.',
  `version_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'json-encoded string of version data',
  `keep_forever` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0=auto delete; 1=keep',
  PRIMARY KEY (`version_id`),
  KEY `idx_ucm_item_id` (`item_id`),
  KEY `idx_save_date` (`save_date`)
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__history VALUES
("1","com_content.category.19","","2015-02-02 06:05:15","739","580","8b8b28d0735048ef374cfed409baeca2e9c48a2a","{\"id\":19,\"asset_id\":\"44\",\"parent_id\":\"1\",\"lft\":\"105\",\"rgt\":132,\"level\":1,\"path\":\"sample-data-articles\\/joomla\",\"extension\":\"com_content\",\"title\":\"Joomla!\",\"alias\":\"joomla\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 06:05:10\",\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"864\",\"created_time\":\"2011-01-01 00:00:01\",\"modified_user_id\":\"864\",\"modified_time\":\"2015-02-02 06:05:15\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\"}","0"),
("2","com_content.category.21","","2015-02-02 06:05:23","739","872","44c955d32c91be43379e62067ff88355a5e6afd7","{\"id\":21,\"asset_id\":\"46\",\"parent_id\":\"19\",\"lft\":\"130\",\"rgt\":131,\"level\":2,\"path\":\"joomla\\/extensions\\/components\",\"extension\":\"com_content\",\"title\":\"Components\",\"alias\":\"components\",\"note\":\"\",\"description\":\"<p>Components are larger extensions that produce the major content for your site. Each component has one or more \\\"views\\\" that control how content is displayed. In the Joomla administrator there are additional extensions such as Menus, Redirection, and the extension managers.<\\/p>\",\"published\":\"1\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 06:05:17\",\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"864\",\"created_time\":\"2011-01-01 00:00:01\",\"modified_user_id\":\"864\",\"modified_time\":\"2015-02-02 06:05:23\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\"}","0"),
("3","com_content.category.79","","2015-02-02 06:12:46","739","511","633bb165d3f0f0ffc2722ee67a8a24736aadfb47","{\"id\":79,\"asset_id\":179,\"parent_id\":\"1\",\"lft\":\"91\",\"rgt\":92,\"level\":1,\"path\":null,\"extension\":\"com_content\",\"title\":\"Blog\",\"alias\":\"blog\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"864\",\"created_time\":\"2015-02-02 06:12:46\",\"modified_user_id\":null,\"modified_time\":null,\"hits\":\"0\",\"language\":\"*\",\"version\":null}","0"),
("4","com_content.category.80","","2015-02-02 18:42:14","739","511","d9e56992245d6c642c811b6be37a65ad944605d4","{\"id\":80,\"asset_id\":191,\"parent_id\":\"1\",\"lft\":\"93\",\"rgt\":94,\"level\":1,\"path\":null,\"extension\":\"com_content\",\"title\":\"News\",\"alias\":\"news\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"864\",\"created_time\":\"2015-02-02 18:42:14\",\"modified_user_id\":null,\"modified_time\":null,\"hits\":\"0\",\"language\":\"*\",\"version\":null}","0"),
("5","com_content.category.80","","2015-02-02 18:42:30","739","551","b0c69f126552d2f470dab4c2637f32d2d55d04ca","{\"id\":80,\"asset_id\":\"191\",\"parent_id\":\"79\",\"lft\":\"92\",\"rgt\":93,\"level\":2,\"path\":\"news\",\"extension\":\"com_content\",\"title\":\"News\",\"alias\":\"news\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 18:42:24\",\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"864\",\"created_time\":\"2015-02-02 18:42:14\",\"modified_user_id\":\"864\",\"modified_time\":\"2015-02-02 18:42:30\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\"}","0"),
("6","com_content.category.81","","2015-02-02 18:42:46","739","520","c1186cda9e6fae853472a26d68bc50d2f9af3eef","{\"id\":81,\"asset_id\":192,\"parent_id\":\"79\",\"lft\":\"94\",\"rgt\":95,\"level\":2,\"path\":null,\"extension\":\"com_content\",\"title\":\"Tutorial\",\"alias\":\"tutorial\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"864\",\"created_time\":\"2015-02-02 18:42:46\",\"modified_user_id\":null,\"modified_time\":null,\"hits\":\"0\",\"language\":\"*\",\"version\":null}","0"),
("7","com_content.category.82","","2015-02-02 18:42:56","739","516","8433516aea93072c0f29f750669e5b4dfe733e72","{\"id\":82,\"asset_id\":193,\"parent_id\":\"79\",\"lft\":\"96\",\"rgt\":97,\"level\":2,\"path\":null,\"extension\":\"com_content\",\"title\":\"Review\",\"alias\":\"review\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"864\",\"created_time\":\"2015-02-02 18:42:56\",\"modified_user_id\":null,\"modified_time\":null,\"hits\":\"0\",\"language\":\"*\",\"version\":null}","0"),
("8","com_content.category.83","","2015-02-02 18:43:15","739","518","c054624137f36fae4f0cc107c6e7caa47aeb8401","{\"id\":83,\"asset_id\":194,\"parent_id\":\"79\",\"lft\":\"98\",\"rgt\":99,\"level\":2,\"path\":null,\"extension\":\"com_content\",\"title\":\"Updates\",\"alias\":\"updates\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"864\",\"created_time\":\"2015-02-02 18:43:15\",\"modified_user_id\":null,\"modified_time\":null,\"hits\":\"0\",\"language\":\"*\",\"version\":null}","0"),
("9","com_content.article.71","","2015-02-02 18:56:08","739","2452","3199ad1fb625886490e0c300580c73a27ce5ad80","{\"id\":71,\"asset_id\":195,\"title\":\"Sed non bibendum urna lorem ipsum dolor sit amet, consectetur adipiscing elit\",\"alias\":\"sed-non-bibendum-urna-lorem-ipsum-dolor-sit-amet-consectetur-adipiscing-elit\",\"introtext\":\"\",\"fulltext\":\"\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 18:56:08\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2015-02-02 18:56:08\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"status\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"<blockquote class=\\\\\\\"twitter-tweet\\\\\\\" lang=\\\\\\\"en\\\\\\\"><p>Published a new blog entry One Month Extra for all JoomShaper Members in News. <a href=\\\\\\\"http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8\\\\\\\">http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8<\\\\\\/a><\\\\\\/p>&mdash; JoomShaper (@joomshaper) <a href=\\\\\\\"https:\\\\\\/\\\\\\/twitter.com\\\\\\/joomshaper\\\\\\/status\\\\\\/562210375480139777\\\\\\\">February 2, 2015<\\\\\\/a><\\\\\\/blockquote>\\\\r\\\\n<script async src=\\\\\\\"\\\\\\/\\\\\\/platform.twitter.com\\\\\\/widgets.js\\\\\\\" charset=\\\\\\\"utf-8\\\\\\\"><\\\\\\/script>\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("10","com_content.article.71","","2015-02-02 18:57:20","739","3565","d515334bc8af0f508f8d49ed3f265247e6927098","{\"id\":71,\"asset_id\":\"195\",\"title\":\"Sed non bibendum urna lorem ipsum dolor sit amet, consectetur adipiscing elit\",\"alias\":\"sed-non-bibendum-urna-lorem-ipsum-dolor-sit-amet-consectetur-adipiscing-elit\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 18:56:08\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 18:57:20\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 18:56:08\",\"publish_up\":\"2015-02-02 18:56:08\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"status\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"<blockquote class=\\\\\\\"twitter-tweet\\\\\\\" lang=\\\\\\\"en\\\\\\\"><p>Published a new blog entry One Month Extra for all JoomShaper Members in News. <a href=\\\\\\\"http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8\\\\\\\">http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8<\\\\\\/a><\\\\\\/p>&mdash; JoomShaper (@joomshaper) <a href=\\\\\\\"https:\\\\\\/\\\\\\/twitter.com\\\\\\/joomshaper\\\\\\/status\\\\\\/562210375480139777\\\\\\\">February 2, 2015<\\\\\\/a><\\\\\\/blockquote>\\\\r\\\\n<script async src=\\\\\\\"\\\\\\/\\\\\\/platform.twitter.com\\\\\\/widgets.js\\\\\\\" charset=\\\\\\\"utf-8\\\\\\\"><\\\\\\/script>\\\"}\",\"version\":2,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("11","com_content.article.71","","2015-02-02 19:27:38","739","3506","65f0cb164ef3547aea586502a546465a75009405","{\"id\":71,\"asset_id\":\"195\",\"title\":\"Sed non bibendum urna lorem ipsum dolor sit amet\",\"alias\":\"sed-non-bibendum-urna-lorem-ipsum-dolor-sit-amet\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 18:56:08\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 19:27:38\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 19:27:11\",\"publish_up\":\"2015-02-02 18:56:08\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"link\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"<blockquote class=\\\\\\\"twitter-tweet\\\\\\\" lang=\\\\\\\"en\\\\\\\"><p>Published a new blog entry One Month Extra for all JoomShaper Members in News. <a href=\\\\\\\"http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8\\\\\\\">http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8<\\\\\\/a><\\\\\\/p>&mdash; JoomShaper (@joomshaper) <a href=\\\\\\\"https:\\\\\\/\\\\\\/twitter.com\\\\\\/joomshaper\\\\\\/status\\\\\\/562210375480139777\\\\\\\">February 2, 2015<\\\\\\/a><\\\\\\/blockquote>\\\\r\\\\n<script async src=\\\\\\\"\\\\\\/\\\\\\/platform.twitter.com\\\\\\/widgets.js\\\\\\\" charset=\\\\\\\"utf-8\\\\\\\"><\\\\\\/script>\\\"}\",\"version\":3,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"2\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("12","com_content.article.71","","2015-02-02 20:27:55","739","3474","83a23bb087b2f684a1a99ac8909d53860444eef9","{\"id\":71,\"asset_id\":\"195\",\"title\":\"Doner spare ribs pastrami shank\",\"alias\":\"doner-spare-ribs-pastrami-shank\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 18:56:08\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:27:55\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 19:44:14\",\"publish_up\":\"2015-02-02 18:56:08\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"status\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"<blockquote class=\\\\\\\"twitter-tweet\\\\\\\" lang=\\\\\\\"en\\\\\\\"><p>Published a new blog entry One Month Extra for all JoomShaper Members in News. <a href=\\\\\\\"http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8\\\\\\\">http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8<\\\\\\/a><\\\\\\/p>&mdash; JoomShaper (@joomshaper) <a href=\\\\\\\"https:\\\\\\/\\\\\\/twitter.com\\\\\\/joomshaper\\\\\\/status\\\\\\/562210375480139777\\\\\\\">February 2, 2015<\\\\\\/a><\\\\\\/blockquote>\\\\r\\\\n<script async src=\\\\\\\"\\\\\\/\\\\\\/platform.twitter.com\\\\\\/widgets.js\\\\\\\" charset=\\\\\\\"utf-8\\\\\\\"><\\\\\\/script>\\\"}\",\"version\":4,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"5\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("13","com_content.article.72","","2015-02-02 20:29:50","739","2978","2e634ee58bf5a238a9f23f8648ceb1740903121e","{\"id\":72,\"asset_id\":196,\"title\":\"Jerky shank chicken boudin\",\"alias\":\"jerky-shank-chicken-boudin\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>\\u00a0<\\/p>\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"video\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"http:\\\\\\/\\\\\\/vimeo.com\\\\\\/106306926\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("14","com_content.article.72","","2015-02-02 20:31:04","739","3015","dd4d438b486ad946a1e95cdd3e0fb3f6362dc0a0","{\"id\":72,\"asset_id\":\"196\",\"title\":\"Jerky shank chicken boudin\",\"alias\":\"jerky-shank-chicken-boudin\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>\\u00a0<\\/p>\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:31:04\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 20:29:50\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"video\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"http:\\\\\\/\\\\\\/vimeo.com\\\\\\/47505825\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("15","com_content.article.72","","2015-02-02 20:31:45","739","3015","d6a7362352a24b1ee69fcc4aa4377bf7d7de6c7a","{\"id\":72,\"asset_id\":\"196\",\"title\":\"Jerky shank chicken boudin\",\"alias\":\"jerky-shank-chicken-boudin\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>\\u00a0<\\/p>\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:31:45\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 20:31:40\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"video\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"http:\\\\\\/\\\\\\/vimeo.com\\\\\\/43426940\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("16","com_content.article.73","","2015-02-02 20:37:50","739","3008","460756e5114f53fbad57d5f6ae16e526d075d1d6","{\"id\":73,\"asset_id\":197,\"title\":\"Jerky shank chicken boudin (2)\",\"alias\":\"jerky-shank-chicken-boudin-2\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>\\u00a0<\\/p>\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":0,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:31:45\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/blog\\\\\\/blog01.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"images\\\\\\/blog\\\\\\/blog01.jpg\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("17","com_content.article.73","","2015-02-02 20:41:37","739","3036","98e5d3dc541496f3f246af84a9202acdb7bd8a73","{\"id\":73,\"asset_id\":\"197\",\"title\":\"Leberkas tail swine pork\",\"alias\":\"leberkas-tail-swine-pork\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>\\u00a0<\\/p>\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:41:37\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 20:41:31\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/blog\\\\\\/blog01.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"images\\\\\\/blog\\\\\\/blog01.jpg\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"1\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("18","com_content.article.73","","2015-02-02 20:41:44","739","3018","a4b8c473d3b20bf02900c7dc1e0ceb2b34933c53","{\"id\":73,\"asset_id\":\"197\",\"title\":\"Leberkas tail swine pork\",\"alias\":\"leberkas-tail-swine-pork\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:41:44\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 20:41:39\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/blog\\\\\\/blog01.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"images\\\\\\/blog\\\\\\/blog01.jpg\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"1\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("19","com_content.article.72","","2015-02-02 20:41:51","739","2997","d7d89e0f2bdb0473656ea2c99972bce38c9f5863","{\"id\":72,\"asset_id\":\"196\",\"title\":\"Jerky shank chicken boudin\",\"alias\":\"jerky-shank-chicken-boudin\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:41:51\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 20:41:46\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"video\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"http:\\\\\\/\\\\\\/vimeo.com\\\\\\/43426940\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("20","com_content.article.74","","2015-02-02 20:45:07","739","2998","93efe9629942027e6326ea1e2a9b0de9e6839399","{\"id\":74,\"asset_id\":198,\"title\":\"Meatball kevin beef ribs shoulder\",\"alias\":\"meatball-kevin-beef-ribs-shoulder\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":0,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:41:44\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/blog\\\\\\/blog01.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"images\\\\\\/blog\\\\\\/blog01.jpg\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("21","com_content.article.74","","2015-02-02 20:45:19","739","3035","7423ef48e031b34fa2aeadc7ce2c862b53df4f2c","{\"id\":74,\"asset_id\":\"198\",\"title\":\"Meatball kevin beef ribs shoulder\",\"alias\":\"meatball-kevin-beef-ribs-shoulder\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:45:19\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 20:45:11\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/blog\\\\\\/blog01.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"images\\\\\\/blog\\\\\\/blog01.jpg\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"gallery\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("22","com_content.article.74","","2015-02-02 20:53:42","739","3116","15f8fb6bb8f068b4c2ea6609839940990835bb91","{\"id\":74,\"asset_id\":\"198\",\"title\":\"Meatball kevin beef ribs shoulder\",\"alias\":\"meatball-kevin-beef-ribs-shoulder\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:53:42\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 20:53:38\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"gallery\\\",\\\"gallery\\\":\\\"{\\\\\\\"gallery_images\\\\\\\":[\\\\\\\"images\\\\\\/blog\\\\\\/blog06.jpg\\\\\\\",\\\\\\\"images\\\\\\/blog\\\\\\/blog05.jpg\\\\\\\",\\\\\\\"images\\\\\\/blog\\\\\\/blog04.jpg\\\\\\\"]}\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("23","com_content.article.75","","2015-02-02 20:53:52","739","2986","b733c0264029616c869839b0d11fa141f0a586ea","{\"id\":75,\"asset_id\":199,\"title\":\"Leberkas tail swine pork (2)\",\"alias\":\"leberkas-tail-swine-pork-2\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":0,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:41:44\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/blog\\\\\\/blog01.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"images\\\\\\/blog\\\\\\/blog01.jpg\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("24","com_content.article.75","","2015-02-02 20:55:25","739","3290","5f3e633cad869e47c3feccb1cd2bec12a5e38550","{\"id\":75,\"asset_id\":\"199\",\"title\":\"Leberkas tail swine pork (2)\",\"alias\":\"leberkas-tail-swine-pork-2\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":0,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:55:25\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 20:53:52\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"audio\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"<iframe width=\\\\\\\"100%\\\\\\\" height=\\\\\\\"450\\\\\\\" scrolling=\\\\\\\"no\\\\\\\" frameborder=\\\\\\\"no\\\\\\\" src=\\\\\\\"https:\\\\\\/\\\\\\/w.soundcloud.com\\\\\\/player\\\\\\/?url=https%3A\\\\\\/\\\\\\/api.soundcloud.com\\\\\\/tracks\\\\\\/28830162&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true\\\\\\\"><\\\\\\/iframe>\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("25","com_content.article.75","","2015-02-02 20:55:33","739","3309","4042e0f7cdaab4924473214ec8cb1e224fca233e","{\"id\":75,\"asset_id\":\"199\",\"title\":\"Leberkas tail swine pork (2)\",\"alias\":\"leberkas-tail-swine-pork-2\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:55:33\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 20:55:25\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"audio\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"<iframe width=\\\\\\\"100%\\\\\\\" height=\\\\\\\"450\\\\\\\" scrolling=\\\\\\\"no\\\\\\\" frameborder=\\\\\\\"no\\\\\\\" src=\\\\\\\"https:\\\\\\/\\\\\\/w.soundcloud.com\\\\\\/player\\\\\\/?url=https%3A\\\\\\/\\\\\\/api.soundcloud.com\\\\\\/tracks\\\\\\/28830162&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true\\\\\\\"><\\\\\\/iframe>\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("26","com_content.article.75","","2015-02-02 20:58:11","739","3325","214eb92eda7e3fd1aa2e9358f79cd9f35c145ed1","{\"id\":75,\"asset_id\":\"199\",\"title\":\"5 Effective Email Unsubscribe Pages\",\"alias\":\"5-effective-email-unsubscribe-pages\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:58:11\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 20:55:33\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"audio\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"<iframe width=\\\\\\\"100%\\\\\\\" height=\\\\\\\"450\\\\\\\" scrolling=\\\\\\\"no\\\\\\\" frameborder=\\\\\\\"no\\\\\\\" src=\\\\\\\"https:\\\\\\/\\\\\\/w.soundcloud.com\\\\\\/player\\\\\\/?url=https%3A\\\\\\/\\\\\\/api.soundcloud.com\\\\\\/tracks\\\\\\/28830162&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true\\\\\\\"><\\\\\\/iframe>\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("27","com_content.article.76","","2015-02-02 20:59:21","739","3284","4ae92dd3439354d44eaa990f051fe33a25a09410","{\"id\":76,\"asset_id\":200,\"title\":\"Who Actually Clicks on Banner Ads?\",\"alias\":\"who-actually-clicks-on-banner-ads\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":0,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:58:11\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"audio\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"<iframe width=\\\\\\\"100%\\\\\\\" height=\\\\\\\"450\\\\\\\" scrolling=\\\\\\\"no\\\\\\\" frameborder=\\\\\\\"no\\\\\\\" src=\\\\\\\"https:\\\\\\/\\\\\\/w.soundcloud.com\\\\\\/player\\\\\\/?url=https%3A\\\\\\/\\\\\\/api.soundcloud.com\\\\\\/tracks\\\\\\/28830162&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true\\\\\\\"><\\\\\\/iframe>\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("28","com_content.article.76","","2015-02-02 20:59:51","739","3036","831346c8e036f9c50948e91fda6382464b93510f","{\"id\":76,\"asset_id\":\"200\",\"title\":\"Who Actually Clicks on Banner Ads?\",\"alias\":\"who-actually-clicks-on-banner-ads\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":0,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:59:51\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 20:59:21\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"link\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"=\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"Responive Joomla Templates\\\",\\\"link_url\\\":\\\"http:\\\\\\/\\\\\\/www.joomshaper.com\\\\\\/joomla-templates\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("29","com_content.article.76","","2015-02-02 21:00:29","739","3054","2b7e156f98ef23e5293b94c2c792d29e5c8e355f","{\"id\":76,\"asset_id\":\"200\",\"title\":\"Who Actually Clicks on Banner Ads?\",\"alias\":\"who-actually-clicks-on-banner-ads\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 21:00:29\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 20:59:51\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"link\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"Responive Joomla Templates\\\",\\\"link_url\\\":\\\"http:\\\\\\/\\\\\\/www.joomshaper.com\\\\\\/joomla-templates\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("30","com_content.article.76","","2015-02-02 21:03:52","739","3267","2cc28fa75fa79e432bd08cb348d8397b4b2bad98","{\"id\":76,\"asset_id\":\"200\",\"title\":\"See the new Miss Universe get her crown\",\"alias\":\"see-the-new-miss-universe-get-her-crown\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 21:03:52\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 21:02:26\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"quote\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"Pork meatball ground round prosciutto. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Filet mignon bresaola pork boudin capicola prosciutto. Frankfurter chicken leberkas drumstick ball tip turducken rump spare ribs meatball.\\\",\\\"quote_author\\\":\\\"- John Doe\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("31","com_content.article.76","","2015-02-02 21:04:39","739","3397","8beda0d66c8c213f9a621f81613a871e1cc86e4f","{\"id\":76,\"asset_id\":\"200\",\"title\":\"See the new Miss Universe get her crown\",\"alias\":\"see-the-new-miss-universe-get-her-crown\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 21:04:39\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 21:04:08\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"quote\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"Pork meatball ground round prosciutto. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Filet mignon bresaola pork boudin capicola prosciutto. Frankfurter chicken leberkas drumstick ball tip turducken rump spare ribs meatball. Tail salami pork loin ham. Drumstick flank porchetta, hamburger ham swine biltong chicken pancetta. Spare ribs prosciutto t-bone.\\\",\\\"quote_author\\\":\\\"- John Doe\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":5,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("32","com_content.article.77","","2015-02-02 21:05:10","739","3022","4bea0e0fd22f934dff631c5d14e91c65cc80c5b5","{\"id\":77,\"asset_id\":201,\"title\":\"Who Actually Clicks on Banner Ads? (2)\",\"alias\":\"who-actually-clicks-on-banner-ads-2\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":0,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 21:05:00\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"link\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"Responive Joomla Templates\\\",\\\"link_url\\\":\\\"http:\\\\\\/\\\\\\/www.joomshaper.com\\\\\\/joomla-templates\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("33","com_content.article.77","","2015-02-02 21:05:57","739","3378","05e3b522a0e0b79dac1156b6a5be2c90e8edc821","{\"id\":77,\"asset_id\":\"201\",\"title\":\"See the new Miss Universe get her crown\",\"alias\":\"see-the-new-miss-universe-get-her-crown\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":0,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 21:05:57\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 21:05:24\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"quote\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"Pork meatball ground round prosciutto. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Filet mignon bresaola pork boudin capicola prosciutto. Frankfurter chicken leberkas drumstick ball tip turducken rump spare ribs meatball. Tail salami pork loin ham. Drumstick flank porchetta, hamburger ham swine biltong chicken pancetta. Spare ribs prosciutto t-bone.\\\",\\\"quote_author\\\":\\\"- John Doe\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("34","com_content.article.73","","2015-11-02 10:12:41","739","3055","b509aaf5641d99d1f403a21d43d0125fac737fce","{\"id\":73,\"asset_id\":\"197\",\"title\":\"Pellentesque Habitant Morbi Tristique\",\"alias\":\"leberkas-tail-swine-pork\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"47\",\"created_by_alias\":\"\",\"modified\":\"2015-11-02 10:12:41\",\"modified_by\":\"47\",\"checked_out\":\"47\",\"checked_out_time\":\"2015-11-02 10:12:17\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/blog\\\\\\/blog01.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"images\\\\\\/blog\\\\\\/blog01.jpg\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"97\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("35","com_content.category.84","","2017-04-20 02:47:43","739","567","3b062044438bf9147bc8c1504b46a91d9b9dacbb","{\"id\":84,\"asset_id\":228,\"parent_id\":\"1\",\"lft\":\"101\",\"rgt\":102,\"level\":1,\"path\":null,\"extension\":\"com_content\",\"title\":\"Trending Post\",\"alias\":\"trending-post\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"507\",\"created_time\":\"2017-04-20 02:47:43\",\"modified_user_id\":null,\"modified_time\":\"2017-04-20 02:47:43\",\"hits\":\"0\",\"language\":\"*\",\"version\":null}","0"),
("36","com_content.category.85","","2017-04-20 02:48:05","739","563","b37af9834982304430e8461e369a1b971df15728","{\"id\":85,\"asset_id\":229,\"parent_id\":\"1\",\"lft\":\"103\",\"rgt\":104,\"level\":1,\"path\":null,\"extension\":\"com_content\",\"title\":\"Life Styles\",\"alias\":\"life-styles\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"507\",\"created_time\":\"2017-04-20 02:48:05\",\"modified_user_id\":null,\"modified_time\":\"2017-04-20 02:48:05\",\"hits\":\"0\",\"language\":\"*\",\"version\":null}","0"),
("37","com_content.category.86","","2017-04-20 02:48:28","739","561","f85b68e2e4d676926001e3ec8e4b2c388ea2ce45","{\"id\":86,\"asset_id\":230,\"parent_id\":\"1\",\"lft\":\"105\",\"rgt\":106,\"level\":1,\"path\":null,\"extension\":\"com_content\",\"title\":\"World News\",\"alias\":\"world-news\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"507\",\"created_time\":\"2017-04-20 02:48:28\",\"modified_user_id\":null,\"modified_time\":\"2017-04-20 02:48:28\",\"hits\":\"0\",\"language\":\"*\",\"version\":null}","0"),
("38","com_content.category.87","","2017-04-20 02:48:45","739","559","6dd670168a791d9fe61fcec784aa34b9281c916d","{\"id\":87,\"asset_id\":231,\"parent_id\":\"1\",\"lft\":\"107\",\"rgt\":108,\"level\":1,\"path\":null,\"extension\":\"com_content\",\"title\":\"Watch Now\",\"alias\":\"watch-now\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"507\",\"created_time\":\"2017-04-20 02:48:45\",\"modified_user_id\":null,\"modified_time\":\"2017-04-20 02:48:45\",\"hits\":\"0\",\"language\":\"*\",\"version\":null}","0"),
("39","com_content.category.88","","2017-04-20 02:49:20","739","567","8fef0a9d9cb49ead0272974404f80d3b8626b8b7","{\"id\":88,\"asset_id\":232,\"parent_id\":\"1\",\"lft\":\"109\",\"rgt\":110,\"level\":1,\"path\":null,\"extension\":\"com_content\",\"title\":\"Food & Recipes\",\"alias\":\"food-recipes\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"507\",\"created_time\":\"2017-04-20 02:49:20\",\"modified_user_id\":null,\"modified_time\":\"2017-04-20 02:49:20\",\"hits\":\"0\",\"language\":\"*\",\"version\":null}","0"),
("40","com_content.category.89","","2017-04-20 02:50:37","739","567","29782bcb709ad73d92ddbf362a51e033ec79c88f","{\"id\":89,\"asset_id\":233,\"parent_id\":\"1\",\"lft\":\"111\",\"rgt\":112,\"level\":1,\"path\":null,\"extension\":\"com_content\",\"title\":\"Entertainment\",\"alias\":\"entertainment\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"507\",\"created_time\":\"2017-04-20 02:50:37\",\"modified_user_id\":null,\"modified_time\":\"2017-04-20 02:50:37\",\"hits\":\"0\",\"language\":\"*\",\"version\":null}","0"),
("41","com_content.article.78","","2017-04-20 03:03:58","739","2149","6c2dcbbd3ebbdf99137f6316c3f473723f1bff48","{\"id\":78,\"asset_id\":234,\"title\":\"Spectacular New Bridges That Break The Mold\",\"alias\":\"spectacular-new-bridges-that-break-the-mold\",\"introtext\":\"<p>In a world of bamboo skyscrapers and transforming apartments, it\'s easy to forget about the bridge, the humble structure that makes getting from point A to B all the more simple.<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"84\",\"created\":\"2017-04-20 03:03:58\",\"created_by\":\"507\",\"created_by_alias\":\"\",\"modified\":\"2017-04-20 03:03:58\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2017-04-20 03:03:58\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("42","com_tags.tag.2","","2017-04-20 03:04:39","739","856","dfe813bae6da70f9860cdc02143ee70e2f8387a8","{\"id\":2,\"parent_id\":\"1\",\"lft\":\"1\",\"rgt\":2,\"level\":1,\"path\":null,\"title\":\"Architects\",\"alias\":\"architects\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":\"2017-04-20 03:04:39\",\"access\":\"1\",\"params\":\"{\\\"tag_layout\\\":\\\"\\\",\\\"tag_link_class\\\":\\\"label label-info\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"507\",\"created_time\":\"2017-04-20 03:04:39\",\"created_by_alias\":\"\",\"modified_user_id\":null,\"modified_time\":\"2017-04-20 03:04:39\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":null,\"publish_up\":\"2017-04-20 03:04:39\",\"publish_down\":\"2017-04-20 03:04:39\"}","0"),
("43","com_tags.tag.3","","2017-04-20 03:04:51","739","848","64df3884ddc89d6332d6298d8ea2d2cb05eb0384","{\"id\":3,\"parent_id\":\"1\",\"lft\":\"3\",\"rgt\":4,\"level\":1,\"path\":null,\"title\":\"Health\",\"alias\":\"health\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":\"2017-04-20 03:04:51\",\"access\":\"1\",\"params\":\"{\\\"tag_layout\\\":\\\"\\\",\\\"tag_link_class\\\":\\\"label label-info\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"507\",\"created_time\":\"2017-04-20 03:04:51\",\"created_by_alias\":\"\",\"modified_user_id\":null,\"modified_time\":\"2017-04-20 03:04:51\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":null,\"publish_up\":\"2017-04-20 03:04:51\",\"publish_down\":\"2017-04-20 03:04:51\"}","0"),
("44","com_tags.tag.4","","2017-04-20 03:05:06","739","856","6ab87cbddf3ce2f4ea10d22d7bb0f6ca92ccf209","{\"id\":4,\"parent_id\":\"1\",\"lft\":\"5\",\"rgt\":6,\"level\":1,\"path\":null,\"title\":\"Life Style\",\"alias\":\"life-style\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":\"2017-04-20 03:05:06\",\"access\":\"1\",\"params\":\"{\\\"tag_layout\\\":\\\"\\\",\\\"tag_link_class\\\":\\\"label label-info\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"507\",\"created_time\":\"2017-04-20 03:05:06\",\"created_by_alias\":\"\",\"modified_user_id\":null,\"modified_time\":\"2017-04-20 03:05:06\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":null,\"publish_up\":\"2017-04-20 03:05:06\",\"publish_down\":\"2017-04-20 03:05:06\"}","0"),
("45","com_tags.tag.5","","2017-04-20 03:05:19","739","846","40b3e1dede9cd056e87ad6a6a4b3e021e16087e2","{\"id\":5,\"parent_id\":\"1\",\"lft\":\"7\",\"rgt\":8,\"level\":1,\"path\":null,\"title\":\"World\",\"alias\":\"world\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":\"2017-04-20 03:05:19\",\"access\":\"1\",\"params\":\"{\\\"tag_layout\\\":\\\"\\\",\\\"tag_link_class\\\":\\\"label label-info\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"507\",\"created_time\":\"2017-04-20 03:05:19\",\"created_by_alias\":\"\",\"modified_user_id\":null,\"modified_time\":\"2017-04-20 03:05:19\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":null,\"publish_up\":\"2017-04-20 03:05:19\",\"publish_down\":\"2017-04-20 03:05:19\"}","0"),
("46","com_tags.tag.6","","2017-04-20 03:05:52","739","863","1bfae6d073b86aae78946f635df09eb779342508","{\"id\":6,\"parent_id\":\"1\",\"lft\":\"9\",\"rgt\":10,\"level\":1,\"path\":null,\"title\":\"Entertainment\",\"alias\":\"entertainment\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":\"2017-04-20 03:05:52\",\"access\":\"1\",\"params\":\"{\\\"tag_layout\\\":\\\"\\\",\\\"tag_link_class\\\":\\\"label label-info\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"507\",\"created_time\":\"2017-04-20 03:05:52\",\"created_by_alias\":\"\",\"modified_user_id\":null,\"modified_time\":\"2017-04-20 03:05:52\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":null,\"publish_up\":\"2017-04-20 03:05:52\",\"publish_down\":\"2017-04-20 03:05:52\"}","0"),
("47","com_contact.category.90","","2017-05-15 17:12:29","739","565","8f6f56200eec45996ada0f81d0385ed5b102823b","{\"id\":90,\"asset_id\":266,\"parent_id\":\"1\",\"lft\":\"113\",\"rgt\":114,\"level\":1,\"path\":null,\"extension\":\"com_contact\",\"title\":\"Contact Form\",\"alias\":\"contact-form\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"507\",\"created_time\":\"2017-05-15 17:12:29\",\"modified_user_id\":null,\"modified_time\":\"2017-05-15 17:12:29\",\"hits\":\"0\",\"language\":\"*\",\"version\":null}","0"),
("48","com_contact.contact.6","","2017-05-15 17:13:33","739","2415","3f8903b1628a0e721bd00f75380514e4bdbdca0b","{\"id\":6,\"name\":\"Apples\",\"alias\":\"apples\",\"con_position\":\"Scientific Name: Malus domestica\",\"address\":\"Image Credit: Fievet\\r\\nRights: Public Domain\\r\\nSource: http:\\/\\/commons.wikimedia.org\\/wiki\\/File:Pommes_vertes.JPG\",\"suburb\":\"\",\"state\":\"Family: Rosaceae\",\"country\":\"Large: Producers: China, United States\",\"postcode\":\"\",\"telephone\":\"\",\"fax\":\"\",\"misc\":\"<p>Apples are a versatile fruit, used for eating, cooking, and preserving.<\\/p>\\r\\n<p>There are more that 7500 different kinds of apples grown around the world.<\\/p>\",\"image\":\"images\\/sampledata\\/fruitshop\\/apple.jpg\",\"email_to\":\"\",\"default_con\":0,\"published\":\"1\",\"checked_out\":\"507\",\"checked_out_time\":\"2017-05-15 17:13:24\",\"ordering\":\"1\",\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"plain\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"1\\\",\\\"linka_name\\\":\\\"Wikipedia: Apples English\\\",\\\"linka\\\":\\\"http:\\\\\\/\\\\\\/en.wikipedia.org\\\\\\/wiki\\\\\\/Apple\\\",\\\"linkb_name\\\":\\\"Wikipedia: Manzana Espa\\\\u00f1ol \\\",\\\"linkb\\\":\\\"http:\\\\\\/\\\\\\/es.wikipedia.org\\\\\\/wiki\\\\\\/Manzana\\\",\\\"linkc_name\\\":\\\"Wikipedia: \\\\u82f9\\\\u679c \\\\u4e2d\\\\u6587\\\",\\\"linkc\\\":\\\"http:\\\\\\/\\\\\\/zh.wikipedia.org\\\\\\/zh\\\\\\/\\\\u82f9\\\\u679c\\\",\\\"linkd_name\\\":\\\"Wikipedia: Tofaa Kiswahili\\\",\\\"linkd\\\":\\\"http:\\\\\\/\\\\\\/sw.wikipedia.org\\\\\\/wiki\\\\\\/Tofaa\\\",\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":0,\"catid\":\"38\",\"access\":\"1\",\"mobile\":\"\",\"webpage\":false,\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2011-01-01 00:00:01\",\"created_by\":\"507\",\"created_by_alias\":\"Joomla\",\"modified\":\"2017-05-15 17:13:33\",\"modified_by\":\"507\",\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":2,\"hits\":\"1\"}","0"),
("49","com_contact.contact.9","","2017-05-15 17:16:36","739","1836","7857c52aaa8fa7d37a0d37f486fb4d16f9b64441","{\"id\":9,\"name\":\"Contact Form\",\"alias\":\"contact-form\",\"con_position\":\"\",\"address\":\"Room 302, No 18 Lane 11, Thai Ha Street, Trung Liet, Dong Da, Hanoi, Vietnam \",\"suburb\":\"\",\"state\":\"\",\"country\":\"\",\"postcode\":\"\",\"telephone\":\"+84 (04) 3514 9260\",\"fax\":\"\",\"misc\":\"\",\"image\":\"\",\"email_to\":\"contact@ytcvn.com\",\"default_con\":0,\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"ordering\":3,\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"507\",\"catid\":\"90\",\"access\":\"1\",\"mobile\":\"+84 (04) 3514 9260\",\"webpage\":\"https:\\/\\/www.smartaddons.com\\/\",\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2017-05-15 17:16:36\",\"created_by\":\"507\",\"created_by_alias\":\"\",\"modified\":\"2017-05-15 17:16:36\",\"modified_by\":null,\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":1,\"hits\":null}","0"),
("50","com_contact.contact.9","","2017-05-16 01:54:06","739","1914","e37c08e5727849aa2e8c20e1a7bc09b172e20f20","{\"id\":9,\"name\":\"Contact Form\",\"alias\":\"contact-form\",\"con_position\":\"\",\"address\":\"Room 302, No 18 Lane 11, Thai Ha Street, Trung Liet, Dong Da, Hanoi, Vietnam \",\"suburb\":\"\",\"state\":\"\",\"country\":\"\",\"postcode\":\"\",\"telephone\":\"+84 (04) 3514 9260\",\"fax\":\"\",\"misc\":\"\",\"image\":\"images\\/corporate1.jpg\",\"email_to\":\"contact@ytcvn.com\",\"default_con\":0,\"published\":\"1\",\"checked_out\":\"507\",\"checked_out_time\":\"2017-05-16 01:51:51\",\"ordering\":\"3\",\"params\":\"{\\\"show_contact_category\\\":\\\"hide\\\",\\\"show_contact_list\\\":\\\"0\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"0\\\",\\\"show_info\\\":\\\"0\\\",\\\"show_name\\\":\\\"0\\\",\\\"show_position\\\":\\\"0\\\",\\\"show_email\\\":\\\"0\\\",\\\"show_street_address\\\":\\\"0\\\",\\\"show_suburb\\\":\\\"0\\\",\\\"show_state\\\":\\\"0\\\",\\\"show_postcode\\\":\\\"0\\\",\\\"show_country\\\":\\\"0\\\",\\\"show_telephone\\\":\\\"0\\\",\\\"show_mobile\\\":\\\"0\\\",\\\"show_fax\\\":\\\"0\\\",\\\"show_webpage\\\":\\\"0\\\",\\\"show_image\\\":\\\"0\\\",\\\"show_misc\\\":\\\"0\\\",\\\"allow_vcard\\\":\\\"0\\\",\\\"show_articles\\\":\\\"0\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"0\\\",\\\"show_links\\\":\\\"0\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"_:default\\\",\\\"show_email_form\\\":\\\"0\\\",\\\"show_email_copy\\\":\\\"0\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"507\",\"catid\":\"90\",\"access\":\"1\",\"mobile\":\"+84 (04) 3514 9260\",\"webpage\":\"https:\\/\\/www.smartaddons.com\\/\",\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2017-05-15 17:16:36\",\"created_by\":\"507\",\"created_by_alias\":\"\",\"modified\":\"2017-05-16 01:54:06\",\"modified_by\":\"507\",\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":2,\"hits\":\"0\"}","0"),
("51","com_contact.contact.9","","2017-05-24 15:50:02","739","1887","aa29870927aef54ffc69d941414550b37aac2f1a","{\"id\":9,\"name\":\"Contact Form\",\"alias\":\"contact-form\",\"con_position\":\"\",\"address\":\"Room 302, No 18 Lane 11, Thai Ha Street, Trung Liet, Dong Da, Hanoi, Vietnam \",\"suburb\":\"\",\"state\":\"\",\"country\":\"\",\"postcode\":\"\",\"telephone\":\"+84 (04) 3514 9260\",\"fax\":\"\",\"misc\":\"\",\"image\":\"images\\/corporate1.jpg\",\"email_to\":\"contact@ytcvn.com\",\"default_con\":0,\"published\":\"1\",\"checked_out\":\"507\",\"checked_out_time\":\"2017-05-24 15:48:51\",\"ordering\":\"3\",\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"_:default\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"507\",\"catid\":\"90\",\"access\":\"1\",\"mobile\":\"+84 (04) 3514 9260\",\"webpage\":\"https:\\/\\/www.smartaddons.com\\/\",\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2017-05-15 17:16:36\",\"created_by\":\"507\",\"created_by_alias\":\"\",\"modified\":\"2017-05-24 15:50:02\",\"modified_by\":\"507\",\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":3,\"hits\":\"0\"}","0"),
("52","com_contact.contact.10","","2017-05-24 16:01:32","739","1847","84da9e39ded3c75f9897a796988dd5f6341175d1","{\"id\":10,\"name\":\"Contact Us\",\"alias\":\"contact-us\",\"con_position\":\"CEO\",\"address\":\"No 11. Thai Ha - Dong Da - Ha Noi\",\"suburb\":\"Ha Noi\",\"state\":\"\",\"country\":\"Viet Nam\",\"postcode\":\"\",\"telephone\":\"+84 (04) 3514 9260\",\"fax\":\"+84 (04) 3514 9260\",\"misc\":\"\",\"image\":\"images\\/testimonial.png\",\"email_to\":\"contact@ytcvn.com\",\"default_con\":0,\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"ordering\":4,\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"507\",\"catid\":\"16\",\"access\":\"1\",\"mobile\":\"+84 (04) 3514 9260\",\"webpage\":\"https:\\/\\/www.smartaddons.com\\/\",\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2017-05-24 16:01:32\",\"created_by\":\"507\",\"created_by_alias\":\"\",\"modified\":\"2017-05-24 16:01:32\",\"modified_by\":null,\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":1,\"hits\":null}","0"),
("53","com_banners.category.91","","2017-05-25 17:06:58","739","569","df27de1a370bea49fbc7b29037a84ace0c29c4f8","{\"id\":91,\"asset_id\":269,\"parent_id\":\"1\",\"lft\":\"115\",\"rgt\":116,\"level\":1,\"path\":null,\"extension\":\"com_banners\",\"title\":\"Banner Sidebar\",\"alias\":\"banner-sidebar\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"507\",\"created_time\":\"2017-05-25 17:06:58\",\"modified_user_id\":null,\"modified_time\":\"2017-05-25 17:06:58\",\"hits\":\"0\",\"language\":\"*\",\"version\":null}","0"),
("54","com_banners.banner.5","","2017-05-25 17:09:02","739","740","053631fe1d80a76350f0e69e15e1c794d0457d1c","{\"id\":5,\"cid\":\"0\",\"type\":\"0\",\"name\":\"Advertise\",\"alias\":\"advertise\",\"imptotal\":0,\"impmade\":\"0\",\"clicks\":\"0\",\"clickurl\":false,\"state\":\"1\",\"catid\":\"10\",\"description\":\"\",\"custombannercode\":\"\",\"sticky\":\"0\",\"ordering\":4,\"metakey\":\"\",\"params\":\"{\\\"imageurl\\\":\\\"images\\\\\\/banners\\\\\\/banner-sidebar.jpg\\\",\\\"width\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"alt\\\":\\\"\\\"}\",\"own_prefix\":\"0\",\"metakey_prefix\":\"\",\"purchase_type\":\"-1\",\"track_clicks\":\"0\",\"track_impressions\":\"0\",\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"reset\":\"2017-06-25 00:00:00\",\"created\":\"2017-05-25 17:09:02\",\"language\":\"*\",\"created_by\":\"507\",\"created_by_alias\":\"\",\"modified\":\"0000-00-00 00:00:00\",\"modified_by\":null,\"version\":1}","0"),
("55","com_banners.banner.5","","2017-05-25 17:09:09","739","761","8f4ea05f2a997bb71233e49821080f093db7dbbe","{\"id\":5,\"cid\":\"0\",\"type\":\"0\",\"name\":\"Advertise\",\"alias\":\"advertise\",\"imptotal\":0,\"impmade\":\"0\",\"clicks\":\"0\",\"clickurl\":false,\"state\":\"1\",\"catid\":\"91\",\"description\":\"\",\"custombannercode\":\"\",\"sticky\":\"0\",\"ordering\":\"4\",\"metakey\":\"\",\"params\":\"{\\\"imageurl\\\":\\\"images\\\\\\/banners\\\\\\/banner-sidebar.jpg\\\",\\\"width\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"alt\\\":\\\"\\\"}\",\"own_prefix\":\"0\",\"metakey_prefix\":\"\",\"purchase_type\":\"-1\",\"track_clicks\":\"0\",\"track_impressions\":\"0\",\"checked_out\":\"507\",\"checked_out_time\":\"2017-05-25 17:09:02\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"reset\":\"2017-06-25 00:00:00\",\"created\":\"2017-05-25 17:09:02\",\"language\":\"*\",\"created_by\":\"507\",\"created_by_alias\":\"\",\"modified\":\"2017-05-25 17:09:09\",\"modified_by\":\"507\",\"version\":2}","0"),
("56","com_content.article.73","","2017-05-28 14:55:10","739","3145","34609e9ebc5fc2f2609afa20e16fe5cd4ebdac6c","{\"id\":73,\"asset_id\":\"197\",\"title\":\"Pellentesque Habitant Morbi Tristique\",\"alias\":\"leberkas-tail-swine-pork\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"507\",\"created_by_alias\":\"\",\"modified\":\"2017-05-28 14:55:10\",\"modified_by\":\"507\",\"checked_out\":\"507\",\"checked_out_time\":\"2017-05-28 14:45:32\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/blog\\\\\\/blog01.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"images\\\\\\/blog\\\\\\/blog01.jpg\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":6,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"152\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("57","com_content.article.77","","2017-05-28 14:57:36","739","3510","6631cfc5a4c69f5f58b3194df3e762ffb282786f","{\"id\":77,\"asset_id\":\"201\",\"title\":\"See the new Miss Universe get her crown\",\"alias\":\"see-the-new-miss-universe-get-her-crown\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"507\",\"created_by_alias\":\"\",\"modified\":\"2017-05-28 14:57:36\",\"modified_by\":\"507\",\"checked_out\":\"507\",\"checked_out_time\":\"2017-05-28 14:57:28\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"quote\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"Pork meatball ground round prosciutto. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Filet mignon bresaola pork boudin capicola prosciutto. Frankfurter chicken leberkas drumstick ball tip turducken rump spare ribs meatball. Tail salami pork loin ham. Drumstick flank porchetta, hamburger ham swine biltong chicken pancetta. Spare ribs prosciutto t-bone.\\\",\\\"quote_author\\\":\\\"- John Doe\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"45\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("58","com_content.article.76","","2017-05-28 14:57:57","739","3167","cf17a3db6a422952477279cf363adb6e95bbe19f","{\"id\":76,\"asset_id\":\"200\",\"title\":\"Who Actually Clicks on Banner Ads?\",\"alias\":\"who-actually-clicks-on-banner-ads\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"507\",\"created_by_alias\":\"\",\"modified\":\"2017-05-28 14:57:57\",\"modified_by\":\"507\",\"checked_out\":\"507\",\"checked_out_time\":\"2017-05-28 14:57:50\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"link\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"Responive Joomla Templates\\\",\\\"link_url\\\":\\\"http:\\\\\\/\\\\\\/www.joomshaper.com\\\\\\/joomla-templates\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"39\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("59","com_content.article.75","","2017-05-28 14:58:19","739","3438","786304f3284bfdc38fbd02887a64b915c6de4088","{\"id\":75,\"asset_id\":\"199\",\"title\":\"5 Effective Email Unsubscribe Pages\",\"alias\":\"5-effective-email-unsubscribe-pages\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"507\",\"created_by_alias\":\"\",\"modified\":\"2017-05-28 14:58:19\",\"modified_by\":\"507\",\"checked_out\":\"507\",\"checked_out_time\":\"2017-05-28 14:58:09\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"audio\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"<iframe width=\\\\\\\"100%\\\\\\\" height=\\\\\\\"450\\\\\\\" scrolling=\\\\\\\"no\\\\\\\" frameborder=\\\\\\\"no\\\\\\\" src=\\\\\\\"https:\\\\\\/\\\\\\/w.soundcloud.com\\\\\\/player\\\\\\/?url=https%3A\\\\\\/\\\\\\/api.soundcloud.com\\\\\\/tracks\\\\\\/28830162&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true\\\\\\\"><\\\\\\/iframe>\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":5,\"ordering\":\"2\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"23\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("60","com_content.article.74","","2017-05-28 14:58:41","739","3229","bfec8e120116509ced9df73b85d242a1a11eb954","{\"id\":74,\"asset_id\":\"198\",\"title\":\"Meatball kevin beef ribs shoulder\",\"alias\":\"meatball-kevin-beef-ribs-shoulder\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"507\",\"created_by_alias\":\"\",\"modified\":\"2017-05-28 14:58:41\",\"modified_by\":\"507\",\"checked_out\":\"507\",\"checked_out_time\":\"2017-05-28 14:58:31\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"gallery\\\",\\\"gallery\\\":\\\"{\\\\\\\"gallery_images\\\\\\\":[\\\\\\\"images\\\\\\/blog\\\\\\/blog06.jpg\\\\\\\",\\\\\\\"images\\\\\\/blog\\\\\\/blog05.jpg\\\\\\\",\\\\\\\"images\\\\\\/blog\\\\\\/blog04.jpg\\\\\\\"]}\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"3\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"48\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("61","com_content.article.72","","2017-05-28 14:59:01","739","3110","8867931e5818e6818d426b742c006a1a3660d971","{\"id\":72,\"asset_id\":\"196\",\"title\":\"Jerky shank chicken boudin\",\"alias\":\"jerky-shank-chicken-boudin\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"507\",\"created_by_alias\":\"\",\"modified\":\"2017-05-28 14:59:01\",\"modified_by\":\"507\",\"checked_out\":\"507\",\"checked_out_time\":\"2017-05-28 14:58:53\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"video\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"http:\\\\\\/\\\\\\/vimeo.com\\\\\\/43426940\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":5,\"ordering\":\"5\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"55\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("62","com_content.article.71","","2017-05-28 14:59:21","739","3587","1faeb8cde92367b307ce914ffe100b6864f36c6e","{\"id\":71,\"asset_id\":\"195\",\"title\":\"Doner spare ribs pastrami shank\",\"alias\":\"doner-spare-ribs-pastrami-shank\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 18:56:08\",\"created_by\":\"507\",\"created_by_alias\":\"\",\"modified\":\"2017-05-28 14:59:21\",\"modified_by\":\"507\",\"checked_out\":\"507\",\"checked_out_time\":\"2017-05-28 14:59:12\",\"publish_up\":\"2015-02-02 18:56:08\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"status\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"<blockquote class=\\\\\\\"twitter-tweet\\\\\\\" lang=\\\\\\\"en\\\\\\\"><p>Published a new blog entry One Month Extra for all JoomShaper Members in News. <a href=\\\\\\\"http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8\\\\\\\">http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8<\\\\\\/a><\\\\\\/p>&mdash; JoomShaper (@joomshaper) <a href=\\\\\\\"https:\\\\\\/\\\\\\/twitter.com\\\\\\/joomshaper\\\\\\/status\\\\\\/562210375480139777\\\\\\\">February 2, 2015<\\\\\\/a><\\\\\\/blockquote>\\\\r\\\\n<script async src=\\\\\\\"\\\\\\/\\\\\\/platform.twitter.com\\\\\\/widgets.js\\\\\\\" charset=\\\\\\\"utf-8\\\\\\\"><\\\\\\/script>\\\"}\",\"version\":5,\"ordering\":\"6\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"21\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("63","com_banners.category.92","","2017-05-28 15:46:29","739","573","9d766523a95fede0d9a01bd3681447276fececb7","{\"id\":92,\"asset_id\":277,\"parent_id\":\"1\",\"lft\":\"117\",\"rgt\":118,\"level\":1,\"path\":null,\"extension\":\"com_banners\",\"title\":\"Banner Mainboard\",\"alias\":\"banner-mainboard\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"507\",\"created_time\":\"2017-05-28 15:46:29\",\"modified_user_id\":null,\"modified_time\":\"2017-05-28 15:46:29\",\"hits\":\"0\",\"language\":\"*\",\"version\":null}","0"),
("64","com_banners.banner.6","","2017-05-28 15:48:02","739","737","2100eaa7601e96b0dbe80da040fc7d3761e2a48d","{\"id\":6,\"cid\":\"0\",\"type\":\"0\",\"name\":\"Advertise 1\",\"alias\":\"advertise-1\",\"imptotal\":0,\"impmade\":\"0\",\"clicks\":\"0\",\"clickurl\":false,\"state\":\"1\",\"catid\":\"92\",\"description\":\"\",\"custombannercode\":\"\",\"sticky\":\"0\",\"ordering\":5,\"metakey\":\"\",\"params\":\"{\\\"imageurl\\\":\\\"images\\\\\\/banners\\\\\\/banner1.jpg\\\",\\\"width\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"alt\\\":\\\"\\\"}\",\"own_prefix\":\"0\",\"metakey_prefix\":\"\",\"purchase_type\":\"-1\",\"track_clicks\":\"0\",\"track_impressions\":\"0\",\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"reset\":\"2017-06-28 00:00:00\",\"created\":\"2017-05-28 15:48:02\",\"language\":\"*\",\"created_by\":\"507\",\"created_by_alias\":\"\",\"modified\":\"0000-00-00 00:00:00\",\"modified_by\":null,\"version\":1}","0"),
("65","com_banners.banner.7","","2017-05-28 15:48:28","739","737","3fc8c50769f2b7d22e08fe9303140e3c5e2fa57d","{\"id\":7,\"cid\":\"0\",\"type\":\"0\",\"name\":\"Advertise 2\",\"alias\":\"advertise-2\",\"imptotal\":0,\"impmade\":\"0\",\"clicks\":\"0\",\"clickurl\":false,\"state\":\"1\",\"catid\":\"92\",\"description\":\"\",\"custombannercode\":\"\",\"sticky\":\"0\",\"ordering\":6,\"metakey\":\"\",\"params\":\"{\\\"imageurl\\\":\\\"images\\\\\\/banners\\\\\\/banner2.jpg\\\",\\\"width\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"alt\\\":\\\"\\\"}\",\"own_prefix\":\"0\",\"metakey_prefix\":\"\",\"purchase_type\":\"-1\",\"track_clicks\":\"0\",\"track_impressions\":\"0\",\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"reset\":\"2017-06-28 00:00:00\",\"created\":\"2017-05-28 15:48:28\",\"language\":\"*\",\"created_by\":\"507\",\"created_by_alias\":\"\",\"modified\":\"0000-00-00 00:00:00\",\"modified_by\":null,\"version\":1}","0"),
("66","com_content.article.8","","2017-09-06 10:10:08","739","3841","cdd905defcbaa57315965a52e614dfe58cd5d573","{\"id\":8,\"asset_id\":\"104\",\"title\":\"Beginners\",\"alias\":\"beginners\",\"introtext\":\"<p>If this is your first Joomla! site or your first web site, you have come to the right place. Joomla will help you get your website up and running quickly and easily.<\\/p>\\r\\n<p>Start off using your site by logging in using the administrator account you created when you installed Joomla.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Explore the articles and other resources right here on your site data to learn more about how Joomla works. (When you\'re done reading, you can delete or archive all of this.) You will also probably want to visit the Beginners\' Areas of the <a href=\\\"http:\\/\\/docs.joomla.org\\/Beginners\\\">Joomla documentation<\\/a> and <a href=\\\"http:\\/\\/forum.joomla.org\\\">support forums<\\/a>.<\\/p>\\r\\n<p>You\'ll also want to sign up for the Joomla Security Mailing list and the Announcements mailing list. For inspiration visit the <a href=\\\"http:\\/\\/community.joomla.org\\/showcase\\/\\\">Joomla! Site Showcase<\\/a> to see an amazing array of ways people use Joomla to tell their stories on the web.<\\/p>\\r\\n<p>The basic Joomla installation will let you get a great site up and running, but when you are ready for more features the power of Joomla is in the creative ways that developers have extended it to do all kinds of things. Visit the <a href=\\\"http:\\/\\/extensions.joomla.org\\/\\\">Joomla! Extensions Directory<\\/a> to see thousands of extensions that can do almost anything you could want on a website. Can\'t find what you need? You may want to find a Joomla professional in the <a href=\\\"http:\\/\\/resources.joomla.org\\/\\\">Joomla! Resource Directory<\\/a>.<\\/p>\\r\\n<p>Want to learn more? Consider attending a <a href=\\\"http:\\/\\/community.joomla.org\\/events.html\\\">Joomla! Day<\\/a> or other event or joining a local <a href=\\\"http:\\/\\/community.joomla.org\\/user-groups.html\\\">Joomla! Users Group<\\/a>. Can\'t find one near you? Start one yourself.<\\/p>\",\"state\":1,\"catid\":\"19\",\"created\":\"2011-01-01 00:00:01\",\"created_by\":\"266\",\"created_by_alias\":\"Joomla\",\"modified\":\"2017-09-06 10:10:08\",\"modified_by\":\"266\",\"checked_out\":\"266\",\"checked_out_time\":\"2017-09-06 10:09:53\",\"publish_up\":\"2011-01-01 00:00:01\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/featured-bg2.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"3\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"1\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("67","com_content.article.8","","2017-09-07 07:42:58","739","3843","1175b60810ce6d24be9016877a99b12b8141a4ad","{\"id\":8,\"asset_id\":\"104\",\"title\":\"Beginners\",\"alias\":\"beginners\",\"introtext\":\"<p>If this is your first Joomla! site or your first web site, you have come to the right place. Joomla will help you get your website up and running quickly and easily.<\\/p>\\r\\n<p>Start off using your site by logging in using the administrator account you created when you installed Joomla.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Explore the articles and other resources right here on your site data to learn more about how Joomla works. (When you\'re done reading, you can delete or archive all of this.) You will also probably want to visit the Beginners\' Areas of the <a href=\\\"http:\\/\\/docs.joomla.org\\/Beginners\\\">Joomla documentation<\\/a> and <a href=\\\"http:\\/\\/forum.joomla.org\\\">support forums<\\/a>.<\\/p>\\r\\n<p>You\'ll also want to sign up for the Joomla Security Mailing list and the Announcements mailing list. For inspiration visit the <a href=\\\"http:\\/\\/community.joomla.org\\/showcase\\/\\\">Joomla! Site Showcase<\\/a> to see an amazing array of ways people use Joomla to tell their stories on the web.<\\/p>\\r\\n<p>The basic Joomla installation will let you get a great site up and running, but when you are ready for more features the power of Joomla is in the creative ways that developers have extended it to do all kinds of things. Visit the <a href=\\\"http:\\/\\/extensions.joomla.org\\/\\\">Joomla! Extensions Directory<\\/a> to see thousands of extensions that can do almost anything you could want on a website. Can\'t find what you need? You may want to find a Joomla professional in the <a href=\\\"http:\\/\\/resources.joomla.org\\/\\\">Joomla! Resource Directory<\\/a>.<\\/p>\\r\\n<p>Want to learn more? Consider attending a <a href=\\\"http:\\/\\/community.joomla.org\\/events.html\\\">Joomla! Day<\\/a> or other event or joining a local <a href=\\\"http:\\/\\/community.joomla.org\\/user-groups.html\\\">Joomla! Users Group<\\/a>. Can\'t find one near you? Start one yourself.<\\/p>\",\"state\":1,\"catid\":\"19\",\"created\":\"2011-01-01 00:00:01\",\"created_by\":\"266\",\"created_by_alias\":\"Joomla\",\"modified\":\"2017-09-07 07:42:58\",\"modified_by\":\"266\",\"checked_out\":\"266\",\"checked_out_time\":\"2017-09-07 07:42:37\",\"publish_up\":\"2011-01-01 00:00:01\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/articles\\\\\\/a1.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"3\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"1\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("68","com_content.article.21","","2017-09-07 07:43:47","739","2591","f4ae7591eb2599debc1f01151b1b5871b04d34e3","{\"id\":21,\"asset_id\":\"119\",\"title\":\"Getting Help\",\"alias\":\"getting-help\",\"introtext\":\"<p>\\u00a0There are lots of places you can get help with Joomla!. In many places in your site administrator you will see the help icon. Click on this for more information about the options and functions of items on your screen. Other places to get help are:<\\/p>\\r\\n<ul>\\r\\n<li><a href=\\\"http:\\/\\/forum.joomla.org\\\">Support Forums<\\/a><\\/li>\\r\\n<li><a href=\\\"http:\\/\\/docs.joomla.org\\\">Documentation<\\/a><\\/li>\\r\\n<li><a href=\\\"http:\\/\\/resources.joomla.org\\\">Professionals<\\/a><\\/li>\\r\\n<li><a href=\\\"http:\\/\\/shop.joomla.org\\/amazoncom-bookstores.html\\\">Books<\\/a><\\/li>\\r\\n<\\/ul>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"19\",\"created\":\"2011-01-01 00:00:01\",\"created_by\":\"266\",\"created_by_alias\":\"Joomla\",\"modified\":\"2017-09-07 07:43:47\",\"modified_by\":\"266\",\"checked_out\":\"266\",\"checked_out_time\":\"2017-09-07 07:43:32\",\"publish_up\":\"2011-01-01 00:00:01\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/articles\\\\\\/a2.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"0\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"8\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"5\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("69","com_content.article.24","","2017-09-07 07:44:22","739","2525","2ac40db2469e73c04ba88bff0f2a2257d9a08085","{\"id\":24,\"asset_id\":\"122\",\"title\":\"Joomla!\",\"alias\":\"joomla\",\"introtext\":\"<p>Congratulations! You have a Joomla site! Joomla makes it easy to build a website just the way you want it and keep it simple to update and maintain.<\\/p>\\r\\n<p>Joomla is a flexible and powerful platform, whether you are building a small site for yourself or a huge site with hundreds of thousands of visitors. Joomla is open source, which means you can make it work just the way you want it to.<\\/p>\\r\\n<p>The content in this installation of Joomla has been designed to give you an in depth tour of Joomla\'s features.<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"19\",\"created\":\"2011-01-01 00:00:01\",\"created_by\":\"266\",\"created_by_alias\":\"Joomla\",\"modified\":\"2017-09-07 07:44:22\",\"modified_by\":\"266\",\"checked_out\":\"266\",\"checked_out_time\":\"2017-09-07 07:44:07\",\"publish_up\":\"2011-01-01 00:00:01\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/articles\\\\\\/a3.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"0\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"2\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"10\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"1\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("70","com_content.article.22","","2017-09-07 07:44:58","739","4339","32cdc17994ecb07ebfba270068be4df133a525b7","{\"id\":22,\"asset_id\":\"120\",\"title\":\"Getting Started\",\"alias\":\"getting-started\",\"introtext\":\"<p>It\'s easy to get started creating your website. Knowing some of the basics will help.<\\/p>\\r\\n<h3>What is a Content Management System?<\\/h3>\\r\\n<p>A content management system is software that allows you to create and manage webpages easily by separating the creation of your content from the mechanics required to present it on the web.<\\/p>\\r\\n<p>In this site, the content is stored in a <em>database<\\/em>. The look and feel are created by a <em>template<\\/em>. The Joomla! software brings together the template and the content to create web pages.<\\/p>\\r\\n<h3>Site and Administrator<\\/h3>\\r\\n<p>Your site actually has two separate sites. The site (also called the front end) is what visitors to your site will see. The administrator (also called the back end) is only used by people managing your site. You can access the administrator by clicking the \\\"Site Administrator\\\" link on the \\\"This Site\\\" menu or by adding \\/administrator to the end of you domain name.<\\/p>\\r\\n<p>Log in to the administrator using the username and password created during the installation of Joomla.<\\/p>\\r\\n<h3>Logging in<\\/h3>\\r\\n<p>To login to the front end of your site use the login form or the login menu link on the \\\"This Site\\\" menu. Use the user name and password that were created as part of the installation process. Once logged-in you will be able to create and edit articles.<\\/p>\\r\\n<p>In managing your site, you will be able to create content that only logged-in users are able to see.<\\/p>\\r\\n<h3>Creating an article<\\/h3>\\r\\n<p>Once you are logged-in, a new menu will be visible. To create a new article, click on the \\\"submit article\\\" link on that menu.<\\/p>\\r\\n<p>The new article interface gives you a lot of options, but all you need to do is add a title and put something in the content area. To make it easy to find, set the state to published and put it in the Joomla category.<\\/p>\\r\\n<div>You can edit an existing article by clicking on the edit icon (this only displays to users who have the right to edit).<\\/div>\\r\\n<h3>Learn more<\\/h3>\\r\\n<p>There is much more to learn about how to use Joomla! to create the web site you envision. You can learn much more at the <a href=\\\"http:\\/\\/docs.joomla.org\\\">Joomla! documentation site<\\/a> and on the<a href=\\\"http:\\/\\/forum.joomla.org\\\"> Joomla! forums<\\/a>.<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"19\",\"created\":\"2011-01-01 00:00:01\",\"created_by\":\"266\",\"created_by_alias\":\"Joomla\",\"modified\":\"2017-09-07 07:44:58\",\"modified_by\":\"266\",\"checked_out\":\"266\",\"checked_out_time\":\"2017-09-07 07:44:43\",\"publish_up\":\"2011-01-01 00:00:01\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/articles\\\\\\/a4.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"9\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"68\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("71","com_content.article.32","","2017-09-07 07:45:48","739","2762","fed3290a5e9cde0870679d3775b7e04b08b98a40","{\"id\":32,\"asset_id\":\"130\",\"title\":\"Options\",\"alias\":\"options\",\"introtext\":\"<p>As you make your Joomla! site you will control the details of the display using <em>options<\\/em> also referred to as <em>parameter<\\/em><strong>s<\\/strong>. Options control everything from whether the author\'s name is displayed to who can view what to the number of items shown on a list.<\\/p>\\r\\n<p>Default options for each component are changed using the Options button on the component toolbar.<\\/p>\\r\\n<p>Options can also be set on an individual item, such as an article or contact and in menu links.<\\/p>\\r\\n<p>If you are happy with how your site looks, it is fine to leave all of the options set to the defaults that were created when your site was installed. As you become more experienced with Joomla you will use options more.<\\/p>\\r\\n<p>\\u00a0<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"19\",\"created\":\"2011-01-01 00:00:01\",\"created_by\":\"266\",\"created_by_alias\":\"Joomla\",\"modified\":\"2017-09-07 07:45:48\",\"modified_by\":\"266\",\"checked_out\":\"266\",\"checked_out_time\":\"2017-09-07 07:45:26\",\"publish_up\":\"2011-01-01 00:00:01\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/articles\\\\\\/a5.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"10\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"8\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("72","com_content.article.35","","2017-09-07 07:46:23","739","2842","7c8905f7d7c53cd3bbedcdb4d2a1ad5a347d74aa","{\"id\":35,\"asset_id\":\"133\",\"title\":\"Professionals\",\"alias\":\"professionals\",\"introtext\":\"<p>Joomla! 3 continues development of the Joomla Platform and CMS as a powerful and flexible way to bring your vision of the web to reality. With the new administrator interface and adoption of Twitter Bootstrap, the ability to control its look and the management of extensions is now complete.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Working with multiple template styles and overrides for the same views, creating the design you want is easier than it has ever been. Limiting support to PHP 5.3.10 and above makes Joomla lighter and faster than ever.\\u00a0<\\/p>\\r\\n<p>The separation of the Joomla! Platform project from the Joomla! CMS project makes continuous development of new, powerful APIs and continuous improvement of existing APIs possible while maintaining the stability of the CMS that millions of webmasters and professionals rely upon.<\\/p>\",\"state\":1,\"catid\":\"19\",\"created\":\"2011-01-01 00:00:01\",\"created_by\":\"266\",\"created_by_alias\":\"Joomla\",\"modified\":\"2017-09-07 07:46:23\",\"modified_by\":\"266\",\"checked_out\":\"266\",\"checked_out_time\":\"2017-09-07 07:46:01\",\"publish_up\":\"2011-01-09 16:41:13\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/articles\\\\\\/a6.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"0\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"5\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"43\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"1\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("73","com_content.article.38","","2017-09-07 07:47:01","739","3251","7be5d745abd81091e239456b730dd06885d4d0ac","{\"id\":38,\"asset_id\":\"136\",\"title\":\"Sample Sites\",\"alias\":\"sample-sites\",\"introtext\":\"<p>Your installation includes sample data, designed to show you some of the options you have for building your website. In addition to information about Joomla! there are two sample \\\"sites within a site\\\" designed to help you get started with building your own site.<\\/p>\\r\\n<p>The first site is a simple site about <a href=\\\"index.php?Itemid=243\\\">Australian Parks<\\/a>. It shows how you can quickly and easily build a personal site with just the building blocks that are part of Joomla. It includes a personal blog, weblinks, and a very simple image gallery.<\\/p>\\r\\n<p>The second site is slightly more complex and represents what you might do if you are building a site for a small business, in this case a <a href=\\\"index.php?Itemid=429\\\">Fruit Shop<\\/a>.<\\/p>\\r\\n<p>In building either style site, or something completely different, you will probably want to add <a href=\\\"http:\\/\\/extensions.joomla.org\\\">extensions<\\/a> and either create or purchase your own template. Many Joomla users start by modifying the <a href=\\\"http:\\/\\/docs.joomla.org\\/How_do_you_modify_a_template%3F\\\">templates<\\/a> that come with the core distribution so that they include special images and other design elements that relate to their site\'s focus.<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"19\",\"created\":\"2011-01-01 00:00:01\",\"created_by\":\"266\",\"created_by_alias\":\"Joomla\",\"modified\":\"2017-09-07 07:47:01\",\"modified_by\":\"266\",\"checked_out\":\"266\",\"checked_out_time\":\"2017-09-07 07:46:47\",\"publish_up\":\"2011-01-01 00:00:01\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/articles\\\\\\/a7.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"11\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"15\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("74","com_content.article.47","","2017-09-07 07:47:27","739","2859","0292bf000f136a6f57d77a348bf506fdd9c3ca69","{\"id\":47,\"asset_id\":\"145\",\"title\":\"The Joomla! Community\",\"alias\":\"the-joomla-community\",\"introtext\":\"<p>Joomla means All Together, and it is a community of people all working and having fun together that makes Joomla possible. Thousands of people each year participate in the Joomla community, and we hope you will be one of them.<\\/p>\\r\\n<p>People with all kinds of skills, of all skill levels and from around the world are welcome to join in. Participate in the <a href=\\\"http:\\/\\/joomla.org\\\">Joomla.org<\\/a> family of websites (the<a href=\\\"http:\\/\\/forum.joomla.org\\\"> forum <\\/a>is a great place to start). Come to a <a href=\\\"http:\\/\\/community.joomla.org\\/events.html\\\">Joomla! event<\\/a>. Join or start a <a href=\\\"http:\\/\\/community.joomla.org\\/user-groups.html\\\">Joomla! Users Group<\\/a>. Whether you are a developer, site administrator, designer, end user or fan, there are ways for you to participate and contribute.<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"19\",\"created\":\"2011-01-01 00:00:01\",\"created_by\":\"266\",\"created_by_alias\":\"Joomla\",\"modified\":\"2017-09-07 07:47:27\",\"modified_by\":\"266\",\"checked_out\":\"266\",\"checked_out_time\":\"2017-09-07 07:47:12\",\"publish_up\":\"2011-01-01 00:00:01\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/articles\\\\\\/a8.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"3\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"2\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("75","com_content.article.22","","2017-09-07 07:49:33","739","4339","8239e7d924f20cab1baac98bbff1aa15e9a40da5","{\"id\":22,\"asset_id\":\"120\",\"title\":\"Getting Started\",\"alias\":\"getting-started\",\"introtext\":\"<p>It\'s easy to get started creating your website. Knowing some of the basics will help.<\\/p>\\r\\n<h3>What is a Content Management System?<\\/h3>\\r\\n<p>A content management system is software that allows you to create and manage webpages easily by separating the creation of your content from the mechanics required to present it on the web.<\\/p>\\r\\n<p>In this site, the content is stored in a <em>database<\\/em>. The look and feel are created by a <em>template<\\/em>. The Joomla! software brings together the template and the content to create web pages.<\\/p>\\r\\n<h3>Site and Administrator<\\/h3>\\r\\n<p>Your site actually has two separate sites. The site (also called the front end) is what visitors to your site will see. The administrator (also called the back end) is only used by people managing your site. You can access the administrator by clicking the \\\"Site Administrator\\\" link on the \\\"This Site\\\" menu or by adding \\/administrator to the end of you domain name.<\\/p>\\r\\n<p>Log in to the administrator using the username and password created during the installation of Joomla.<\\/p>\\r\\n<h3>Logging in<\\/h3>\\r\\n<p>To login to the front end of your site use the login form or the login menu link on the \\\"This Site\\\" menu. Use the user name and password that were created as part of the installation process. Once logged-in you will be able to create and edit articles.<\\/p>\\r\\n<p>In managing your site, you will be able to create content that only logged-in users are able to see.<\\/p>\\r\\n<h3>Creating an article<\\/h3>\\r\\n<p>Once you are logged-in, a new menu will be visible. To create a new article, click on the \\\"submit article\\\" link on that menu.<\\/p>\\r\\n<p>The new article interface gives you a lot of options, but all you need to do is add a title and put something in the content area. To make it easy to find, set the state to published and put it in the Joomla category.<\\/p>\\r\\n<div>You can edit an existing article by clicking on the edit icon (this only displays to users who have the right to edit).<\\/div>\\r\\n<h3>Learn more<\\/h3>\\r\\n<p>There is much more to learn about how to use Joomla! to create the web site you envision. You can learn much more at the <a href=\\\"http:\\/\\/docs.joomla.org\\\">Joomla! documentation site<\\/a> and on the<a href=\\\"http:\\/\\/forum.joomla.org\\\"> Joomla! forums<\\/a>.<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"19\",\"created\":\"2011-01-01 00:00:01\",\"created_by\":\"266\",\"created_by_alias\":\"Joomla\",\"modified\":\"2017-09-07 07:49:33\",\"modified_by\":\"266\",\"checked_out\":\"266\",\"checked_out_time\":\"2017-09-07 07:49:21\",\"publish_up\":\"2011-01-01 00:00:01\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/articles\\\\\\/a3.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"9\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"68\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("76","com_content.article.24","","2017-09-07 07:50:01","739","2525","91520919ac50034d6ff139e65fb046fe76f30165","{\"id\":24,\"asset_id\":\"122\",\"title\":\"Joomla!\",\"alias\":\"joomla\",\"introtext\":\"<p>Congratulations! You have a Joomla site! Joomla makes it easy to build a website just the way you want it and keep it simple to update and maintain.<\\/p>\\r\\n<p>Joomla is a flexible and powerful platform, whether you are building a small site for yourself or a huge site with hundreds of thousands of visitors. Joomla is open source, which means you can make it work just the way you want it to.<\\/p>\\r\\n<p>The content in this installation of Joomla has been designed to give you an in depth tour of Joomla\'s features.<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"19\",\"created\":\"2011-01-01 00:00:01\",\"created_by\":\"266\",\"created_by_alias\":\"Joomla\",\"modified\":\"2017-09-07 07:50:01\",\"modified_by\":\"266\",\"checked_out\":\"266\",\"checked_out_time\":\"2017-09-07 07:49:52\",\"publish_up\":\"2011-01-01 00:00:01\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/articles\\\\\\/a4.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"0\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":5,\"ordering\":\"2\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"10\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"1\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("77","com_content.article.75","","2017-09-07 08:53:43","739","3465","27dac5c44b9c093b10907c5657a32bc76ca5a50d","{\"id\":75,\"asset_id\":\"199\",\"title\":\"5 Effective Email Unsubscribe Pages\",\"alias\":\"5-effective-email-unsubscribe-pages\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"266\",\"created_by_alias\":\"\",\"modified\":\"2017-09-07 08:53:43\",\"modified_by\":\"266\",\"checked_out\":\"266\",\"checked_out_time\":\"2017-09-07 08:49:34\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/blog\\\\\\/blog1.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"audio\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"<iframe width=\\\\\\\"100%\\\\\\\" height=\\\\\\\"450\\\\\\\" scrolling=\\\\\\\"no\\\\\\\" frameborder=\\\\\\\"no\\\\\\\" src=\\\\\\\"https:\\\\\\/\\\\\\/w.soundcloud.com\\\\\\/player\\\\\\/?url=https%3A\\\\\\/\\\\\\/api.soundcloud.com\\\\\\/tracks\\\\\\/28830162&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true\\\\\\\"><\\\\\\/iframe>\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":6,\"ordering\":\"2\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"31\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("78","com_content.article.71","","2017-09-07 08:56:22","739","3614","58bb34d2b284bb52e225c3a5ebc42fc7606c783f","{\"id\":71,\"asset_id\":\"195\",\"title\":\"Doner spare ribs pastrami shank\",\"alias\":\"doner-spare-ribs-pastrami-shank\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 18:56:08\",\"created_by\":\"266\",\"created_by_alias\":\"\",\"modified\":\"2017-09-07 08:56:22\",\"modified_by\":\"266\",\"checked_out\":\"266\",\"checked_out_time\":\"2017-09-07 08:55:52\",\"publish_up\":\"2015-02-02 18:56:08\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/blog\\\\\\/blog2.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"status\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"<blockquote class=\\\\\\\"twitter-tweet\\\\\\\" lang=\\\\\\\"en\\\\\\\"><p>Published a new blog entry One Month Extra for all JoomShaper Members in News. <a href=\\\\\\\"http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8\\\\\\\">http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8<\\\\\\/a><\\\\\\/p>&mdash; JoomShaper (@joomshaper) <a href=\\\\\\\"https:\\\\\\/\\\\\\/twitter.com\\\\\\/joomshaper\\\\\\/status\\\\\\/562210375480139777\\\\\\\">February 2, 2015<\\\\\\/a><\\\\\\/blockquote>\\\\r\\\\n<script async src=\\\\\\\"\\\\\\/\\\\\\/platform.twitter.com\\\\\\/widgets.js\\\\\\\" charset=\\\\\\\"utf-8\\\\\\\"><\\\\\\/script>\\\"}\",\"version\":6,\"ordering\":\"6\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"28\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("79","com_content.article.72","","2017-09-07 09:33:06","739","3137","fa0f9d0ec355a09900e102dda6ce57413f4277ab","{\"id\":72,\"asset_id\":\"196\",\"title\":\"Jerky shank chicken boudin\",\"alias\":\"jerky-shank-chicken-boudin\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"266\",\"created_by_alias\":\"\",\"modified\":\"2017-09-07 09:33:06\",\"modified_by\":\"266\",\"checked_out\":\"266\",\"checked_out_time\":\"2017-09-07 09:32:46\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/blog\\\\\\/blog3.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"video\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"http:\\\\\\/\\\\\\/vimeo.com\\\\\\/43426940\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":6,\"ordering\":\"5\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"62\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("80","com_contact.contact.10","","2017-09-11 09:26:35","739","1928","0b9d7d67ff70524bc6c625127fde70479af6a42f","{\"id\":10,\"name\":\"Contact Us\",\"alias\":\"contact-us\",\"con_position\":\"CEO\",\"address\":\"1233, 20th Street,\\r\\nN.W. Suite 400\\r\\nWashington DC, 20036\",\"suburb\":\"Washington DC\",\"state\":\"\",\"country\":\"England\",\"postcode\":\"\",\"telephone\":\"+84 (0123) 456 7899\",\"fax\":\"+84 (0123) 456 7899\",\"misc\":\"\",\"image\":\"images\\/testimonial.png\",\"email_to\":\"contact@ytcvn.com\",\"default_con\":0,\"published\":\"1\",\"checked_out\":\"266\",\"checked_out_time\":\"2017-09-11 09:23:46\",\"ordering\":\"4\",\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"add_mailto_link\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"507\",\"catid\":\"16\",\"access\":\"1\",\"mobile\":\"+84 (0123) 456 7899\",\"webpage\":\"https:\\/\\/www.smartaddons.com\\/\",\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2017-05-24 16:01:32\",\"created_by\":\"266\",\"created_by_alias\":\"\",\"modified\":\"2017-09-11 09:26:35\",\"modified_by\":\"266\",\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":3,\"hits\":\"0\"}","0"),
("81","com_contact.contact.10","","2017-09-11 09:38:14","739","1928","24b23e803519cc7d97dd8906f950b884610855db","{\"id\":10,\"name\":\"Contact Us\",\"alias\":\"contact-us\",\"con_position\":\"CEO\",\"address\":\"1233, 20th Street,\\r\\nN.W. Suite 400\\r\\nWashington DC, 20036\",\"suburb\":\"Washington DC\",\"state\":\"\",\"country\":\"England\",\"postcode\":\"\",\"telephone\":\"+84 (0123) 456 7899\",\"fax\":\"+84 (0123) 456 7899\",\"misc\":\"\",\"image\":\"images\\/testimonial.png\",\"email_to\":\"contact@ytcvn.com\",\"default_con\":0,\"published\":\"1\",\"checked_out\":\"266\",\"checked_out_time\":\"2017-09-11 09:26:35\",\"ordering\":\"4\",\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"add_mailto_link\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"507\",\"catid\":\"16\",\"access\":\"1\",\"mobile\":\"+84 (0123) 456 7890\",\"webpage\":\"https:\\/\\/www.smartaddons.com\\/\",\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2017-05-24 16:01:32\",\"created_by\":\"266\",\"created_by_alias\":\"\",\"modified\":\"2017-09-11 09:38:14\",\"modified_by\":\"266\",\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":4,\"hits\":\"0\"}","0"),
("82","com_content.article.74","","2017-09-14 05:01:34","739","3257","4099de60338a34a3926d2df3c8f2657533edba37","{\"id\":74,\"asset_id\":\"198\",\"title\":\"Meatball kevin beef ribs shoulder\",\"alias\":\"meatball-kevin-beef-ribs-shoulder\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"266\",\"created_by_alias\":\"\",\"modified\":\"2017-09-14 05:01:34\",\"modified_by\":\"266\",\"checked_out\":\"266\",\"checked_out_time\":\"2017-09-14 05:01:05\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"images\\\\\\/blog\\\\\\/blog07.jpg\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"gallery\\\",\\\"gallery\\\":\\\"{\\\\\\\"gallery_images\\\\\\\":[\\\\\\\"images\\\\\\/blog\\\\\\/blog06.jpg\\\\\\\",\\\\\\\"images\\\\\\/blog\\\\\\/blog05.jpg\\\\\\\",\\\\\\\"images\\\\\\/blog\\\\\\/blog04.jpg\\\\\\\"]}\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":5,\"ordering\":\"3\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"57\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("83","com_content.article.74","","2017-09-14 09:00:26","739","3269","6479981762f4e5456c27a0bc884772d2f1277355","{\"id\":74,\"asset_id\":\"198\",\"title\":\"Meatball kevin beef ribs shoulder\",\"alias\":\"meatball-kevin-beef-ribs-shoulder\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"266\",\"created_by_alias\":\"\",\"modified\":\"2017-09-14 09:00:26\",\"modified_by\":\"266\",\"checked_out\":\"266\",\"checked_out_time\":\"2017-09-14 08:59:13\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"images\\\\\\/blog\\\\\\/blog07.jpg\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"gallery\\\",\\\"gallery\\\":\\\"{\\\\\\\"gallery_images\\\\\\\":[\\\\\\\"images\\\\\\/blog\\\\\\/blog06.jpg\\\\\\\",\\\\\\\"images\\\\\\/blog\\\\\\/blog04.jpg\\\\\\\",\\\\\\\"images\\\\\\/2017\\\\\\/09\\\\\\/14\\\\\\/blog01.jpg\\\\\\\"]}\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":6,\"ordering\":\"3\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"58\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("84","com_contact.contact.11","","2017-09-27 09:04:56","739","758","02e2961fb65b851346bdde196eab7cfb7707ca9d","{\"id\":11,\"name\":\"H\\u1eb1ng\",\"alias\":\"h-ng\",\"con_position\":null,\"address\":null,\"suburb\":null,\"state\":null,\"country\":null,\"postcode\":null,\"telephone\":null,\"fax\":null,\"misc\":null,\"image\":null,\"email_to\":\"hangltt@ytcvn.com\",\"default_con\":0,\"published\":\"0\",\"checked_out\":\"0\",\"checked_out_time\":\"0000-00-00 00:00:00\",\"ordering\":\"0\",\"params\":null,\"user_id\":508,\"catid\":\"34\",\"access\":1,\"mobile\":\"\",\"webpage\":\"\",\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2017-09-27 09:04:56\",\"created_by\":0,\"created_by_alias\":\"\",\"modified\":\"2017-09-27 09:04:56\",\"modified_by\":\"0\",\"metakey\":null,\"metadesc\":null,\"metadata\":null,\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":\"1\",\"hits\":\"0\"}","0"),
("85","com_content.article.75","","2017-12-06 14:26:34","739","3465","12a37586f6d654a85bfcce47c0fb20aba6b8535f","{\"id\":75,\"asset_id\":\"199\",\"title\":\"5 Effective Email Unsubscribe Pages\",\"alias\":\"5-effective-email-unsubscribe-pages\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"621\",\"created_by_alias\":\"\",\"modified\":\"2017-12-06 14:26:34\",\"modified_by\":\"621\",\"checked_out\":\"621\",\"checked_out_time\":\"2017-12-06 14:24:52\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/blog\\\\\\/blog1.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"audio\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"<iframe width=\\\\\\\"100%\\\\\\\" height=\\\\\\\"450\\\\\\\" scrolling=\\\\\\\"no\\\\\\\" frameborder=\\\\\\\"no\\\\\\\" src=\\\\\\\"https:\\\\\\/\\\\\\/w.soundcloud.com\\\\\\/player\\\\\\/?url=https%3A\\\\\\/\\\\\\/api.soundcloud.com\\\\\\/tracks\\\\\\/28830162&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true\\\\\\\"><\\\\\\/iframe>\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":7,\"ordering\":\"2\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"46\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"1\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("86","com_content.article.71","","2017-12-06 14:32:46","739","3610","ea24db3ce50c44b6eca632fe0db558542a1975e3","{\"id\":71,\"asset_id\":\"195\",\"title\":\"Doner spare ribs pastrami shank\",\"alias\":\"doner-spare-ribs-pastrami-shank\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 18:56:08\",\"created_by\":\"621\",\"created_by_alias\":\"\",\"modified\":\"2017-12-06 14:32:46\",\"modified_by\":\"621\",\"checked_out\":\"621\",\"checked_out_time\":\"2017-12-06 14:32:32\",\"publish_up\":\"2015-02-02 18:56:08\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/blog\\\\\\/6.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"status\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"<blockquote class=\\\\\\\"twitter-tweet\\\\\\\" lang=\\\\\\\"en\\\\\\\"><p>Published a new blog entry One Month Extra for all JoomShaper Members in News. <a href=\\\\\\\"http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8\\\\\\\">http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8<\\\\\\/a><\\\\\\/p>&mdash; JoomShaper (@joomshaper) <a href=\\\\\\\"https:\\\\\\/\\\\\\/twitter.com\\\\\\/joomshaper\\\\\\/status\\\\\\/562210375480139777\\\\\\\">February 2, 2015<\\\\\\/a><\\\\\\/blockquote>\\\\r\\\\n<script async src=\\\\\\\"\\\\\\/\\\\\\/platform.twitter.com\\\\\\/widgets.js\\\\\\\" charset=\\\\\\\"utf-8\\\\\\\"><\\\\\\/script>\\\"}\",\"version\":7,\"ordering\":\"6\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"40\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0"),
("87","com_content.article.73","","2017-12-06 14:35:05","739","3145","eb7b69d3cc150ba6e903f4070e789cff3d9f4e13","{\"id\":73,\"asset_id\":\"197\",\"title\":\"Pellentesque Habitant Morbi Tristique\",\"alias\":\"leberkas-tail-swine-pork\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"621\",\"created_by_alias\":\"\",\"modified\":\"2017-12-06 14:35:05\",\"modified_by\":\"621\",\"checked_out\":\"621\",\"checked_out_time\":\"2017-12-06 14:34:34\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/blog\\\\\\/blog06.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"images\\\\\\/blog\\\\\\/blog06.jpg\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"spfeatured_image\\\":\\\"\\\",\\\"post_format\\\":\\\"standard\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":7,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"225\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}","0");


DROP TABLE IF EXISTS #__k2_log;
CREATE TABLE `#__k2_log` (
  `status` int(11) NOT NULL,
  `response` text NOT NULL,
  `timestamp` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO #__k2_log VALUES
("200","OK","2017-11-22 15:55:40");


DROP TABLE IF EXISTS #__languages;
CREATE TABLE `#__languages` (
  `lang_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lang_code` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_native` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sef` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sitename` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `idx_sef` (`sef`),
  UNIQUE KEY `idx_langcode` (`lang_code`),
  KEY `idx_access` (`access`),
  KEY `idx_ordering` (`ordering`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__languages VALUES
("1","307","en-GB","English ","English ","en","en","","","","","1","1","1"),
("2","224","ar-AA","Arabic","Arabic","ar","ar","","","","","1","1","0");


DROP TABLE IF EXISTS #__mail_templates;
CREATE TABLE `#__mail_templates` (
  `template_id` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `htmlbody` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `attachments` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`template_id`,`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__mail_templates VALUES
("com_actionlogs.notification","com_actionlogs","","COM_ACTIONLOGS_EMAIL_SUBJECT","COM_ACTIONLOGS_EMAIL_BODY","COM_ACTIONLOGS_EMAIL_HTMLBODY","","{\"tags\":[\"message\",\"date\",\"extension\"]}"),
("com_config.test_mail","com_config","","COM_CONFIG_SENDMAIL_SUBJECT","COM_CONFIG_SENDMAIL_BODY","","","{\"tags\":[\"sitename\",\"method\"]}"),
("com_contact.mail","com_contact","","COM_CONTACT_ENQUIRY_SUBJECT","COM_CONTACT_ENQUIRY_TEXT","","","{\"tags\":[\"sitename\",\"name\",\"email\",\"subject\",\"body\",\"url\",\"customfields\"]}"),
("com_contact.mail.copy","com_contact","","COM_CONTACT_COPYSUBJECT_OF","COM_CONTACT_COPYTEXT_OF","","","{\"tags\":[\"sitename\",\"name\",\"email\",\"subject\",\"body\",\"url\",\"customfields\"]}"),
("com_messages.new_message","com_messages","","COM_MESSAGES_NEW_MESSAGE","COM_MESSAGES_NEW_MESSAGE_BODY","","","{\"tags\":[\"subject\",\"message\",\"fromname\",\"sitename\",\"siteurl\",\"fromemail\",\"toname\",\"toemail\"]}"),
("com_privacy.notification.admin.export","com_privacy","","COM_PRIVACY_EMAIL_ADMIN_REQUEST_SUBJECT_EXPORT_REQUEST","COM_PRIVACY_EMAIL_ADMIN_REQUEST_BODY_EXPORT_REQUEST","","","{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}"),
("com_privacy.notification.admin.remove","com_privacy","","COM_PRIVACY_EMAIL_ADMIN_REQUEST_SUBJECT_REMOVE_REQUEST","COM_PRIVACY_EMAIL_ADMIN_REQUEST_BODY_REMOVE_REQUEST","","","{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}"),
("com_privacy.notification.export","com_privacy","","COM_PRIVACY_EMAIL_REQUEST_SUBJECT_EXPORT_REQUEST","COM_PRIVACY_EMAIL_REQUEST_BODY_EXPORT_REQUEST","","","{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}"),
("com_privacy.notification.remove","com_privacy","","COM_PRIVACY_EMAIL_REQUEST_SUBJECT_REMOVE_REQUEST","COM_PRIVACY_EMAIL_REQUEST_BODY_REMOVE_REQUEST","","","{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}"),
("com_privacy.userdataexport","com_privacy","","COM_PRIVACY_EMAIL_DATA_EXPORT_COMPLETED_SUBJECT","COM_PRIVACY_EMAIL_DATA_EXPORT_COMPLETED_BODY","","","{\"tags\":[\"sitename\",\"url\"]}"),
("com_users.massmail.mail","com_users","","COM_USERS_MASSMAIL_MAIL_SUBJECT","COM_USERS_MASSMAIL_MAIL_BODY","","","{\"tags\":[\"subject\",\"body\",\"subjectprefix\",\"bodysuffix\"]}"),
("com_users.password_reset","com_users","","COM_USERS_EMAIL_PASSWORD_RESET_SUBJECT","COM_USERS_EMAIL_PASSWORD_RESET_BODY","","","{\"tags\":[\"name\",\"email\",\"sitename\",\"link_text\",\"link_html\",\"token\"]}"),
("com_users.registration.admin.new_notification","com_users","","COM_USERS_EMAIL_ACCOUNT_DETAILS","COM_USERS_EMAIL_REGISTERED_NOTIFICATION_TO_ADMIN_BODY","","","{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\"]}"),
("com_users.registration.admin.verification_request","com_users","","COM_USERS_EMAIL_ACTIVATE_WITH_ADMIN_ACTIVATION_SUBJECT","COM_USERS_EMAIL_ACTIVATE_WITH_ADMIN_ACTIVATION_BODY","","","{\"tags\":[\"name\",\"sitename\",\"email\",\"username\",\"activate\"]}"),
("com_users.registration.user.admin_activated","com_users","","COM_USERS_EMAIL_ACTIVATED_BY_ADMIN_ACTIVATION_SUBJECT","COM_USERS_EMAIL_ACTIVATED_BY_ADMIN_ACTIVATION_BODY","","","{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\"]}"),
("com_users.registration.user.admin_activation","com_users","","COM_USERS_EMAIL_ACCOUNT_DETAILS","COM_USERS_EMAIL_REGISTERED_WITH_ADMIN_ACTIVATION_BODY_NOPW","","","{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\"]}"),
("com_users.registration.user.admin_activation_w_pw","com_users","","COM_USERS_EMAIL_ACCOUNT_DETAILS","COM_USERS_EMAIL_REGISTERED_WITH_ADMIN_ACTIVATION_BODY","","","{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\",\"password_clear\"]}"),
("com_users.registration.user.registration_mail","com_users","","COM_USERS_EMAIL_ACCOUNT_DETAILS","COM_USERS_EMAIL_REGISTERED_BODY_NOPW","","","{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\"]}"),
("com_users.registration.user.registration_mail_w_pw","com_users","","COM_USERS_EMAIL_ACCOUNT_DETAILS","COM_USERS_EMAIL_REGISTERED_BODY","","","{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\",\"password_clear\"]}"),
("com_users.registration.user.self_activation","com_users","","COM_USERS_EMAIL_ACCOUNT_DETAILS","COM_USERS_EMAIL_REGISTERED_WITH_ACTIVATION_BODY_NOPW","","","{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\"]}"),
("com_users.registration.user.self_activation_w_pw","com_users","","COM_USERS_EMAIL_ACCOUNT_DETAILS","COM_USERS_EMAIL_REGISTERED_WITH_ACTIVATION_BODY","","","{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\",\"password_clear\"]}"),
("com_users.reminder","com_users","","COM_USERS_EMAIL_USERNAME_REMINDER_SUBJECT","COM_USERS_EMAIL_USERNAME_REMINDER_BODY","","","{\"tags\":[\"name\",\"username\",\"sitename\",\"email\",\"link_text\",\"link_html\"]}"),
("plg_system_privacyconsent.request.reminder","plg_system_privacyconsent","","PLG_SYSTEM_PRIVACYCONSENT_EMAIL_REMIND_SUBJECT","PLG_SYSTEM_PRIVACYCONSENT_EMAIL_REMIND_BODY","","","{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}"),
("plg_system_updatenotification.mail","plg_system_updatenotification","","PLG_SYSTEM_UPDATENOTIFICATION_EMAIL_SUBJECT","PLG_SYSTEM_UPDATENOTIFICATION_EMAIL_BODY","","","{\"tags\":[\"newversion\",\"curversion\",\"sitename\",\"url\",\"link\",\"releasenews\"]}"),
("plg_user_joomla.mail","plg_user_joomla","","PLG_USER_JOOMLA_NEW_USER_EMAIL_SUBJECT","PLG_USER_JOOMLA_NEW_USER_EMAIL_BODY","","","{\"tags\":[\"name\",\"sitename\",\"url\",\"username\",\"password\",\"email\"]}");


DROP TABLE IF EXISTS #__menu;
CREATE TABLE `#__menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) unsigned NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`(100),`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_path` (`path`(100))
) ENGINE=InnoDB AUTO_INCREMENT=744 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__menu VALUES
("1","","Menu_Item_Root","root","","","","","1","0","0","0",NULL,NULL,"0","0","","0","","0","451","0","*","0",NULL,NULL),
("2","main","com_banners","Banners","","Banners","index.php?option=com_banners","component","1","1","1","4",NULL,NULL,"0","0","class:bookmark","0","","1","10","0","*","1",NULL,NULL),
("3","main","com_banners","Banners","","Banners/Banners","index.php?option=com_banners&view=banners","component","1","2","2","4",NULL,NULL,"0","0","class:banners","0","","2","3","0","*","1",NULL,NULL),
("4","main","com_banners_categories","Categories","","Banners/Categories","index.php?option=com_categories&view=categories&extension=com_banners","component","1","2","2","6",NULL,NULL,"0","0","class:banners-cat","0","","4","5","0","*","1",NULL,NULL),
("5","main","com_banners_clients","Clients","","Banners/Clients","index.php?option=com_banners&view=clients","component","1","2","2","4",NULL,NULL,"0","0","class:banners-clients","0","","6","7","0","*","1",NULL,NULL),
("6","main","com_banners_tracks","Tracks","","Banners/Tracks","index.php?option=com_banners&view=tracks","component","1","2","2","4",NULL,NULL,"0","0","class:banners-tracks","0","","8","9","0","*","1",NULL,NULL),
("7","main","com_contact","Contacts","","Contacts","index.php?option=com_contact","component","1","1","1","8",NULL,NULL,"0","0","class:address-book","0","","125","136","0","*","1",NULL,NULL),
("8","main","com_contact_contacts","Contacts","","Contacts/Contacts","index.php?option=com_contact&view=contacts","component","1","7","2","8",NULL,NULL,"0","0","class:contact","0","","126","127","0","*","1",NULL,NULL),
("9","main","com_contact_categories","Categories","","Contacts/Categories","index.php?option=com_categories&view=categories&extension=com_contact","component","1","7","2","6",NULL,NULL,"0","0","class:contact-cat","0","","128","129","0","*","1",NULL,NULL),
("13","main","com_newsfeeds","News Feeds","","News Feeds","index.php?option=com_newsfeeds","component","1","1","1","17",NULL,NULL,"0","0","class:rss","0","","137","142","0","*","1",NULL,NULL),
("14","main","com_newsfeeds_feeds","Feeds","","News Feeds/Feeds","index.php?option=com_newsfeeds&view=newsfeeds","component","1","13","2","17",NULL,NULL,"0","0","class:newsfeeds","0","","138","139","0","*","1",NULL,NULL),
("15","main","com_newsfeeds_categories","Categories","","News Feeds/Categories","index.php?option=com_categories&view=categories&extension=com_newsfeeds","component","1","13","2","6",NULL,NULL,"0","0","class:newsfeeds-cat","0","","140","141","0","*","1",NULL,NULL),
("21","main","com_finder","Smart Search","","Smart Search","index.php?option=com_finder","component","1","1","1","27",NULL,NULL,"0","0","class:search-plus","0","","143","154","0","*","1",NULL,NULL),
("201","usermenu","Portfolio items","portfolio-items","","portfolio-items","index.php?option=com_spsimpleportfolio&view=items","component","1","1","1","10007",NULL,NULL,"0","2"," ","0","{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"masonry\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"201\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"201\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","155","156","0","*","0",NULL,NULL),
("229","mainmenu","Single Contact","single-contact","","joomla/contact-component/single-contact","index.php?option=com_contact&view=contact&id=1","component","-2","270","3","8",NULL,NULL,"0","1","","0","{\"presentation_style\":\"\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_tags\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","39","40","0","*","0",NULL,NULL),
("251","mainmenu","Contact Categories","contact-categories","","joomla/contact-component/contact-categories","index.php?option=com_contact&view=categories&id=16","component","-2","270","3","8",NULL,NULL,"0","1","","0","{\"show_base_description\":\"\",\"categories_description\":\"\",\"maxLevelcat\":\"\",\"show_empty_categories_cat\":\"\",\"show_subcat_desc_cat\":\"\",\"show_cat_items_cat\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_position_headings\":\"\",\"show_email_headings\":\"\",\"show_telephone_headings\":\"\",\"show_mobile_headings\":\"\",\"show_fax_headings\":\"\",\"show_suburb_headings\":\"\",\"show_state_headings\":\"\",\"show_country_headings\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"presentation_style\":\"sliders\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"1\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","35","36","0","*","0",NULL,NULL),
("252","mainmenu","News Feed Categories","new-feed-categories","","joomla/other-components/news-feeds-component/new-feed-categories","index.php?option=com_newsfeeds&view=categories&id=0","component","-2","267","4","17",NULL,NULL,"0","1","","0","{\"show_base_description\":\"\",\"categories_description\":\"\",\"maxLevelcat\":\"\",\"show_empty_categories_cat\":\"\",\"show_subcat_desc_cat\":\"\",\"show_cat_items_cat\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_articles\":\"\",\"show_link\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","56","57","0","*","0",NULL,NULL),
("253","mainmenu","News Feed Category","news-feed-category","","joomla/other-components/news-feeds-component/news-feed-category","index.php?option=com_newsfeeds&view=category&id=17","component","-2","267","4","17",NULL,NULL,"0","1","","0","{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_articles\":\"\",\"show_link\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"feed_display_order\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","60","61","0","*","0",NULL,NULL),
("254","mainmenu","Single News Feed","single-news-feed","","joomla/other-components/news-feeds-component/single-news-feed","index.php?option=com_newsfeeds&view=newsfeed&id=4","component","-2","267","4","17",NULL,NULL,"0","1","","0","{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"show_tags\":\"\",\"feed_character_count\":\"0\",\"feed_display_order\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","58","59","0","*","0",NULL,NULL),
("255","mainmenu","Search","search","","joomla/other-components/search","index.php?option=com_search&view=search","component","1","268","3","19",NULL,NULL,"0","1"," ","0","{\"search_phrases\":\"\",\"search_areas\":\"1\",\"show_date\":\"1\",\"searchphrase\":\"0\",\"ordering\":\"newest\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","67","68","0","*","0",NULL,NULL),
("257","mainmenu","Single Article","single-article","","joomla/content-component/single-article","index.php?option=com_content&view=article&id=73","component","1","266","3","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","23","24","0","*","0",NULL,NULL),
("259","mainmenu","Article Category Blog","article-category-blog","","joomla/content-component/article-category-blog","index.php?option=com_content&view=category&layout=blog&id=79","component","1","266","3","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","25","26","0","*","0",NULL,NULL),
("260","mainmenu","Article Category List","article-category-list","","joomla/content-component/article-category-list","index.php?option=com_content&view=category&id=19","component","1","266","3","22",NULL,NULL,"0","1"," ","0","{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_category_heading_title_text\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"show_pagination_limit\":\"\",\"filter_field\":\"\",\"show_headings\":\"\",\"list_show_date\":\"\",\"date_format\":\"\",\"list_show_hits\":\"\",\"list_show_author\":\"\",\"list_show_votes\":\"\",\"list_show_ratings\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"alpha\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"display_num\":\"10\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","27","28","0","*","0",NULL,NULL),
("262","mainmenu","Featured Articles","featured-articles","","joomla/content-component/featured-articles","index.php?option=com_content&view=featured","component","1","266","3","22",NULL,NULL,"0","1"," ","0","{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","29","30","0","*","0",NULL,NULL),
("263","mainmenu","Submit Article","submit-article","","joomla/content-component/submit-article","index.php?option=com_content&view=form&layout=edit","component","1","266","3","22",NULL,NULL,"0","3"," ","0","{\"enable_category\":\"0\",\"catid\":\"19\",\"redirect_menuitem\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","31","32","0","*","0",NULL,NULL),
("266","mainmenu","Content Component","content-component","","joomla/content-component","#","url","1","280","2","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","22","33","0","*","0",NULL,NULL),
("267","mainmenu","News Feeds Component","news-feeds-component","","joomla/other-components/news-feeds-component","index.php?option=com_content&view=article&id=60","component","1","268","3","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Newsfeeds Categories View \",\"show_page_heading\":\"1\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","55","62","0","*","0",NULL,NULL),
("268","mainmenu","Other Components","other-components","","joomla/other-components","#","url","1","280","2","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","54","69","0","*","0",NULL,NULL),
("270","mainmenu","Contact Component","contact-component","","joomla/contact-component","#","url","-2","280","2","0",NULL,NULL,"0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","34","43","0","*","0",NULL,NULL),
("271","mainmenu","Users Component","users-component","","joomla/users-component","#","url","1","280","2","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","44","53","0","*","0",NULL,NULL),
("275","mainmenu","Contact Single Category","contact-single-category","","joomla/contact-component/contact-single-category","index.php?option=com_contact&view=category&catid=26&id=36","component","-2","270","3","8",NULL,NULL,"0","1","","0","{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_position_headings\":\"\",\"show_email_headings\":\"\",\"show_telephone_headings\":\"\",\"show_mobile_headings\":\"\",\"show_fax_headings\":\"\",\"show_suburb_headings\":\"\",\"show_state_headings\":\"\",\"show_country_headings\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"initial_sort\":\"\",\"presentation_style\":\"sliders\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"1\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"show_feed_link\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","37","38","0","*","0",NULL,NULL),
("276","mainmenu","Search Components","search-component","","joomla/other-components/search-component","index.php?option=com_content&view=article&id=39","component","1","268","3","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","63","64","0","*","0",NULL,NULL),
("278","mainmenu","Blog","blog","","blog","index.php?option=com_content&view=category&layout=blog&id=79","component","1","1","1","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"278\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"278\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","71","78","0","*","0",NULL,NULL),
("279","mainmenu","Pages","pages","","pages","#","url","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"279\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","97","106","0","*","0",NULL,NULL),
("280","mainmenu","Joomla!","joomla","","joomla","","separator","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_css\":\"last-item\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":800,\\\"menuItem\\\":3,\\\"menuAlign\\\":\\\"full\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"266\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"271\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"268\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"1\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":650,\\\"menuItem\\\":3,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"266\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"271\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"268\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"1\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","21","70","0","*","0",NULL,NULL),
("402","mainmenu","Login Form","login-form","","joomla/users-component/login-form","index.php?option=com_users&view=login","component","1","271","3","25",NULL,NULL,"0","1"," ","0","{\"loginredirectchoice\":\"1\",\"login_redirect_url\":\"\",\"login_redirect_menuitem\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"logoutredirectchoice\":\"1\",\"logout_redirect_url\":\"\",\"logout_redirect_menuitem\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","45","46","0","*","0",NULL,NULL),
("403","mainmenu","User Profile","user-profile","","joomla/users-component/user-profile","index.php?option=com_users&view=profile","component","1","271","3","25",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","47","48","0","*","0",NULL,NULL),
("404","mainmenu","Edit User Profile","edit-user-profile","","joomla/users-component/edit-user-profile","index.php?option=com_users&view=profile&layout=edit","component","1","271","3","25",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","49","50","0","*","0",NULL,NULL),
("405","mainmenu","Registration Form","registration-form","","joomla/users-component/registration-form","index.php?option=com_users&view=registration","component","1","271","3","25",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","51","52","0","*","0",NULL,NULL),
("437","mainmenu","Home","home","","home","index.php?option=com_sppagebuilder&view=page&id=1","component","1","1","1","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"437\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","11","20","1","*","0",NULL,NULL),
("449","usermenu","Submit an Article","submit-an-article","","submit-an-article","index.php?option=com_content&view=form&layout=edit","component","1","1","1","22",NULL,NULL,"0","3","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","157","158","0","*","0",NULL,NULL),
("450","usermenu","Submit a Web Link","submit-a-web-link","","submit-a-web-link","index.php?option=com_weblinks&view=form&layout=edit","component","1","1","1","21",NULL,NULL,"0","3","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","159","160","0","*","0",NULL,NULL),
("452","mainmenu","Featured Contacts","featured-contacts","","joomla/contact-component/featured-contacts","index.php?option=com_contact&view=featured&id=16","component","-2","270","3","8",NULL,NULL,"0","1","","0","{\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_position_headings\":\"\",\"show_email_headings\":\"\",\"show_telephone_headings\":\"\",\"show_mobile_headings\":\"\",\"show_fax_headings\":\"\",\"show_suburb_headings\":\"\",\"show_state_headings\":\"\",\"show_country_headings\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"presentation_style\":\"sliders\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"1\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","41","42","0","*","0",NULL,NULL),
("466","mainmenu","Smart Search","smart-search","","joomla/other-components/smart-search","index.php?option=com_finder&view=search","component","1","268","3","27",NULL,NULL,"0","1"," ","0","{\"show_date_filters\":\"\",\"show_advanced\":\"\",\"expand_advanced\":\"\",\"show_description\":\"\",\"description_length\":\"255\",\"show_url\":\"\",\"show_pagination_limit\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"allow_empty_query\":\"0\",\"show_suggested_query\":\"1\",\"show_explained_query\":\"1\",\"sort_order\":\"\",\"sort_direction\":\"\",\"show_feed\":\"0\",\"show_feed_text\":\"0\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","65","66","0","*","0",NULL,NULL),
("471","main","com_tags","com-tags","","com-tags","index.php?option=com_tags","component","1","1","1","29",NULL,NULL,"0","1","class:tags","0","","161","162","0","","1",NULL,NULL),
("481","quicklink","Helix 3 Framework","helix-framework","","helix-framework","http://www.joomshaper.com/helix3","url","1","1","1","0",NULL,NULL,"0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"481\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","163","164","0","*","0",NULL,NULL),
("482","quicklink","Documentation","documentation","","documentation","http://www.joomshaper.com/documentation/","url","1","1","1","0",NULL,NULL,"0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","165","166","0","*","0",NULL,NULL),
("483","quicklink","Demo Page Builder ","demo-pagebuilder","","demo-pagebuilder","http://demo.joomshaper.com/page-builder/","url","1","1","1","0",NULL,NULL,"0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","167","168","0","*","0",NULL,NULL),
("484","quicklink","Plans & Pricing","plan-pricing","","plan-pricing","http://www.joomshaper.com/join-now","url","1","1","1","0",NULL,NULL,"0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","169","170","0","*","0",NULL,NULL),
("487","mainmenu","Coming Soon","2015-02-02-15-01-12","","pages/2015-02-02-15-01-12","?tmpl=comingsoon","url","1","279","2","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","104","105","0","*","0",NULL,NULL),
("488","mainmenu","404 Page","2015-02-02-15-05-34","","pages/2015-02-02-15-05-34","index.php?option=com_404","url","1","279","2","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","102","103","0","*","0",NULL,NULL),
("489","mainmenu","Portfolio","portfolio","","home/portfolio","index.php?option=com_sppagebuilder&view=page&id=6","component","-2","437","2","10004",NULL,NULL,"0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","14","15","0","*","0",NULL,NULL),
("490","mainmenu","Corporate","corporate","","home/corporate","index.php?option=com_sppagebuilder&view=page&id=2","component","-2","437","2","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","12","13","0","*","0",NULL,NULL),
("492","mainmenu","Blog With Right Sidebar","blog-with-right-sidebar","","blog/blog-with-right-sidebar","index.php?option=com_content&view=category&layout=blog&id=79","component","1","278","2","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","72","73","0","*","0",NULL,NULL),
("493","mainmenu","Blog With Left Sidebar","blog-with-left-sidebar","","blog/blog-with-left-sidebar","index.php?option=com_content&view=category&layout=blog&id=79","component","1","278","2","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","74","75","0","*","0",NULL,NULL),
("494","mainmenu","Standard Post Format","standard-post-format","","post-formats/standard-post-format","index.php?option=com_content&view=article&id=73","component","1","503","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","80","81","0","*","0",NULL,NULL),
("495","mainmenu","Video Post Format","video-post-format","","post-formats/video-post-format","index.php?option=com_content&view=article&id=72","component","1","503","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","82","83","0","*","0",NULL,NULL),
("496","mainmenu","Gallery Post Format","gallery-post-format","","post-formats/gallery-post-format","index.php?option=com_content&view=article&id=74","component","1","503","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","86","87","0","*","0",NULL,NULL),
("497","mainmenu","Audio Post Format","audio-post-format","","post-formats/audio-post-format","index.php?option=com_content&view=article&id=75","component","1","503","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","84","85","0","*","0",NULL,NULL),
("498","mainmenu","Image Post Format","image-post-format","","post-formats/image-post-format","index.php?option=com_content&view=article&id=73","component","1","503","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","94","95","0","*","0",NULL,NULL),
("499","mainmenu","Link Post Format","link-post-format","","post-formats/link-post-format","index.php?option=com_content&view=article&id=76","component","1","503","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","88","89","0","*","0",NULL,NULL),
("500","mainmenu","Status Post Format","status-post-format","","post-formats/status-post-format","index.php?option=com_content&view=article&id=71","component","1","503","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","92","93","0","*","0",NULL,NULL),
("501","mainmenu","Quote Post Format","quote-post-format","","post-formats/quote-post-format","index.php?option=com_content&view=article&id=77","component","1","503","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","90","91","0","*","0",NULL,NULL),
("502","mainmenu","Portfolio","portfolio-2","","portfolio-2","index.php?option=com_sppagebuilder&view=page&id=9","component","-2","1","1","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"502\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"502\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","107","108","0","*","0",NULL,NULL),
("503","mainmenu","Post Formats","post-formats","","post-formats","#","url","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"503\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"503\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","79","96","0","*","0",NULL,NULL),
("504","mainmenu","Article Category Blog","article-category-blog-2","","blog/article-category-blog-2","index.php?option=com_content&view=category&layout=blog&id=79","component","1","278","2","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","76","77","0","*","0",NULL,NULL),
("521","menu-horizontal","Top Stories","top-stories","","top-stories","index.php?option=com_k2&view=itemlist&layout=category&task=category&id=1","component","1","1","1","10015",NULL,NULL,"0","1"," ","0","{\"categories\":[\"1\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"521\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"521\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","171","172","0","*","0",NULL,NULL),
("533","menu-horizontal","North America","north-america","","north-america","index.php?option=com_k2&view=itemlist&layout=category&task=category&id=2","component","1","1","1","10015",NULL,NULL,"0","1"," ","0","{\"categories\":[\"2\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"533\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"533\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","173","174","0","*","0",NULL,NULL),
("534","menu-horizontal","South America","south-america","","south-america","index.php?option=com_k2&view=itemlist&layout=category&task=category&id=3","component","1","1","1","10015",NULL,NULL,"0","1"," ","0","{\"categories\":[\"3\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"534\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"534\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","175","176","0","*","0",NULL,NULL),
("535","menu-horizontal","Africa","africa","","africa","index.php?option=com_k2&view=itemlist&layout=category&task=category&id=5","component","1","1","1","10015",NULL,NULL,"0","1"," ","0","{\"categories\":[\"5\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"535\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"535\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","177","178","0","*","0",NULL,NULL),
("536","menu-horizontal","Europe","europe","","europe","index.php?option=com_k2&view=itemlist&layout=category&task=category&id=1","component","1","1","1","10015",NULL,NULL,"0","1"," ","0","{\"categories\":[\"1\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"536\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"536\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","179","180","0","*","0",NULL,NULL),
("537","menu-horizontal","Asia Pacific","asia-pacific","","asia-pacific","index.php?option=com_k2&view=itemlist&layout=category&task=category&id=2","component","1","1","1","10015",NULL,NULL,"0","1"," ","0","{\"categories\":[\"2\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"537\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"537\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","181","182","0","*","0",NULL,NULL),
("538","menu-horizontal","Australia","australia","","australia","index.php?option=com_k2&view=itemlist&layout=category&task=category&id=5","component","1","1","1","10015",NULL,NULL,"0","1"," ","0","{\"categories\":[\"5\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"538\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"538\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","183","184","0","*","0",NULL,NULL),
("539","menu-horizontal","Antarctica","antarctica","","antarctica","index.php?option=com_k2&view=itemlist&layout=category&task=category&id=6","component","0","1","1","10015",NULL,NULL,"0","1"," ","0","{\"categories\":[\"6\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"539\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"539\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","185","186","0","*","0",NULL,NULL),
("541","menu-arabic","Home","home-arabic","","home-arabic","index.php?option=com_sppagebuilder&view=page&id=1","component","-2","1","1","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"541\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"541\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","187","188","0","ar-AA","0",NULL,NULL),
("550","menu-footer","Home","home-footer","","home-footer","index.php?option=com_sppagebuilder&view=page&id=1","component","1","1","1","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","189","190","0","*","0",NULL,NULL),
("551","menu-footer","Blog","blog-footer","","blog-footer","index.php?option=com_k2&view=itemlist&layout=category","component","1","1","1","10015",NULL,NULL,"0","1"," ","0","{\"catCatalogMode\":\"0\",\"theme\":\"default\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"551\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"551\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","191","192","0","*","0",NULL,NULL),
("552","menu-footer","About Us","about-us","","about-us","index.php?option=com_sppagebuilder&view=page&id=7","component","1","1","1","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"552\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"552\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","193","194","0","*","0",NULL,NULL),
("553","menu-footer","Contact Us","contact-us","","contact-us","index.php?option=com_sppagebuilder&view=page&id=8","component","1","1","1","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"553\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"553\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","195","196","0","*","0",NULL,NULL),
("554","menu-footer","Help","help","","help","index.php?option=com_sppagebuilder&view=page&id=8","component","1","1","1","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"554\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"554\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","197","198","0","*","0",NULL,NULL),
("555","menu-footer","Privacy","privacy","","privacy","index.php?option=com_sppagebuilder&view=page&id=9","component","1","1","1","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"555\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"555\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","199","200","0","*","0",NULL,NULL),
("556","menu-footer","Terms Of Use","terms-of-use","","terms-of-use","index.php?option=com_sppagebuilder&view=page&id=9","component","1","1","1","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"556\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"556\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","201","202","0","*","0",NULL,NULL),
("557","menu-categories","News","news","","news","index.php?option=com_content&view=category&layout=blog&id=80","component","1","1","1","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":0,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"557\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"557\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","203","204","0","*","0",NULL,NULL),
("558","menu-categories","Twitter (2)","twitter-2","","twitter-2","#","url","-2","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"557\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"fa fa-twitter\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","205","206","0","*","0",NULL,NULL),
("559","menu-categories","Tutorials","tutorials","","tutorials","index.php?option=com_content&view=category&layout=blog&id=81","component","1","1","1","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"557\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"559\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","207","208","0","*","0",NULL,NULL),
("560","menu-categories","Dribbble (2)","dribbble-2","","dribbble-2","#","url","-2","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"557\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"fa fa-facebok\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","209","210","0","*","0",NULL,NULL),
("561","menu-categories","Review","review","","review","index.php?option=com_content&view=category&layout=blog&id=82","component","1","1","1","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"557\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"561\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","211","212","0","*","0",NULL,NULL),
("562","menu-categories","Updates","updates","","updates","index.php?option=com_content&view=category&layout=blog&id=83","component","1","1","1","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"557\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"562\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","213","214","0","*","0",NULL,NULL),
("563","menu-categories","Soundcloud (2)","soundcloud-2","","soundcloud-2","#","url","-2","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"557\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"fa fa-facebok\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","215","216","0","*","0",NULL,NULL),
("564","menu-categories","Vimeo","vimeo","","vimeo","#","url","-2","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"fa-vimeo\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"557\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","217","218","0","*","0",NULL,NULL),
("565","menu-categories","Facebook","facebook","","facebook","https://www.facebook.com/smartaddons","url","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"557\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"565\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","219","220","0","*","0",NULL,NULL),
("566","menu-copyright","App Store","app-store","","app-store","#","url","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\" hidden-text\",\"menu-anchor_rel\":\"\",\"menu_image\":\"images\\/icon-appstore.png\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"566\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","221","222","0","*","0",NULL,NULL),
("567","menu-copyright","Google Play","google-play","","google-play","#","url","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"hidden-text\",\"menu-anchor_rel\":\"\",\"menu_image\":\"images\\/icon-googleplay.png\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"567\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","223","224","0","*","0",NULL,NULL),
("568","menu-copyright","Privacy Policy","privacy-policy","","privacy-policy","#","url","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","225","226","0","*","0",NULL,NULL),
("569","menu-copyright","Terms of Service","terms-of-service","","terms-of-service","#","url","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","227","228","0","*","0",NULL,NULL),
("570","menu-copyright","Share","share","","share","","url","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"btn-share-social\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"570\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"570\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","229","230","0","*","0",NULL,NULL),
("571","mainmenu","Contact Us","contact-us2","","pages/contact-us2","index.php?option=com_sppagebuilder&view=page&id=8","component","1","279","2","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","100","101","0","*","0",NULL,NULL),
("572","mainmenu","About Us","about-us2","","pages/about-us2","index.php?option=com_sppagebuilder&view=page&id=7","component","0","279","2","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","98","99","0","*","0",NULL,NULL),
("573","main","com_associations","multilingual-associations","","multilingual-associations","index.php?option=com_associations","component","1","1","1","34",NULL,NULL,"0","1","class:associations","0","{}","231","232","0","*","1",NULL,NULL),
("574","mainmenu","K2","k2","","k2","index.php?option=com_k2&view=itemlist&layout=category","component","-2","1","1","10015",NULL,NULL,"0","1"," ","0","{\"catCatalogMode\":\"0\",\"theme\":\"default\",\"num_leading_items\":\"10\",\"num_leading_columns\":\"2\",\"leadingImgSize\":\"Medium\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"0\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"0\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"0\",\"linksImgSize\":\"XSmall\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"575,576,581,580\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"575,576,581,580\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","109","124","0","*","0",NULL,NULL);
INSERT INTO #__menu VALUES
("575","mainmenu","K2 Listing","k2-listing","","k2/k2-listing","index.php?option=com_k2&view=itemlist&layout=category","component","-2","574","2","10015",NULL,NULL,"0","1"," ","0","{\"categories\":[\"1\",\"7\"],\"catCatalogMode\":\"0\",\"theme\":\"listing\",\"num_leading_items\":\"10\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Small\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"0\",\"primaryImgSize\":\"Large\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"0\",\"secondaryImgSize\":\"Large\",\"num_links\":\"0\",\"num_links_columns\":\"0\",\"linksImgSize\":\"Large\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","110","111","0","*","0",NULL,NULL),
("576","mainmenu","K2 Grid","k2-grid","","k2/k2-grid","index.php?option=com_k2&view=itemlist&layout=category","component","-2","574","2","10015",NULL,NULL,"0","1"," ","0","{\"catCatalogMode\":\"0\",\"theme\":\"default\",\"num_leading_items\":\"9\",\"num_leading_columns\":\"3\",\"leadingImgSize\":\"Medium\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"0\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"0\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"0\",\"linksImgSize\":\"XSmall\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","112","119","0","*","0",NULL,NULL),
("577","mainmenu","Grid 2 columns","grid-2-columns","","k2/k2-grid/grid-2-columns","index.php?option=com_k2&view=itemlist&layout=category","component","-2","576","3","10015",NULL,NULL,"0","1"," ","0","{\"catCatalogMode\":\"0\",\"theme\":\"default\",\"num_leading_items\":\"10\",\"num_leading_columns\":\"2\",\"leadingImgSize\":\"Medium\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"0\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"0\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"0\",\"linksImgSize\":\"XSmall\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","113","114","0","*","0",NULL,NULL),
("578","mainmenu","Grid 3 columns","grid-3-columns","","k2/k2-grid/grid-3-columns","index.php?option=com_k2&view=itemlist&layout=category","component","-2","576","3","10015",NULL,NULL,"0","1"," ","0","{\"catCatalogMode\":\"0\",\"theme\":\"default\",\"num_leading_items\":\"9\",\"num_leading_columns\":\"3\",\"leadingImgSize\":\"Medium\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"0\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"0\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"0\",\"linksImgSize\":\"XSmall\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","115","116","0","*","0",NULL,NULL),
("579","mainmenu","Grid 4 columns","grid-4-columns","","k2/k2-grid/grid-4-columns","index.php?option=com_k2&view=itemlist&layout=category","component","-2","576","3","10015",NULL,NULL,"0","1"," ","0","{\"catCatalogMode\":\"0\",\"theme\":\"default\",\"num_leading_items\":\"12\",\"num_leading_columns\":\"4\",\"leadingImgSize\":\"Medium\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"0\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"0\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"0\",\"linksImgSize\":\"XSmall\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","117","118","0","*","0",NULL,NULL),
("580","mainmenu","K2 Tag","k2-tag","","k2/k2-tag","index.php?option=com_k2&view=itemlist&layout=tag&tag=Architects&task=tag","component","-2","574","2","10015",NULL,NULL,"0","1"," ","0","{\"theme\":\"default\",\"tagOrdering\":\"\",\"tagFeedLink\":\"1\",\"tagFeedIcon\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","122","123","0","*","0",NULL,NULL),
("581","mainmenu","K2 Item","k2-item","","k2/k2-item","index.php?option=com_k2&view=item&layout=item&id=13","component","-2","574","2","10015",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","120","121","0","*","0",NULL,NULL),
("582","menu-social-header","Facebook","facebook-sidebar","","facebook-sidebar","https://www.facebook.com/smartaddons","url","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"582\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"0\",\"icon\":\"fa-facebook-official\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"582\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","233","234","0","*","0",NULL,NULL),
("583","menu-social-header","Twitter","twitter-sidebar","","twitter-sidebar","https://twitter.com/smartaddons","url","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"583\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"fa-twitter-square\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"583\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","235","236","0","*","0",NULL,NULL),
("584","menu-social-header","Youtube","youtube-sidebar","","youtube-sidebar","https://www.youtube.com/user/smartaddons","url","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"584\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"fa-youtube-square\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"584\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","237","238","0","*","0",NULL,NULL),
("585","menu-social-header","Linkedin","linkedin-sidebar","","linkedin-sidebar","https://www.linkedin.com/authwall?trk=gf&trkInfo=AQFOalnMcN6eEwAAAVxMtBfQlmOIsM8er44lmFwmK3xgZzyk75X2Bz8t8M-73U6FwdOFosAuST-WF_TP-_DtPnUz1pKPQcN_9bj73UxB6dc5gIU1xCcF6xPujy6lkeGYTajEdkM=&originalReferer=http://wp.smartaddons.com/themes/sw_expnews/?cat=52&sessionRedirect=https%3A%2F%2Fvn.linkedin.com%2Fin%2Fsmartaddons","url","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"585\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"fa-linkedin-square\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"585\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","239","240","0","*","0",NULL,NULL),
("586","menu-social-header","Google","google-plus","","google-plus","https://plus.google.com/u/0/+Smartaddons","url","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"586\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"fa-google-plus-square\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"586\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","241","242","0","*","0",NULL,NULL),
("587","menu-english","Home","home-2","","home-2","index.php?option=com_sppagebuilder&view=page&id=1","component","1","1","1","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Sj iconstruct - Responsive Multi-Purpose Personal Portfolio Joomla Template\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"fa-home\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"437\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","243","244","1","en-GB","0",NULL,NULL),
("588","menu-english","Pages","pages-2","","pages-2","","separator","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"fa-indent\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"588\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","245","254","0","en-GB","0",NULL,NULL),
("589","menu-english","About Us","about-us2","","pages-2/about-us2","index.php?option=com_sppagebuilder&view=page&id=7","component","1","588","2","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","246","247","0","en-GB","0",NULL,NULL),
("590","menu-english","Contact Us","contact-us2","","pages-2/contact-us2","index.php?option=com_sppagebuilder&view=page&id=8","component","1","588","2","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","248","249","0","en-GB","0",NULL,NULL),
("591","menu-english","404 Page","2015-02-02-15-05-34","","pages-2/2015-02-02-15-05-34","index.php?option=com_404","url","1","588","2","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","250","251","0","en-GB","0",NULL,NULL),
("592","menu-english","Coming Soon","2015-02-02-15-01-12","","pages-2/2015-02-02-15-01-12","?tmpl=comingsoon","url","1","588","2","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","252","253","0","en-GB","0",NULL,NULL),
("593","menu-english","Portfolio","portfolio-3","","portfolio-3","index.php?option=com_sppagebuilder&view=page&id=9","component","1","1","1","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"502\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"fa-pie-chart\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"502\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","255","256","0","en-GB","0",NULL,NULL),
("602","menu-english","Blog","blog-2","","blog-2","index.php?option=com_content&view=category&layout=blog&id=79","component","1","1","1","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"278\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"fa-edit\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"278\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","257","264","0","en-GB","0",NULL,NULL),
("603","menu-english","Blog With Right Sidebar","blog-with-right-sidebar","","blog-2/blog-with-right-sidebar","index.php?option=com_content&view=category&layout=blog&id=79","component","1","602","2","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","258","259","0","en-GB","0",NULL,NULL),
("604","menu-english","Blog With Left Sidebar","blog-with-left-sidebar","","blog-2/blog-with-left-sidebar","index.php?option=com_content&view=category&layout=blog&id=79","component","1","602","2","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","260","261","0","en-GB","0",NULL,NULL),
("605","menu-english","Article Category Blog","article-category-blog-2","","blog-2/article-category-blog-2","index.php?option=com_content&view=category&layout=blog&id=79","component","1","602","2","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","262","263","0","en-GB","0",NULL,NULL),
("606","menu-english","Post Formats","post-formats-2","","post-formats-2","#","url","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"503\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"fa-paint-brush\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"503\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","265","282","0","en-GB","0",NULL,NULL),
("607","menu-english","Standard Post Format","standard-post-format","","post-formats-2/standard-post-format","index.php?option=com_content&view=article&id=73","component","1","606","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","266","267","0","en-GB","0",NULL,NULL),
("608","menu-english","Video Post Format","video-post-format","","post-formats-2/video-post-format","index.php?option=com_content&view=article&id=72","component","1","606","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","268","269","0","en-GB","0",NULL,NULL),
("609","menu-english","Audio Post Format","audio-post-format","","post-formats-2/audio-post-format","index.php?option=com_content&view=article&id=75","component","1","606","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","270","271","0","en-GB","0",NULL,NULL),
("610","menu-english","Gallery Post Format","gallery-post-format","","post-formats-2/gallery-post-format","index.php?option=com_content&view=article&id=74","component","1","606","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","272","273","0","en-GB","0",NULL,NULL),
("611","menu-english","Link Post Format","link-post-format","","post-formats-2/link-post-format","index.php?option=com_content&view=article&id=76","component","1","606","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","274","275","0","en-GB","0",NULL,NULL),
("612","menu-english","Quote Post Format","quote-post-format","","post-formats-2/quote-post-format","index.php?option=com_content&view=article&id=77","component","1","606","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","276","277","0","en-GB","0",NULL,NULL),
("613","menu-english","Status Post Format","status-post-format","","post-formats-2/status-post-format","index.php?option=com_content&view=article&id=71","component","1","606","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","278","279","0","en-GB","0",NULL,NULL),
("614","menu-english","Image Post Format","image-post-format","","post-formats-2/image-post-format","index.php?option=com_content&view=article&id=73","component","1","606","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","280","281","0","en-GB","0",NULL,NULL),
("615","menu-english","Joomla!","joomla-2","","joomla-2","","separator","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":800,\\\"menuItem\\\":3,\\\"menuAlign\\\":\\\"full\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"266\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"271\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"268\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"1\",\"showmenutitle\":\"1\",\"icon\":\"fa-joomla\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":3,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"616\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"622\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"627\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"1\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","283","316","0","en-GB","0",NULL,NULL),
("616","menu-english","Content Component","content-component","","joomla-2/content-component","#","url","1","615","2","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","284","295","0","en-GB","0",NULL,NULL),
("617","menu-english","Single Article","single-article","","joomla-2/content-component/single-article","index.php?option=com_content&view=article&id=73","component","1","616","3","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","285","286","0","en-GB","0",NULL,NULL),
("618","menu-english","Article Category Blog","article-category-blog","","joomla-2/content-component/article-category-blog","index.php?option=com_content&view=category&layout=blog&id=79","component","1","616","3","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","287","288","0","en-GB","0",NULL,NULL),
("619","menu-english","Article Category List","article-category-list","","joomla-2/content-component/article-category-list","index.php?option=com_content&view=category&id=19","component","1","616","3","22",NULL,NULL,"0","1"," ","0","{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_category_heading_title_text\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"show_pagination_limit\":\"\",\"filter_field\":\"\",\"show_headings\":\"\",\"list_show_date\":\"\",\"date_format\":\"\",\"list_show_hits\":\"\",\"list_show_author\":\"\",\"list_show_votes\":\"\",\"list_show_ratings\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"alpha\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"display_num\":\"10\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","289","290","0","en-GB","0",NULL,NULL),
("620","menu-english","Featured Articles","featured-articles","","joomla-2/content-component/featured-articles","index.php?option=com_content&view=featured","component","1","616","3","22",NULL,NULL,"0","1"," ","0","{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","291","292","0","en-GB","0",NULL,NULL),
("621","menu-english","Submit Article","submit-article","","joomla-2/content-component/submit-article","index.php?option=com_content&view=form&layout=edit","component","1","616","3","22",NULL,NULL,"0","3"," ","0","{\"enable_category\":\"0\",\"catid\":\"19\",\"redirect_menuitem\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","293","294","0","en-GB","0",NULL,NULL),
("622","menu-english","Users Component","users-component","","joomla-2/users-component","#","url","1","615","2","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","296","305","0","en-GB","0",NULL,NULL),
("623","menu-english","Login Form","login-form","","joomla-2/users-component/login-form","index.php?option=com_users&view=login","component","1","622","3","25",NULL,NULL,"0","1"," ","0","{\"loginredirectchoice\":\"1\",\"login_redirect_url\":\"\",\"login_redirect_menuitem\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"logoutredirectchoice\":\"1\",\"logout_redirect_url\":\"\",\"logout_redirect_menuitem\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","297","298","0","en-GB","0",NULL,NULL),
("624","menu-english","User Profile","user-profile","","joomla-2/users-component/user-profile","index.php?option=com_users&view=profile","component","1","622","3","25",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","299","300","0","en-GB","0",NULL,NULL),
("625","menu-english","Edit User Profile","edit-user-profile","","joomla-2/users-component/edit-user-profile","index.php?option=com_users&view=profile&layout=edit","component","1","622","3","25",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","301","302","0","en-GB","0",NULL,NULL),
("626","menu-english","Registration Form","registration-form","","joomla-2/users-component/registration-form","index.php?option=com_users&view=registration","component","1","622","3","25",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","303","304","0","en-GB","0",NULL,NULL),
("627","menu-english","Other Components","other-components","","joomla-2/other-components","#","url","1","615","2","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","306","315","0","en-GB","0",NULL,NULL),
("628","menu-english","News Feeds Component","news-feeds-component","","joomla-2/other-components/news-feeds-component","index.php?option=com_content&view=article&id=60","component","1","627","3","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Newsfeeds Categories View \",\"show_page_heading\":\"1\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","307","308","0","en-GB","0",NULL,NULL),
("629","menu-english","Search Components","search-component","","joomla-2/other-components/search-component","index.php?option=com_content&view=article&id=39","component","1","627","3","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","309","310","0","en-GB","0",NULL,NULL),
("630","menu-english","Smart Search","smart-search","","joomla-2/other-components/smart-search","index.php?option=com_finder&view=search","component","1","627","3","27",NULL,NULL,"0","1"," ","0","{\"show_date_filters\":\"\",\"show_advanced\":\"\",\"expand_advanced\":\"\",\"show_description\":\"\",\"description_length\":\"255\",\"show_url\":\"\",\"show_pagination_limit\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"allow_empty_query\":\"0\",\"show_suggested_query\":\"1\",\"show_explained_query\":\"1\",\"sort_order\":\"\",\"sort_direction\":\"\",\"show_feed\":\"0\",\"show_feed_text\":\"0\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","311","312","0","en-GB","0",NULL,NULL),
("631","menu-english","Search","search","","joomla-2/other-components/search","index.php?option=com_search&view=search","component","1","627","3","19",NULL,NULL,"0","1"," ","0","{\"search_phrases\":\"\",\"search_areas\":\"1\",\"show_date\":\"1\",\"searchphrase\":\"0\",\"ordering\":\"newest\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","313","314","0","en-GB","0",NULL,NULL),
("642","menu-arabic","Home","home-3","","home-3","index.php?option=com_sppagebuilder&view=page&id=1","component","1","1","1","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"fa-home\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"437\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","317","322","1","ar-AA","0",NULL,NULL),
("643","menu-arabic","Pages","pages-3","","pages-3","#","url","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"fa-indent\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"left\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"279\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","323","332","0","ar-AA","0",NULL,NULL),
("644","menu-arabic","About Us","about-us2","","pages-3/about-us2","index.php?option=com_sppagebuilder&view=page&id=7","component","1","643","2","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","324","325","0","ar-AA","0",NULL,NULL),
("645","menu-arabic","Contact Us","contact-us2","","pages-3/contact-us2","index.php?option=com_sppagebuilder&view=page&id=8","component","1","643","2","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","326","327","0","ar-AA","0",NULL,NULL),
("646","menu-arabic","404 Page","2015-02-02-15-05-34","","pages-3/2015-02-02-15-05-34","index.php?option=com_404","url","1","643","2","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","328","329","0","ar-AA","0",NULL,NULL),
("647","menu-arabic","Coming Soon","2015-02-02-15-01-12","","pages-3/2015-02-02-15-01-12","?tmpl=comingsoon","url","1","643","2","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","330","331","0","ar-AA","0",NULL,NULL),
("648","menu-arabic","Portfolio","portfolio-4","","portfolio-4","index.php?option=com_sppagebuilder&view=page&id=9","component","1","1","1","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"502\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"fa-pie-chart\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"502\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","333","334","0","ar-AA","0",NULL,NULL),
("649","menu-arabic","K2","k2-3","","k2-3","index.php?option=com_k2&view=itemlist&layout=category","component","-2","1","1","10015",NULL,NULL,"0","1"," ","0","{\"catCatalogMode\":\"0\",\"theme\":\"default\",\"num_leading_items\":\"10\",\"num_leading_columns\":\"2\",\"leadingImgSize\":\"Medium\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"0\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"0\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"0\",\"linksImgSize\":\"XSmall\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"left\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"575,576,581,580\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"fa-newspaper-o\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"left\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"575,576,581,580\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","335","350","0","ar-AA","0",NULL,NULL),
("650","menu-arabic","K2 Listing","k2-listing","","k2-3/k2-listing","index.php?option=com_k2&view=itemlist&layout=category","component","-2","649","2","10015",NULL,NULL,"0","1"," ","0","{\"categories\":[\"1\",\"7\"],\"catCatalogMode\":\"0\",\"theme\":\"listing\",\"num_leading_items\":\"10\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Small\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"0\",\"primaryImgSize\":\"Large\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"0\",\"secondaryImgSize\":\"Large\",\"num_links\":\"0\",\"num_links_columns\":\"0\",\"linksImgSize\":\"Large\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","336","337","0","ar-AA","0",NULL,NULL),
("651","menu-arabic","K2 Grid","k2-grid","","k2-3/k2-grid","index.php?option=com_content&view=archive","component","-2","649","2","22",NULL,NULL,"0","1"," ","0","{\"orderby_sec\":\"alpha\",\"order_date\":\"created\",\"display_num\":\"5\",\"filter_field\":\"\",\"introtext_limit\":\"100\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"link_titles\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"image\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"image\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","338","345","0","ar-AA","0",NULL,NULL),
("652","menu-arabic","Grid 2 columns","grid-2-columns","","k2-3/k2-grid/grid-2-columns","index.php?option=com_k2&view=itemlist&layout=category","component","-2","651","3","10015",NULL,NULL,"0","1"," ","0","{\"catCatalogMode\":\"0\",\"theme\":\"default\",\"num_leading_items\":\"10\",\"num_leading_columns\":\"2\",\"leadingImgSize\":\"Medium\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"0\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"0\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"0\",\"linksImgSize\":\"XSmall\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","339","340","0","ar-AA","0",NULL,NULL),
("653","menu-arabic","Grid 3 columns","grid-3-columns","","k2-3/k2-grid/grid-3-columns","index.php?option=com_k2&view=itemlist&layout=category","component","-2","651","3","10015",NULL,NULL,"0","1"," ","0","{\"catCatalogMode\":\"0\",\"theme\":\"default\",\"num_leading_items\":\"9\",\"num_leading_columns\":\"3\",\"leadingImgSize\":\"Medium\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"0\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"0\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"0\",\"linksImgSize\":\"XSmall\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","341","342","0","ar-AA","0",NULL,NULL),
("654","menu-arabic","Grid 4 columns","grid-4-columns","","k2-3/k2-grid/grid-4-columns","index.php?option=com_k2&view=itemlist&layout=category","component","-2","651","3","10015",NULL,NULL,"0","1"," ","0","{\"catCatalogMode\":\"0\",\"theme\":\"default\",\"num_leading_items\":\"12\",\"num_leading_columns\":\"4\",\"leadingImgSize\":\"Medium\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"0\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"0\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"0\",\"linksImgSize\":\"XSmall\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","343","344","0","ar-AA","0",NULL,NULL),
("655","menu-arabic","K2 Item","k2-item","","k2-3/k2-item","index.php?option=com_k2&view=item&layout=item&id=13","component","-2","649","2","10015",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","346","347","0","ar-AA","0",NULL,NULL),
("656","menu-arabic","K2 Tag","k2-tag","","k2-3/k2-tag","index.php?option=com_k2&view=itemlist&layout=tag&tag=Architects&task=tag","component","-2","649","2","10015",NULL,NULL,"0","1"," ","0","{\"theme\":\"default\",\"tagOrdering\":\"\",\"tagFeedLink\":\"1\",\"tagFeedIcon\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","348","349","0","ar-AA","0",NULL,NULL),
("657","menu-arabic","Blog","blog-3","","blog-3","index.php?option=com_content&view=category&layout=blog&id=79","component","1","1","1","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"278\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"fa-edit\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"left\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"278\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","351","358","0","ar-AA","0",NULL,NULL),
("658","menu-arabic","Blog With Right Sidebar","blog-with-right-sidebar","","blog-3/blog-with-right-sidebar","index.php?option=com_content&view=category&layout=blog&id=79","component","1","657","2","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","352","353","0","ar-AA","0",NULL,NULL),
("659","menu-arabic","Blog With Left Sidebar","blog-with-left-sidebar","","blog-3/blog-with-left-sidebar","index.php?option=com_content&view=category&layout=blog&id=79","component","1","657","2","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","354","355","0","ar-AA","0",NULL,NULL),
("660","menu-arabic","Article Category Blog","article-category-blog-2","","blog-3/article-category-blog-2","index.php?option=com_content&view=category&layout=blog&id=79","component","1","657","2","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","356","357","0","ar-AA","0",NULL,NULL),
("661","menu-arabic","Post Formats","post-formats-3","","post-formats-3","#","url","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"503\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"fa-paint-brush\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"left\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"503\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"0\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","359","376","0","ar-AA","0",NULL,NULL),
("662","menu-arabic","Standard Post Format","standard-post-format","","post-formats-3/standard-post-format","index.php?option=com_content&view=article&id=73","component","1","661","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","360","361","0","ar-AA","0",NULL,NULL),
("663","menu-arabic","Video Post Format","video-post-format","","post-formats-3/video-post-format","index.php?option=com_content&view=article&id=72","component","1","661","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","362","363","0","ar-AA","0",NULL,NULL),
("664","menu-arabic","Audio Post Format","audio-post-format","","post-formats-3/audio-post-format","index.php?option=com_content&view=article&id=75","component","1","661","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","364","365","0","ar-AA","0",NULL,NULL),
("665","menu-arabic","Gallery Post Format","gallery-post-format","","post-formats-3/gallery-post-format","index.php?option=com_content&view=article&id=74","component","1","661","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","366","367","0","ar-AA","0",NULL,NULL),
("666","menu-arabic","Link Post Format","link-post-format","","post-formats-3/link-post-format","index.php?option=com_content&view=article&id=76","component","1","661","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","368","369","0","ar-AA","0",NULL,NULL),
("667","menu-arabic","Quote Post Format","quote-post-format","","post-formats-3/quote-post-format","index.php?option=com_content&view=article&id=77","component","1","661","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","370","371","0","ar-AA","0",NULL,NULL),
("668","menu-arabic","Status Post Format","status-post-format","","post-formats-3/status-post-format","index.php?option=com_content&view=article&id=71","component","1","661","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","372","373","0","ar-AA","0",NULL,NULL),
("669","menu-arabic","Image Post Format","image-post-format","","post-formats-3/image-post-format","index.php?option=com_content&view=article&id=73","component","1","661","2","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","374","375","0","ar-AA","0",NULL,NULL),
("670","menu-arabic","Joomla!","joomla-3","","joomla-3","","separator","1","1","1","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":800,\\\"menuItem\\\":3,\\\"menuAlign\\\":\\\"full\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"266\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"271\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"268\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"1\",\"showmenutitle\":\"1\",\"icon\":\"fa-joomla\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"sjmenulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":3,\\\"menuAlign\\\":\\\"left\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"671\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"677\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"682\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"sjmegamenu\":\"1\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"0\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","377","426","0","ar-AA","0",NULL,NULL),
("671","menu-arabic","Content Component","content-component","","joomla-3/content-component","#","url","1","670","2","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","378","389","0","ar-AA","0",NULL,NULL),
("672","menu-arabic","Single Article","single-article","","joomla-3/content-component/single-article","index.php?option=com_content&view=article&id=73","component","1","671","3","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","379","380","0","ar-AA","0",NULL,NULL),
("673","menu-arabic","Article Category Blog","article-category-blog","","joomla-3/content-component/article-category-blog","index.php?option=com_content&view=category&layout=blog&id=79","component","1","671","3","22",NULL,NULL,"0","1"," ","0","{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","381","382","0","ar-AA","0",NULL,NULL),
("674","menu-arabic","Article Category List","article-category-list","","joomla-3/content-component/article-category-list","index.php?option=com_content&view=category&id=19","component","1","671","3","22",NULL,NULL,"0","1"," ","0","{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_category_heading_title_text\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"show_pagination_limit\":\"\",\"filter_field\":\"\",\"show_headings\":\"\",\"list_show_date\":\"\",\"date_format\":\"\",\"list_show_hits\":\"\",\"list_show_author\":\"\",\"list_show_votes\":\"\",\"list_show_ratings\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"alpha\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"display_num\":\"10\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","383","384","0","ar-AA","0",NULL,NULL),
("675","menu-arabic","Featured Articles","featured-articles","","joomla-3/content-component/featured-articles","index.php?option=com_content&view=featured","component","1","671","3","22",NULL,NULL,"0","1"," ","0","{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","385","386","0","ar-AA","0",NULL,NULL),
("676","menu-arabic","Submit Article","submit-article","","joomla-3/content-component/submit-article","index.php?option=com_content&view=form&layout=edit","component","1","671","3","22",NULL,NULL,"0","3"," ","0","{\"enable_category\":\"0\",\"catid\":\"19\",\"redirect_menuitem\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","387","388","0","ar-AA","0",NULL,NULL),
("677","menu-arabic","Users Component","users-component","","joomla-3/users-component","#","url","1","670","2","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","390","399","0","ar-AA","0",NULL,NULL),
("678","menu-arabic","Login Form","login-form","","joomla-3/users-component/login-form","index.php?option=com_users&view=login","component","1","677","3","25",NULL,NULL,"0","1"," ","0","{\"loginredirectchoice\":\"1\",\"login_redirect_url\":\"\",\"login_redirect_menuitem\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"logoutredirectchoice\":\"1\",\"logout_redirect_url\":\"\",\"logout_redirect_menuitem\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","391","392","0","ar-AA","0",NULL,NULL),
("679","menu-arabic","User Profile","user-profile","","joomla-3/users-component/user-profile","index.php?option=com_users&view=profile","component","1","677","3","25",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","393","394","0","ar-AA","0",NULL,NULL),
("680","menu-arabic","Edit User Profile","edit-user-profile","","joomla-3/users-component/edit-user-profile","index.php?option=com_users&view=profile&layout=edit","component","1","677","3","25",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","395","396","0","ar-AA","0",NULL,NULL),
("681","menu-arabic","Registration Form","registration-form","","joomla-3/users-component/registration-form","index.php?option=com_users&view=registration","component","1","677","3","25",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","397","398","0","ar-AA","0",NULL,NULL),
("682","menu-arabic","Other Components","other-components","","joomla-3/other-components","#","url","1","670","2","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","400","415","0","ar-AA","0",NULL,NULL),
("683","menu-arabic","News Feeds Component","news-feeds-component","","joomla-3/other-components/news-feeds-component","index.php?option=com_content&view=article&id=60","component","1","682","3","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Newsfeeds Categories View \",\"show_page_heading\":\"1\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","401","408","0","ar-AA","0",NULL,NULL),
("684","menu-arabic","Search Components","search-component","","joomla-3/other-components/search-component","index.php?option=com_content&view=article&id=39","component","1","682","3","22",NULL,NULL,"0","1"," ","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","409","410","0","ar-AA","0",NULL,NULL),
("685","menu-arabic","Smart Search","smart-search","","joomla-3/other-components/smart-search","index.php?option=com_finder&view=search","component","1","682","3","27",NULL,NULL,"0","1"," ","0","{\"show_date_filters\":\"\",\"show_advanced\":\"\",\"expand_advanced\":\"\",\"show_description\":\"\",\"description_length\":\"255\",\"show_url\":\"\",\"show_pagination_limit\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"allow_empty_query\":\"0\",\"show_suggested_query\":\"1\",\"show_explained_query\":\"1\",\"sort_order\":\"\",\"sort_direction\":\"\",\"show_feed\":\"0\",\"show_feed_text\":\"0\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","411","412","0","ar-AA","0",NULL,NULL),
("686","menu-arabic","Search","search","","joomla-3/other-components/search","index.php?option=com_search&view=search","component","1","682","3","19",NULL,NULL,"0","1"," ","0","{\"search_phrases\":\"\",\"search_areas\":\"1\",\"show_date\":\"1\",\"searchphrase\":\"0\",\"ordering\":\"newest\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","413","414","0","ar-AA","0",NULL,NULL),
("687","menu-arabic","Corporate","corporate","","home-3/corporate","index.php?option=com_sppagebuilder&view=page&id=2","component","-2","642","2","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","318","319","0","ar-AA","0",NULL,NULL),
("688","menu-arabic","Portfolio","portfolio","","home-3/portfolio","index.php?option=com_sppagebuilder&view=page&id=6","component","-2","642","2","10004",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","320","321","0","ar-AA","0",NULL,NULL),
("689","menu-arabic","Contact Component","contact-component","","joomla-3/contact-component","#","url","-2","670","2","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","416","425","0","ar-AA","0",NULL,NULL),
("690","menu-arabic","Contact Categories","contact-categories","","joomla-3/contact-component/contact-categories","index.php?option=com_contact&view=categories&id=16","component","-2","689","3","8",NULL,NULL,"0","1"," ","0","{\"show_base_description\":\"\",\"categories_description\":\"\",\"maxLevelcat\":\"\",\"show_empty_categories_cat\":\"\",\"show_subcat_desc_cat\":\"\",\"show_cat_items_cat\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_position_headings\":\"\",\"show_email_headings\":\"\",\"show_telephone_headings\":\"\",\"show_mobile_headings\":\"\",\"show_fax_headings\":\"\",\"show_suburb_headings\":\"\",\"show_state_headings\":\"\",\"show_country_headings\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"presentation_style\":\"sliders\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"1\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","417","418","0","ar-AA","0",NULL,NULL),
("691","menu-arabic","Contact Single Category","contact-single-category","","joomla-3/contact-component/contact-single-category","index.php?option=com_contact&view=category&catid=26&id=36","component","-2","689","3","8",NULL,NULL,"0","1"," ","0","{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_position_headings\":\"\",\"show_email_headings\":\"\",\"show_telephone_headings\":\"\",\"show_mobile_headings\":\"\",\"show_fax_headings\":\"\",\"show_suburb_headings\":\"\",\"show_state_headings\":\"\",\"show_country_headings\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"initial_sort\":\"\",\"presentation_style\":\"sliders\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"1\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"show_feed_link\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","419","420","0","ar-AA","0",NULL,NULL),
("692","menu-arabic","Single Contact","single-contact","","joomla-3/contact-component/single-contact","index.php?option=com_contact&view=contact&id=1","component","-2","689","3","8",NULL,NULL,"0","1"," ","0","{\"presentation_style\":\"\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_tags\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","421","422","0","ar-AA","0",NULL,NULL);
INSERT INTO #__menu VALUES
("693","menu-arabic","Featured Contacts","featured-contacts","","joomla-3/contact-component/featured-contacts","index.php?option=com_contact&view=featured&id=16","component","-2","689","3","8",NULL,NULL,"0","1"," ","0","{\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_position_headings\":\"\",\"show_email_headings\":\"\",\"show_telephone_headings\":\"\",\"show_mobile_headings\":\"\",\"show_fax_headings\":\"\",\"show_suburb_headings\":\"\",\"show_state_headings\":\"\",\"show_country_headings\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"presentation_style\":\"sliders\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"1\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","423","424","0","ar-AA","0",NULL,NULL),
("694","menu-arabic","News Feed Categories","new-feed-categories","","joomla-3/other-components/news-feeds-component/new-feed-categories","index.php?option=com_newsfeeds&view=categories&id=0","component","-2","683","4","17",NULL,NULL,"0","1"," ","0","{\"show_base_description\":\"\",\"categories_description\":\"\",\"maxLevelcat\":\"\",\"show_empty_categories_cat\":\"\",\"show_subcat_desc_cat\":\"\",\"show_cat_items_cat\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_articles\":\"\",\"show_link\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","402","403","0","ar-AA","0",NULL,NULL),
("695","menu-arabic","Single News Feed","single-news-feed","","joomla-3/other-components/news-feeds-component/single-news-feed","index.php?option=com_newsfeeds&view=newsfeed&id=4","component","-2","683","4","17",NULL,NULL,"0","1"," ","0","{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"show_tags\":\"\",\"feed_character_count\":\"0\",\"feed_display_order\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","404","405","0","ar-AA","0",NULL,NULL),
("696","menu-arabic","News Feed Category","news-feed-category","","joomla-3/other-components/news-feeds-component/news-feed-category","index.php?option=com_newsfeeds&view=category&id=17","component","-2","683","4","17",NULL,NULL,"0","1"," ","0","{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_articles\":\"\",\"show_link\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"feed_display_order\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}","406","407","0","ar-AA","0",NULL,NULL),
("697","mainmenu","Layout - LTR","layout-ltr","","home/layout-ltr","http://localhost/joomla38/sj_iconstruct/index.php","url","1","437","2","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","16","17","0","*","0",NULL,NULL),
("698","mainmenu","Layout - RTL","layout-ltr-2","","home/layout-ltr-2","http://localhost/joomla38/sj_iconstruct/index.php/ar/","url","1","437","2","0",NULL,NULL,"0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"choose_icon\":\"icon\",\"image_icon\":\"\",\"xmp_showsubtitle\":\"0\",\"xmp_description\":\"\",\"xmp_showlink\":\"1\",\"xmp_tag_id\":\"\",\"xmp_tag_class\":\"\",\"xmp_float\":\"left\",\"xmp_width\":\"\",\"backgroundtype\":\"color\",\"backgroundimage\":\"\",\"backgroundcolor\":\"#ffffff\"}","18","19","0","*","0",NULL,NULL),
("700","main","-","1634728470-9428","","Contacts/1634728470-9428","#","separator","1","7","2","33",NULL,NULL,"0","0"," ","0","{}","130","131","0","*","1",NULL,NULL),
("701","main","mod_menu_fields","contact-custom-fields","","Contacts/contact-custom-fields","index.php?option=com_fields&context=com_contact.contact","component","1","7","2","33",NULL,NULL,"0","0"," ","0","{}","132","133","0","*","1",NULL,NULL),
("702","main","mod_menu_fields_group","contact-custom-fields-group","","Contacts/contact-custom-fields-group","index.php?option=com_fields&view=groups&context=com_contact.contact","component","1","7","2","33",NULL,NULL,"0","0"," ","0","{}","134","135","0","*","1",NULL,NULL),
("703","main","-","1634728470-9496","","Smart Search/1634728470-9496","#","separator","1","21","2","27",NULL,NULL,"0","0"," ","0","{}","144","145","0","*","1",NULL,NULL),
("704","main","com_finder_index","smart-search-index","","Smart Search/smart-search-index","index.php?option=com_finder&view=index","component","1","21","2","27",NULL,NULL,"0","0"," ","0","{}","146","147","0","*","1",NULL,NULL),
("705","main","com_finder_maps","smart-search-maps","","Smart Search/smart-search-maps","index.php?option=com_finder&view=maps","component","1","21","2","27",NULL,NULL,"0","0"," ","0","{}","148","149","0","*","1",NULL,NULL),
("706","main","com_finder_filters","smart-search-filters","","Smart Search/smart-search-filters","index.php?option=com_finder&view=filters","component","1","21","2","27",NULL,NULL,"0","0"," ","0","{}","150","151","0","*","1",NULL,NULL),
("707","main","com_finder_searches","smart-search-searches","","Smart Search/smart-search-searches","index.php?option=com_finder&view=searches","component","1","21","2","27",NULL,NULL,"0","0"," ","0","{}","152","153","0","*","1",NULL,NULL),
("732","main","COM_SPPAGEBUILDER","com-sppagebuilder","","com-sppagebuilder","index.php?option=com_sppagebuilder","component","1","1","1","10004",NULL,NULL,"0","1","class:component","0","{}","427","440","0","","1",NULL,NULL),
("733","main","COM_SPPAGEBUILDER_PAGES","com-sppagebuilder-pages","","com-sppagebuilder/com-sppagebuilder-pages","index.php?option=com_sppagebuilder&view=pages","component","1","732","2","10004",NULL,NULL,"0","1","class:component","0","{}","428","429","0","","1",NULL,NULL),
("734","main","COM_SPPAGEBUILDER_MEDIA","com-sppagebuilder-media","","com-sppagebuilder/com-sppagebuilder-media","index.php?option=com_sppagebuilder&view=media","component","1","732","2","10004",NULL,NULL,"0","1","class:component","0","{}","430","431","0","","1",NULL,NULL),
("735","main","COM_SPPAGEBUILDER_CATEGORIES","com-sppagebuilder-categories","","com-sppagebuilder/com-sppagebuilder-categories","index.php?option=com_categories&extension=com_sppagebuilder","component","1","732","2","10004",NULL,NULL,"0","1","class:component","0","{}","432","433","0","","1",NULL,NULL),
("736","main","COM_SPPAGEBUILDER_INTEGRATIONS","com-sppagebuilder-integrations","","com-sppagebuilder/com-sppagebuilder-integrations","index.php?option=com_sppagebuilder&view=integrations","component","1","732","2","10004",NULL,NULL,"0","1","class:component","0","{}","434","435","0","","1",NULL,NULL),
("737","main","COM_SPPAGEBUILDER_LANGUAGES","com-sppagebuilder-languages","","com-sppagebuilder/com-sppagebuilder-languages","index.php?option=com_sppagebuilder&view=languages","component","1","732","2","10004",NULL,NULL,"0","1","class:component","0","{}","436","437","0","","1",NULL,NULL),
("738","main","COM_SPPAGEBUILDER_ABOUT","com-sppagebuilder-about","","com-sppagebuilder/com-sppagebuilder-about","index.php?option=com_sppagebuilder&view=about","component","1","732","2","10004",NULL,NULL,"0","1","class:component","0","{}","438","439","0","","1",NULL,NULL),
("739","main","COM_SPSIMPLEPORTFOLIO","com-spsimpleportfolio","","com-spsimpleportfolio","index.php?option=com_spsimpleportfolio","component","1","1","1","10007",NULL,NULL,"0","1","class:component","0","{}","441","448","0","","1",NULL,NULL),
("740","main","COM_SPSIMPLEPORTFOLIO_ITEMS","com-spsimpleportfolio-items","","com-spsimpleportfolio/com-spsimpleportfolio-items","index.php?option=com_spsimpleportfolio&view=items","component","1","739","2","10007",NULL,NULL,"0","1","class:component","0","{}","442","443","0","","1",NULL,NULL),
("741","main","COM_SPSIMPLEPORTFOLIO_CATEGORIES","com-spsimpleportfolio-categories","","com-spsimpleportfolio/com-spsimpleportfolio-categories","index.php?option=com_categories&view=categories&extension=com_spsimpleportfolio","component","1","739","2","10007",NULL,NULL,"0","1","class:component","0","{}","444","445","0","","1",NULL,NULL),
("742","main","COM_SPSIMPLEPORTFOLIO_TAGS","com-spsimpleportfolio-tags","","com-spsimpleportfolio/com-spsimpleportfolio-tags","index.php?option=com_spsimpleportfolio&view=tags","component","1","739","2","10007",NULL,NULL,"0","1","class:component","0","{}","446","447","0","","1",NULL,NULL),
("743","main","Search","search","","search","index.php?option=com_search","component","1","1","1","19",NULL,NULL,"0","1","class:search","0","{}","449","450","0","","1",NULL,NULL);


DROP TABLE IF EXISTS #__menu_types;
CREATE TABLE `#__menu_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__menu_types VALUES
("2","0","usermenu","User Menu","A Menu for logged-in Users","0"),
("4","0","mainmenu","Main Menu","Main Menu","0"),
("9","0","quicklink","Quick Link","","0"),
("10","215","menu-horizontal","Menu Horizontal ","","0"),
("11","225","menu-english","Menu English","","0"),
("12","226","menu-arabic","Menu Arabic","","0"),
("13","245","menu-footer","Menu Footer","","0"),
("14","247","menu-categories","Menu Categories","","0"),
("15","249","menu-copyright","Menu Copyright","","0"),
("16","273","menu-social-header","Menu Social Header","","0");


DROP TABLE IF EXISTS #__messages;
CREATE TABLE `#__messages` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id_from` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id_to` int(10) unsigned NOT NULL DEFAULT '0',
  `folder_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `useridto_state` (`user_id_to`,`state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS #__messages_cfg;
CREATE TABLE `#__messages_cfg` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfg_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS #__modules;
CREATE TABLE `#__modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` text COLLATE utf8mb4_unicode_ci,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `showtitle` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=203 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__modules VALUES
("2","0","Login","","","1","login",NULL,NULL,NULL,NULL,"1","mod_login","1","1","","1","*"),
("3","0","Popular Articles","","","3","cpanel",NULL,NULL,NULL,NULL,"1","mod_popular","3","1","{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}","1","*"),
("4","0","Recently Added Articles","","","4","cpanel",NULL,NULL,NULL,NULL,"1","mod_latest","3","1","{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}","1","*"),
("8","0","Toolbar","","","1","toolbar",NULL,NULL,NULL,NULL,"1","mod_toolbar","3","1","","1","*"),
("9","0","Notifications","","","3","icon",NULL,NULL,NULL,NULL,"1","mod_quickicon","3","1","{\"context\":\"update_quickicon\",\"header_icon\":\"fas fa-sync\",\"show_global\":\"0\",\"show_checkin\":\"0\",\"show_cache\":\"0\",\"show_users\":\"0\",\"show_articles\":\"0\",\"show_categories\":\"0\",\"show_media\":\"0\",\"show_menuItems\":\"0\",\"show_modules\":\"0\",\"show_plugins\":\"0\",\"show_templates\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}","1","*"),
("10","0","Logged-in Users","","","2","cpanel",NULL,NULL,NULL,NULL,"1","mod_logged","3","1","{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}","1","*"),
("12","0","Admin Menu","","","1","menu",NULL,NULL,NULL,NULL,"1","mod_menu","3","1","{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}","1","*"),
("13","0","Admin Submenu","","","1","submenu",NULL,NULL,NULL,NULL,"1","mod_submenu","3","1","","1","*"),
("14","0","User Status","","","2","status",NULL,NULL,NULL,NULL,"1","mod_status","3","1","","1","*"),
("15","0","Title","","","1","title",NULL,NULL,NULL,NULL,"1","mod_title","3","1","","1","*"),
("17","185","Breadcrumbs","","","1","breadcrumb",NULL,NULL,NULL,NULL,"1","mod_breadcrumbs","1","0","{\"showHere\":0,\"showHome\":1,\"homeText\":\"\",\"showLast\":1,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\"}","0","*"),
("35","186","Search","","","1","offcanvas",NULL,NULL,"2017-05-27 16:05:30",NULL,"-2","mod_search","1","1","{\"label\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"0\",\"button_pos\":\"right\",\"imagebutton\":\"0\",\"button_text\":\"\",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}","0","*"),
("79","0","Multilanguage status","","","2","status",NULL,NULL,NULL,NULL,"0","mod_multilangstatus","3","1","{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}","1","*"),
("86","0","Joomla Version","","","1","status",NULL,NULL,NULL,NULL,"1","mod_version","3","1","{\"format\":\"short\",\"product\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}","1","*"),
("91","181","SP Page Builder","","","1","cpanel",NULL,NULL,NULL,NULL,"1","mod_sppagebuilder_icons","1","1","{\"layout\":\"_:default\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","1","*"),
("94","187","About Helix","","<p>Ball tip biltong pork belly frankfurter shankle jerky leberkas pig kielbasa kay boudin alcatra short loin.</p>
\n<p>Jowl salami leberkas turkey pork brisket meatball turducken flank bilto porke belly ball tip. pork belly frankf urtane bilto</p>","1","bottom1",NULL,NULL,"2017-04-21 09:38:27",NULL,"-2","mod_custom","1","1","{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("95","188","Latest News","","","1","bottom2",NULL,NULL,"2017-04-21 10:34:12",NULL,"-2","mod_articles_latest","1","1","{\"catid\":[\"\"],\"count\":\"3\",\"show_featured\":\"\",\"ordering\":\"c_dsc\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}","0","*"),
("97","190","Quick Link","","","1","bottom4",NULL,NULL,NULL,NULL,"0","mod_menu","1","1","{\"menutype\":\"quicklink\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("98","202","Portfolio Module","","","1","pagebuilder",NULL,NULL,"2017-05-27 16:22:29",NULL,"-2","mod_spsimpleportfolio","1","1","{\"show_filter\":\"0\",\"layout_type\":\"gallery_nospace\",\"columns\":\"4\",\"thumbnail_type\":\"square\",\"limit\":\"4\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}","0","*"),
("99","203","Latest News","","","8","right",NULL,NULL,"2017-05-24 18:48:52",NULL,"-2","mod_articles_latest","1","1","{\"catid\":[\"79\"],\"count\":\"6\",\"show_featured\":\"\",\"ordering\":\"c_dsc\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("100","204","Search sidebar right","","","3","right",NULL,NULL,NULL,NULL,"1","mod_search","1","0","{\"label\":\"\",\"width\":\"25\",\"text\":\"Enter your search...\",\"button\":\"1\",\"button_pos\":\"right\",\"imagebutton\":\"0\",\"button_text\":\"\",\"opensearch\":\"0\",\"opensearch_title\":\"\",\"set_itemid\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\" search-aside-top\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("102","206","Search","","","1","left",NULL,NULL,"2017-05-27 16:25:38",NULL,"-2","mod_search","1","1","{\"label\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"0\",\"button_pos\":\"right\",\"imagebutton\":\"0\",\"button_text\":\"\",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}","0","*"),
("103","207","Latest News","","","4","left",NULL,NULL,"2017-05-27 16:25:38",NULL,"-2","mod_articles_latest","1","1","{\"catid\":[\"79\"],\"count\":\"6\",\"show_featured\":\"\",\"ordering\":\"c_dsc\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}","0","*"),
("105","209","Off Canvas Menu","","","1","offcanvas",NULL,NULL,"2017-05-27 16:05:30",NULL,"-2","mod_menu","1","0","{\"menutype\":\"mainmenu\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("107","211","Portfolio Module -  Portfolio Home","","","1","pagebuilder",NULL,NULL,"2017-05-27 16:22:29",NULL,"-2","mod_spsimpleportfolio","1","1","{\"show_filter\":\"1\",\"layout_type\":\"gallery_nospace\",\"columns\":\"4\",\"thumbnail_type\":\"square\",\"limit\":\"12\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}","0","*"),
("108","212","test","","","0","footer1",NULL,NULL,"2016-09-20 12:40:23",NULL,"-2","mod_related_items","1","1","{\"showDate\":\"0\",\"maximum\":\"5\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("109","213","Login","","","1","top1",NULL,NULL,NULL,NULL,"1","mod_login","1","0","{\"pretext\":\"\",\"posttext\":\"\",\"login\":\"\",\"logout\":\"\",\"greeting\":\"0\",\"name\":\"0\",\"profilelink\":\"0\",\"usesecure\":\"0\",\"usetext\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("110","214","Language","","","1","top1",NULL,NULL,"2017-09-27 08:50:28",NULL,"1","mod_languages","1","0","{\"header_text\":\"\",\"footer_text\":\"\",\"dropdown\":\"1\",\"dropdownimage\":\"1\",\"lineheight\":\"1\",\"image\":\"1\",\"show_active\":\"1\",\"full_name\":\"1\",\"inline\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("128","246","Our Services","","","1","bottom3",NULL,NULL,NULL,NULL,"1","mod_menu","1","1","{\"menutype\":\"menu-footer\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("129","248","Categories","","","4","right",NULL,NULL,NULL,NULL,"1","mod_menu","1","1","{\"menutype\":\"menu-categories\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"categories-sidebar\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("130","250","Menu Copyright","","","1","footer2",NULL,NULL,NULL,NULL,"0","mod_menu","1","0","{\"menutype\":\"menu-copyright\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\" menu_copyright\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("136","256","HTML Top Categories","","","1","",NULL,NULL,"2017-05-31 16:04:33",NULL,"-2","mod_custom","1","1","{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("138","258","SJ Twitter Slider","","","6","right",NULL,NULL,"2017-04-26 02:39:51",NULL,"-2","mod_sj_twitter_slider","1","0","{\"screenname\":\"smartaddons\",\"id_user\":\"321482620284321792\",\"count\":\"6\",\"display_avatars\":\"0\",\"display_follow_button\":\"1\",\"display_direction_button\":\"0\",\"start\":\"1\",\"play\":\"0\",\"interval\":\"5000\",\"pause_hover\":\"hover\",\"effect\":\"slide\",\"swipe_enable\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"pretext\":\"\",\"posttext\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("140","260","SJ Instagram","","","7","right",NULL,NULL,"2017-04-26 04:01:07",NULL,"-2","mod_sj_instagram_gallery","1","0","{\"type_show\":\"simple\",\"nb_rows\":\"1\",\"nb-column1\":\"3\",\"nb-column2\":\"3\",\"nb-column3\":\"3\",\"nb-column4\":\"3\",\"title\":\"Instagram\",\"show_title\":\"1\",\"full_name\":\"1\",\"target\":\"_blank\",\"users_id\":\"2104313612\",\"access_token\":\"2104313612.1677ed0.2a631e32ce344b4580477470faa0517c\",\"limit_image\":\"9\",\"autoplay\":\"1\",\"display_nav\":\"1\",\"display_loop\":\"1\",\"touchdrag\":\"1\",\"mousedrag\":\"1\",\"pausehover\":\"1\",\"autoplay_timeout\":\"5000\",\"autoplay_speed\":\"2000\",\"layout\":\"_:default\",\"pretext\":\"\",\"posttext\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("141","263","Home - Why choose us","","<div class=\"sppb-addon-whychoose row\">
\n<div class=\"col-md-7 col-sm-12\">
\n<div class=\"sppb-addon-heading \">
\n<p class=\"sppb-addon-title\">Why choose us ?</p>
\n<h3 class=\"heading-title\">Bring the best things</h3>
\n<p class=\"heading-subtitle\">It’s important to use cocoa butter. It’s the key to more success, why not live smooth? You should never complain, complaining is a weak emotion</p>
\n</div>
\n<div class=\"row\">
\n<div class=\"col-sm-6\">
\n<div class=\"sppb-box-whychoose\">
\n<div class=\"sppb-box-whychoose-inner\">
\n<div class=\"box-whychoose--icons\"><img src=\"images/homepage/why-1.png\" alt=\"\" /></div>
\n<h3 class=\"box-whychoose--title\">We are Responsible</h3>
\n<p>In life there will be road blocks but we will over come it. Let me be clear, you have to make it</p>
\n</div>
\n</div>
\n<div class=\"sppb-box-whychoose\">
\n<div class=\"sppb-box-whychoose-inner\">
\n<div class=\"box-whychoose--icons\"><img src=\"images/homepage/why-2.png\" alt=\"\" /></div>
\n<h3 class=\"box-whychoose--title\">Best Finance Aid</h3>
\n<p>In life there will be road blocks but we will over come it. Let me be clear, you have to make it</p>
\n</div>
\n</div>
\n<div class=\"sppb-box-whychoose\">
\n<div class=\"sppb-box-whychoose-inner\">
\n<div class=\"box-whychoose--icons\"><img src=\"images/homepage/why-3.png\" alt=\"\" /></div>
\n<h3 class=\"box-whychoose--title\">First Class Support</h3>
\n<p>In life there will be road blocks but we will over come it. Let me be clear, you have to make it</p>
\n</div>
\n</div>
\n</div>
\n<div class=\"col-sm-6\">
\n<div class=\"sppb-box-whychoose\">
\n<div class=\"sppb-box-whychoose-inner\">
\n<div class=\"box-whychoose--icons\"><img src=\"images/homepage/why-4.png\" alt=\"\" /></div>
\n<h3 class=\"box-whychoose--title\">World Class Specialists</h3>
\n<p>In life there will be road blocks but we will over come it. Let me be clear, you have to make it</p>
\n</div>
\n</div>
\n<div class=\"sppb-box-whychoose\">
\n<div class=\"sppb-box-whychoose-inner\">
\n<div class=\"box-whychoose--icons\"><img src=\"images/homepage/why-5.png\" alt=\"\" /></div>
\n<h3 class=\"box-whychoose--title\">Clear Design</h3>
\n<p>In life there will be road blocks but we will over come it. Let me be clear, you have to make it</p>
\n</div>
\n</div>
\n<div class=\"sppb-box-whychoose\">
\n<div class=\"sppb-box-whychoose-inner\">
\n<div class=\"box-whychoose--icons\"><img src=\"images/homepage/why-6.png\" alt=\"\" /></div>
\n<h3 class=\"box-whychoose--title\">Install and Play</h3>
\n<p>In life there will be road blocks but we will over come it. Let me be clear, you have to make it</p>
\n</div>
\n</div>
\n</div>
\n</div>
\n</div>
\n</div>","1","",NULL,NULL,NULL,NULL,"1","mod_custom","1","1","{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("143","265","Home - Project Counter","","<div class=\"counter-wrap\">
\n<div class=\"row\">
\n<div class=\"maps box-maps col-lg-3 col-md-3 col-sm-3 col-xs-12\">[yt_counter count_start=\"900\" count_end=\"1250\" counter_speed=\"5\" prefix=\"\" suffix=\"\" separator=\"no\" align=\"none\" background=\"transparent\" border_radius=\"0px\" icon=\"images/homepage/icon1.png\" icon_color=\"\" count_color=\"\" count_size=\"36px\" text_color=\"#ffffff\" text_size=\"18px\" border=\"0px solid #DDD\" ]Projects[/yt_counter]</div>
\n<div class=\"maps box-maps col-md-3 col-sm-3 col-xs-12\">[yt_counter count_start=\"200\" count_end=\"350\" counter_speed=\"5\" prefix=\"\" suffix=\"\" separator=\"no\" align=\"none\" background=\"transparent\" border_radius=\"0px\" icon=\"images/homepage/icon2.png\" icon_color=\"\" count_color=\"\" count_size=\"36px\" text_color=\"#ffffff\" text_size=\"18px\" border=\"0px solid #DDD\" ]Clients [/yt_counter]</div>
\n<div class=\"maps box-maps col-md-3 col-sm-3 col-xs-12\">[yt_counter count_start=\"200\" count_end=\"550\" counter_speed=\"5\" prefix=\"\" suffix=\"\" separator=\"no\" align=\"none\" background=\"transparent\" border_radius=\"0px\" icon=\"images/homepage/icon3.png\" icon_color=\"\" count_color=\"\" count_size=\"36px\" text_color=\"#ffffff\" text_size=\"18px\" border=\"0px solid #DDD\" ]Members [/yt_counter]</div>
\n<div class=\"maps box-maps col-md-3 col-sm-3 col-xs-12\">[yt_counter count_start=\"6000\" count_end=\"7000\" counter_speed=\"5\" prefix=\"\" suffix=\"\" separator=\"no\" align=\"none\" background=\"transparent\" border_radius=\"0px\" icon=\"images/homepage/icon4.png\" icon_color=\"\" count_color=\"\" count_size=\"36px\" text_color=\"#ffffff\" text_size=\"18px\" border=\"0px solid #DDD\" ]Awards [/yt_counter]</div>
\n</div>
\n</div>","1","",NULL,NULL,"2017-05-24 15:42:11",NULL,"1","mod_custom","1","1","{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("144","267","Sj Ajax contact","","","1","",NULL,NULL,"2017-05-16 08:18:53",NULL,"1","mod_sj_contact_ajax","1","1","{\"contact_id\":\"10\",\"email_copy_dis\":\"1\",\"facebook_dis\":\"0\",\"facebook_text\":\"\",\"twitter_dis\":\"0\",\"twitter_text\":\"\",\"rss_dis\":\"0\",\"rss_text\":\"\",\"linkedin_dis\":\"0\",\"linkedin_text\":\"\",\"google_plus_dis\":\"0\",\"google_plus_text\":\"\",\"captcha_dis\":\"0\",\"captcha_type\":\"1\",\"captcha_disable\":\"1\",\"maps_display\":\"1\",\"map_width\":\"560\",\"map_height\":\"350\",\"select_type\":\"0\",\"key_text\":\"AIzaSyBf-EZpcLV72omKDDxOlhG6-i8Ga8NenRo\",\"address_text\":\"1233, 20th Street, N.W. Suite 400 Washington DC, 20036\",\"sLat\":\"21.0333333\",\"sLong\":\"105.85000000000002\",\"map_zoom\":\"19\",\"moduleclass_sfx\":\"\",\"layout\":\"_:default\",\"pretext\":\"\",\"posttext\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("145","268","Custom HTML Sidebar","","","3","right",NULL,NULL,NULL,NULL,"1","mod_banners","1","0","{\"target\":\"1\",\"count\":1,\"cid\":\"0\",\"catid\":[\"91\"],\"tag_search\":\"0\",\"ordering\":\"0\",\"header_text\":\"\",\"footer_text\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("146","270","iConstruct About","","<p class=\"form-group\"><img src=\"images/logo/logo.png\" alt=\"\" /></p>
\n<p class=\"form-group\" style=\"width: 80%;\">Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl. Duis autem vel eum iriure dolor ... <a href=\"#\">Read more</a></p>
\n<ul class=\"list-inline list-social--about\">
\n<li>[yt_social_icon type=\"facebook\" yt_title=\"SmartAddons\" color=\"no\" style=\"flat\" size=\"large\" link=\"https://www.facebook.com/SmartAddons.page\" ]</li>
\n<li>[yt_social_icon type=\"twitter\" yt_title=\"smartaddons\" color=\"no\" style=\"flat\" size=\"large\" link=\"https://twitter.com/smartaddons\" ]</li>
\n<li>[yt_social_icon type=\"google-plus\" yt_title=\"smartaddons\" color=\"no\" style=\"flat\" size=\"large\" link=\"https://plus.google.com/+Smartaddons\" ]</li>
\n<li>[yt_social_icon type=\"rss\" yt_title=\"smartaddons\" color=\"no\" style=\"flat\" size=\"large\" link=\"#\" ]</li>
\n<li>[yt_social_icon type=\"pinterest\" yt_title=\"smartaddons\" color=\"no\" style=\"flat\" size=\"large\" link=\"https://www.pinterest.com/smartaddons/\" ]</li>
\n</ul>
\n<p><img class=\"hidden-md hidden-sm hidden-xs\" src=\"images/demo/map.png\" alt=\"\" /></p>","1","bottom1",NULL,NULL,"2017-11-20 16:15:35",NULL,"1","mod_custom","1","0","{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("147","271","SJ Mega Menu Horizontal","","","1","menu-hozizontal",NULL,NULL,"2017-05-26 08:57:51",NULL,"1","mod_sj_megamenu_res","1","0","{\"style_layout\":\"layout1\",\"show_heading_title\":\"0\",\"heading_title\":\"\",\"bg_menu\":\"#ffffff\",\"menutype\":\"mainmenu\",\"menu_event\":\"hover\",\"moofx\":\"fade\",\"moofxtimeout\":\"150\",\"css_style\":\"1\",\"include_js\":\"1\",\"include_css\":\"1\",\"sub_animation\":\"\",\"megamenutype\":\"horizontal\",\"active\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"mobilemenutype\":\"sidebar\",\"tag_id\":\"container_menu2\",\"moduleclass_sfx\":\"\",\"layout\":\"_:default\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\"}","0","*"),
("148","272","SJ Mega Menu Vertical","","","1","sidebar-primary",NULL,NULL,"2017-05-26 08:57:51",NULL,"1","mod_sj_megamenu_res","1","0","{\"style_layout\":\"layout1\",\"show_heading_title\":\"0\",\"heading_title\":\"\",\"bg_menu\":\"#090909\",\"menutype\":\"menu-english\",\"menu_event\":\"hover\",\"moofx\":\"fade\",\"moofxtimeout\":\"150\",\"css_style\":\"1\",\"include_js\":\"1\",\"include_css\":\"1\",\"sub_animation\":\"menu-fade-in-up\",\"megamenutype\":\"vertical\",\"active\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"mobilemenutype\":\"sidebar\",\"tag_id\":\"container_menu0\",\"moduleclass_sfx\":\"\",\"layout\":\"_:default\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\"}","0","en-GB"),
("149","274","Menu Social Header","","","1","top2",NULL,NULL,NULL,NULL,"1","mod_menu","1","0","{\"menutype\":\"menu-social-header\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\" menu_social_header\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("150","275","Portfolio","","","1","",NULL,NULL,NULL,NULL,"1","mod_spsimpleportfolio","1","1","{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"gallery_nospace\",\"columns\":\"4\",\"thumbnail_type\":\"square\",\"limit\":\"8\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("151","276","Menu","","","1","menu",NULL,NULL,NULL,NULL,"1","mod_menu","1","0","{\"menutype\":\"mainmenu\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("152","278","Home - Our Team","","<div class=\"sppb-addon-heading text-center \">
\n<p class=\"sppb-addon-title\">Our team</p>
\n<h3 class=\"heading-title\">always be the best team</h3>
\n<p class=\"heading-subtitle\">It’s important to use cocoa butter. It’s the key to more success, why not live smooth?</p>
\n</div>
\n<div class=\"yt-content-slider content-slider--team\" data-margin=\"30\" data-items_column0=\"3\" data-items_column1=\"3\" data-items_column2=\"2\" data-items_column3=\"1\" data-items_column4=\"1\" data-arrows=\"yes\" data-pagination=\"no\" data-loop=\"yes\">
\n<div class=\"yt-content-slide\">
\n<div class=\"image\"><img src=\"images/homepage/member-1.jpg\" alt=\"\" />
\n<ul class=\"list-social list-inline\">
\n<li class=\"facebook\"><a class=\"fa fa-facebook\" title=\"facebook\" href=\"#\">facebook</a></li>
\n<li class=\"google\"><a class=\"fa fa-google-plus\" title=\"google\" href=\"#\">google</a></li>
\n<li class=\"twitter\"><a class=\"fa fa-twitter\" title=\"twitter\" href=\"#\">twitter</a></li>
\n</ul>
\n</div>
\n<div class=\"content\">
\n<h3>Mr.Michale</h3>
\n<span class=\"job\">Ceo</span></div>
\n</div>
\n<div class=\"yt-content-slide\">
\n<div class=\"image\"><img src=\"images/homepage/member-2.jpg\" alt=\"\" />
\n<ul class=\"list-social list-inline\">
\n<li class=\"facebook\"><a class=\"fa fa-facebook\" title=\"facebook\" href=\"#\">facebook</a></li>
\n<li class=\"google\"><a class=\"fa fa-google-plus\" title=\"google\" href=\"#\">google</a></li>
\n<li class=\"twitter\"><a class=\"fa fa-twitter\" title=\"twitter\" href=\"#\">twitter</a></li>
\n</ul>
\n</div>
\n<div class=\"content\">
\n<h3>Roy Hamilton</h3>
\n<span class=\"job\">care workers</span></div>
\n</div>
\n<div class=\"yt-content-slide\">
\n<div class=\"image\"><img src=\"images/homepage/member-3.jpg\" alt=\"\" />
\n<ul class=\"list-social list-inline\">
\n<li class=\"facebook\"><a class=\"fa fa-facebook\" title=\"facebook\" href=\"#\">facebook</a></li>
\n<li class=\"google\"><a class=\"fa fa-google-plus\" title=\"google\" href=\"#\">google</a></li>
\n<li class=\"twitter\"><a class=\"fa fa-twitter\" title=\"twitter\" href=\"#\">twitter</a></li>
\n</ul>
\n</div>
\n<div class=\"content\">
\n<h3>Roy Hamilton</h3>
\n<span class=\"job\">care workers</span></div>
\n</div>
\n<div class=\"item\">
\n<div class=\"image\"><img src=\"images/homepage/member-1.jpg\" alt=\"\" />
\n<ul class=\"list-social list-inline\">
\n<li class=\"facebook\"><a class=\"fa fa-facebook\" title=\"facebook\" href=\"#\">facebook</a></li>
\n<li class=\"google\"><a class=\"fa fa-google-plus\" title=\"google\" href=\"#\">google</a></li>
\n<li class=\"twitter\"><a class=\"fa fa-twitter\" title=\"twitter\" href=\"#\">twitter</a></li>
\n</ul>
\n</div>
\n<div class=\"content\">
\n<h3>Mr.Michale</h3>
\n<span class=\"job\">Ceo</span></div>
\n</div>
\n</div>","5","",NULL,NULL,NULL,NULL,"0","mod_custom","1","0","{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("153","279","SJ Mega Menu Vertical - Arabic","","","1","sidebar-primary",NULL,NULL,"2017-05-26 08:57:51",NULL,"1","mod_sj_megamenu_res","1","0","{\"style_layout\":\"layout2\",\"show_heading_title\":\"0\",\"heading_title\":\"\",\"bg_menu\":\"#090909\",\"menutype\":\"menu-arabic\",\"menu_event\":\"hover\",\"moofx\":\"fade\",\"moofxtimeout\":\"150\",\"css_style\":\"1\",\"include_js\":\"1\",\"include_css\":\"1\",\"sub_animation\":\"menu-fade-in-up\",\"megamenutype\":\"vertical\",\"active\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"mobilemenutype\":\"sidebar\",\"tag_id\":\"container_menu1\",\"moduleclass_sfx\":\"\",\"layout\":\"_:default\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\"}","0","ar-AA"),
("155","281","Twitter Feeds","","","1","bottom4",NULL,NULL,"2017-04-26 02:39:51",NULL,"1","mod_sj_twitter_slider","1","1","{\"screenname\":\"smartaddons\",\"id_user\":\"321482620284321792\",\"count\":\"3\",\"display_avatars\":\"0\",\"display_follow_button\":\"0\",\"display_direction_button\":\"0\",\"start\":\"3\",\"play\":\"0\",\"interval\":\"5000\",\"pause_hover\":\"0\",\"effect\":\"fade\",\"swipe_enable\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"pretext\":\"\",\"posttext\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("157","283","Instagram","","","8","left",NULL,NULL,"2017-04-26 04:01:07",NULL,"1","mod_sj_instagram_gallery","1","1","{\"type_show\":\"simple\",\"nb_rows\":\"1\",\"nb-column1\":\"3\",\"nb-column2\":\"3\",\"nb-column3\":\"3\",\"nb-column4\":\"3\",\"title\":\"Instagram\",\"show_title\":\"0\",\"full_name\":\"1\",\"target\":\"_blank\",\"users_id\":\"8786444743\",\"access_token\":\"8786444743.1677ed0.3ed55b4cddad43d7857b79e9a80cab7a\",\"limit_image\":\"9\",\"autoplay\":\"1\",\"display_nav\":\"1\",\"display_loop\":\"1\",\"touchdrag\":\"1\",\"mousedrag\":\"1\",\"pausehover\":\"1\",\"autoplay_timeout\":\"5000\",\"autoplay_speed\":\"2000\",\"layout\":\"_:default\",\"pretext\":\"\",\"posttext\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("158","284","Home - Slideshow","","<div>[yt_content_slider style=\"default\" margin=\"0\" items_column0=\"1\" items_column1=\"1\" items_column2=\"1\" items_column3=\"1\" items_column4=\"1\" type_change=\"fade\" transitionin=\"fadeIn\" transitionout=\"fadeOut\" arrows=\"yes\" arrow_position=\"arrow-default\" pagination=\"yes\" autoplay=\"no\" autoheight=\"no\" hoverpause=\"yes\" lazyload=\"no\" loop=\"yes\" speed=\"0.6\" delay=\"4\" ] [yt_content_slider_item src=\"images/slideshow/slide1.jpg\" caption=\"yes\" link=\"#\" ]
\n<h3 class=\"title-small lora\">WELCOME TO iconstruct</h3>
\n<h2 class=\"title-lage\">Make Everything You Want</h2>
\n<p class=\"des\">“ It’s important to shape up your hedges, it’s like getting a haircut, stay fresh.”</p>
\n<a class=\"btn btn-default button-find\" href=\"#\">Read more</a> [/yt_content_slider_item] [yt_content_slider_item src=\"images/slideshow/slide2.jpg\" caption=\"yes\" link=\"#\" ]
\n<h3 class=\"title-small lora\">WELCOME TO iconstruct</h3>
\n<h2 class=\"title-lage\">Make Everything You Want</h2>
\n<p class=\"des\">“ It’s important to shape up your hedges, it’s like getting a haircut, stay fresh.”</p>
\n<a class=\"btn btn-default button-find\" href=\"#\">Read more</a> [/yt_content_slider_item] [yt_content_slider_item src=\"images/slideshow/slide3.jpg\" caption=\"yes\" link=\"#\" ]
\n<h3 class=\"title-small lora\">WELCOME TO iconstruct</h3>
\n<h2 class=\"title-lage\">Make Everything You Want</h2>
\n<p class=\"des\">“ It’s important to shape up your hedges, it’s like getting a haircut, stay fresh.”</p>
\n<a class=\"btn btn-default button-find\" href=\"#\">Read more</a> [/yt_content_slider_item] [/yt_content_slider]</div>","1","",NULL,NULL,NULL,NULL,"1","mod_custom","1","0","{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("159","285","Home - Our services","","<div class=\"sppb-addon-heading text-center\">
\n<p class=\"sppb-addon-title\">our services</p>
\n<h3 class=\"heading-title\">Bring the best things</h3>
\n<p class=\"heading-subtitle\">It’s important to use cocoa butter. It’s the key to more success, why not live smooth?</p>
\n</div>
\n<div class=\"sppb-addon-services row\">
\n<div class=\"col-sm-6 col-md-4\">
\n<div class=\"sppb-box-services\">
\n<div class=\"sppb-box-services-inner\">
\n<div class=\"box-services--icons\"><img src=\"images/homepage/do2.png\" alt=\"\" /></div>
\n<h3 class=\"box-services--title\">General Construction</h3>
\n<p>We are a fully accredited hospital by The Joint Commission, with a certified Level II Trauma Center...</p>
\n<a class=\"btn btn-default btn-services--readmore\" href=\"#\">Read more</a></div>
\n</div>
\n<div class=\"sppb-box-services\">
\n<div class=\"sppb-box-services-inner\">
\n<div class=\"box-services--icons\"><img src=\"images/homepage/do5.png\" alt=\"\" /></div>
\n<h3 class=\"box-services--title\">Electrical System</h3>
\n<p>We are a fully accredited hospital by The Joint Commission, with a certified Level II Trauma Center...</p>
\n<a class=\"btn btn-default btn-services--readmore\" href=\"#\">Read more</a></div>
\n</div>
\n</div>
\n<div class=\"col-sm-6 col-md-4\">
\n<div class=\"sppb-box-services\">
\n<div class=\"sppb-box-services-inner\">
\n<div class=\"box-services--icons\"><img src=\"images/homepage/do3.png\" alt=\"\" /></div>
\n<h3 class=\"box-services--title\">Renovation Project</h3>
\n<p>We are a fully accredited hospital by The Joint Commission, with a certified Level II Trauma Center...</p>
\n<a class=\"btn btn-default btn-services--readmore\" href=\"#\">Read more</a></div>
\n</div>
\n<div class=\"sppb-box-services\">
\n<div class=\"sppb-box-services-inner\">
\n<div class=\"box-services--icons\"><img src=\"images/homepage/do6.png\" alt=\"\" /></div>
\n<h3 class=\"box-services--title\">Consultation Projects</h3>
\n<p>We are a fully accredited hospital by The Joint Commission, with a certified Level II Trauma Center...</p>
\n<a class=\"btn btn-default btn-services--readmore\" href=\"#\">Read more</a></div>
\n</div>
\n</div>
\n<div class=\"col-sm-6 col-md-4\">
\n<div class=\"sppb-box-services\">
\n<div class=\"sppb-box-services-inner\">
\n<div class=\"box-services--icons\"><img src=\"images/homepage/do4.png\" alt=\"\" /></div>
\n<h3 class=\"box-services--title\">Interior &amp; Decor Design</h3>
\n<p>We are a fully accredited hospital by The Joint Commission, with a certified Level II Trauma Center...</p>
\n<a class=\"btn btn-default btn-services--readmore\" href=\"#\">Read more</a></div>
\n</div>
\n<div class=\"sppb-box-services\">
\n<div class=\"sppb-box-services-inner\">
\n<div class=\"box-services--icons\"><img src=\"images/homepage/do7.png\" alt=\"\" /></div>
\n<h3 class=\"box-services--title\">Project Partnering</h3>
\n<p>We are a fully accredited hospital by The Joint Commission, with a certified Level II Trauma Center...</p>
\n<a class=\"btn btn-default btn-services--readmore\" href=\"#\">Read more</a></div>
\n</div>
\n</div>
\n</div>","1","",NULL,NULL,"2017-11-23 15:37:56",NULL,"1","mod_custom","1","1","{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("160","286","Home - Our Product","","<div class=\"module my-work\">
\n<div class=\"modtitle\">
\n<h2>My Works</h2>
\n<p>The key to success is to keep your head above the water</p>
\n</div>
\n<div class=\"modcontent\">[yt_portfolio style=\"1\" padding=\"30\" source=\"category: 19\" limit=\"8\" intro_text_limit=\"50\" grid_type=\"8\" animation=\"fade\" speed=\"850\" rotate=\"99\" delay=\"20\" border=\"0px solid #000\" ]</div>
\n</div>","1","",NULL,NULL,NULL,NULL,"1","mod_custom","1","1","{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("161","287","Home - Faq","","<div class=\"sppb-addon-faq row\">
\n<div class=\"col-sm-5\"> </div>
\n<div class=\"col-md-7 col-sm-12\">
\n<div class=\"sppb-addon-heading \">
\n<p class=\"sppb-addon-title\">FAQ</p>
\n<h3 class=\"heading-title\">Additional Help</h3>
\n<p class=\"heading-subtitle\">It’s important to use cocoa butter. It’s the key to more success, why not live smooth? You should never complain, complaining is a weak emotion</p>
\n</div>
\n[yt_accordion align=\"left\" width=\"100\" style=\"basic\" color_background_active=\"yes\" item_active=\"1\" background_active=\"#ffb600\" color_active=\"#ffffff\" ] [yt_accordion_item yt_title=\"Nullam a lacus vel malesuada mollis nibh adipiscing sit litora ?\" icon=\"\" icon_color=\"#ccc\" icon_size=\"14\" color_title=\"#000\" color_desc=\"#fff\" background=\"#e3e3e3\" border_color=\"#ccc\" ] Placerat ipsum ut proin a dis nascetur suscipit a ullamcorper a magnis a scelerisque felis pretium himenaeos malesuada enim nostra non dapibu mattis nisl iaculis vivamus non ipsum ullamcorper. Convallis parturient curae rhoncus tempor in eget ullamcorper purus sociis ut ad viverra ipsum suspendisse. [/yt_accordion_item] [yt_accordion_item yt_title=\"Nullam a lacus vel malesuada mollis nibh adipiscing sit litora ?\" icon=\"\" icon_color=\"#ccc\" icon_size=\"14\" color_title=\"#000\" color_desc=\"#fff\" background=\"#e3e3e3\" border_color=\"#ccc\" ] Placerat ipsum ut proin a dis nascetur suscipit a ullamcorper a magnis a scelerisque felis pretium himenaeos malesuada enim nostra non dapibu mattis nisl iaculis vivamus non ipsum ullamcorper. Convallis parturient curae rhoncus tempor in eget ullamcorper purus sociis ut ad viverra ipsum suspendisse. [/yt_accordion_item] [yt_accordion_item yt_title=\"Nullam a lacus vel malesuada mollis nibh adipiscing sit litora ?\" icon=\"\" icon_color=\"#ccc\" icon_size=\"14\" color_title=\"#000\" color_desc=\"#fff\" background=\"#e3e3e3\" border_color=\"#ccc\" ] Placerat ipsum ut proin a dis nascetur suscipit a ullamcorper a magnis a scelerisque felis pretium himenaeos malesuada enim nostra non dapibu mattis nisl iaculis vivamus non ipsum ullamcorper. Convallis parturient curae rhoncus tempor in eget ullamcorper purus sociis ut ad viverra ipsum suspendisse. [/yt_accordion_item] [yt_accordion_item yt_title=\"Nullam a lacus vel malesuada mollis nibh adipiscing sit litora ?\" icon=\"\" icon_color=\"#ccc\" icon_size=\"14\" color_title=\"#000\" color_desc=\"#fff\" background=\"#e3e3e3\" border_color=\"#ccc\" ] Placerat ipsum ut proin a dis nascetur suscipit a ullamcorper a magnis a scelerisque felis pretium himenaeos malesuada enim nostra non dapibu mattis nisl iaculis vivamus non ipsum ullamcorper. Convallis parturient curae rhoncus tempor in eget ullamcorper purus sociis ut ad viverra ipsum suspendisse. [/yt_accordion_item] [/yt_accordion]</div>
\n</div>","1","",NULL,NULL,NULL,NULL,"1","mod_custom","1","1","{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("162","288","Our information","","<table class=\"header-info\">
\n<tbody>
\n<tr>
\n<td><i class=\"fa fa-map-marker\"> </i>
\n<h4>Our Address</h4>
\n<p>2381 Rosecrans Ave, CA USA</p>
\n</td>
\n<td><i class=\"fa fa-phone\"> </i>
\n<h4>Phone</h4>
\n<p>+67 7839 749 472</p>
\n</td>
\n<td><i class=\"fa fa-envelope\"> </i>
\n<h4>Email</h4>
\n<p>iconstruct@gmail.com</p>
\n</td>
\n<td><a class=\"btn btn-warning\" title=\"Get A Quote\" href=\"#\">Get A Quote</a></td>
\n</tr>
\n</tbody>
\n</table>","1","top3",NULL,NULL,NULL,NULL,"1","mod_custom","1","0","{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("163","289","Html Latest Blog","","<p>Box này sử dụng Module Content Latest Blog, nhưng do chưa cài vào</p>","1","",NULL,NULL,"2017-09-11 03:15:31",NULL,"-2","mod_custom","1","1","{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("164","290","Latest news","","","1","",NULL,NULL,NULL,NULL,"1","mod_sj_basic_news","1","1","{\"link_target\":\"_self\",\"catid\":[\"79\"],\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"show_front\":\"show\",\"article_ordering\":\"a.created\",\"article_ordering_direction\":\"ASC\",\"count\":\"3\",\"cat_title_display\":\"0\",\"title_display\":\"1\",\"item_title_max_characs\":\"50\",\"item_desc_display\":\"1\",\"item_desc_max_characs\":\"80\",\"item_date_display\":\"0\",\"item_readmore_display\":\"1\",\"item_readmore_text\":\"Read more\",\"showline\":\"0\",\"imgcfg_from_image_intro\":\"1\",\"imgcfg_from_image_fulltext\":\"1\",\"imgcfg_from_inline_introtext\":\"1\",\"imgcfg_from_inline_fulltext\":\"1\",\"imgcfg_from_external\":\"1\",\"imgcfg_external_url\":\"images\\/{id}.jpg\",\"imgcfg_order\":\"image_intro, image_fulltext, inline_introtext, inline_fulltext, external\",\"imgcfg_function\":\"resize_stretch\",\"imgcfg_type\":\"\",\"imgcfg_transparency\":\"1\",\"imgcfg_width\":\"370\",\"imgcfg_height\":\"250\",\"imgcfg_background\":\"\",\"imgcfg_placeholder\":\"1\",\"imgcfg_placeholder_path\":\"modules\\/mod_sj_basic_news\\/assets\\/images\\/nophoto.png\",\"moduleclass_sfx\":\"blog-home\",\"layout\":\"sj_iconstruct:homepage\",\"pretext\":\"<div class=\\\"sppb-addon-heading text-center \\\">\\r\\n<p class=\\\"sppb-addon-title\\\">insights & Articles<\\/p>\\r\\n<h3 class=\\\"heading-title\\\">Latest news<\\/h3>\\r\\n<p class=\\\"heading-subtitle\\\">It\\u2019s important to use cocoa butter. It\\u2019s the key to more success, why not live smooth?<\\/p>\\r\\n<\\/div>\",\"posttext\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("165","291","Contact Me","","","1","bottom1",NULL,NULL,"2017-09-06 14:53:56",NULL,"0","mod_sj_contact_ajax","1","1","{\"contact_id\":\"10\",\"email_copy_dis\":\"0\",\"facebook_dis\":\"0\",\"facebook_text\":\"\",\"twitter_dis\":\"0\",\"twitter_text\":\"\",\"rss_dis\":\"0\",\"rss_text\":\"\",\"linkedin_dis\":\"0\",\"linkedin_text\":\"\",\"google_plus_dis\":\"0\",\"google_plus_text\":\"\",\"captcha_dis\":\"0\",\"captcha_type\":\"1\",\"captcha_disable\":\"1\",\"maps_display\":\"0\",\"map_width\":\"500\",\"map_height\":\"300\",\"select_type\":\"0\",\"key_text\":\"AIzaSyAYvfhU3lQ4Z52FXziEBemhbiXzFycLj7U\",\"address_text\":\"Hanoi, Viet nam\",\"sLat\":\"21.0333333\",\"sLong\":\"105.85000000000002\",\"map_zoom\":\"3\",\"moduleclass_sfx\":\"contact-footer\",\"layout\":\"sj_personal:theme2\",\"pretext\":\"The key to success is to keep your head above the water\",\"posttext\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("166","292","Search sidebar left","","","3","left",NULL,NULL,"2017-09-12 02:02:22",NULL,"1","mod_search","1","0","{\"label\":\"\",\"width\":\"25\",\"text\":\"Enter your search...\",\"button\":\"1\",\"button_pos\":\"right\",\"imagebutton\":\"0\",\"button_text\":\"\",\"opensearch\":\"0\",\"opensearch_title\":\"\",\"set_itemid\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"search-aside-top\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("167","293","Recent Posts","","","5","right",NULL,NULL,"2017-09-12 02:43:12",NULL,"1","mod_sj_basic_news","1","1","{\"link_target\":\"_self\",\"catid\":[\"79\"],\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"show_front\":\"show\",\"article_ordering\":\"a.title\",\"article_ordering_direction\":\"ASC\",\"count\":\"4\",\"cat_title_display\":\"0\",\"title_display\":\"1\",\"item_title_max_characs\":\"50\",\"item_desc_display\":\"0\",\"item_desc_max_characs\":\"150\",\"item_date_display\":\"1\",\"item_readmore_display\":\"0\",\"item_readmore_text\":\"Read more\",\"showline\":\"0\",\"imgcfg_from_image_intro\":\"1\",\"imgcfg_from_image_fulltext\":\"1\",\"imgcfg_from_inline_introtext\":\"1\",\"imgcfg_from_inline_fulltext\":\"1\",\"imgcfg_from_external\":\"1\",\"imgcfg_external_url\":\"images\\/{id}.jpg\",\"imgcfg_order\":\"image_intro, image_fulltext, inline_introtext, inline_fulltext, external\",\"imgcfg_function\":\"resize_fill\",\"imgcfg_type\":\"\",\"imgcfg_transparency\":\"1\",\"imgcfg_width\":\"85\",\"imgcfg_height\":\"85\",\"imgcfg_background\":\"\",\"imgcfg_placeholder\":\"1\",\"imgcfg_placeholder_path\":\"modules\\/mod_sj_basic_news\\/assets\\/images\\/nophoto.png\",\"moduleclass_sfx\":\"blog-sidebar\",\"layout\":\"_:default\",\"pretext\":\"\",\"posttext\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\"}","0","*"),
("168","294","Recent Posts","","","6","left",NULL,NULL,"2017-09-12 02:43:12",NULL,"1","mod_sj_basic_news","1","1","{\"link_target\":\"_self\",\"catid\":[\"79\"],\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"show_front\":\"show\",\"article_ordering\":\"a.title\",\"article_ordering_direction\":\"ASC\",\"count\":\"4\",\"cat_title_display\":\"0\",\"title_display\":\"1\",\"item_title_max_characs\":\"50\",\"item_desc_display\":\"0\",\"item_desc_max_characs\":\"150\",\"item_date_display\":\"1\",\"item_readmore_display\":\"0\",\"item_readmore_text\":\"Read more\",\"showline\":\"0\",\"imgcfg_from_image_intro\":\"1\",\"imgcfg_from_image_fulltext\":\"1\",\"imgcfg_from_inline_introtext\":\"1\",\"imgcfg_from_inline_fulltext\":\"1\",\"imgcfg_from_external\":\"1\",\"imgcfg_external_url\":\"images\\/{id}.jpg\",\"imgcfg_order\":\"image_intro, image_fulltext, inline_introtext, inline_fulltext, external\",\"imgcfg_function\":\"resize_stretch\",\"imgcfg_type\":\"\",\"imgcfg_transparency\":\"1\",\"imgcfg_width\":\"85\",\"imgcfg_height\":\"85\",\"imgcfg_background\":\"\",\"imgcfg_placeholder\":\"1\",\"imgcfg_placeholder_path\":\"modules\\/mod_sj_basic_news\\/assets\\/images\\/nophoto.png\",\"moduleclass_sfx\":\"blog-sidebar\",\"layout\":\"sj_personal:default2\",\"pretext\":\"\",\"posttext\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("169","295","Instagram ","","","7","right",NULL,NULL,"2017-04-26 04:01:07",NULL,"1","mod_sj_instagram_gallery","1","1","{\"type_show\":\"simple\",\"nb_rows\":\"1\",\"nb-column1\":\"3\",\"nb-column2\":\"3\",\"nb-column3\":\"3\",\"nb-column4\":\"3\",\"title\":\"Instagram\",\"show_title\":\"0\",\"full_name\":\"1\",\"target\":\"_blank\",\"users_id\":\"8786444743\",\"access_token\":\"8786444743.1677ed0.3ed55b4cddad43d7857b79e9a80cab7a\",\"limit_image\":\"9\",\"autoplay\":\"1\",\"display_nav\":\"1\",\"display_loop\":\"1\",\"touchdrag\":\"1\",\"mousedrag\":\"1\",\"pausehover\":\"1\",\"autoplay_timeout\":\"5000\",\"autoplay_speed\":\"2000\",\"layout\":\"_:default\",\"pretext\":\"\",\"posttext\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("170","296","Archives","","<div class=\"archies-sidebar\">
\n<ul class=\"list-cat\">
\n<li><a href=\"#\">January 2017</a></li>
\n<li><a href=\"#\">February 2017</a></li>
\n<li><a href=\"#\">March 2017</a></li>
\n<li><a href=\"#\">April 2017</a></li>
\n<li><a href=\"#\">May 2017</a></li>
\n</ul>
\n</div>","9","right",NULL,NULL,"2017-09-12 03:15:59",NULL,"1","mod_custom","1","1","{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("171","297","Archives","","<div class=\"archies-sidebar\">
\n<ul class=\"list-cat\">
\n<li><a href=\"#\">January 2017</a></li>
\n<li><a href=\"#\">February 2017</a></li>
\n<li><a href=\"#\">March 2017</a></li>
\n<li><a href=\"#\">April 2017</a></li>
\n<li><a href=\"#\">May 2017</a></li>
\n</ul>
\n</div>","5","left",NULL,NULL,"2017-09-12 03:15:59",NULL,"1","mod_custom","1","1","{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("172","298","Working Time","","<table class=\"table-worktime\">
\n<tbody>
\n<tr>
\n<td>Mon</td>
\n<td class=\"td-time\">08:00 AM - 10:00 PM</td>
\n</tr>
\n<tr>
\n<td>Tue </td>
\n<td class=\"td-time\">08:00 AM - 10:00 PM</td>
\n</tr>
\n<tr>
\n<td>Wed</td>
\n<td class=\"td-time\">08:00 AM - 10:00 PM</td>
\n</tr>
\n<tr>
\n<td>Thur</td>
\n<td class=\"td-time\">08:00 AM - 10:00 PM </td>
\n</tr>
\n<tr>
\n<td>Fri</td>
\n<td class=\"td-time\">08:00 AM - 10:00 PM</td>
\n</tr>
\n<tr>
\n<td>Weekend</td>
\n<td class=\"td-time\">CLOSED</td>
\n</tr>
\n</tbody>
\n</table>","1","bottom2",NULL,NULL,NULL,NULL,"1","mod_custom","1","1","{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("173","299","Home - Our Awards","","<div class=\"sppb-addon-heading \">
\n<p class=\"sppb-addon-title\">our Awards</p>
\n<h3 class=\"heading-title\">be the best team</h3>
\n<p class=\"heading-subtitle\">It’s important to use cocoa butter. It’s the key to more success, why not live smooth?</p>
\n</div>
\n<p>[yt_content_slider style=\"default\" margin=\"15\" items_column0=\"3\" items_column1=\"2\" items_column2=\"2\" items_column3=\"1\" items_column4=\"1\" type_change=\"fade\" transitionin=\"fadeIn\" transitionout=\"fadeOut\" arrows=\"yes\" arrow_position=\"arrow-default\" pagination=\"no\" autoplay=\"no\" autoheight=\"no\" hoverpause=\"yes\" lazyload=\"no\" loop=\"yes\" speed=\"0.6\" delay=\"4\" ] [yt_content_slider_item src=\"images/homepage/award-3.jpg\" caption=\"yes\" link=\"#\" ] Archicture Award [/yt_content_slider_item] [yt_content_slider_item src=\"images/homepage/award-2.jpg\" caption=\"yes\" link=\"#\" ] Archicture Award [/yt_content_slider_item] [yt_content_slider_item src=\"images/homepage/award-1.jpg\" caption=\"yes\" link=\"#\" ] Archicture Award [/yt_content_slider_item] [/yt_content_slider]</p>","1","",NULL,NULL,NULL,NULL,"1","mod_custom","1","1","{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("175","301","We and our features ","","","1","",NULL,NULL,NULL,NULL,"1","mod_sj_news_extra_slider","1","1","{\"item_link_target\":\"_self\",\"button_page\":\"top\",\"theme\":\"style2\",\"nb-column0\":\"3\",\"nb-column1\":\"3\",\"nb-column2\":\"2\",\"nb-column3\":\"1\",\"nb-column4\":\"1\",\"nb_rows\":\"1\",\"catid\":[\"79\"],\"show_child_category_articles\":\"1\",\"levels\":\"1\",\"show_front\":\"show\",\"article_ordering\":\"a.title\",\"article_ordering_direction\":\"ASC\",\"count\":\"5\",\"title_slider_display\":\"1\",\"title_slider\":\"We and our features\",\"item_title_display\":\"1\",\"item_title_max_characs\":\"28\",\"item_desc_display\":\"1\",\"item_desc_max_characs\":\"120\",\"item_tags_display\":\"0\",\"item_readmore_display\":\"1\",\"item_readmore_text\":\"Read more\",\"imgcfg_from_image_intro\":\"1\",\"imgcfg_show_image_intro\":\"0\",\"imgcfg_from_image_fulltext\":\"1\",\"imgcfg_from_inline_introtext\":\"1\",\"imgcfg_from_inline_fulltext\":\"1\",\"imgcfg_from_external\":\"1\",\"imgcfg_order\":\"image_intro, image_fulltext, inline_introtext, inline_fulltext, external\",\"imgcfg_external_url\":\"images\\/{id}.jpg\",\"imgcfg_function\":\"resize_stretch\",\"imgcfg_type\":\"\",\"imgcfg_transparency\":\"1\",\"imgcfg_width\":\"370\",\"imgcfg_height\":\"215\",\"imgcfg_background\":\"#ffffff\",\"imgcfg_placeholder_path\":\"modules\\/mod_sj_news_extra_slider\\/assets\\/images\\/nophoto.jpg\",\"include_js\":\"0\",\"margin\":\"20\",\"slideBy\":\"3\",\"autoplay\":\"0\",\"autoplay_timeout\":\"5000\",\"pausehover\":\"1\",\"autoplay_speed\":\"2000\",\"startPosition\":\"0\",\"mousedrag\":\"1\",\"touchdrag\":\"1\",\"effect\":\"none\",\"dots\":\"0\",\"dotsSpeed\":\"500\",\"navs\":\"1\",\"navSpeed\":\"500\",\"duration\":\"600\",\"delay\":\"300\",\"moduleclass_sfx\":\"\",\"layout\":\"_:default\",\"pretext\":\"It\\u2019s important to use cocoa butter. It\\u2019s the key to more success, why not live smooth?\",\"posttext\":\" I\\u2019m keeping it real with you, so what you going do is have lunch. Fan luv. Let me be clear, you have to make it through the jungle to make it to paradise, that\\u2019s the key, Lion! Find peace, life is like a water fall, you\\u2019ve gotta flow. Stay focused. Look at the sunset, life is amazing, life is beautiful, life is what you make it.\",\"owncache\":\"1\",\"cache_time\":\"900\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\"}","0","*"),
("176","302","Home - Our Project","","<div>[yt_lightbox yt_title=\"\" align=\"left\" type=\"none\" style=\"none\" src=\"images/homepage/bg-video.jpg\" video_addr=\"https://www.youtube.com/watch?v=yJZ-Pqj-glU\" width=\"960px\" height=\"746px\"  lightbox=\"yes\" description=\"It’s important to use cocoa butter. It’s the key to more success, why not live smooth?\" ]</div>","1","",NULL,NULL,NULL,NULL,"1","mod_custom","1","1","{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("177","303","Home - Testimonials","","<div class=\"sppb-addon-heading text-center\">
\n<p class=\"sppb-addon-title\">Testimonials</p>
\n<h3 class=\"heading-title\">what’s client say ?</h3>
\n<p class=\"heading-subtitle\">It’s important to use cocoa butter. It’s the key to more success, why not live smooth?</p>
\n</div>
\n<p>[yt_content_slider style=\"default\" margin=\"15\" items_column0=\"3\" items_column1=\"3\" items_column2=\"2\" items_column3=\"2\" items_column4=\"1\" type_change=\"fade\" transitionin=\"fadeIn\" transitionout=\"fadeOut\" arrows=\"yes\" arrow_position=\"arrow-default\" pagination=\"no\" autoplay=\"no\" autoheight=\"no\" hoverpause=\"yes\" lazyload=\"no\" loop=\"yes\" speed=\"0.6\" delay=\"4\" ] [yt_content_slider_item src=\"images/homepage/award-3.jpg\" caption=\"yes\" link=\"#\" ] Archicture Award [/yt_content_slider_item] [yt_content_slider_item src=\"images/homepage/award-2.jpg\" caption=\"yes\" link=\"#\" ] Archicture Award [/yt_content_slider_item] [yt_content_slider_item src=\"images/homepage/award-1.jpg\" caption=\"yes\" link=\"#\" ] Archicture Award [/yt_content_slider_item] [/yt_content_slider]</p>","1","",NULL,NULL,NULL,NULL,"1","mod_custom","1","1","{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("178","304","Html - Contact Us","","<div class=\"sppb-addon-heading text-center\">
\n<p class=\"sppb-addon-title\">contact</p>
\n<h3 class=\"heading-title\">get in touch</h3>
\n</div>","1","",NULL,NULL,NULL,NULL,"0","mod_custom","1","1","{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("179","305","Smart Search","","","1","top4",NULL,NULL,NULL,NULL,"0","mod_finder","1","0","{\"searchfilter\":\"\",\"show_autosuggest\":\"1\",\"show_advanced\":\"0\",\"field_size\":25,\"show_label\":\"1\",\"label_pos\":\"left\",\"alt_label\":\"\",\"show_button\":\"0\",\"button_pos\":\"left\",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("180","306","Search Menu","","","1","top4",NULL,NULL,NULL,NULL,"1","mod_search","1","0","{\"label\":\"\",\"width\":\"17\",\"text\":\"\",\"button\":\"0\",\"button_pos\":\"left\",\"imagebutton\":\"0\",\"button_text\":\"\",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*"),
("181","0","Login Support","","","1","sidebar",NULL,NULL,NULL,NULL,"1","mod_loginsupport","1","1","{\"forum_url\":\"https://forum.joomla.org/\",\"documentation_url\":\"https://docs.joomla.org/\",\"news_url\":\"https://www.joomla.org/announcements.html\",\"automatic_title\":1,\"prepare_content\":1,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","1","*"),
("182","0","System Dashboard","","","1","cpanel-system",NULL,NULL,NULL,NULL,"1","mod_submenu","1","0","{\"menutype\":\"*\",\"preset\":\"system\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}","1","*"),
("183","0","Content Dashboard","","","1","cpanel-content",NULL,NULL,NULL,NULL,"1","mod_submenu","1","0","{\"menutype\":\"*\",\"preset\":\"content\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"3\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}","1","*"),
("184","0","Menus Dashboard","","","1","cpanel-menus",NULL,NULL,NULL,NULL,"1","mod_submenu","1","0","{\"menutype\":\"*\",\"preset\":\"menus\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}","1","*"),
("185","0","Components Dashboard","","","1","cpanel-components",NULL,NULL,NULL,NULL,"1","mod_submenu","1","0","{\"menutype\":\"*\",\"preset\":\"components\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}","1","*"),
("186","0","Users Dashboard","","","1","cpanel-users",NULL,NULL,NULL,NULL,"1","mod_submenu","1","0","{\"menutype\":\"*\",\"preset\":\"users\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}","1","*"),
("187","0","Popular Articles","","","3","cpanel-content",NULL,NULL,NULL,NULL,"1","mod_popular","3","1","{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\":\"12\"}","1","*"),
("188","0","Recently Added Articles","","","4","cpanel-content",NULL,NULL,NULL,NULL,"1","mod_latest","3","1","{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\":\"12\"}","1","*"),
("189","0","Logged-in Users","","","2","cpanel-users",NULL,NULL,NULL,NULL,"1","mod_logged","3","1","{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\":\"12\"}","1","*"),
("190","0","Frontend Link","","","5","status",NULL,NULL,NULL,NULL,"1","mod_frontend","1","1","","1","*"),
("191","0","Messages","","","4","status",NULL,NULL,NULL,NULL,"1","mod_messages","3","1","","1","*"),
("192","0","Post Install Messages","","","3","status",NULL,NULL,NULL,NULL,"1","mod_post_installation_messages","3","1","","1","*"),
("193","0","User Status","","","6","status",NULL,NULL,NULL,NULL,"1","mod_user","3","1","","1","*"),
("194","0","Site","","","1","icon",NULL,NULL,NULL,NULL,"1","mod_quickicon","1","1","{\"context\":\"site_quickicon\",\"header_icon\":\"fas fa-desktop\",\"show_users\":\"1\",\"show_articles\":\"1\",\"show_categories\":\"1\",\"show_media\":\"1\",\"show_menuItems\":\"1\",\"show_modules\":\"1\",\"show_plugins\":\"1\",\"show_templates\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}","1","*"),
("195","0","System","","","2","icon",NULL,NULL,NULL,NULL,"1","mod_quickicon","1","1","{\"context\":\"system_quickicon\",\"header_icon\":\"fas fa-wrench\",\"show_global\":\"1\",\"show_checkin\":\"1\",\"show_cache\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}","1","*"),
("196","0","3rd Party","","","4","icon",NULL,NULL,NULL,NULL,"1","mod_quickicon","1","1","{\"context\":\"mod_quickicon\",\"header_icon\":\"fas fa-boxes\",\"load_plugins\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}","1","*"),
("197","0","Help Dashboard","","","1","cpanel-help",NULL,NULL,NULL,NULL,"1","mod_submenu","1","0","{\"menutype\":\"*\",\"preset\":\"help\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"style\":\"System-none\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h2\",\"header_class\":\"\"}","1","*"),
("198","0","Privacy Requests","","","1","cpanel-privacy",NULL,NULL,NULL,NULL,"1","mod_privacy_dashboard","1","1","{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h2\",\"header_class\":\"\"}","1","*"),
("199","0","Privacy Status","","","1","cpanel-privacy",NULL,NULL,NULL,NULL,"1","mod_privacy_status","1","1","{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h2\",\"header_class\":\"\"}","1","*"),
("201","311","SP Page Builder","","","6","",NULL,NULL,NULL,NULL,"0","mod_sppagebuilder","1","1","","0","*"),
("202","313","Newsletter","","<div class=\"box-newsletter\">
\n<div class=\"introtext\">Subscribe to Our Newsletter</div>
\n<form class=\"form-inline newsletter\" action=\"#\" method=\"post\"><input class=\"input-large\" name=\"youremail\" size=\"18\" type=\"text\" value=\"Enter Your Email\" /> <button class=\"button btn\">Newsletter</button></form></div>","1","footer2",NULL,NULL,NULL,NULL,"1","mod_custom","1","0","{\"prepare_content\":0,\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\"}","0","*");


DROP TABLE IF EXISTS #__modules_menu;
CREATE TABLE `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__modules_menu VALUES
("1","101"),
("2","0"),
("3","0"),
("4","0"),
("6","0"),
("7","0"),
("8","0"),
("9","0"),
("10","0"),
("12","0"),
("13","0"),
("14","0"),
("15","0"),
("17","201"),
("17","255"),
("17","257"),
("17","259"),
("17","260"),
("17","262"),
("17","263"),
("17","267"),
("17","276"),
("17","278"),
("17","402"),
("17","403"),
("17","404"),
("17","405"),
("17","466"),
("17","492"),
("17","493"),
("17","494"),
("17","495"),
("17","496"),
("17","497"),
("17","498"),
("17","499"),
("17","500"),
("17","501"),
("17","504"),
("17","521"),
("17","533"),
("17","534"),
("17","535"),
("17","536"),
("17","537"),
("17","538"),
("17","539"),
("17","571"),
("17","572"),
("17","589"),
("17","590"),
("17","593"),
("17","602"),
("17","603"),
("17","604"),
("17","605"),
("17","607"),
("17","608"),
("17","609"),
("17","610"),
("17","611"),
("17","612"),
("17","613"),
("17","614"),
("17","617"),
("17","618"),
("17","619"),
("17","620"),
("17","621"),
("17","623"),
("17","624"),
("17","625"),
("17","626"),
("17","628"),
("17","629"),
("17","630"),
("17","631"),
("17","644"),
("17","645"),
("17","648"),
("17","657"),
("17","658"),
("17","659"),
("17","660"),
("17","662"),
("17","663"),
("17","664"),
("17","665"),
("17","666"),
("17","667"),
("17","668"),
("17","669"),
("17","672"),
("17","673"),
("17","674"),
("17","675"),
("17","676"),
("17","678"),
("17","679"),
("17","680");
INSERT INTO #__modules_menu VALUES
("17","681"),
("17","683"),
("17","684"),
("17","685"),
("17","686"),
("20","0"),
("22","234"),
("22","238"),
("22","242"),
("22","243"),
("22","244"),
("22","296"),
("22","399"),
("22","400"),
("25","294"),
("26","-463"),
("26","-462"),
("26","-433"),
("26","-432"),
("26","-431"),
("26","-430"),
("26","-429"),
("26","-427"),
("26","-400"),
("26","-399"),
("26","-296"),
("26","-244"),
("26","-243"),
("26","-242"),
("26","-238"),
("26","-234"),
("32","309"),
("35","0"),
("45","303"),
("57","238"),
("57","427"),
("57","429"),
("57","430"),
("57","431"),
("57","432"),
("57","433"),
("57","462"),
("57","463"),
("79","0"),
("86","0"),
("87","238"),
("87","427"),
("87","429"),
("87","430"),
("87","431"),
("87","432"),
("87","433"),
("87","462"),
("87","463"),
("91","0"),
("94","0"),
("95","0"),
("96","0"),
("97","0"),
("98","0"),
("99","0"),
("100","278"),
("100","492"),
("100","494"),
("100","495"),
("100","496"),
("100","497"),
("100","498"),
("100","499"),
("100","500"),
("100","501"),
("100","657"),
("100","658"),
("101","492"),
("102","493"),
("103","493"),
("104","493"),
("105","0"),
("107","0"),
("108","0"),
("109","0"),
("110","0"),
("128","0"),
("129","278"),
("129","492"),
("129","494"),
("129","495"),
("129","496"),
("129","497"),
("129","498"),
("129","499"),
("129","500"),
("129","501"),
("129","657"),
("129","658"),
("130","0"),
("136","0"),
("138","255"),
("138","257"),
("138","259");
INSERT INTO #__modules_menu VALUES
("138","260"),
("138","262"),
("138","263"),
("138","267"),
("138","276"),
("138","278"),
("138","402"),
("138","403"),
("138","404"),
("138","405"),
("138","466"),
("138","492"),
("138","493"),
("138","494"),
("138","495"),
("138","496"),
("138","497"),
("138","498"),
("138","499"),
("138","500"),
("138","501"),
("138","502"),
("138","504"),
("138","521"),
("138","533"),
("138","534"),
("138","535"),
("138","536"),
("138","537"),
("138","538"),
("138","539"),
("138","571"),
("138","572"),
("138","574"),
("138","575"),
("138","576"),
("138","577"),
("138","578"),
("138","579"),
("138","580"),
("138","581"),
("138","593"),
("138","602"),
("138","603"),
("138","605"),
("138","607"),
("138","608"),
("138","609"),
("138","610"),
("138","611"),
("138","612"),
("138","613"),
("138","614"),
("138","617"),
("138","618"),
("138","619"),
("138","620"),
("138","621"),
("138","648"),
("138","649"),
("138","650"),
("138","651"),
("138","652"),
("138","653"),
("138","654"),
("138","655"),
("138","656"),
("138","657"),
("138","658"),
("138","660"),
("138","662"),
("138","663"),
("138","664"),
("138","665"),
("138","666"),
("138","667"),
("138","668"),
("138","669"),
("138","672"),
("138","673"),
("138","674"),
("138","675"),
("138","676"),
("140","201"),
("140","255"),
("140","257"),
("140","259"),
("140","260"),
("140","262"),
("140","263"),
("140","267"),
("140","276"),
("140","278"),
("140","402"),
("140","403"),
("140","404"),
("140","405"),
("140","449"),
("140","450"),
("140","466");
INSERT INTO #__modules_menu VALUES
("140","492"),
("140","493"),
("140","494"),
("140","495"),
("140","496"),
("140","497"),
("140","498"),
("140","499"),
("140","500"),
("140","501"),
("140","502"),
("140","504"),
("140","521"),
("140","533"),
("140","534"),
("140","535"),
("140","536"),
("140","537"),
("140","538"),
("140","539"),
("140","571"),
("140","572"),
("140","574"),
("140","575"),
("140","576"),
("140","577"),
("140","578"),
("140","579"),
("140","580"),
("140","581"),
("140","593"),
("140","602"),
("140","603"),
("140","605"),
("140","607"),
("140","608"),
("140","609"),
("140","610"),
("140","611"),
("140","612"),
("140","613"),
("140","614"),
("140","617"),
("140","618"),
("140","619"),
("140","620"),
("140","621"),
("140","648"),
("140","649"),
("140","650"),
("140","651"),
("140","652"),
("140","653"),
("140","655"),
("140","656"),
("140","657"),
("140","658"),
("140","660"),
("140","662"),
("140","663"),
("140","664"),
("140","665"),
("140","666"),
("140","667"),
("140","668"),
("140","669"),
("140","672"),
("140","673"),
("140","674"),
("140","675"),
("140","676"),
("141","0"),
("143","0"),
("144","0"),
("146","0"),
("147","0"),
("148","0"),
("149","0"),
("150","0"),
("151","0"),
("152","255"),
("152","257"),
("152","259"),
("152","260"),
("152","262"),
("152","263"),
("152","267"),
("152","276"),
("152","278"),
("152","402"),
("152","403"),
("152","404"),
("152","405"),
("152","466"),
("152","492"),
("152","494"),
("152","495"),
("152","496"),
("152","497"),
("152","498");
INSERT INTO #__modules_menu VALUES
("152","499"),
("152","500"),
("152","501"),
("152","502"),
("152","571"),
("152","572"),
("152","574"),
("152","575"),
("152","576"),
("152","577"),
("152","578"),
("152","579"),
("152","580"),
("152","581"),
("153","0"),
("155","0"),
("157","493"),
("157","604"),
("157","659"),
("158","0"),
("159","0"),
("160","0"),
("161","0"),
("162","0"),
("163","0"),
("164","0"),
("165","0"),
("166","493"),
("166","659"),
("167","278"),
("167","492"),
("167","494"),
("167","495"),
("167","496"),
("167","497"),
("167","498"),
("167","499"),
("167","500"),
("167","501"),
("167","657"),
("167","658"),
("168","493"),
("168","659"),
("169","278"),
("169","492"),
("169","494"),
("169","495"),
("169","496"),
("169","497"),
("169","498"),
("169","499"),
("169","500"),
("169","501"),
("169","604"),
("169","657"),
("169","658"),
("170","278"),
("170","492"),
("170","494"),
("170","495"),
("170","496"),
("170","497"),
("170","498"),
("170","499"),
("170","500"),
("170","501"),
("170","657"),
("170","658"),
("171","493"),
("171","659"),
("172","0"),
("173","0"),
("175","0"),
("176","0"),
("177","0"),
("178","0"),
("179","0"),
("180","0"),
("181","0"),
("182","0"),
("183","0"),
("184","0"),
("185","0"),
("186","0"),
("187","0"),
("188","0"),
("189","0"),
("190","0"),
("191","0"),
("192","0"),
("193","0"),
("194","0"),
("195","0"),
("196","0"),
("197","0"),
("198","0"),
("199","0"),
("202","0");


DROP TABLE IF EXISTS #__postinstall_messages;
CREATE TABLE `#__postinstall_messages` (
  `postinstall_message_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `extension_id` bigint(20) NOT NULL DEFAULT '700' COMMENT 'FK to #__extensions',
  `title_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for the title',
  `description_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for description',
  `action_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language_extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'com_postinstall' COMMENT 'Extension holding lang keys',
  `language_client_id` tinyint(3) NOT NULL DEFAULT '1',
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'link' COMMENT 'Message type - message, link, action',
  `action_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'RAD URI to the PHP file containing action method',
  `action` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'Action method name or URL',
  `condition_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'RAD URI to file holding display condition method',
  `condition_method` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Display condition method, must return boolean',
  `version_introduced` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '3.2.0' COMMENT 'Version when this message was introduced',
  `enabled` tinyint(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`postinstall_message_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__postinstall_messages VALUES
("1","700","PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_TITLE","PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_BODY","PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_ACTION","plg_twofactorauth_totp","1","action","site://plugins/twofactorauth/totp/postinstall/actions.php","twofactorauth_postinstall_action","site://plugins/twofactorauth/totp/postinstall/actions.php","twofactorauth_postinstall_condition","3.2.0","1"),
("3","700","COM_CPANEL_WELCOME_BEGINNERS_TITLE","COM_CPANEL_WELCOME_BEGINNERS_MESSAGE","","com_cpanel","1","message","","","","","3.2.0","1"),
("6","700","COM_CPANEL_MSG_ROBOTS_TITLE","COM_CPANEL_MSG_ROBOTS_BODY","","com_cpanel","1","message","","","","","3.3.0","1"),
("7","700","COM_CPANEL_MSG_LANGUAGEACCESS340_TITLE","COM_CPANEL_MSG_LANGUAGEACCESS340_BODY","","com_cpanel","1","message","","","admin://components/com_admin/postinstall/languageaccess340.php","admin_postinstall_languageaccess340_condition","3.4.1","1"),
("8","700","COM_CPANEL_MSG_STATS_COLLECTION_TITLE","COM_CPANEL_MSG_STATS_COLLECTION_BODY","","com_cpanel","1","message","","","admin://components/com_admin/postinstall/statscollection.php","admin_postinstall_statscollection_condition","3.5.0","1"),
("9","700","PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME","PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_BODY","PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_ACTION","plg_system_updatenotification","1","action","site://plugins/system/updatenotification/postinstall/updatecachetime.php","updatecachetime_postinstall_action","site://plugins/system/updatenotification/postinstall/updatecachetime.php","updatecachetime_postinstall_condition","3.6.3","1"),
("14","700","COM_ACTIONLOGS_POSTINSTALL_TITLE","COM_ACTIONLOGS_POSTINSTALL_BODY","","com_actionlogs","1","message","","","","","3.9.0","1"),
("15","700","COM_PRIVACY_POSTINSTALL_TITLE","COM_PRIVACY_POSTINSTALL_BODY","","com_privacy","1","message","","","","","3.9.0","1"),
("16","700","COM_CPANEL_MSG_ADDNOSNIFF_TITLE","COM_CPANEL_MSG_ADDNOSNIFF_BODY","","com_cpanel","1","message","","","admin://components/com_admin/postinstall/addnosniff.php","admin_postinstall_addnosniff_condition","3.9.3","1"),
("17","700","COM_CPANEL_MSG_TEXTFILTER3919_TITLE","COM_CPANEL_MSG_TEXTFILTER3919_BODY","","com_cpanel","1","message","","","admin://components/com_admin/postinstall/textfilter3919.php","admin_postinstall_textfilter3919_condition","3.9.19","1"),
("18","700","COM_CPANEL_MSG_HTACCESSSVG_TITLE","COM_CPANEL_MSG_HTACCESSSVG_BODY","","com_cpanel","1","message","","","admin://components/com_admin/postinstall/htaccesssvg.php","admin_postinstall_htaccesssvg_condition","3.9.21","1"),
("19","700","COM_ADMIN_POSTINSTALL_MSG_HTACCESS_AUTOINDEX_TITLE","COM_ADMIN_POSTINSTALL_MSG_HTACCESS_AUTOINDEX_DESCRIPTION","","com_admin","1","message","","","","","3.9.22","1"),
("20","700","PLG_SYSTEM_HTTPHEADERS_POSTINSTALL_INTRODUCTION_TITLE","PLG_SYSTEM_HTTPHEADERS_POSTINSTALL_INTRODUCTION_BODY","PLG_SYSTEM_HTTPHEADERS_POSTINSTALL_INTRODUCTION_ACTION","plg_system_httpheaders","1","action","site://plugins/system/httpheaders/postinstall/introduction.php","httpheaders_postinstall_action","site://plugins/system/httpheaders/postinstall/introduction.php","httpheaders_postinstall_condition","4.0.0","1");


DROP TABLE IF EXISTS #__privacy_consents;
CREATE TABLE `#__privacy_consents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `state` int(10) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `remind` tinyint(4) NOT NULL DEFAULT '0',
  `token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS #__privacy_requests;
CREATE TABLE `#__privacy_requests` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `requested_at` datetime NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `request_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token_created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS #__spmedia;
CREATE TABLE `#__spmedia` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `thumb` varchar(255) NOT NULL DEFAULT '',
  `alt` varchar(255) NOT NULL DEFAULT '',
  `caption` varchar(2048) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `type` varchar(100) NOT NULL DEFAULT 'image',
  `media_attr` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '{}',
  `extension` varchar(100) NOT NULL DEFAULT '',
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

INSERT INTO #__spmedia VALUES
("1","ab3","images/2017/05/14/ab3.jpg","images/2017/05/14/_spmedia_thumbs/ab3.jpg","ab3","","","image","{}","com_sppagebuilder","2017-05-14 04:31:27","507","0000-00-00 00:00:00","0"),
("2","ab4","images/2017/05/14/ab4.jpg","images/2017/05/14/_spmedia_thumbs/ab4.jpg","ab4","","","image","{}","com_sppagebuilder","2017-05-14 04:31:27","507","0000-00-00 00:00:00","0"),
("5","chart","images/2017/05/14/chart.jpg","images/2017/05/14/_spmedia_thumbs/chart.jpg","chart","","","image","{}","com_sppagebuilder","2017-05-14 10:12:35","507","0000-00-00 00:00:00","0"),
("6","bg-testimonial","images/2017/05/14/bg-testimonial.jpg","images/2017/05/14/_spmedia_thumbs/bg-testimonial.jpg","bg-testimonial","","","image","{}","com_sppagebuilder","2017-05-14 10:12:35","507","0000-00-00 00:00:00","0"),
("7","8_about_us","images/2017/05/14/8_about_us.jpg","","8_about_us","","","image","{}","com_sppagebuilder","2017-05-14 10:26:19","507","0000-00-00 00:00:00","0"),
("9","bg-project","images/2017/09/04/bg-project.jpg","images/2017/09/04/_spmedia_thumbs/bg-project.jpg","bg-project","","","image","{}","com_sppagebuilder","2017-09-04 10:27:49","266","0000-00-00 00:00:00","0"),
("11","bg-whychoose","images/2017/11/24/bg-whychoose.jpg","images/2017/11/24/_spmedia_thumbs/bg-whychoose.jpg","bg-whychoose","","","image","{}","com_sppagebuilder","2017-11-24 15:18:00","621","0000-00-00 00:00:00","0"),
("12","bg-fqa","images/2017/11/24/bg-fqa.jpg","images/2017/11/24/_spmedia_thumbs/bg-fqa.jpg","bg-fqa","","","image","{}","com_sppagebuilder","2017-11-24 15:18:22","621","0000-00-00 00:00:00","0"),
("14","bg-contact","images/2017/11/26/bg-contact.jpg","images/2017/11/26/_spmedia_thumbs/bg-contact.jpg","bg-contact","","","image","{}","com_sppagebuilder","2017-11-26 01:21:42","621","0000-00-00 00:00:00","0"),
("15","user-1","images/2017/11/26/user-1.jpg","","user-1","","","image","{}","com_sppagebuilder","2017-11-26 04:24:37","621","0000-00-00 00:00:00","0"),
("16","bg-testimonial","images/2017/11/26/bg-testimonial.jpg","images/2017/11/26/_spmedia_thumbs/bg-testimonial.jpg","bg-testimonial","","","image","{}","com_sppagebuilder","2017-11-26 04:28:30","621","0000-00-00 00:00:00","0"),
("17","bg-portfolio","images/2017/11/26/bg-portfolio.jpg","images/2017/11/26/_spmedia_thumbs/bg-portfolio.jpg","bg-portfolio","","","image","{}","com_sppagebuilder","2017-11-26 08:15:43","621","0000-00-00 00:00:00","0");


DROP TABLE IF EXISTS #__sppagebuilder;
CREATE TABLE `#__sppagebuilder` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `text` mediumtext NOT NULL,
  `extension` varchar(255) NOT NULL DEFAULT 'com_sppagebuilder',
  `extension_view` varchar(255) NOT NULL DEFAULT 'page',
  `view_id` bigint(20) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(3) NOT NULL DEFAULT '1',
  `catid` int(10) NOT NULL DEFAULT '0',
  `access` int(10) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `checked_out` int(10) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[]',
  `og_title` varchar(255) NOT NULL DEFAULT '',
  `og_image` varchar(255) NOT NULL DEFAULT '',
  `og_description` varchar(255) NOT NULL DEFAULT '',
  `language` char(7) NOT NULL DEFAULT '',
  `hits` bigint(20) NOT NULL DEFAULT '0',
  `css` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO #__sppagebuilder VALUES
("1","312","Home","[{\"id\":1503971704128,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"1\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"slider-images\",\"padding\":\"0px 0px 0px 0px\",\"margin\":\"0px 0px 0px 0px\",\"color\":\"\",\"background_color\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":1503971704129,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1503971704132,\"name\":\"module\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"module_type\":\"module\",\"id\":\"158\",\"position\":\"\",\"class\":\"sppb-addon--slider\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\"}}]}]},{\"layout\":\"12\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h1\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":0,\"no_gutter\":0,\"id\":\"\",\"class\":\"wrapper-content\",\"padding\":{\"md\":\"50px  50px \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background_color\":\"rgba(247, 247, 247, 1)\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"inherit\",\"background_position\":\"50% 50%\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"columns_align_center\":0},\"id\":1492655064,\"visibility\":1,\"columns\":[{\"class_name\":\"col-md-12\",\"settings\":{\"color\":\"\",\"background\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"padding\":\"\",\"class\":\"main-content\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"0\",\"hidden_sm\":\"0\",\"hidden_md\":\"\",\"animation\":\"fadeInUp\",\"animationduration\":\"500\",\"animationdelay\":\"300\"},\"id\":1492655065,\"addons\":[{\"id\":1492658524370,\"name\":\"module\",\"visibility\":true,\"settings\":{\"admin_label\":\"Who we are ?\",\"title\":\"Who we are ?\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"module_type\":\"module\",\"id\":\"175\",\"position\":\"\",\"class\":\"module--extraslider1\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"1\",\"global_animation\":\"fadeIn\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\"}}],\"visibility\":1}],\"collapse\":false,\"title\":\"Row\"},{\"id\":1504165457685,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"\",\"padding\":\"50px 0px 40px 0px\",\"margin\":\"0px 0px 0px 0px\",\"color\":\"\",\"background_color\":\"rgba(51, 51, 51, 1)\",\"background_image\":\"images/2017/09/04/bg-project.jpg\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"contain\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"fadeInUp\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":1504165457686,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"color\":\"\",\"background\":\"\",\"background_image\":\"images/2017/09/04/bg-project.jpg\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"padding\":\"\",\"class\":\"\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1504165457684,\"name\":\"module\",\"visibility\":true,\"settings\":{\"admin_label\":\"Html Project Counter\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"module_type\":\"module\",\"id\":\"143\",\"position\":\"\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"1\",\"global_animation\":\"zoomIn\",\"global_animationduration\":\"598\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\"}}]}]},{\"id\":1504165457687,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"sppb-section--services\",\"padding\":\"80px 0px 60px 0px\",\"margin\":\"0px 0px 0px 0px\",\"color\":\"\",\"background_color\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"fadeInUp\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":1504165457688,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1504165457698,\"name\":\"module\",\"visibility\":true,\"settings\":{\"admin_label\":\"Our Services\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"module_type\":\"module\",\"id\":\"159\",\"position\":\"\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"1\",\"global_animation\":\"fadeIn\",\"global_animationduration\":\"700\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\"}}]}]},{\"id\":1504165457699,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"1\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"sppb-section--project\",\"padding\":\"82px 0px 0px 0px\",\"margin\":\"0px 0px 0px 0px\",\"color\":\"\",\"background_color\":\"rgba(247, 247, 247, 1)\",\"background_image\":\"images/2017/11/26/bg-portfolio.jpg\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"fadeInUp\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12,12\",\"columns\":[{\"id\":1511683766985,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1511683766988,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"our products\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"<div class=\\\"sppb-addon-heading text-center \\\">\\n<p class=\\\"sppb-addon-title\\\">our products</p>\\n<h3 class=\\\"heading-title\\\">The Latest Projects</h3>\\n<p class=\\\"heading-subtitle\\\">It’s important to use cocoa butter. It’s the key to more success, why not live smooth?</p>\\n</div>\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"global_text_color\":\"rgba(255, 255, 255, 1)\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\"}}]},{\"id\":1504165457700,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1504165457703,\"name\":\"module\",\"visibility\":true,\"settings\":{\"admin_label\":\"Our Product\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"module_type\":\"module\",\"id\":\"150\",\"position\":\"\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"1\",\"global_animation\":\"zoomInUp\",\"global_animationduration\":\"800\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\"}}]}]},{\"id\":1504167133101,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"\",\"padding\":\"90px 0px 45px 0px\",\"margin\":\"0px 0px 0px 0px\",\"color\":\"\",\"background_color\":\"\",\"background_image\":\"images/2017/11/24/bg-whychoose.jpg\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"contain\",\"background_attachment\":\"inherit\",\"background_position\":\"100% 100%\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"fadeInUpBig\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":1504167133102,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1504167133103,\"name\":\"module\",\"visibility\":true,\"settings\":{\"admin_label\":\"Why choose us ?\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"module_type\":\"module\",\"id\":\"141\",\"position\":\"\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"1\",\"global_animation\":\"fadeIn\",\"global_animationduration\":\"800\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\"}}]}]},{\"id\":1504165457712,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":0,\"no_gutter\":0,\"id\":\"\",\"class\":\" section-faq\",\"padding\":{\"md\":\"85px 0px 90px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background_color\":\"rgba(247, 247, 247, 1)\",\"background_image\":\"images/2017/11/24/bg-fqa.jpg\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"contain\",\"background_attachment\":\"inherit\",\"background_position\":\"0 100%\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animation\":\"fadeInUpBig\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"columns_align_center\":0},\"layout\":\"12\",\"columns\":[{\"id\":1504165457713,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1504165457714,\"name\":\"module\",\"visibility\":true,\"settings\":{\"admin_label\":\"Faq\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"module_type\":\"module\",\"id\":\"161\",\"position\":\"\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"1\",\"global_animation\":\"zoomInUp\",\"global_animationduration\":\"800\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\"}}]}]},{\"id\":1511542635718,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"\",\"padding\":\"80px 0px 70px 0px\",\"margin\":\"0px 0px 0px 0px\",\"color\":\"\",\"background_color\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"contain\",\"background_attachment\":\"inherit\",\"background_position\":\"100% 100%\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"zoomInUp\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":1511542635719,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1511683268756,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"Our Team\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"<div class=\\\"sppb-addon-heading text-center \\\">\\n<p class=\\\"sppb-addon-title\\\">Our team</p>\\n<h3 class=\\\"heading-title\\\">always be the best team</h3>\\n<p class=\\\"heading-subtitle\\\">It&rsquo;s important to use cocoa butter. It&rsquo;s the key to more success, why not live smooth?</p>\\n</div>\\n<div class=\\\"yt-content-slider  arrow-default  content-slider--team\\\" data-transitionin=\\\"fadeIn\\\" data-transitionout=\\\"fadeOut\\\" data-autoplay=\\\"no\\\" data-autoheight=\\\"no\\\" data-delay=\\\"4\\\" data-speed=\\\"0.6\\\" data-margin=\\\"30\\\" data-items_column0=\\\"3\\\" data-items_column1=\\\"3\\\" data-items_column2=\\\"2\\\" data-items_column3=\\\"1\\\" data-items_column4=\\\"1\\\" data-arrows=\\\"yes\\\" data-pagination=\\\"no\\\" data-lazyload=\\\"no\\\" data-loop=\\\"yes\\\" data-hoverpause=\\\"yes\\\">\\n<div class=\\\"yt-content-slide\\\">\\n<div class=\\\"image\\\"><img src=\\\"images/homepage/member-1.jpg\\\" alt=\\\"\\\" />\\n<ul class=\\\"list-social list-inline\\\">\\n<li class=\\\"facebook\\\"><a class=\\\"fa fa-facebook\\\" title=\\\"facebook\\\" href=\\\"#\\\">facebook</a></li>\\n<li class=\\\"google\\\"><a class=\\\"fa fa-google-plus\\\" title=\\\"google\\\" href=\\\"#\\\">google</a></li>\\n<li class=\\\"twitter\\\"><a class=\\\"fa fa-twitter\\\" title=\\\"twitter\\\" href=\\\"#\\\">twitter</a></li>\\n</ul>\\n</div>\\n<div class=\\\"content\\\">\\n<h3>Mr.Michale</h3>\\n<span class=\\\"job\\\">Ceo</span></div>\\n</div>\\n<div class=\\\"yt-content-slide\\\">\\n<div class=\\\"image\\\"><img src=\\\"images/homepage/member-2.jpg\\\" alt=\\\"\\\" />\\n<ul class=\\\"list-social list-inline\\\">\\n<li class=\\\"facebook\\\"><a class=\\\"fa fa-facebook\\\" title=\\\"facebook\\\" href=\\\"#\\\">facebook</a></li>\\n<li class=\\\"google\\\"><a class=\\\"fa fa-google-plus\\\" title=\\\"google\\\" href=\\\"#\\\">google</a></li>\\n<li class=\\\"twitter\\\"><a class=\\\"fa fa-twitter\\\" title=\\\"twitter\\\" href=\\\"#\\\">twitter</a></li>\\n</ul>\\n</div>\\n<div class=\\\"content\\\">\\n<h3>Roy Hamilton</h3>\\n<span class=\\\"job\\\">care workers</span></div>\\n</div>\\n<div class=\\\"yt-content-slide\\\">\\n<div class=\\\"image\\\"><img src=\\\"images/homepage/member-3.jpg\\\" alt=\\\"\\\" />\\n<ul class=\\\"list-social list-inline\\\">\\n<li class=\\\"facebook\\\"><a class=\\\"fa fa-facebook\\\" title=\\\"facebook\\\" href=\\\"#\\\">facebook</a></li>\\n<li class=\\\"google\\\"><a class=\\\"fa fa-google-plus\\\" title=\\\"google\\\" href=\\\"#\\\">google</a></li>\\n<li class=\\\"twitter\\\"><a class=\\\"fa fa-twitter\\\" title=\\\"twitter\\\" href=\\\"#\\\">twitter</a></li>\\n</ul>\\n</div>\\n<div class=\\\"content\\\">\\n<h3>Roy Hamilton</h3>\\n<span class=\\\"job\\\">care workers</span></div>\\n</div>\\n<div class=\\\"item\\\">\\n<div class=\\\"image\\\"><img src=\\\"images/homepage/member-1.jpg\\\" alt=\\\"\\\" />\\n<ul class=\\\"list-social list-inline\\\">\\n<li class=\\\"facebook\\\"><a class=\\\"fa fa-facebook\\\" title=\\\"facebook\\\" href=\\\"#\\\">facebook</a></li>\\n<li class=\\\"google\\\"><a class=\\\"fa fa-google-plus\\\" title=\\\"google\\\" href=\\\"#\\\">google</a></li>\\n<li class=\\\"twitter\\\"><a class=\\\"fa fa-twitter\\\" title=\\\"twitter\\\" href=\\\"#\\\">twitter</a></li>\\n</ul>\\n</div>\\n<div class=\\\"content\\\">\\n<h3>Mr.Michale</h3>\\n<span class=\\\"job\\\">Ceo</span></div>\\n</div>\\n</div>\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\"}}]}]},{\"id\":1511624346557,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"1\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"\",\"padding\":\"0px 0px 0px 0px\",\"margin\":\"0px 0px 0px 0px\",\"color\":\"\",\"background_color\":\"rgba(247, 247, 247, 1)\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"contain\",\"background_attachment\":\"inherit\",\"background_position\":\"100% 100%\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"6,6\",\"columns\":[{\"id\":1511624346558,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1511624346559,\"name\":\"module\",\"visibility\":true,\"settings\":{\"admin_label\":\"our Awards\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"module_type\":\"module\",\"id\":\"173\",\"position\":\"\",\"class\":\"sppb-addon--awards\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"1\",\"global_animation\":\"fadeIn\",\"global_animationduration\":\"800\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\"}}]},{\"id\":1511624346560,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1511624346565,\"name\":\"module\",\"visibility\":true,\"settings\":{\"admin_label\":\" Our project are Perfect\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"module_type\":\"module\",\"id\":\"176\",\"position\":\"\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\"}}]}]},{\"id\":1504165457704,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"sppb-section-testimonial\",\"padding\":\"80px 0px 27px 0px\",\"margin\":\"0px 0px 0px 0px\",\"color\":\"\",\"background_color\":\"\",\"background_image\":\"images/2017/11/26/bg-testimonial.jpg\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"50% 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":1504165457705,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1511667922955,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"Heading Testimonials\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"<div class=\\\"sppb-addon-heading text-center \\\">\\n<p class=\\\"sppb-addon-title\\\">testimonials</p>\\n<h3 class=\\\"heading-title\\\">what’s client say ?</h3>\\n<p class=\\\"heading-subtitle\\\">It’s important to use cocoa butter. It’s the key to more success, why not live smooth?</p>\\n</div>\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\"}},{\"id\":1511667922950,\"name\":\"testimonialpro\",\"visibility\":true,\"settings\":{\"autoplay\":\"0\",\"arrows\":\"1\",\"class\":\"\",\"sp_testimonialpro_item\":[{\"title\":\"Mr.Anna Hr\",\"avatar\":\"images/2017/11/26/user-1.jpg\",\"avatar_style\":\"\",\"message\":\"“In auctor ex id urna faucibus porttitor. Lorem ipsum dolor sit amet, consectetur adipiscing elit. In maximus ligula semper metus pellentesque mattis. Maecenas volutpat, diam enim sagittis quam, id porta quam. Sed id dolor consectetur fermentum nibh volutpat, accumsan purus”\",\"url\":\"Desugner\"},{\"title\":\"Mr.Anna Hr\",\"avatar\":\"images/2017/11/26/user-1.jpg\",\"avatar_style\":\"\",\"message\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\",\"url\":\"Web Design\"},{\"title\":\"Mr.Anna Hr\",\"avatar\":\"images/2017/11/26/user-1.jpg\",\"avatar_style\":\"\",\"message\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\",\"url\":\"Other Client\"}],\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\"}}]}]},{\"id\":1511667922943,\"visibility\":true,\"collapse\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"\",\"padding\":\"80px 0px 65px 0px\",\"margin\":\"0px 0px 0px 0px\",\"color\":\"\",\"background_color\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":1511667922944,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1511667922945,\"name\":\"module\",\"visibility\":true,\"settings\":{\"admin_label\":\"Latest Blog\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"module_type\":\"module\",\"id\":\"164\",\"position\":\"\",\"class\":\"sppb-addon-latestnew\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"1\",\"global_animation\":\"fadeInUp\",\"global_animationduration\":\"796\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\"}}]}]},{\"id\":1511656285252,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"sppb-section--contact\",\"padding\":\"60px 0px 75px 0px\",\"margin\":\"0px 0px 0px 0px\",\"color\":\"\",\"background_color\":\"rgba(247, 247, 247, 1)\",\"background_image\":\"images/2017/11/26/bg-contact.jpg\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"contain\",\"background_attachment\":\"inherit\",\"background_position\":\"50% 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12,12\",\"columns\":[{\"id\":1511656285253,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1511656285275,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"Contact Us\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"<div class=\\\"sppb-addon-heading text-center\\\">\\n<p class=\\\"sppb-addon-title\\\">contact</p>\\n<h3 class=\\\"heading-title\\\">get in touch</h3>\\n</div>\\n<ul class=\\\"list-inline sppb-addon--contactus\\\">\\n<li class=\\\"item\\\"><em class=\\\"fa fa-map-marker\\\">&nbsp;</em>\\n<h4>Our Address</h4>\\n<p>2381 Rosecrans Ave, CA USA 452 Washington, USA</p>\\n<a class=\\\"contact--link\\\" href=\\\"#\\\">Directions</a></li>\\n<li class=\\\"item\\\"><em class=\\\"fa fa-envelope\\\">&nbsp;</em>\\n<h4>Contact Info</h4>\\n<p>iconstruct@gmail.com</p>\\n<p>+67 7839 749 472</p>\\n<a class=\\\"contact--link\\\" href=\\\"#\\\">Send a Message</a></li>\\n<li class=\\\"item\\\"><em class=\\\"fa fa-life-ring\\\">&nbsp;</em>\\n<h4>Our Support</h4>\\n<p>Email support :iconstructsupport@gmail.com</p>\\n<a class=\\\"contact--link\\\" href=\\\"#\\\">one a ticket</a></li>\\n</ul>\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\"}}]},{\"id\":1511656285258,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1511656285262,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"Brands Logo\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"<div class=\\\"sppb-addon--brand\\\">\\n<div class=\\\"item\\\"><a href=\\\"#\\\"><img src=\\\"images/homepage/brand-1.jpg\\\" alt=\\\"brand-1\\\" /></a></div>\\n<div class=\\\"item\\\"><a href=\\\"#\\\"><img src=\\\"images/homepage/brand-2.jpg\\\" alt=\\\"brand-2\\\" /></a></div>\\n<div class=\\\"item\\\"><a href=\\\"#\\\"><img src=\\\"images/homepage/brand-3.jpg\\\" alt=\\\"brand-3\\\" /></a></div>\\n<div class=\\\"item\\\"><a href=\\\"#\\\"><img src=\\\"images/homepage/brand-4.jpg\\\" alt=\\\"brand-4\\\" /></a></div>\\n<div class=\\\"item\\\"><a href=\\\"#\\\"><img src=\\\"images/homepage/brand-5.jpg\\\" alt=\\\"brand-5\\\" /></a></div>\\n<div class=\\\"item\\\"><a href=\\\"#\\\"><img src=\\\"images/homepage/brand-1.jpg\\\" alt=\\\"brand-1\\\" /></a></div>\\n</div>\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\"}}]}]}]","com_sppagebuilder","page","0","0","1","0","1","0","2015-01-22 07:12:35","739","2022-02-09 10:33:32","739","0","0000-00-00 00:00:00","[]","","","","*","7830",""),
("2","0","Corporate","[{\"layout\":\"6,6\",\"settings\":{\"title\":\"\",\"heading_selector\":\"h1\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"images/slider.jpg\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"inherit\",\"background_position\":\"50% 50%\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"10px 0 0\",\"margin\":\"\",\"fullscreen\":0},\"id\":1481002171,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-6\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInLeftBig\",\"animationduration\":300,\"animationdelay\":300,\"class\":\"\"},\"id\":1481002172,\"addons\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481002173,\"settings\":{\"gap\":\"100\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481002174,\"settings\":{\"admin_label\":\"\",\"title\":\"Clean and Unique Free  Joomla Template\",\"heading_selector\":\"h3\",\"title_position\":\"before\",\"title_fontsize\":\"48\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"#333333\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"\",\"icon_size\":\"\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Lorem ipsum dolor sit amet consectetur adipisicing elit sed do eiusmod temporconsectetur adipisicing elit sed do.\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\"},\"visibility\":1},{\"name\":\"button\",\"title\":\"Button\",\"id\":1481002175,\"settings\":{\"admin_label\":\"\",\"text\":\"Download Now!\",\"fontstyle\":null,\"letterspace\":\"0\",\"url\":\"http://www.joomshaper.com/helix\",\"target\":\"_blank\",\"type\":\"primary\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#ffffff\",\"background_color_hover\":\"#222222\",\"color_hover\":\"#ffffff\",\"size\":\"lg\",\"shape\":\"rounded\",\"block\":\"\",\"icon\":\"\",\"icon_position\":\"left\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"30px 0px 0px 0px\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-6\",\"settings\":{\"class\":\"\",\"animationdelay\":300,\"animationduration\":300,\"animation\":\"fadeInRightBig\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481002176,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1481002177,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/slide1.png\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"title\":\"Our Services\",\"heading_selector\":\"h2\",\"title_fontsize\":36,\"title_text_color\":\"\",\"title_margin_top\":0,\"title_margin_bottom\":20,\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"#f5f5f5\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"100px 0px\",\"margin\":\"0px \",\"fullscreen\":0},\"id\":1481002178,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":300,\"animationdelay\":100,\"class\":\"\"},\"id\":1481002179,\"addons\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481002180,\"settings\":{\"gap\":\"50\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481002181,\"settings\":{\"title\":\"Fully Responsive\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-laptop\",\"icon_size\":\"42\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"0\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine chuck flank tritip picola kevin filet mignon\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":300,\"animationdelay\":200,\"class\":\"\"},\"id\":1481002182,\"addons\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481002183,\"settings\":{\"gap\":\"50\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481002184,\"settings\":{\"title\":\"Unique Design\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-dashboard\",\"icon_size\":\"42\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"0\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine chuck flank tritip picola kevin filet mignon\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":300,\"animationdelay\":300,\"class\":\"\"},\"id\":1481002185,\"addons\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481002186,\"settings\":{\"gap\":\"50\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481002187,\"settings\":{\"title\":\"Easy to Customize\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-gear\",\"icon_size\":\"42\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"0\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine chuck flank tritip picola kevin filet mignon\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":300,\"animationdelay\":400,\"class\":\"\"},\"id\":1481002188,\"addons\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481002189,\"settings\":{\"gap\":\"50\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481002190,\"settings\":{\"title\":\"Awesome Support\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-envelope\",\"icon_size\":\"42\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"0\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine chuck flank tritip picola kevin filet mignon\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"background_attachment\":\"inherit\",\"fullscreen\":1,\"margin\":\"0px\",\"padding\":\"0px\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 50%\",\"background_size\":\"contain\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontsize\":\"\",\"title\":\"\"},\"id\":1481002191,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481002192,\"addons\":[{\"name\":\"image_content\",\"title\":\"Image Content\",\"id\":1481002193,\"settings\":{\"admin_label\":\"\",\"image\":\"images/corporate.jpg\",\"image_alignment\":\"left\",\"title\":\"We Build our products to Represent our Values\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"<br />The Helix Framework is one of the best light and feature rich responsive framework for Joomla templating. It is so easy to develop and control of Joomla templates for you and your clients. Helix framework will make your experience of creating website much smoother than ever before.<br /><br /