<?php
/**
 * @package Sj Responsive Listing for JoomShopping
 * @version 1.0.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @copyright (c) 2012 YouTech Company. All Rights Reserved.
 * @author YouTech Company http://www.smartaddons.com
 */

defined('_JEXEC') or die;

if(!class_exists('plgSystemX_Sj_Js_ResListing_Ajax')){
	echo '<b>'.JText::_('WARNING_NOT_INSTALL_PLUGIN').'</b>';
	return ;
}

if (!defined('DS')) {
	define('DS', DIRECTORY_SEPARATOR);
}

require_once dirname(__FILE__).'/core/helper.php';

$layout = $params->get('layout', 'default');
$cacheid = md5(serialize(array ($layout, $module->id)));
$cacheparams = new stdClass;
$cacheparams->cachemode = 'id';
$cacheparams->class = 'JSResponsiveListingHelper';
$cacheparams->method = 'getList';
$cacheparams->methodparams = $params;
$cacheparams->modeparams = $cacheid;
$list = JModuleHelper::moduleCache ($module, $params, $cacheparams);
//var_dump($list['items']);
$is_ajax = !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';
if($is_ajax){
	$app = \JFactory::getApplication();
	$sj_module_id	= $app->input->getVar('sj_module_id', null);
	if($sj_module_id == $module->id){
		$result = new stdClass();
		ob_start();
		require  JModuleHelper::getLayoutPath($module->module, $layout.'_items');
		$buffer = ob_get_contents();
		$result->items_markup = preg_replace(
				array(
						'/ {2,}/',
						'/<!--.*?-->|\t|(?:\r?\n[ \t]*)+/s'
				),
				array(
						' ',
						''
				),
				$buffer
		);
		ob_end_clean();
		die(json_encode($result));
	}
}else{
	require JModuleHelper::getLayoutPath($module->module, $layout);
	require JModuleHelper::getLayoutPath($module->module, $layout.'_js');
}
