<?php

/**
 * @version    1.0.0
 * @package    Com_Sj_newsletter
 * @author     YouTech Company <contact@ytcvn.com>
 * @copyright  Copyright (c) 2016 YouTech Company
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

/**
 * Sj_newsletter helper.
 *
 * @since  1.6
 */
class Sj_newsletterHelper
{
	/**
	 * Configure the Linkbar.
	 *
	 * @param   string  $vName  string
	 *
	 * @return void
	 */
	public static function addSubmenu($vName = '')
	{
		JHtmlSidebar::addEntry(
			JText::_('COM_SJ_NEWSLETTER_TITLE_EMAILS'),
			'index.php?option=com_sj_newsletter&view=emails',
			$vName == 'emails'
		);
		JHtmlSidebar::addEntry(
			JText::_('COM_SJ_NEWSLETTER_TITLE_EMAILCONTENTS'),
			'index.php?option=com_sj_newsletter&view=emailcontents',
			$vName == 'emailcontents'
		);

	}

	/**
	 * Gets a list of the actions that can be performed.
	 *
	 * @return    JObject
	 *
	 * @since    1.6
	 */
	public static function getActions()
	{
		$user   = JFactory::getUser();
		$result = new JObject;

		$assetName = 'com_sj_newsletter';

		$actions = array(
			'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 'core.delete'
		);

		foreach ($actions as $action)
		{
			$result->set($action, $user->authorise($action, $assetName));
		}

		return $result;
	}
}
