<?php
/**
 * @version    1.0.0
 * @package    Com_Sj_newsletter
 * @author     YouTech Company <contact@ytcvn.com>
 * @copyright  Copyright (c) 2016 YouTech Company
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access.
defined('_JEXEC') or die;

jimport('joomla.application.component.controlleradmin');

use Joomla\Utilities\ArrayHelper;

/**
 * Emails list controller class.
 *
 * @since  1.6
 */
class Sj_newsletterControllerEmails extends JControllerAdmin
{
	/**
	 * Method to clone existing Emails
	 *
	 * @return void
	 */
	public function duplicate()
	{
		// Check for request forgeries
		Jsession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		// Get id(s)
		$pks = $this->input->post->get('cid', array(), 'array');

		try
		{
			if (empty($pks))
			{
				throw new Exception(JText::_('COM_SJ_NEWSLETTER_NO_ELEMENT_SELECTED'));
			}

			ArrayHelper::toInteger($pks);
			$model = $this->getModel();
			$model->duplicate($pks);
			$this->setMessage(Jtext::_('COM_SJ_NEWSLETTER_ITEMS_SUCCESS_DUPLICATED'));
		}
		catch (Exception $e)
		{
			JFactory::getApplication()->enqueueMessage($e->getMessage(), 'warning');
		}

		$this->setRedirect('index.php?option=com_sj_newsletter&view=emails');
	}

	/**
	 * Proxy for getModel.
	 *
	 * @param   string  $name    Optional. Model name
	 * @param   string  $prefix  Optional. Class prefix
	 * @param   array   $config  Optional. Configuration array for model
	 *
	 * @return  object	The Model
	 *
	 * @since    1.6
	 */
	public function getModel($name = 'email', $prefix = 'Sj_newsletterModel', $config = array())
	{
		$model = parent::getModel($name, $prefix, array('ignore_request' => true));

		return $model;
	}

	/**
	 * Method to save the submitted ordering values for records via AJAX.
	 *
	 * @return  void
	 *
	 * @since   3.0
	 */
	public function saveOrderAjax()
	{
		// Get the input
		$input = JFactory::getApplication()->input;
		$pks   = $input->post->get('cid', array(), 'array');
		$order = $input->post->get('order', array(), 'array');

		// Sanitize the input
		ArrayHelper::toInteger($pks);
		ArrayHelper::toInteger($order);

		// Get the model
		$model = $this->getModel();

		// Save the ordering
		$return = $model->saveorder($pks, $order);

		if ($return)
		{
			echo "1";
		}

		// Close the application
		JFactory::getApplication()->close();
	}
	public function saveId()
	{
		$id = JFactory::getApplication()->input->getInt('id', 0);
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->update("#__sj_newsletter_email_content_id as a");
		$query->set("a.id_content_mail='$id'");
		$query->where("a.id=1");
		$db->setQuery($query);
		$db->execute();
	}
	function deleteitem(){
		//$app    = JFactory::getApplication();
		//$id     = $app->input->get('id',0,'int');
		$id = JFactory::getApplication()->input->getInt('id', 0);

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->delete("#__sj_newsletter_email");
		$query->where("id =".$id);
		$db->setQuery($query);
		$db->execute();
		$this->setRedirect ( 'index.php?option=com_sj_newsletter&view=emails');
	}
	public function revert()
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->update("#__sj_newsletter_email as a");
		$query->set("a.confirm_mail=0");
		$db->setQuery($query);
		$db->execute();
		$this->setRedirect ( 'index.php?option=com_sj_newsletter&view=emails');
	}
	public function sendall()
	{
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select("e.email");
		$query->from("#__sj_newsletter_email as e");
		$query->where("e.confirm_mail=0");
		$db->setQuery($query);
		$data =  $db->loadObjectList();
		if($data != null){
			foreach($data as $d){
				$recipient[]=$d->email;
			}
			//
			$query1 = $db->getQuery(true);
			$query1->select("c.*");
			$query1->from("#__sj_newsletter_email_content_id as cid");
			$query1->leftJoin("#__sj_newsletter_email_content AS c ON cid.id_content_mail = c.id");
			$query1->where("c.state=1");
			$db->setQuery($query1);
			$data_cid =  $db->loadObjectList();
			//update confirm mail
			$query2 = $db->getQuery(true);
			$query2->update("#__sj_newsletter_email as b");
			$query2->set("b.confirm_mail=1");
			$db->setQuery($query2);
			$db->execute();
			// Send email
			$mailer = JFactory::getMailer();
			$config = JFactory::getConfig();
			$from   = $config->get('mailfrom');
			$fromname = $data_cid[0]->email_send_from_name;
			$sender = array(
				$from,
				$fromname
			);
			//my config
			$mailer->setSender($sender);
			$mailer->Subject= $data_cid[0]->email_customer_subject;
			$mailer->addRecipient($recipient);

			$mailer->isHTML(true);
			$mailer->setBody($data_cid[0]->email_customer_body);

			// Optionally add embedded image
			$mailer->AddEmbeddedImage( JPATH_COMPONENT.'/assets/logo128.jpg', 'logo_id', 'logo.jpg', 'base64', 'image/jpeg' );
			$send = $mailer->Send();
			if ( $send !== true ) {
				$message = "0";
			} else {
				$message = "1";
			}
		}else{
			$message = "2";
		}
		die (json_encode($message));
	}
	public function sendselect()
	{
		$cids[]= $_POST['cid'];
		$items = [];
		foreach ($cids[0] as $cid)
		{
			$db = JFactory::getDBO();
			$query = $db->getQuery(true);
			$query->select("e.email");
			$query->from("#__sj_newsletter_email as e");
			$query->where("e.id=".$cid);
			$query->where("e.confirm_mail=0");
			$db->setQuery($query);
			$items[] = $db->loadObjectList();
			//update confirm mail
			$query2 = $db->getQuery(true);
			$query2->update("#__sj_newsletter_email as b");
			$query2->set("b.confirm_mail=1");
			$query2->where("b.id=".$cid);
			$db->setQuery($query2);
			$db->execute();
		}

		foreach($items as $item){
			$recipient[]=$item[0]->email;
		}
		//if($recipient != null){
			$query1 = $db->getQuery(true);
			$query1->select("c.*");
			$query1->from("#__sj_newsletter_email_content_id as cid");
			$query1->leftJoin("#__sj_newsletter_email_content AS c ON cid.id_content_mail = c.id");
			$query1->where("c.state=1");
			$db->setQuery($query1);
			$data_cid =  $db->loadObjectList();

			// Send email
			$mailer = JFactory::getMailer();
			$config = JFactory::getConfig();
			$from   = $config->get('mailfrom');
			$fromname = $data_cid[0]->email_send_from_name;
			$sender = array(
				$from,
				$fromname
			);
			//my config
			$mailer->setSender($sender);
			$mailer->Subject= $data_cid[0]->email_customer_subject;
			$mailer->addRecipient($recipient);

			$mailer->isHTML(true);
			$mailer->setBody($data_cid[0]->email_customer_body);

			// Optionally add embedded image
			$mailer->AddEmbeddedImage( JPATH_COMPONENT.'/assets/logo128.jpg', 'logo_id', 'logo.jpg', 'base64', 'image/jpeg' );
			$send = $mailer->Send();
			if ( $send !== true ) {
				$message = "0";
			} else {
				$message = "1";
			}
		//}else{
			//$message = "2";
		//}
		die (json_encode($message));
	}
	public function sendone()
	{
		$id = JFactory::getApplication()->input->getInt('id', 0);
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select("e.*");
		$query->from("#__sj_newsletter_email as e");
		$query->where("e.id=".$id);
		$query->where("e.confirm_mail=0");
		$db->setQuery($query);
		$data =  $db->loadObjectList();
		if($data != null){
			// get id content mail
			$query1 = $db->getQuery(true);
			$query1->select("c.*");
			$query1->from("#__sj_newsletter_email_content_id as cid");
			$query1->leftJoin("#__sj_newsletter_email_content AS c ON cid.id_content_mail = c.id");
			$query1->where("c.state=1");
			$db->setQuery($query1);
			$data_cid =  $db->loadObjectList();
			//update confirm mail
			$query2 = $db->getQuery(true);
			$query2->update("#__sj_newsletter_email as b");
			$query2->set("b.confirm_mail=1");
			$query2->where("b.id=".$id);
			$db->setQuery($query2);
			$db->execute();
			// Send email
			$mailer = JFactory::getMailer();
			$config = JFactory::getConfig();
			$from   = $config->get('mailfrom');
			$fromname = $data_cid[0]->email_send_from_name;
			$sender = array(
				$from,
				$fromname
			);
			//my config
			$mailer->setSender($sender);
			$mailer->Subject= $data_cid[0]->email_customer_subject;
			$mailer->addRecipient($data[0]->email);

			$mailer->isHTML(true);
			$mailer->setBody($data_cid[0]->email_customer_body);

			// Optionally add embedded image
			$mailer->AddEmbeddedImage( JPATH_COMPONENT.'/assets/logo128.jpg', 'logo_id', 'logo.jpg', 'base64', 'image/jpeg' );
			$send = $mailer->Send();
			if ( $send !== true ) {
				$message = "0";
			} else {
				$message = "1";
			}
		}else{
			$message = "2";
		}
		die (json_encode($message));
	}
}
