<?php
/**
 * @package Sj Responsive Listing for JoomShopping
 * @version 1.0.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @copyright (c) 2012 YouTech Company. All Rights Reserved.
 * @author YouTech Company http://www.smartaddons.com
 */

defined('_JEXEC') or die;

include_once dirname(__FILE__).'/helper_base.php';

class JSResponsiveListingHelper extends JSResponsiveListingBaseHelper{
	public static $total = null;
	public static function getList(&$params)
	{
		$db = JFactory::getDBO();
		$jshopConfig = JSFactory::getConfig();
		$jshopConfig->cur_lang = $jshopConfig->frontend_lang;
		JSFactory::loadCssFiles();
		JSFactory::loadLanguageFile();
		$langName = JFactory::getLanguage()->getTag();	
		$lang = \JSFactory::getLang($langName);
		$jshopConfig = JSFactory::getConfig();
		
		$filters = array();
		$order_by = $params->get('source_order_by');
		$itemsOrdering_display = $params->get('itemsOrdering_display');
		if(!empty($itemsOrdering_display) && !in_array($order_by,$itemsOrdering_display)){
			$order_by = $itemsOrdering_display[0];
		}else{
		
		}
		if( $order_by == 'name' ){
			$order_by = "prod.`".$lang->get('name')."`";
		}
		$order_dir = $params->get('product_order_dir');
		
		$app = JFactory::getApplication();
		$appParams = $app->getParams();
		$source_limit = '';
		$limitation = (int)$params->get('source_limit');
		$limit_start = $app->input->getInt('ajax_reslisting_start',0);
		$field_sort = $params->get('sort', 'id');
		$ordering = $params->get('ordering', 'asc');
		$count_cat= (int)$params->get('count_cat',10);
		$catidpreload = $params->get('catidpreload')[0];
	
		$catids = $params->get('catids');
		$_catids = array();
		$list = array();
		$retur = array();
		if(!empty($catids)){
			if(in_array($catidpreload,$catids)){
				array_unshift($catids,$catidpreload);				
			}
			$filters['categorys'] = array_unique($catids);
			$catid = implode(", ", $catids);
		    $product =\JSFactory::getModel('vendor', 'Site\\Productlist');
		    $productNew = \JSFactory::getTable('product');					
			$products = \JSFactory::getModel("products");
			self::$total = $products->getCountAllProducts($filters);
			
			$categories = self::getCategory($catid,$field_sort,$ordering,1);
			
			if(!empty($categories)){
				foreach($categories as $i=> $category){
					//$cat->_description = self::_cleanText($cat->description);
					//self::getJSCImages($item, $params,'imgcfgcat');				
					$category->count = 3;
					$list[$category->category_id] = $category;
				}			
				$retur['categories'] = $list;			
				//var_dump($retur['categories']);return;			
				$items = \JSFactory::getModel("products")->getAllProducts(array_unique($filters),$limit_start, $limitation,$order_by," ".$order_dir);
					

				foreach($items as $item){
					
					$catid = (new JSResponsiveListingHelper)->getCategoryByProductID($item->product_id);
					$array = array();
					foreach ($catid as $value) {
                       $array[] = $value->category_id;
					}
					$array = implode(", ", $array);					

					$category = self::getCategory($array,$field_sort,$ordering,1);
					//$category = $list['1'];
					foreach($category as $categoryItem) {
						if(isset($categoryItem->count)){
								$categoryItem->count ++;
						}else{
							$categoryItem->count = 1;
						}
						$item->category_title = $categoryItem->name;					
						$item->category_id = $categoryItem->category_id;					
					}
				
					$images = $productNew->getImages();			
					$item->product_old_price = self::_getOldPriceProducts($item->product_id)[0]->product_old_price;
					$item->product_thumb_image = $item->image;
					$item->product_name_image = $item->image;
					$item->title = $item->name;	
					$item->product_date_added = $item->product_date_added;
					$item->short_desc = (new JSResponsiveListingBaseHelper)->_cleanText($item->short_description);
					$item->link = \JSHelper::SEFLink('index.php?option=com_jshopping&controller=product&task=view&category_id=' . $item->category_id.'&product_id=' . $item->product_id ,1);
			
				}
				if ($params->get('tab_all_display', 1)){
					$all = new stdClass();
					$all->category_id = '*';
					$all->count = count($items);
					$all->name = JText::_('All');
				
					array_unshift($retur['categories'], $all);
				}
				
				// default select
				
				$selected = false;
				foreach ($retur['categories'] as $cat){
					if ( $cat->category_id == $catidpreload && $cat->count > 0 ){
						$cat->sel = 'sel';
						$selected = true;
						
					}
				}		
				// first tab is active
				if (!$selected){
					foreach ($retur['categories'] as $cat){
						if ($cat->count > 0){
							$cat->sel = 'sel';
							break;
						}
					}
				}
				
				$retur['items'] = $items;
			}
			
		}
	
		return $retur;	
	}

    public static function _getOldPriceProducts($id)
    {
		$_db = JFactory::getDBO();
        $query = "SELECT DISTINCT product_old_price FROM `#__jshopping_products`
                  WHERE product_publish = '1' AND product_id=".$id;
        $_db->setQuery($query);
        $products = $_db->loadObjectList();
       // $products = listProductUpdateData($products);

        return $products;
    }
			
	
    function getCategoryByProductID($product_id) {
        $db = \JFactory::getDBO();
        $query = "SELECT prod_cat.category_id FROM `#__jshopping_products_to_categories` AS prod_cat
                   WHERE prod_cat.product_id = '".$db->escape($product_id)."'";
        $db->setQuery($query);
        $categories = $db->loadObjectList();

        return $categories;
    }	
	
	public static   function getCategory($catid, $order = 'id', $ordering = 'asc', $publish = 0) {
		$_db = JFactory::getDBO();
		$lang = JSFactory::getLang();
        $user = JFactory::getUser();
        $add_where = ($publish)?(" AND category_publish = 1 "):("");
        $groups = implode(',', $user->getAuthorisedViewLevels());
        $add_where .=' AND access IN ('.$groups.')';
        if ($order=="id") $orderby = "category_id";
        if ($order=="name") $orderby = "`".$lang->get('name')."`";
        if ($order=="ordering") $orderby = "ordering";
        if (!$orderby) $orderby = "ordering";
        
        $query = "SELECT `".$lang->get('name')."` as name,`".$lang->get('description')."` as description,`".$lang->get('short_description')."` as short_description, category_id, category_publish, ordering, category_image FROM `#__jshopping_categories`
                   WHERE category_id IN (".$catid.") " . $add_where."
                   ORDER BY ".$orderby." ".$ordering;

        $_db->setQuery($query);
        $categories = $_db->loadObjectList();
 		
        foreach($categories as $key=>$value){
            $categories[$key]->link = \JSHelper::SEFLink('index.php?option=com_jshopping&controller=category&task=view&category_id='.$categories[$key]->category_id, 1);

			$queryCount = "SELECT * FROM `#__jshopping_products_to_categories` WHERE category_id = ".$value->category_id." " ;
			$_db->setQuery($queryCount);
			$categories[$key]->count = count($_db->loadObjectList());
        }       
		 		
        return $categories;
    }
	
	

}
